/**
 * @file   audio_postprocess.c
 * 
 * <EN>
 * @brief  A sample audio postprocessing plugin
 * </EN>
 * 
 * <JA>
 * @brief  ǥϤθץ饰Υץ
 * </JA>
 * 
 * @author Akinobu Lee
 * @date   Sun Aug 10 15:12:50 2008
 * 
 * $Revision: 1.1 $
 * 
 */

/**
 * Required for a file
 *   - get_plugin_info()
 *
 * Optional for a file
 *   - initialize()
 * 
 */
/**
 * A/D-in postprocessing functions
 * 
 * Required:
 *   - adin_postprocess()
 *   
 */

/***************************************************************************/

#include <stdio.h>
#include <string.h>
#include "plugin_defs.h"

#define PLUGIN_TITLE "audio postprocess plugin for Julius"

/** 
 * <EN>
 * @brief  Initialization at loading time (optional)
 * 
 * If defined, this will be called just before this plugin is loaded to Julius.
 * if this returns -1, the whole functions in this file will not be loaded.
 *
 * This function is OPTIONAL.
 * </EN>
 * <JA>
 * @brief  ɤ߹߻νǤա
 *
 * ưJulius Υץ饰ɤ߹ݤ˺ǽ˸ƤФ롥
 * -1 ֤ȡΥץ饰Τɤ߹ޤʤʤ롥
 * ¹ԲǽΥå˻Ȥ롥
 *
 * </JA>
 * 
 * 
 * @return 0 on success, -1 on failure.
 * 
 */
int
initialize()
{
  return 0;
}

/** 
 * <EN>
 * @brief  Get information of this plugin (required)
 *
 * This function should return informations of this plugin file.
 * The required info will be specified by opcode:
 *  - 0: return description string of this file into buf
 *
 * This will be called just after Julius find this file and after
 * initialize().
 *
 * @param opcode [in] requested operation code
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 *
 * @return 0 on success, -1 on failure.  On failure, Julius will ignore this
 * plugin.
 * 
 * </EN>
 * <JA>
 * @brief  ץ饰ɬܡ
 *
 * Υץ饰˴ؤ֤Ϳ줿 opcode ˤäư롥
 *  - 0 ξ硤Υץ饰ե̾ΤͿ줿Хåե˳Ǽ
 *
 * δؿϡJulius Υץ饰ɤ߹ľ˸ƤФ롥
 * 
 * @param opcode [in] ׵ư ( 0 Τ߼)
 * @param buf [out] ͤǼХåե
 * @param buflen [in] buf κĹ
 * 
 * @return 顼 -1,  0 ֤顼Ȥ -1 ֤硤
 * Υץ饰Τɤ߹ޤʤ
 * </JA>
 * 
 */
int
get_plugin_info(int opcode, char *buf, int buflen)
{
  switch(opcode) {
  case 0:
    /* plugin description string */
    strncpy(buf, PLUGIN_TITLE, buflen);
    break;
  }

  return 0;
}

/** 
 * <EN>
 * @brief  Post-processing function for captured audio
 *
 * When defined, this function will be called at every audio input
 * fragments before any feature analysis.  @a buf contains the small
 * fragment of captured audio input at a length of @a len, and this
 * will be called successively as input goes.
 *
 * You can monitor the incoming audio stream, and also can modify or
 * overwrite the content of @a buf to do some audio processing for the
 * incoming data like noise supression etc.
 *
 * If multiple plugins have this functions, they are all executed in order
 * of loading.
 * 
 * @param buf [i/o] a fragment of audio inputs
 * @param len [in] length of @a buf (in samples)
 * 
 * </EN>
 * <JA>
 * @brief  ϤФ
 *
 * δؿ줿硤Julius Ϥ줿ǡФơ
 * ħФԤˤδؿƤӽФ@a buf ˤ @a len Ĺβ
 * ϥǡҤäƤ롥δؿϡϤʤिӤˤû
 * ҤȤ˷֤ƤФ롥
 *
 * δؿȤäϲǡ˥ǤۤˡХåե
 * ǡľܽ񤭴뤳ȤǤ롥ǧϤδؿäȤ
 * ǡФƹԤΤǡ㤨лްʤɤ򤳤ǹԤ
 * ȤǽǤ롥
 *
 * ʣΥץ饰ǤδؿꤵƤ硤ɤ߹߽
 * ¹Ԥ롥
 * 
 * @param buf [i/o] ϥǡҤäХåե
 * @param len [in] @a buf Ĺʥץ
 * 
 * </JA>
 * 
 */
void
adin_postprocess(SP16 *buf, int len)
{
  //printf("%d\n", len);
}
/* end of file */
