/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.util.Arrays;
import javax.xml.transform.Source;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ParsingValidator;
import org.xmlunit.validation.ValidationResult;

public abstract class Validator {
    private String schemaURI;
    private Source[] sourceLocations;

    protected Validator() {
    }

    public void setSchemaURI(String uri) {
        this.schemaURI = uri;
    }

    protected String getSchemaURI() {
        return this.schemaURI;
    }

    public void setSchemaSources(Source ... s) {
        this.sourceLocations = s != null ? Arrays.copyOf(s, s.length) : null;
    }

    public final void setSchemaSource(Source s) {
        Source[] sourceArray;
        if (s == null) {
            sourceArray = null;
        } else {
            Source[] sourceArray2 = new Source[1];
            sourceArray = sourceArray2;
            sourceArray2[0] = s;
        }
        this.setSchemaSources(sourceArray);
    }

    protected Source[] getSchemaSources() {
        return this.sourceLocations == null ? new Source[]{} : this.sourceLocations;
    }

    public abstract ValidationResult validateSchema();

    public abstract ValidationResult validateInstance(Source var1);

    public static Validator forLanguage(String language) {
        if (!"http://www.w3.org/TR/REC-xml".equals(language)) {
            return new JAXPValidator(language);
        }
        return new ParsingValidator("http://www.w3.org/TR/REC-xml");
    }
}

