/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.utils;

import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFinder {
    private final Set<Class<?>> classes = new HashSet();
    private final ClassLoader loader;
    private Class<?> parentType;
    private String jarPath = null;
    private static final Log log = Log.getInstance(ClassFinder.class);

    public ClassFinder() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public ClassFinder(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassFinder(File jarFile) throws IOException {
        this.jarPath = jarFile.getCanonicalPath();
        URL[] urls = new URL[]{new File(this.jarPath).toURI().toURL()};
        this.loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public String toClassName(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public void find(String packageName, Class<?> parentType) {
        Enumeration<URL> urls;
        this.parentType = parentType;
        packageName = packageName.replace('.', '/');
        try {
            urls = this.loader.getResources(packageName);
        }
        catch (IOException ioe) {
            log.warn("Could not read package: " + packageName, ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath = urls.nextElement().getFile();
                try {
                    URI uri = new URI(urlPath);
                    urlPath = uri.getPath();
                }
                catch (URISyntaxException e) {
                    log.warn("Cannot convert to URI the " + urlPath + " URL");
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (this.jarPath != null && !this.jarPath.equals(urlPath)) continue;
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.scanDir(file, packageName);
                    continue;
                }
                this.scanJar(file, packageName);
            }
            catch (IOException ioe) {
                log.warn("could not read entries", ioe);
            }
        }
    }

    protected void scanJar(File file, String packagePath) throws IOException {
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packagePath)) continue;
            this.handleItem(name);
        }
    }

    protected void scanDir(File file, String path) {
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.scanDir(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }

    protected void handleItem(String name) {
        if (name.endsWith(".class")) {
            String classname = this.toClassName(name);
            try {
                Class<?> type = this.loader.loadClass(classname);
                if (this.parentType.isAssignableFrom(type)) {
                    this.classes.add(type);
                }
            }
            catch (Throwable t) {
                log.debug("could not load class: " + classname, t);
            }
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Class<?>> getConcreteClasses() {
        return this.getClasses().stream().filter(ClassFinder::isConcrete).collect(Collectors.toSet());
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers());
    }
}

