/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.NA12878KnowledgeBase;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.SiteIterator;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.SiteManager;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.SiteSelector;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.errors.InvalidRecordsRemove;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.bson.types.ObjectId;

public class NewlyAddedSites {
    private static final DBObject SORT_BY_ID = new BasicDBObject("_id", (Object)-1);
    private static Logger logger = Logger.getLogger(NewlyAddedSites.class);
    final NA12878KnowledgeBase kb;
    ObjectId lastObjectID = null;

    public NewlyAddedSites(NA12878KnowledgeBase kb, ObjectId lastObjectID) {
        if (kb == null) {
            throw new IllegalArgumentException("NA12878KnowledgeBase cannot be null");
        }
        this.kb = kb;
        this.lastObjectID = lastObjectID;
    }

    public NewlyAddedSites(NA12878KnowledgeBase kb) {
        this(kb, NewlyAddedSites.getLastObjectID(kb.getSitesCollection()));
    }

    public DBCursor getNewlyAddedRecords() {
        DBObject query = this.makeQuery();
        DBCursor cursor = this.kb.getSitesCollection().find(query).sort(this.kb.sitesOrder());
        logger.debug((Object)("Query for newly added sites with lastObjectID " + this.lastObjectID + " returned " + cursor.size() + " records"));
        this.lastObjectID = NewlyAddedSites.getLastObjectID(this.kb.getSitesCollection());
        return cursor;
    }

    public SiteManager getNewlyAddedLocations(GenomeLocParser parser, int maxItemizedQueries) {
        if (parser == null) {
            throw new IllegalArgumentException("GenomeLocParser cannot be null");
        }
        DBCursor cursor = this.getNewlyAddedRecords();
        if (cursor.size() == 0) {
            return null;
        }
        if (cursor.size() > maxItemizedQueries && maxItemizedQueries != -1) {
            return new SiteManager(parser);
        }
        SiteSelector selector = new SiteSelector(parser);
        SiteIterator<MongoVariantContext> iterator = new SiteManager(parser, cursor).getIterator();
        iterator.setErrorHandler(new InvalidRecordsRemove(this.kb.sites));
        for (MongoVariantContext mvc : iterator) {
            selector.addInterval(mvc.getLocation(parser));
        }
        return new SiteManager(parser, selector);
    }

    private DBObject makeQuery() {
        if (this.lastObjectID == null) {
            return new BasicDBObject();
        }
        return new BasicDBObject("_id", (Object)new BasicDBObject("$gt", (Object)this.lastObjectID));
    }

    private static ObjectId getLastObjectID(DBCollection sites) {
        DBCursor cursor = sites.find().sort(SORT_BY_ID).limit(1);
        if (cursor.size() == 0) {
            return null;
        }
        return (ObjectId)cursor.next().get("_id");
    }
}

