/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage.implementations;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.xml.security.keys.storage.StorageResolverException;
import org.apache.xml.security.keys.storage.StorageResolverSpi;

public class KeyStoreResolver
extends StorageResolverSpi {
    KeyStore _keyStore = null;

    public KeyStoreResolver(KeyStore keyStore) throws StorageResolverException {
        this._keyStore = keyStore;
        try {
            this._keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            throw new StorageResolverException("generic.EmptyMessage", keyStoreException);
        }
    }

    public Iterator getIterator() {
        return new KeyStoreIterator(this._keyStore);
    }

    static class KeyStoreIterator
    implements Iterator {
        KeyStore _keyStore = null;
        Enumeration _aliases = null;
        Certificate _nextCert = null;

        public KeyStoreIterator(KeyStore keyStore) {
            try {
                this._keyStore = keyStore;
                this._aliases = this._keyStore.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                this._aliases = new Enumeration(this){
                    private final /* synthetic */ KeyStoreIterator this$0;
                    {
                        this.this$0 = keyStoreIterator;
                    }

                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        return null;
                    }
                };
            }
        }

        public boolean hasNext() {
            if (this._nextCert == null) {
                this._nextCert = this.findNextCert();
            }
            return this._nextCert != null;
        }

        public Object next() {
            if (this._nextCert == null) {
                this._nextCert = this.findNextCert();
                if (this._nextCert == null) {
                    throw new NoSuchElementException();
                }
            }
            Certificate certificate = this._nextCert;
            this._nextCert = null;
            return certificate;
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }

        private Certificate findNextCert() {
            while (this._aliases.hasMoreElements()) {
                String string = (String)this._aliases.nextElement();
                try {
                    Certificate certificate = this._keyStore.getCertificate(string);
                    if (certificate == null) continue;
                    return certificate;
                }
                catch (KeyStoreException keyStoreException) {
                    return null;
                }
            }
            return null;
        }
    }
}

