(* Decrypt a PDF file *)
open Utility

let decrypt_pdf pw pdf =
  try
    fst (Pdfcrypt.decrypt_pdf pw pdf)
  with
    _ -> None

(* Read command line arguments and call [decrypt_pdf] *)
let _ =
  let pw, in_file, out_file =
    match Array.to_list Sys.argv with
    | [_; in_file; out_file; pw] -> pw, in_file, out_file
    | [_; in_file; out_file] -> "", in_file, out_file
    | _ ->
      print_string "Syntax: pdfdecrypt <input> <output> {password}\n\n"; exit 1
  in
    begin try
      let ch = open_in_bin in_file in
        let pdf = Pdfread.pdf_of_channel None ch in
          begin match decrypt_pdf pw pdf with
          | Some pdf -> Pdfwrite.pdf_to_file pdf out_file
          | None -> Printf.printf "Bad password or other failure"
          end;
          close_in ch
    with
      err ->
        Printf.printf "Failed to produce output.\n%s\n\n" (Printexc.to_string err);
        exit 1
    end

