/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateCell
extends AbstractCell<Date> {
    private final DateTimeFormat format;
    private final SafeHtmlRenderer<String> renderer;

    public DateCell() {
        this(DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.DATE_FULL), SimpleSafeHtmlRenderer.getInstance());
    }

    public DateCell(SafeHtmlRenderer<String> renderer) {
        this(DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.DATE_FULL), renderer);
    }

    public DateCell(DateTimeFormat format) {
        this(format, SimpleSafeHtmlRenderer.getInstance());
    }

    public DateCell(DateTimeFormat format, SafeHtmlRenderer<String> renderer) {
        super(new String[0]);
        if (format == null) {
            throw new IllegalArgumentException("format == null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        this.format = format;
        this.renderer = renderer;
    }

    @Override
    public void render(Cell.Context context, Date value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render(this.format.format(value)));
        }
    }
}

