/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.impl.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProxyId<P extends BaseProxy> {
    public static final int NEVER_EPHEMERAL = -1;
    private final int clientId;
    private String encodedAddress;
    private final int hashCode;
    private final Class<P> proxyClass;
    private int syntheticId;

    SimpleProxyId(Class<P> proxyClass, int clientId) {
        assert (proxyClass != null);
        this.clientId = clientId;
        this.proxyClass = proxyClass;
        this.hashCode = clientId;
    }

    SimpleProxyId(Class<P> proxyClass, String encodedAddress) {
        assert (proxyClass != null);
        assert (encodedAddress != null);
        this.setServerId(encodedAddress);
        this.clientId = -1;
        this.hashCode = encodedAddress.hashCode();
        this.proxyClass = proxyClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleProxyId)) {
            return false;
        }
        SimpleProxyId other = (SimpleProxyId)o;
        if (!this.proxyClass.equals(other.proxyClass)) {
            return false;
        }
        if (this.clientId != -1 && this.clientId == other.clientId) {
            return true;
        }
        return this.encodedAddress != null && this.encodedAddress.equals(other.encodedAddress);
    }

    public int getClientId() {
        return this.clientId;
    }

    public Class<P> getProxyClass() {
        return this.proxyClass;
    }

    public String getServerId() {
        return this.encodedAddress;
    }

    public int getSyntheticId() {
        return this.syntheticId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isEphemeral() {
        return this.encodedAddress == null;
    }

    public boolean isSynthetic() {
        return this.syntheticId > 0;
    }

    public void setServerId(String encodedAddress) {
        if (this.encodedAddress != null) {
            throw new IllegalStateException();
        }
        assert (!"null".equals(encodedAddress));
        this.encodedAddress = encodedAddress;
    }

    public void setSyntheticId(int syntheticId) {
        this.syntheticId = syntheticId;
    }

    public String toString() {
        if (this.isEphemeral()) {
            return IdUtil.ephemeralId(this.clientId, this.proxyClass.getName());
        }
        if (this.isSynthetic()) {
            return IdUtil.syntheticId(this.syntheticId, this.proxyClass.getName());
        }
        return IdUtil.persistedId(this.encodedAddress, this.proxyClass.getName());
    }

    public boolean wasEphemeral() {
        return this.clientId != -1;
    }
}

