; RUN: opt %s -S -passes=sroa -o - | FileCheck %s
; RUN: opt --try-experimental-debuginfo-iterators %s -S -passes=sroa -o - | FileCheck %s

;; Ensure that only the value-expression gets fragment info; that the
;; address-expression remains untouched.

;; $ cat test.cpp
;; class a {
;;   float b[4];
;; };
;; class c {
;;   a m_fn1() const;
;;   void d() const;
;; };
;; void c::d() const { a e = m_fn1(); }
;;
;; Generated by grabbing IR before sroa in:
;; $ clang++ -O2 -g -c test.cpp -Xclang  -fexperimental-assignment-tracking

; CHECK: %call = call
; CHECK-NEXT: %0 = extractvalue { <2 x float>, <2 x float> } %call, 0
; CHECK-NEXT: #dbg_value(<2 x float> %0, ![[var:[0-9]+]], !DIExpression(DW_OP_LLVM_fragment, 0, 64),
; CHECK-NEXT: %1 = extractvalue { <2 x float>, <2 x float> } %call, 1
; CHECK-NEXT: #dbg_value(<2 x float> %1, ![[var]], !DIExpression(DW_OP_LLVM_fragment, 64, 64),

%class.c = type { i8 }
%class.a = type { [4 x float] }

; Function Attrs: uwtable
define dso_local void @_ZNK1c1dEv(ptr %this) #0 align 2 !dbg !7 {
entry:
  %this.addr = alloca ptr, align 8, !DIAssignID !29
  call void @llvm.dbg.assign(metadata i1 undef, metadata !26, metadata !DIExpression(), metadata !29, metadata ptr %this.addr, metadata !DIExpression()), !dbg !30
  %e = alloca %class.a, align 4, !DIAssignID !31
  call void @llvm.dbg.assign(metadata i1 undef, metadata !28, metadata !DIExpression(), metadata !31, metadata ptr %e, metadata !DIExpression()), !dbg !30
  store ptr %this, ptr %this.addr, align 8, !DIAssignID !36
  call void @llvm.dbg.assign(metadata ptr %this, metadata !26, metadata !DIExpression(), metadata !36, metadata ptr %this.addr, metadata !DIExpression()), !dbg !30
  %this1 = load ptr, ptr %this.addr, align 8
  %0 = bitcast ptr %e to ptr, !dbg !37
  %call = call { <2 x float>, <2 x float> } @_ZNK1c5m_fn1Ev(ptr %this1), !dbg !38
  %coerce.dive = getelementptr inbounds %class.a, ptr %e, i32 0, i32 0, !dbg !38
  %1 = bitcast ptr %coerce.dive to ptr, !dbg !38
  %2 = getelementptr inbounds { <2 x float>, <2 x float> }, ptr %1, i32 0, i32 0, !dbg !38
  %3 = extractvalue { <2 x float>, <2 x float> } %call, 0, !dbg !38
  store <2 x float> %3, ptr %2, align 4, !dbg !38, !DIAssignID !39
  call void @llvm.dbg.assign(metadata <2 x float> %3, metadata !28, metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata !39, metadata ptr %2, metadata !DIExpression()), !dbg !30
  %4 = getelementptr inbounds { <2 x float>, <2 x float> }, ptr %1, i32 0, i32 1, !dbg !38
  %5 = extractvalue { <2 x float>, <2 x float> } %call, 1, !dbg !38
  store <2 x float> %5, ptr %4, align 4, !dbg !38, !DIAssignID !40
  call void @llvm.dbg.assign(metadata <2 x float> %5, metadata !28, metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata !40, metadata ptr %4, metadata !DIExpression()), !dbg !30
  %6 = bitcast ptr %e to ptr, !dbg !41
  ret void, !dbg !41
}

declare void @llvm.dbg.declare(metadata, metadata, metadata) #1
declare dso_local { <2 x float>, <2 x float> } @_ZNK1c5m_fn1Ev(ptr) #3
declare void @llvm.dbg.assign(metadata, metadata, metadata, metadata, metadata, metadata) #1


!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3, !4, !5, !1000}
!llvm.ident = !{!6}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !1, producer: "clang version 12.0.0", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, splitDebugInlining: false, nameTableKind: None)
!1 = !DIFile(filename: "test.cpp", directory: "/")
!2 = !{}
!3 = !{i32 7, !"Dwarf Version", i32 4}
!4 = !{i32 2, !"Debug Info Version", i32 3}
!5 = !{i32 1, !"wchar_size", i32 4}
!6 = !{!"clang version 12.0.0"}
!7 = distinct !DISubprogram(name: "d", linkageName: "_ZNK1c1dEv", scope: !8, file: !1, line: 8, type: !23, scopeLine: 8, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0, declaration: !22, retainedNodes: !25)
!8 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "c", file: !1, line: 4, size: 8, flags: DIFlagTypePassByValue, elements: !9, identifier: "_ZTS1c")
!9 = !{!10, !22}
!10 = !DISubprogram(name: "m_fn1", linkageName: "_ZNK1c5m_fn1Ev", scope: !8, file: !1, line: 5, type: !11, scopeLine: 5, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized)
!11 = !DISubroutineType(types: !12)
!12 = !{!13, !20}
!13 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "a", file: !1, line: 1, size: 128, flags: DIFlagTypePassByValue, elements: !14, identifier: "_ZTS1a")
!14 = !{!15}
!15 = !DIDerivedType(tag: DW_TAG_member, name: "b", scope: !13, file: !1, line: 2, baseType: !16, size: 128)
!16 = !DICompositeType(tag: DW_TAG_array_type, baseType: !17, size: 128, elements: !18)
!17 = !DIBasicType(name: "float", size: 32, encoding: DW_ATE_float)
!18 = !{!19}
!19 = !DISubrange(count: 4)
!20 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !21, size: 64, flags: DIFlagArtificial | DIFlagObjectPointer)
!21 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !8)
!22 = !DISubprogram(name: "d", linkageName: "_ZNK1c1dEv", scope: !8, file: !1, line: 6, type: !23, scopeLine: 6, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized)
!23 = !DISubroutineType(types: !24)
!24 = !{null, !20}
!25 = !{!26, !28}
!26 = !DILocalVariable(name: "this", arg: 1, scope: !7, type: !27, flags: DIFlagArtificial | DIFlagObjectPointer)
!27 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !21, size: 64)
!28 = !DILocalVariable(name: "e", scope: !7, file: !1, line: 8, type: !13)
!29 = distinct !DIAssignID()
!30 = !DILocation(line: 0, scope: !7)
!31 = distinct !DIAssignID()
!36 = distinct !DIAssignID()
!37 = !DILocation(line: 8, column: 21, scope: !7)
!38 = !DILocation(line: 8, column: 27, scope: !7)
!39 = distinct !DIAssignID()
!40 = distinct !DIAssignID()
!41 = !DILocation(line: 8, column: 36, scope: !7)
!1000 = !{i32 7, !"debug-info-assignment-tracking", i1 true}
