; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=i686-linux-gnu -atomic-expand %s | FileCheck %s


define i256 @atomic_load256_libcall(i256* %ptr) nounwind {
; CHECK-LABEL: @atomic_load256_libcall(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i256* [[PTR:%.*]] to i8*
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i256, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i256* [[TMP2]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 32, i8* [[TMP3]])
; CHECK-NEXT:    call void @__atomic_load(i64 32, i8* [[TMP1]], i8* [[TMP3]], i32 0)
; CHECK-NEXT:    [[TMP4:%.*]] = load i256, i256* [[TMP2]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p0i8(i64 32, i8* [[TMP3]])
; CHECK-NEXT:    ret i256 [[TMP4]]
;
  %result = load atomic i256, i256* %ptr unordered, align 16
  ret i256 %result
}

define i256 @atomic_load256_libcall_as1(i256 addrspace(1)* %ptr) nounwind {
; CHECK-LABEL: @atomic_load256_libcall_as1(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i256 addrspace(1)* [[PTR:%.*]] to i8 addrspace(1)*
; CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast i8 addrspace(1)* [[TMP1]] to i8*
; CHECK-NEXT:    [[TMP3:%.*]] = alloca i256, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i256* [[TMP3]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 32, i8* [[TMP4]])
; CHECK-NEXT:    call void @__atomic_load(i64 32, i8* [[TMP2]], i8* [[TMP4]], i32 0)
; CHECK-NEXT:    [[TMP5:%.*]] = load i256, i256* [[TMP3]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p0i8(i64 32, i8* [[TMP4]])
; CHECK-NEXT:    ret i256 [[TMP5]]
;
  %result = load atomic i256, i256 addrspace(1)* %ptr unordered, align 16
  ret i256 %result
}
