; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -O3 -verify-machineinstrs -ppc-vsr-nums-as-vr \
; RUN:     -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     < %s | FileCheck %s --check-prefixes=P9LE

; RUN: llc -mcpu=pwr9 -O3 -verify-machineinstrs -ppc-vsr-nums-as-vr \
; RUN:     -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     < %s | FileCheck %s --check-prefixes=P9BE

; RUN: llc -mcpu=pwr9 -O3 -verify-machineinstrs -ppc-vsr-nums-as-vr \
; RUN:     -mtriple=powerpc64-ibm-aix-xcoff -vec-extabi \
; RUN:     < %s | FileCheck %s --check-prefixes=P9BE-AIX

; RUN: llc -mcpu=pwr9 -O3 -verify-machineinstrs -ppc-vsr-nums-as-vr \
; RUN:     -mtriple=powerpc-ibm-aix-xcoff -vec-extabi \
; RUN:     < %s | FileCheck %s --check-prefixes=P9BE-AIX32

define void @test64(i8* nocapture readonly %pix2, i32 signext %i_pix2) {
; P9LE-LABEL: test64:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    add 5, 3, 4
; P9LE-NEXT:    lxsdx 2, 3, 4
; P9LE-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; P9LE-NEXT:    xxlxor 4, 4, 4
; P9LE-NEXT:    addi 3, 3, .LCPI0_0@toc@l
; P9LE-NEXT:    lxv 3, 0(3)
; P9LE-NEXT:    addis 3, 2, .LCPI0_1@toc@ha
; P9LE-NEXT:    addi 3, 3, .LCPI0_1@toc@l
; P9LE-NEXT:    vperm 2, 2, 4, 3
; P9LE-NEXT:    lxsd 3, 4(5)
; P9LE-NEXT:    lxv 4, 0(3)
; P9LE-NEXT:    vperm 3, 3, 3, 4
; P9LE-NEXT:    vspltisw 4, 8
; P9LE-NEXT:    vnegw 3, 3
; P9LE-NEXT:    vadduwm 4, 4, 4
; P9LE-NEXT:    vslw 3, 3, 4
; P9LE-NEXT:    vsubuwm 2, 3, 2
; P9LE-NEXT:    xxswapd 0, 2
; P9LE-NEXT:    stxv 0, 0(3)
; P9LE-NEXT:    blr
;
; P9BE-LABEL: test64:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    add 5, 3, 4
; P9BE-NEXT:    lxsdx 2, 3, 4
; P9BE-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; P9BE-NEXT:    xxlxor 4, 4, 4
; P9BE-NEXT:    addi 3, 3, .LCPI0_0@toc@l
; P9BE-NEXT:    lxv 3, 0(3)
; P9BE-NEXT:    addis 3, 2, .LCPI0_1@toc@ha
; P9BE-NEXT:    addi 3, 3, .LCPI0_1@toc@l
; P9BE-NEXT:    vperm 2, 4, 2, 3
; P9BE-NEXT:    lxsd 3, 4(5)
; P9BE-NEXT:    lxv 4, 0(3)
; P9BE-NEXT:    vperm 3, 3, 3, 4
; P9BE-NEXT:    vspltisw 4, 8
; P9BE-NEXT:    vnegw 3, 3
; P9BE-NEXT:    vadduwm 4, 4, 4
; P9BE-NEXT:    vslw 3, 3, 4
; P9BE-NEXT:    vsubuwm 2, 3, 2
; P9BE-NEXT:    xxswapd 0, 2
; P9BE-NEXT:    stxv 0, 0(3)
; P9BE-NEXT:    blr
;
; P9BE-AIX-LABEL: test64:
; P9BE-AIX:       # %bb.0: # %entry
; P9BE-AIX-NEXT:    add 5, 3, 4
; P9BE-AIX-NEXT:    lxsdx 2, 3, 4
; P9BE-AIX-NEXT:    ld 3, L..C0(2) # %const.0
; P9BE-AIX-NEXT:    xxlxor 4, 4, 4
; P9BE-AIX-NEXT:    lxv 3, 0(3)
; P9BE-AIX-NEXT:    ld 3, L..C1(2) # %const.1
; P9BE-AIX-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX-NEXT:    lxsd 3, 4(5)
; P9BE-AIX-NEXT:    lxv 4, 0(3)
; P9BE-AIX-NEXT:    vperm 3, 3, 3, 4
; P9BE-AIX-NEXT:    vspltisw 4, 8
; P9BE-AIX-NEXT:    vnegw 3, 3
; P9BE-AIX-NEXT:    vadduwm 4, 4, 4
; P9BE-AIX-NEXT:    vslw 3, 3, 4
; P9BE-AIX-NEXT:    vsubuwm 2, 3, 2
; P9BE-AIX-NEXT:    xxswapd 0, 2
; P9BE-AIX-NEXT:    stxv 0, 0(3)
; P9BE-AIX-NEXT:    blr
;
; P9BE-AIX32-LABEL: test64:
; P9BE-AIX32:       # %bb.0: # %entry
; P9BE-AIX32-NEXT:    lwzux 4, 3, 4
; P9BE-AIX32-NEXT:    xxlxor 4, 4, 4
; P9BE-AIX32-NEXT:    stw 4, -48(1)
; P9BE-AIX32-NEXT:    lwz 4, 4(3)
; P9BE-AIX32-NEXT:    lxv 0, -48(1)
; P9BE-AIX32-NEXT:    stw 4, -32(1)
; P9BE-AIX32-NEXT:    lwz 4, L..C0(2) # %const.0
; P9BE-AIX32-NEXT:    lwz 3, 8(3)
; P9BE-AIX32-NEXT:    lxv 1, -32(1)
; P9BE-AIX32-NEXT:    lxv 3, 0(4)
; P9BE-AIX32-NEXT:    stw 3, -16(1)
; P9BE-AIX32-NEXT:    lwz 3, L..C1(2) # %const.1
; P9BE-AIX32-NEXT:    xxmrghw 2, 0, 1
; P9BE-AIX32-NEXT:    lxv 0, -16(1)
; P9BE-AIX32-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX32-NEXT:    lxv 4, 0(3)
; P9BE-AIX32-NEXT:    xxmrghw 3, 1, 0
; P9BE-AIX32-NEXT:    vperm 3, 3, 3, 4
; P9BE-AIX32-NEXT:    vspltisw 4, 8
; P9BE-AIX32-NEXT:    vnegw 3, 3
; P9BE-AIX32-NEXT:    vadduwm 4, 4, 4
; P9BE-AIX32-NEXT:    vslw 3, 3, 4
; P9BE-AIX32-NEXT:    vsubuwm 2, 3, 2
; P9BE-AIX32-NEXT:    xxswapd 0, 2
; P9BE-AIX32-NEXT:    stxv 0, 0(3)
; P9BE-AIX32-NEXT:    blr
entry:
  %idx.ext63 = sext i32 %i_pix2 to i64
  %add.ptr64 = getelementptr inbounds i8, i8* %pix2, i64 %idx.ext63
  %arrayidx5.1 = getelementptr inbounds i8, i8* %add.ptr64, i64 4
  %0 = bitcast i8* %add.ptr64 to <4 x i16>*
  %1 = load <4 x i16>, <4 x i16>* %0, align 1
  %reorder_shuffle117 = shufflevector <4 x i16> %1, <4 x i16> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %2 = zext <4 x i16> %reorder_shuffle117 to <4 x i32>
  %3 = sub nsw <4 x i32> zeroinitializer, %2
  %4 = bitcast i8* %arrayidx5.1 to <4 x i16>*
  %5 = load <4 x i16>, <4 x i16>* %4, align 1
  %reorder_shuffle115 = shufflevector <4 x i16> %5, <4 x i16> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %6 = zext <4 x i16> %reorder_shuffle115 to <4 x i32>
  %7 = sub nsw <4 x i32> zeroinitializer, %6
  %8 = shl nsw <4 x i32> %7, <i32 16, i32 16, i32 16, i32 16>
  %9 = add nsw <4 x i32> %8, %3
  %10 = sub nsw <4 x i32> %9, zeroinitializer
  %11 = shufflevector <4 x i32> undef, <4 x i32> %10, <4 x i32> <i32 2, i32 7, i32 0, i32 5>
  %12 = add nsw <4 x i32> zeroinitializer, %11
  %13 = shufflevector <4 x i32> %12, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  store <4 x i32> %13, <4 x i32>* undef, align 16
  ret void
}

define void @test32(i8* nocapture readonly %pix2, i32 signext %i_pix2) {
; P9LE-LABEL: test32:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    add 5, 3, 4
; P9LE-NEXT:    lxsiwzx 2, 3, 4
; P9LE-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; P9LE-NEXT:    xxlxor 3, 3, 3
; P9LE-NEXT:    addi 3, 3, .LCPI1_0@toc@l
; P9LE-NEXT:    lxv 4, 0(3)
; P9LE-NEXT:    li 3, 4
; P9LE-NEXT:    lxsiwzx 5, 5, 3
; P9LE-NEXT:    vperm 2, 2, 3, 4
; P9LE-NEXT:    vperm 3, 5, 3, 4
; P9LE-NEXT:    vspltisw 4, 8
; P9LE-NEXT:    vnegw 3, 3
; P9LE-NEXT:    vadduwm 4, 4, 4
; P9LE-NEXT:    vslw 3, 3, 4
; P9LE-NEXT:    vsubuwm 2, 3, 2
; P9LE-NEXT:    xxswapd 0, 2
; P9LE-NEXT:    stxv 0, 0(3)
; P9LE-NEXT:    blr
;
; P9BE-LABEL: test32:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    add 5, 3, 4
; P9BE-NEXT:    lxsiwzx 2, 3, 4
; P9BE-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; P9BE-NEXT:    xxlxor 3, 3, 3
; P9BE-NEXT:    addi 3, 3, .LCPI1_0@toc@l
; P9BE-NEXT:    lxv 4, 0(3)
; P9BE-NEXT:    li 3, 4
; P9BE-NEXT:    lxsiwzx 5, 5, 3
; P9BE-NEXT:    vperm 2, 3, 2, 4
; P9BE-NEXT:    vperm 3, 3, 5, 4
; P9BE-NEXT:    vspltisw 4, 8
; P9BE-NEXT:    vnegw 3, 3
; P9BE-NEXT:    vadduwm 4, 4, 4
; P9BE-NEXT:    vslw 3, 3, 4
; P9BE-NEXT:    vsubuwm 2, 3, 2
; P9BE-NEXT:    xxswapd 0, 2
; P9BE-NEXT:    stxv 0, 0(3)
; P9BE-NEXT:    blr
;
; P9BE-AIX-LABEL: test32:
; P9BE-AIX:       # %bb.0: # %entry
; P9BE-AIX-NEXT:    add 5, 3, 4
; P9BE-AIX-NEXT:    lxsiwzx 2, 3, 4
; P9BE-AIX-NEXT:    ld 3, L..C2(2) # %const.0
; P9BE-AIX-NEXT:    xxlxor 3, 3, 3
; P9BE-AIX-NEXT:    lxv 4, 0(3)
; P9BE-AIX-NEXT:    li 3, 4
; P9BE-AIX-NEXT:    lxsiwzx 5, 5, 3
; P9BE-AIX-NEXT:    vperm 2, 3, 2, 4
; P9BE-AIX-NEXT:    vperm 3, 3, 5, 4
; P9BE-AIX-NEXT:    vspltisw 4, 8
; P9BE-AIX-NEXT:    vnegw 3, 3
; P9BE-AIX-NEXT:    vadduwm 4, 4, 4
; P9BE-AIX-NEXT:    vslw 3, 3, 4
; P9BE-AIX-NEXT:    vsubuwm 2, 3, 2
; P9BE-AIX-NEXT:    xxswapd 0, 2
; P9BE-AIX-NEXT:    stxv 0, 0(3)
; P9BE-AIX-NEXT:    blr
;
; P9BE-AIX32-LABEL: test32:
; P9BE-AIX32:       # %bb.0: # %entry
; P9BE-AIX32-NEXT:    add 5, 3, 4
; P9BE-AIX32-NEXT:    lxsiwzx 2, 3, 4
; P9BE-AIX32-NEXT:    lwz 3, L..C2(2) # %const.0
; P9BE-AIX32-NEXT:    xxlxor 3, 3, 3
; P9BE-AIX32-NEXT:    lxv 4, 0(3)
; P9BE-AIX32-NEXT:    li 3, 4
; P9BE-AIX32-NEXT:    lxsiwzx 5, 5, 3
; P9BE-AIX32-NEXT:    vperm 2, 3, 2, 4
; P9BE-AIX32-NEXT:    vperm 3, 3, 5, 4
; P9BE-AIX32-NEXT:    vspltisw 4, 8
; P9BE-AIX32-NEXT:    vnegw 3, 3
; P9BE-AIX32-NEXT:    vadduwm 4, 4, 4
; P9BE-AIX32-NEXT:    vslw 3, 3, 4
; P9BE-AIX32-NEXT:    vsubuwm 2, 3, 2
; P9BE-AIX32-NEXT:    xxswapd 0, 2
; P9BE-AIX32-NEXT:    stxv 0, 0(3)
; P9BE-AIX32-NEXT:    blr
entry:
  %idx.ext63 = sext i32 %i_pix2 to i64
  %add.ptr64 = getelementptr inbounds i8, i8* %pix2, i64 %idx.ext63
  %arrayidx5.1 = getelementptr inbounds i8, i8* %add.ptr64, i64 4
  %0 = bitcast i8* %add.ptr64 to <4 x i8>*
  %1 = load <4 x i8>, <4 x i8>* %0, align 1
  %reorder_shuffle117 = shufflevector <4 x i8> %1, <4 x i8> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %2 = zext <4 x i8> %reorder_shuffle117 to <4 x i32>
  %3 = sub nsw <4 x i32> zeroinitializer, %2
  %4 = bitcast i8* %arrayidx5.1 to <4 x i8>*
  %5 = load <4 x i8>, <4 x i8>* %4, align 1
  %reorder_shuffle115 = shufflevector <4 x i8> %5, <4 x i8> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %6 = zext <4 x i8> %reorder_shuffle115 to <4 x i32>
  %7 = sub nsw <4 x i32> zeroinitializer, %6
  %8 = shl nsw <4 x i32> %7, <i32 16, i32 16, i32 16, i32 16>
  %9 = add nsw <4 x i32> %8, %3
  %10 = sub nsw <4 x i32> %9, zeroinitializer
  %11 = shufflevector <4 x i32> undef, <4 x i32> %10, <4 x i32> <i32 2, i32 7, i32 0, i32 5>
  %12 = add nsw <4 x i32> zeroinitializer, %11
  %13 = shufflevector <4 x i32> %12, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  store <4 x i32> %13, <4 x i32>* undef, align 16
  ret void
}

define void @test16(i16* nocapture readonly %sums, i32 signext %delta, i32 signext %thresh) {
; P9LE-LABEL: test16:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    sldi 4, 4, 1
; P9LE-NEXT:    li 7, 16
; P9LE-NEXT:    add 6, 3, 4
; P9LE-NEXT:    lxsihzx 4, 3, 4
; P9LE-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; P9LE-NEXT:    lxsihzx 2, 6, 7
; P9LE-NEXT:    li 6, 0
; P9LE-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; P9LE-NEXT:    mtvsrd 3, 6
; P9LE-NEXT:    vmrghh 4, 3, 4
; P9LE-NEXT:    vmrghh 2, 3, 2
; P9LE-NEXT:    vsplth 3, 3, 3
; P9LE-NEXT:    xxmrglw 3, 4, 3
; P9LE-NEXT:    lxv 4, 0(3)
; P9LE-NEXT:    li 3, 0
; P9LE-NEXT:    vperm 2, 2, 3, 4
; P9LE-NEXT:    xxspltw 3, 2, 2
; P9LE-NEXT:    vadduwm 2, 2, 3
; P9LE-NEXT:    vextuwrx 3, 3, 2
; P9LE-NEXT:    cmpw 3, 5
; P9LE-NEXT:    bgelr+ 0
; P9LE-NEXT:  # %bb.1: # %if.then
;
; P9BE-LABEL: test16:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    sldi 4, 4, 1
; P9BE-NEXT:    li 7, 16
; P9BE-NEXT:    add 6, 3, 4
; P9BE-NEXT:    lxsihzx 5, 3, 4
; P9BE-NEXT:    addis 3, 2, .LCPI2_1@toc@ha
; P9BE-NEXT:    lxsihzx 2, 6, 7
; P9BE-NEXT:    addis 6, 2, .LCPI2_0@toc@ha
; P9BE-NEXT:    addi 3, 3, .LCPI2_1@toc@l
; P9BE-NEXT:    addi 6, 6, .LCPI2_0@toc@l
; P9BE-NEXT:    lxv 3, 0(6)
; P9BE-NEXT:    li 6, 0
; P9BE-NEXT:    mtvsrwz 4, 6
; P9BE-NEXT:    vperm 2, 4, 2, 3
; P9BE-NEXT:    vperm 3, 4, 5, 3
; P9BE-NEXT:    vsplth 4, 4, 3
; P9BE-NEXT:    xxmrghw 3, 4, 3
; P9BE-NEXT:    lxv 4, 0(3)
; P9BE-NEXT:    li 3, 0
; P9BE-NEXT:    vperm 2, 3, 2, 4
; P9BE-NEXT:    xxspltw 3, 2, 1
; P9BE-NEXT:    vadduwm 2, 2, 3
; P9BE-NEXT:    vextuwlx 3, 3, 2
; P9BE-NEXT:    cmpw 3, 5
; P9BE-NEXT:    bgelr+ 0
; P9BE-NEXT:  # %bb.1: # %if.then
;
; P9BE-AIX-LABEL: test16:
; P9BE-AIX:       # %bb.0: # %entry
; P9BE-AIX-NEXT:    sldi 4, 4, 1
; P9BE-AIX-NEXT:    li 7, 16
; P9BE-AIX-NEXT:    add 6, 3, 4
; P9BE-AIX-NEXT:    lxsihzx 5, 3, 4
; P9BE-AIX-NEXT:    ld 3, L..C3(2) # %const.1
; P9BE-AIX-NEXT:    lxsihzx 2, 6, 7
; P9BE-AIX-NEXT:    ld 6, L..C4(2) # %const.0
; P9BE-AIX-NEXT:    lxv 3, 0(6)
; P9BE-AIX-NEXT:    li 6, 0
; P9BE-AIX-NEXT:    mtvsrwz 4, 6
; P9BE-AIX-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX-NEXT:    vperm 3, 4, 5, 3
; P9BE-AIX-NEXT:    vsplth 4, 4, 3
; P9BE-AIX-NEXT:    xxmrghw 3, 4, 3
; P9BE-AIX-NEXT:    lxv 4, 0(3)
; P9BE-AIX-NEXT:    li 3, 0
; P9BE-AIX-NEXT:    vperm 2, 3, 2, 4
; P9BE-AIX-NEXT:    xxspltw 3, 2, 1
; P9BE-AIX-NEXT:    vadduwm 2, 2, 3
; P9BE-AIX-NEXT:    vextuwlx 3, 3, 2
; P9BE-AIX-NEXT:    cmpw 3, 5
; P9BE-AIX-NEXT:    bgelr+ 0
; P9BE-AIX-NEXT:  # %bb.1: # %if.then
;
; P9BE-AIX32-LABEL: test16:
; P9BE-AIX32:       # %bb.0: # %entry
; P9BE-AIX32-NEXT:    slwi 4, 4, 1
; P9BE-AIX32-NEXT:    li 6, 0
; P9BE-AIX32-NEXT:    lhzux 4, 3, 4
; P9BE-AIX32-NEXT:    lhz 3, 16(3)
; P9BE-AIX32-NEXT:    sth 6, -64(1)
; P9BE-AIX32-NEXT:    lxv 2, -64(1)
; P9BE-AIX32-NEXT:    sth 4, -48(1)
; P9BE-AIX32-NEXT:    lxv 4, -48(1)
; P9BE-AIX32-NEXT:    sth 3, -32(1)
; P9BE-AIX32-NEXT:    lwz 3, L..C3(2) # %const.0
; P9BE-AIX32-NEXT:    lxv 3, -32(1)
; P9BE-AIX32-NEXT:    vmrghh 4, 2, 4
; P9BE-AIX32-NEXT:    vmrghh 3, 2, 3
; P9BE-AIX32-NEXT:    vsplth 2, 2, 0
; P9BE-AIX32-NEXT:    xxmrghw 2, 2, 4
; P9BE-AIX32-NEXT:    lxv 4, 0(3)
; P9BE-AIX32-NEXT:    vperm 2, 2, 3, 4
; P9BE-AIX32-NEXT:    xxspltw 3, 2, 1
; P9BE-AIX32-NEXT:    vadduwm 2, 2, 3
; P9BE-AIX32-NEXT:    stxv 2, -16(1)
; P9BE-AIX32-NEXT:    lwz 3, -16(1)
; P9BE-AIX32-NEXT:    cmpw 3, 5
; P9BE-AIX32-NEXT:    bgelr+ 0
; P9BE-AIX32-NEXT:  # %bb.1: # %if.then
entry:
  %idxprom = sext i32 %delta to i64
  %add14 = add nsw i32 %delta, 8
  %idxprom15 = sext i32 %add14 to i64
  br label %for.body

for.body:                                         ; preds = %entry
  %arrayidx8 = getelementptr inbounds i16, i16* %sums, i64 %idxprom
  %0 = load i16, i16* %arrayidx8, align 2
  %arrayidx16 = getelementptr inbounds i16, i16* %sums, i64 %idxprom15
  %1 = load i16, i16* %arrayidx16, align 2
  %2 = insertelement <4 x i16> undef, i16 %0, i32 2
  %3 = insertelement <4 x i16> %2, i16 %1, i32 3
  %4 = zext <4 x i16> %3 to <4 x i32>
  %5 = sub nsw <4 x i32> zeroinitializer, %4
  %6 = sub nsw <4 x i32> zeroinitializer, %5
  %7 = select <4 x i1> undef, <4 x i32> %6, <4 x i32> %5
  %bin.rdx = add <4 x i32> %7, zeroinitializer
  %rdx.shuf54 = shufflevector <4 x i32> %bin.rdx, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %bin.rdx55 = add <4 x i32> %bin.rdx, %rdx.shuf54
  %8 = extractelement <4 x i32> %bin.rdx55, i32 0
  %op.extra = add nuw i32 %8, 0
  %cmp25 = icmp slt i32 %op.extra, %thresh
  br i1 %cmp25, label %if.then, label %if.end

if.then:                                          ; preds = %for.body
  unreachable

if.end:                                           ; preds = %for.body
  ret void
}

define void @test8(i8* nocapture readonly %sums, i32 signext %delta, i32 signext %thresh) {
; P9LE-LABEL: test8:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    add 6, 3, 4
; P9LE-NEXT:    lxsibzx 2, 3, 4
; P9LE-NEXT:    li 3, 0
; P9LE-NEXT:    mtvsrd 3, 3
; P9LE-NEXT:    li 3, 8
; P9LE-NEXT:    lxsibzx 5, 6, 3
; P9LE-NEXT:    vspltb 4, 3, 7
; P9LE-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; P9LE-NEXT:    vmrghb 2, 3, 2
; P9LE-NEXT:    addi 3, 3, .LCPI3_0@toc@l
; P9LE-NEXT:    vmrglh 2, 2, 4
; P9LE-NEXT:    vmrghb 3, 3, 5
; P9LE-NEXT:    xxmrglw 2, 2, 4
; P9LE-NEXT:    vmrglh 3, 3, 4
; P9LE-NEXT:    xxmrglw 3, 4, 3
; P9LE-NEXT:    lxv 4, 0(3)
; P9LE-NEXT:    li 3, 0
; P9LE-NEXT:    vperm 2, 3, 2, 4
; P9LE-NEXT:    xxspltw 3, 2, 2
; P9LE-NEXT:    vadduwm 2, 2, 3
; P9LE-NEXT:    vextuwrx 3, 3, 2
; P9LE-NEXT:    cmpw 3, 5
; P9LE-NEXT:    bgelr+ 0
; P9LE-NEXT:  # %bb.1: # %if.then
;
; P9BE-LABEL: test8:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    add 6, 3, 4
; P9BE-NEXT:    li 7, 8
; P9BE-NEXT:    lxsibzx 5, 3, 4
; P9BE-NEXT:    addis 3, 2, .LCPI3_1@toc@ha
; P9BE-NEXT:    lxsibzx 2, 6, 7
; P9BE-NEXT:    addis 6, 2, .LCPI3_0@toc@ha
; P9BE-NEXT:    addi 3, 3, .LCPI3_1@toc@l
; P9BE-NEXT:    addi 6, 6, .LCPI3_0@toc@l
; P9BE-NEXT:    lxv 3, 0(6)
; P9BE-NEXT:    li 6, 0
; P9BE-NEXT:    mtvsrwz 4, 6
; P9BE-NEXT:    vperm 2, 4, 2, 3
; P9BE-NEXT:    vperm 3, 4, 5, 3
; P9BE-NEXT:    vspltb 4, 4, 7
; P9BE-NEXT:    vmrghh 3, 3, 4
; P9BE-NEXT:    xxspltw 4, 4, 0
; P9BE-NEXT:    xxmrghw 2, 3, 2
; P9BE-NEXT:    lxv 3, 0(3)
; P9BE-NEXT:    li 3, 0
; P9BE-NEXT:    vperm 2, 4, 2, 3
; P9BE-NEXT:    xxspltw 3, 2, 1
; P9BE-NEXT:    vadduwm 2, 2, 3
; P9BE-NEXT:    vextuwlx 3, 3, 2
; P9BE-NEXT:    cmpw 3, 5
; P9BE-NEXT:    bgelr+ 0
; P9BE-NEXT:  # %bb.1: # %if.then
;
; P9BE-AIX-LABEL: test8:
; P9BE-AIX:       # %bb.0: # %entry
; P9BE-AIX-NEXT:    add 6, 3, 4
; P9BE-AIX-NEXT:    li 7, 8
; P9BE-AIX-NEXT:    lxsibzx 5, 3, 4
; P9BE-AIX-NEXT:    ld 3, L..C5(2) # %const.1
; P9BE-AIX-NEXT:    lxsibzx 2, 6, 7
; P9BE-AIX-NEXT:    ld 6, L..C6(2) # %const.0
; P9BE-AIX-NEXT:    lxv 3, 0(6)
; P9BE-AIX-NEXT:    li 6, 0
; P9BE-AIX-NEXT:    mtvsrwz 4, 6
; P9BE-AIX-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX-NEXT:    vperm 3, 4, 5, 3
; P9BE-AIX-NEXT:    vspltb 4, 4, 7
; P9BE-AIX-NEXT:    vmrghh 3, 3, 4
; P9BE-AIX-NEXT:    xxspltw 4, 4, 0
; P9BE-AIX-NEXT:    xxmrghw 2, 3, 2
; P9BE-AIX-NEXT:    lxv 3, 0(3)
; P9BE-AIX-NEXT:    li 3, 0
; P9BE-AIX-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX-NEXT:    xxspltw 3, 2, 1
; P9BE-AIX-NEXT:    vadduwm 2, 2, 3
; P9BE-AIX-NEXT:    vextuwlx 3, 3, 2
; P9BE-AIX-NEXT:    cmpw 3, 5
; P9BE-AIX-NEXT:    bgelr+ 0
; P9BE-AIX-NEXT:  # %bb.1: # %if.then
;
; P9BE-AIX32-LABEL: test8:
; P9BE-AIX32:       # %bb.0: # %entry
; P9BE-AIX32-NEXT:    add 6, 3, 4
; P9BE-AIX32-NEXT:    li 7, 8
; P9BE-AIX32-NEXT:    lxsibzx 5, 3, 4
; P9BE-AIX32-NEXT:    lwz 3, L..C4(2) # %const.1
; P9BE-AIX32-NEXT:    lxsibzx 2, 6, 7
; P9BE-AIX32-NEXT:    lwz 6, L..C5(2) # %const.0
; P9BE-AIX32-NEXT:    lxv 3, 0(6)
; P9BE-AIX32-NEXT:    li 6, 0
; P9BE-AIX32-NEXT:    mtvsrwz 4, 6
; P9BE-AIX32-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX32-NEXT:    vperm 3, 4, 5, 3
; P9BE-AIX32-NEXT:    vspltb 4, 4, 7
; P9BE-AIX32-NEXT:    vmrghh 3, 3, 4
; P9BE-AIX32-NEXT:    xxspltw 4, 4, 0
; P9BE-AIX32-NEXT:    xxmrghw 2, 3, 2
; P9BE-AIX32-NEXT:    lxv 3, 0(3)
; P9BE-AIX32-NEXT:    vperm 2, 4, 2, 3
; P9BE-AIX32-NEXT:    xxspltw 3, 2, 1
; P9BE-AIX32-NEXT:    vadduwm 2, 2, 3
; P9BE-AIX32-NEXT:    stxv 2, -16(1)
; P9BE-AIX32-NEXT:    lwz 3, -16(1)
; P9BE-AIX32-NEXT:    cmpw 3, 5
; P9BE-AIX32-NEXT:    bgelr+ 0
; P9BE-AIX32-NEXT:  # %bb.1: # %if.then
entry:
  %idxprom = sext i32 %delta to i64
  %add14 = add nsw i32 %delta, 8
  %idxprom15 = sext i32 %add14 to i64
  br label %for.body

for.body:                                         ; preds = %entry
  %arrayidx8 = getelementptr inbounds i8, i8* %sums, i64 %idxprom
  %0 = load i8, i8* %arrayidx8, align 2
  %arrayidx16 = getelementptr inbounds i8, i8* %sums, i64 %idxprom15
  %1 = load i8, i8* %arrayidx16, align 2
  %2 = insertelement <4 x i8> undef, i8 %0, i32 2
  %3 = insertelement <4 x i8> %2, i8 %1, i32 3
  %4 = zext <4 x i8> %3 to <4 x i32>
  %5 = sub nsw <4 x i32> zeroinitializer, %4
  %6 = sub nsw <4 x i32> zeroinitializer, %5
  %7 = select <4 x i1> undef, <4 x i32> %6, <4 x i32> %5
  %bin.rdx = add <4 x i32> %7, zeroinitializer
  %rdx.shuf54 = shufflevector <4 x i32> %bin.rdx, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %bin.rdx55 = add <4 x i32> %bin.rdx, %rdx.shuf54
  %8 = extractelement <4 x i32> %bin.rdx55, i32 0
  %op.extra = add nuw i32 %8, 0
  %cmp25 = icmp slt i32 %op.extra, %thresh
  br i1 %cmp25, label %if.then, label %if.end

if.then:                                          ; preds = %for.body
  unreachable

if.end:                                           ; preds = %for.body
  ret void
}
