/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.TransactionLayoutCallback;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLabelLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MinimizeVisibleEntityMovementLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.NodeOrderLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.PreventDriftLayouter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import yguard.A.A.E;
import yguard.A.A.K;
import yguard.A.A.X;
import yguard.A.D.D;
import yguard.A.F.C;
import yguard.A.G.H.m;
import yguard.A.G.J.B;
import yguard.A.G.NA;
import yguard.A.G.RA;
import yguard.A.G.n;
import yguard.A.J.DA;
import yguard.A.J.QA;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.Y;

public class ViewLayouter {
    private static final Logger LOG = Logger.getLogger(ViewLayouter.class.getName());

    public static void layoutAll(U view, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        ViewLayouter.layoutAll(view, mode, keepZoom, false, Collections.EMPTY_SET, callback, isSignificant);
    }

    public static void layoutAll(U view, LayoutMode mode, boolean keepZoom, boolean incremental, Set<yguard.A.A.Y> newNodes, Runnable callback, boolean isSignificant) throws IllegalStateException {
        ViewLayouter.layoutProvided(view, null, mode, keepZoom, incremental, newNodes, callback, isSignificant);
    }

    public static void layoutProvided(U view, K nodeProvider, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        ViewLayouter.layoutProvided(view, nodeProvider, mode, keepZoom, false, Collections.EMPTY_SET, callback, isSignificant);
    }

    public static void layoutProvided(final U view, final K nodeProvider, LayoutMode mode, final boolean keepZoom, boolean incremental, Set<yguard.A.A.Y> newNodes, final Runnable callback, final boolean isSignificant) throws IllegalStateException {
        final SA graph2D = view.getGraph2D();
        final GraphID graphID = GraphIDProvider.forGraph((SA)graph2D);
        n layouter = LayoutFactory.getLayouter(graph2D, mode, incremental);
        if (layouter == null || graph2D.v() == 0) {
            if (callback != null) {
                callback.run();
            }
        } else {
            HashSet<Object> incrementalNodes;
            if (incremental && graph2D.v() < 60) {
                incrementalNodes = new HashSet();
                E nodes = graph2D.\u00a4();
                while (nodes.ok()) {
                    incrementalNodes.add(nodes.B());
                    nodes.next();
                }
            } else {
                incrementalNodes = new HashSet<yguard.A.A.Y>(newNodes);
            }
            final n augmentedLayouter = ViewLayouter.augmentLayouter(nodeProvider, mode, graph2D, view, layouter, incremental, incrementalNodes);
            final HashSet<yguard.A.A.Y> newNodesCopy = new HashSet<yguard.A.A.Y>(newNodes);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                                HackLayoutMorpher layoutMorpher = new HackLayoutMorpher();
                                layoutMorpher.setKeepZoomFactor(keepZoom);
                                layoutMorpher.setSmoothViewTransform(false);
                                DA executer = new DA(7);
                                executer.setLayoutMorpher((QA)layoutMorpher);
                                TransactionLayoutCallback transactionCallback = new TransactionLayoutCallback(graph2D, nodeProvider, newNodesCopy, callback, isSignificant);
                                U viewWrapper = view;
                                executer.doLayout(viewWrapper, augmentedLayouter, (Runnable)transactionCallback, null);
                                GraphDataObject gdo = GraphDataUtils.getGraphDataObject((yguard.A.A.D)graph2D);
                                if (gdo != null) {
                                    gdo.setModified(true);
                                }
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            if (callback == null) break block4;
                            callback.run();
                        }
                    }
                }
            });
        }
    }

    public static void layoutNodes(U view, Set<yguard.A.A.Y> nodes, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        if (nodes == null || nodes.isEmpty()) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        PartialNodeDataProvider nodeProvider = new PartialNodeDataProvider(nodes);
        ViewLayouter.layoutProvided(view, (K)nodeProvider, mode, keepZoom, callback, isSignificant);
    }

    public static void layoutSelection(U view, LayoutMode mode, boolean keepZoom, Runnable callback, boolean isSignificant) throws IllegalStateException {
        K nodeProvider = Y.F((SA)view.getGraph2D());
        ViewLayouter.layoutProvided(view, nodeProvider, mode, keepZoom, callback, isSignificant);
    }

    public static void layoutAll(SA graph2D, LayoutMode mode) throws IllegalStateException {
        ViewLayouter.layoutProvided(graph2D, null, mode);
    }

    public static void layoutNodes(SA graph2D, Set<yguard.A.A.Y> nodes, LayoutMode mode) throws IllegalStateException {
        if (nodes != null && !nodes.isEmpty()) {
            PartialNodeDataProvider nodeProvider = new PartialNodeDataProvider(nodes);
            ViewLayouter.layoutProvided(graph2D, (K)nodeProvider, mode);
        }
    }

    public static void layoutProvided(SA graph2D, K nodeProvider, LayoutMode mode) throws IllegalStateException {
        n layouter = LayoutFactory.getLayouter(graph2D, mode, false);
        if (layouter != null) {
            layouter = ViewLayouter.augmentLayouter(nodeProvider, mode, graph2D, null, layouter);
            layouter = new NA(layouter);
            layouter.doLayout((RA)graph2D);
        }
    }

    private static n augmentLayouter(K nodeProvider, LayoutMode mode, SA graph2D, U view, n layouter) {
        return ViewLayouter.augmentLayouter(nodeProvider, mode, graph2D, view, layouter, false, Collections.EMPTY_SET);
    }

    private static n augmentLayouter(K nodeProvider, LayoutMode mode, SA graph2D, U view, n layouter, boolean incremental, Set<yguard.A.A.Y> newNodes) {
        if (nodeProvider != null) {
            boolean isAlignLayout = LayoutMode.ALIGN_LEFT.equals((Object)mode) || LayoutMode.ALIGN_RIGHT.equals((Object)mode) || LayoutMode.ALIGN_TOP.equals((Object)mode) || LayoutMode.ALIGN_BOTTOM.equals((Object)mode) || LayoutMode.CENTER_VERTICALLY.equals((Object)mode) || LayoutMode.CENTER_HORIZONTALLY.equals((Object)mode);
            graph2D.A(B.\u0a13, nodeProvider);
            if (LOG.isLoggable(Level.ALL)) {
                E nc = graph2D.\u00a4();
                while (nc.ok()) {
                    yguard.A.A.Y node = nc.B();
                    boolean bool = nodeProvider.getBool((Object)node);
                    LOG.log(Level.FINE, "{0}: {1}", new Object[]{node, bool});
                    nc.next();
                }
            }
            B pl = new B(layouter);
            if (LayoutMode.BLOCK.equals((Object)mode)) {
                pl.U((byte)3);
                graph2D.A(B.\u0a1d, (K)new SiblingComponentProvider());
            } else if (isAlignLayout) {
                pl.U((byte)3);
                graph2D.A(B.\u0a1d, (K)new SingleComponentProvider());
            } else {
                pl.U((byte)1);
            }
            pl.S((byte)3);
            if (LayoutMode.BLOCK.equals((Object)mode) || LayoutMode.HIERARCHICAL.equals((Object)mode)) {
                pl.Q((byte)0);
            } else {
                pl.Q((byte)-1);
            }
            layouter = pl;
            if (isAlignLayout) {
                PreventDriftLayouter pdl = new PreventDriftLayouter();
                pdl.setNodeProviderKey(B.\u0a13);
                pdl.setCoreLayouter(layouter);
                layouter = pdl;
            }
        } else {
            if (incremental) {
                if (layouter instanceof m) {
                    m ihl = (m)layouter;
                    ihl.K((byte)0);
                    MaltegoHierarchicLayouter mhl = new MaltegoHierarchicLayouter(newNodes);
                    mhl.setCoreLayouter((n)ihl);
                    layouter = mhl;
                } else if (layouter instanceof MaltegoLayouter) {
                    MaltegoLayouter ml = (MaltegoLayouter)layouter;
                    ml.setIncremental(true);
                    ml.setNewNodes(newNodes);
                }
            }
            if (view != null) {
                MinimizeVisibleEntityMovementLayouter mveml = new MinimizeVisibleEntityMovementLayouter(view);
                mveml.setCoreLayouter(layouter);
                layouter = mveml;
            }
        }
        NodeOrderLayouter nol = new NodeOrderLayouter();
        nol.setCoreLayouter(layouter);
        layouter = nol;
        MaltegoLabelLayouter labelLayouter = new MaltegoLabelLayouter();
        labelLayouter.setCoreLayouter(layouter);
        layouter = labelLayouter;
        return layouter;
    }

    private static class SingleComponentProvider
    extends D {
        private SingleComponentProvider() {
        }

        public Object get(Object o) {
            return null;
        }
    }

    private static class SiblingComponentProvider
    extends D {
        private final Map<Object, X> _groups = new HashMap<Object, X>();

        private SiblingComponentProvider() {
        }

        public Object get(Object o) {
            Object nodeGroup = null;
            if (o instanceof yguard.A.A.Y) {
                yguard.A.A.Y node = (yguard.A.A.Y)o;
                nodeGroup = this.findGroup(node);
                if (nodeGroup == null) {
                    nodeGroup = new Object();
                    this._groups.put(nodeGroup, new X(node));
                } else {
                    this._groups.get(nodeGroup).add((Object)node);
                }
            }
            return nodeGroup;
        }

        private Object findGroup(yguard.A.A.Y node) {
            yguard.A.A.D graph = node.H();
            for (Object group : this._groups.keySet()) {
                X neighbors;
                X nodeList = this._groups.get(group);
                if (!this.overlaps(nodeList, neighbors = C.A((yguard.A.A.D)graph, (X)new X(node), (int)2))) continue;
                return group;
            }
            return null;
        }

        private boolean overlaps(X nodeList1, X nodeList2) {
            E nc = nodeList1.\u0121();
            while (nc.ok()) {
                if (nodeList2.contains((Object)nc.B())) {
                    return true;
                }
                nc.next();
            }
            return false;
        }
    }

    private static class HackLayoutMorpher
    extends QA {
        private static boolean _hasWarned = false;

        private HackLayoutMorpher() {
        }

        public void calcFrame(double d) {
            block2: {
                try {
                    super.calcFrame(d);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    if (_hasWarned) break block2;
                    System.out.println("WARNING LayoutMorpher ArrayIndexOutOfBoundsException ignored by design");
                    _hasWarned = true;
                }
            }
        }
    }

    private static class PartialNodeDataProvider
    extends D {
        private final Set<yguard.A.A.Y> _nodes;

        public PartialNodeDataProvider(Set<yguard.A.A.Y> nodes) {
            this._nodes = new HashSet<yguard.A.A.Y>(nodes);
        }

        public boolean getBool(Object obj) {
            if (obj instanceof yguard.A.A.Y) {
                try {
                    return this._nodes.contains((yguard.A.A.Y)obj);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }
    }
}

