/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.util.FileExtensionFileFilter;
import com.paterva.maltego.util.ui.dialog.FileController;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

public class ImportFileController<TData>
extends FileController {
    private final boolean _multiSelect;
    private TabularGraph _tabularGraph = null;

    public ImportFileController() {
        this(true);
    }

    public ImportFileController(boolean multiSelect) {
        super(0, null, null);
        this._multiSelect = multiSelect;
        this.setName("Select File" + (multiSelect ? "(s)" : ""));
    }

    public void readSettings(WizardDescriptor settings) {
        super.readSettings(settings);
        this.populateFileTypes();
    }

    private void populateFileTypes() {
        JFileChooser component = (JFileChooser)this.component();
        component.resetChoosableFileFilters();
        component.setAcceptAllFileFilterUsed(false);
        ArrayList<String> extensions = new ArrayList<String>();
        for (TabularGraphFileImporterFactory importer : TabularGraphFileImporterFactory.getAll()) {
            String extension = importer.getExtension();
            component.addChoosableFileFilter(new FileNameExtensionFilter(importer.getFileTypeDescription(), extension));
            extensions.add(extension);
        }
        FileExtensionFileFilter defaultFilter = new FileExtensionFileFilter(extensions.toArray(new String[extensions.size()]), "Tabular file");
        component.addChoosableFileFilter((FileFilter)defaultFilter);
        component.setFileFilter((FileFilter)defaultFilter);
        component.setMultiSelectionEnabled(this._multiSelect);
    }

    public void setTabularGraph(TabularGraph tabularGraph) {
        this._tabularGraph = tabularGraph;
    }

    public TabularGraph getTabularGraph() {
        return this._tabularGraph;
    }

    public void validate() throws WizardValidationException {
        String error;
        File[] files = this.getOneOrMoreSelectedFiles();
        if (files == null) {
            error = "Please select a file or files to import";
        } else {
            List<File> filesList = Arrays.asList(files);
            List importers = TabularGraphFileImporterFactory.createImporters(filesList);
            this.getDescriptor().putProperty("files", filesList);
            if (importers.isEmpty() || importers.size() != files.length) {
                error = "Importers could not be found for all selected file types";
            } else {
                if (this._tabularGraph == null) {
                    this._tabularGraph = new DefaultTabularGraph();
                    this._tabularGraph.setExisting(false);
                } else {
                    this._tabularGraph.setExisting(true);
                }
                try {
                    TabularGraphFileImporter firstImporter = (TabularGraphFileImporter)importers.get(0);
                    error = this.testFirst10Rows(firstImporter);
                    if (error == null) {
                        error = this.checkColumnNumbers(this._tabularGraph, firstImporter);
                    }
                    if (error == null) {
                        this.getDescriptor().putProperty("graphTable", (Object)this._tabularGraph);
                    }
                }
                catch (IOException ex) {
                    error = "Unable to read file: " + ex.getMessage();
                }
            }
        }
        if (error != null) {
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String testFirst10Rows(TabularGraphFileImporter importer) throws IOException {
        try (TabularGraphIterator itr = importer.open();){
            int i = 0;
            while (i < 10) {
                if (!itr.hasNext()) return "The file contains no useable data.";
                List row = itr.getRow(null);
                if (!row.isEmpty()) {
                    for (Object value : row) {
                        if (value == null) continue;
                        String string = null;
                        return string;
                    }
                }
                ++i;
                itr.next();
            }
            return "The file contains no useable data.";
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private String checkColumnNumbers(TabularGraph tabularGraph, TabularGraphFileImporter importer) throws IOException {
        String error = null;
        int dataProviderColumnCount = 0;
        try {
            TabularGraphIterator itr = importer.open();
            Object object = null;
            try {
                for (int i = 0; i < 100 && itr.hasNext(); ++i) {
                    List row = itr.getRow(null);
                    dataProviderColumnCount = Math.max(dataProviderColumnCount, row.size());
                    itr.next();
                }
            }
            catch (Throwable i) {
                object = i;
                throw i;
            }
            finally {
                if (itr != null) {
                    if (object != null) {
                        try {
                            itr.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)object).addSuppressed(i);
                        }
                    } else {
                        itr.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        int tbGraphMaxColumn = 0;
        for (TabularGraphEntity entity : tabularGraph.getEntities()) {
            for (int column : entity.getColumns()) {
                tbGraphMaxColumn = Math.max(tbGraphMaxColumn, column + 1);
            }
        }
        if (tbGraphMaxColumn > dataProviderColumnCount) {
            error = String.format("Number of columns in the Mapping Configuration (%d) exceeds the number of columns in the Input File (%d).", tbGraphMaxColumn, dataProviderColumnCount);
        }
        return error;
    }
}

