/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.repository.serializer.TransformSetStub;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.openide.util.Lookup;

public abstract class TransformSetSerializer {
    public static TransformSetSerializer getDefault() {
        TransformSetSerializer serializer = (TransformSetSerializer)Lookup.getDefault().lookup(TransformSetSerializer.class);
        if (serializer == null) {
            serializer = new DefaultTransformSetSerializer();
        }
        return serializer;
    }

    public abstract void write(TransformSet var1, OutputStream var2) throws XmlSerializationException;

    public abstract TransformSet read(InputStream var1) throws XmlSerializationException;

    private static class DefaultTransformSetSerializer
    extends TransformSetSerializer {
        private DefaultTransformSetSerializer() {
        }

        @Override
        public void write(TransformSet set, OutputStream stream) throws XmlSerializationException {
            XmlSerializer serializer = new XmlSerializer();
            TransformSetStub stub = this.translate(set);
            serializer.write((Object)stub, stream);
        }

        @Override
        public TransformSet read(InputStream stream) throws XmlSerializationException {
            XmlSerializer serializer = new XmlSerializer();
            TransformSetStub stub = (TransformSetStub)serializer.read(TransformSetStub.class, stream);
            return this.translate(stub);
        }

        private TransformSetStub translate(TransformSet set) {
            TransformSetStub stub = new TransformSetStub();
            stub.setName(set.getName());
            stub.setDescription(set.getDescription());
            stub.setCustom(set.isCustom());
            stub.setTransforms(new ArrayList<String>(set.getAllTransforms()));
            return stub;
        }

        private TransformSet translate(TransformSetStub stub) {
            String setName = stub.getName();
            setName = FileUtilities.removePathChangeCharacters((String)setName);
            TransformSet set = new TransformSet(setName);
            set.setDescription(stub.getDescription());
            set.setCustom(stub.isCustom());
            for (String transform : stub.getTransforms()) {
                transform = FileUtilities.removePathChangeCharacters((String)transform);
                set.addTransform(transform);
            }
            return set;
        }
    }
}

