/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.util.ui.look.Look;
import com.paterva.maltego.util.ui.look.ShadedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.openide.util.NbBundle;

public class RadioButtonHeaderControl
extends ShadedPanel {
    public static final String MUST_GREY_OUT = "MustGreyOut";
    private ActionCallback _cb;
    private Color _bgColor;
    public JRadioButton _radioButton;
    private JLabel _title;
    private JPanel jPanel1;

    public RadioButtonHeaderControl(Border outsideBorder, Color fontColor) {
        this(outsideBorder, fontColor, null);
    }

    public RadioButtonHeaderControl(Border outsideBorder, ActionCallback cb) {
        this(outsideBorder, UIManager.getLookAndFeelDefaults().getColor("transform-manager-panel-subheader-title"), cb);
    }

    public RadioButtonHeaderControl(Border outsideBorder, Color fontColor, ActionCallback cb) {
        this.initComponents();
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this._bgColor = laf.getColor("transform-manager-panel-subheader-bg");
        this.setBackground(this._bgColor);
        this.setShadeFactor(0.0);
        if (outsideBorder == null) {
            this.setBorder(Look.SUBHEADER_BORDER);
        } else {
            this.setBorder(new CompoundBorder(outsideBorder, Look.SUBHEADER_BORDER));
        }
        this._title.setForeground(fontColor);
        this._title.setFont(this._title.getFont().deriveFont(1));
        this._cb = cb;
        if (this._cb != null) {
            this._cb.setRadioButton(this._radioButton);
        }
    }

    public void setTitle(String title) {
        this._title.setText(title);
    }

    public void radioButtonSelected() {
        if (this._cb != null && !this._cb.isSelected()) {
            this._cb.perform(this._cb, true, true);
        }
    }

    private void initComponents() {
        this._title = new JLabel();
        this._radioButton = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this._title.setText(NbBundle.getMessage(RadioButtonHeaderControl.class, (String)"RadioButtonHeaderControl._title.text"));
        this._title.setHorizontalTextPosition(2);
        this._title.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                RadioButtonHeaderControl.this._titleMouseReleased(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        this.add((Component)this._title, gridBagConstraints);
        this._radioButton.setText(NbBundle.getMessage(RadioButtonHeaderControl.class, (String)"RadioButtonHeaderControl._radioButton.text"));
        this._radioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RadioButtonHeaderControl.this._radioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this._radioButton, gridBagConstraints);
        this.jPanel1.setBackground(this._bgColor);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void _titleMouseReleased(MouseEvent evt) {
        this.radioButtonSelected();
    }

    private void _radioButtonActionPerformed(ActionEvent evt) {
        if (!this._radioButton.isSelected()) {
            this._radioButton.setSelected(true);
        }
        this.radioButtonSelected();
    }

    public static abstract class ActionCallback {
        private boolean _isSelected = false;
        private JRadioButton _cbRadioButton;
        private List<Component> _innerComponents = new ArrayList<Component>();

        public void setRadioButton(JRadioButton radioButton) {
            this._cbRadioButton = radioButton;
        }

        public List<Component> getInnerComponents() {
            return this._innerComponents;
        }

        public void setInnerComponents(List<Component> innerComponents) {
            this._innerComponents = innerComponents;
        }

        public boolean isSelected() {
            return this._isSelected;
        }

        public void setSelected(ActionCallback cb, boolean isSelected, boolean changeSelectedStateOfOther) {
            if (this._isSelected != isSelected) {
                this._isSelected = isSelected;
                this._cbRadioButton.setSelected(this._isSelected);
                this.perform(cb, this._isSelected, changeSelectedStateOfOther);
            }
        }

        public int hashCode() {
            int hash = 3;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActionCallback other = (ActionCallback)obj;
            return Objects.equals(this._cbRadioButton, other._cbRadioButton);
        }

        public abstract void perform(ActionCallback var1, boolean var2, boolean var3);
    }
}

