/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.MachineInputControl;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptors;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.typing.editing.ComponentFactory;
import com.paterva.maltego.util.ui.VFlowLayout;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

class MachineInputController
extends ValidatingController<MachineInputControl> {
    MachineInputController() {
    }

    protected MachineInputControl createComponent() {
        MachineInputControl c = new MachineInputControl();
        return c;
    }

    protected void readSettings(WizardDescriptor descriptor) {
        try {
            String description;
            MachineDescriptor machine = (MachineDescriptor)descriptor.getProperty("selectedMachine");
            MachineInput input = MachineInputProvider.getDefault().getInputDescriptor(machine);
            if (input.getSupportedEntityTypes().length == 0) {
                description = "Click \"Finish\" to run the \"" + machine.getDisplayName() + "\" machine.";
                descriptor.putProperty("selectedTarget", null);
                ((MachineInputControl)this.component()).setEditor(null);
            } else {
                MaltegoEntity[] mes;
                MaltegoEntity[] entities = this.generateEntities(input);
                Object property = descriptor.getProperty("selectedTarget");
                if (property instanceof MaltegoEntity[] && (mes = (MaltegoEntity[])property).length > 0) {
                    block2: for (int i = 0; i < entities.length; ++i) {
                        for (MaltegoEntity me : mes) {
                            if (!entities[i].getTypeName().equals(me.getTypeName())) continue;
                            entities[i] = me;
                            continue block2;
                        }
                    }
                }
                descriptor.putProperty("selectedTarget", (Object)entities);
                ((MachineInputControl)this.component()).setEditor(this.createEditor(entities));
                description = entities != null && entities.length > 0 ? String.format("The %s machine requires the following inputs:", machine.getDisplayName()) : "No required inputs were found. Please proceed.";
            }
            ((MachineInputControl)this.component()).setDescription(description);
        }
        catch (TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Component createEditor(MaltegoEntity[] entities) {
        JPanel panel = new JPanel((LayoutManager)new VFlowLayout(5));
        ComponentFactory factory = ComponentFactories.form();
        EntityRegistry registry = EntityRegistry.getDefault();
        for (MaltegoEntity entity : entities) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(entity.getTypeName());
            PropertyDescriptor valueProperty = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entity, (boolean)true);
            if (!(valueProperty instanceof DisplayDescriptor)) continue;
            DisplayDescriptor displayDescriptor = (DisplayDescriptor)valueProperty;
            Component c = factory.createEditingComponent((DataSource)entity, DisplayDescriptors.singleton((DisplayDescriptor)displayDescriptor), null);
            panel.add(c);
        }
        return panel;
    }

    private MaltegoEntity[] generateEntities(MachineInput input) throws TypeInstantiationException {
        ArrayList<Object> list = new ArrayList<Object>(input.getSupportedEntityTypes().length);
        for (String type : input.getSupportedEntityTypes()) {
            list.add(EntityFactory.getDefault().createInstance(type, false, true));
        }
        return list.toArray(new MaltegoEntity[list.size()]);
    }

    protected void storeSettings(WizardDescriptor descriptor) {
    }
}

