/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.units;

import info.monitorenter.util.units.AUnit;
import info.monitorenter.util.units.IUnitSystem;
import info.monitorenter.util.units.UnitUnchanged;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitFactory {
    private static UnitFactory instance;
    public static final AUnit UNCHANGED;
    private static final Map<String, List<AUnit>> UNITSYSTEMS;

    public static UnitFactory getInstance() {
        if (instance == null) {
            instance = new UnitFactory();
        }
        return instance;
    }

    private UnitFactory() {
    }

    public AUnit getUnit(double absoluteMax, IUnitSystem units) {
        AUnit result = UNCHANGED;
        List<AUnit> choice = UNITSYSTEMS.get(units.getClass().getName());
        if (choice == null) {
            choice = this.initUnitSystem(units);
        }
        result = choice.get(0);
        for (AUnit peek : choice) {
            if (absoluteMax < peek.getFactor()) break;
            result = peek;
        }
        return result;
    }

    public List<AUnit> getUnits(IUnitSystem unitsystem) {
        List<AUnit> choice = UNITSYSTEMS.get(unitsystem.getClass().getName());
        if (choice == null) {
            choice = this.initUnitSystem(unitsystem);
        }
        return choice;
    }

    private List<AUnit> initUnitSystem(IUnitSystem units) {
        LinkedList<AUnit> choice = new LinkedList<AUnit>();
        Class<?>[] clazzs = units.getUnits();
        AUnit unit = null;
        AUnit previous = null;
        for (int i = 0; i < clazzs.length; ++i) {
            if (!AUnit.class.isAssignableFrom(clazzs[i])) {
                System.err.println("UnitFactory: wrong class " + clazzs[i].getName() + " delivered by " + units.getClass().getName());
                continue;
            }
            try {
                unit = (AUnit)clazzs[i].newInstance();
                choice.add(unit);
                if (previous != null) {
                    previous.m_nextHigherUnit = unit;
                    unit.m_nexLowerUnit = previous;
                }
                previous = unit;
                continue;
            }
            catch (InstantiationException e) {
                System.err.println("UnitFactory encountered problems by instantiation of " + clazzs[i].getName());
                continue;
            }
            catch (IllegalAccessException f) {
                System.err.println("UnitFactory has no access to " + clazzs[i].getName());
            }
        }
        int stop = choice.size();
        for (int i = 0; i < stop - 1; ++i) {
            int min = i;
            double tmpfactori = ((AUnit)choice.get(i)).getFactor();
            for (int j = i + 1; j < stop; ++j) {
                double tmpfactorj = ((AUnit)choice.get(j)).getFactor();
                if (!(tmpfactorj < tmpfactori)) continue;
                tmpfactori = tmpfactorj;
                min = j;
            }
            choice.add(i, (AUnit)choice.remove(min));
        }
        UNITSYSTEMS.put(units.getClass().getName(), choice);
        return choice;
    }

    static {
        UNCHANGED = new UnitUnchanged();
        UNITSYSTEMS = new HashMap<String, List<AUnit>>();
    }
}

