# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import (
    FileShareConfigurationType,
    NamingPatternType,
    OSType,
    SAPConfigurationType,
    SAPDeploymentType,
    SAPSoftwareInstallationType,
)

if TYPE_CHECKING:
    from .. import models as _models


class ApplicationServerConfiguration(_model_base.Model):
    """Gets or sets the application server configuration.

    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar instance_count: The number of app server instances. Required.
    :vartype instance_count: int
    """

    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The subnet id. Required."""
    virtual_machine_configuration: "_models.VirtualMachineConfiguration" = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the virtual machine configuration. Required."""
    instance_count: int = rest_field(name="instanceCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of app server instances. Required."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        instance_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationServerFullResourceNames(_model_base.Model):
    """The full resource names object for application layer resources. The number of entries in this
    list should be equal to the number VMs to be created for application layer.

    :ivar virtual_machines: The list of virtual machine naming details.
    :vartype virtual_machines:
     list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
    :ivar availability_set_name: The full name for availability set. In case name is not provided,
     it will be defaulted to {SID}-App-AvSet.
    :vartype availability_set_name: str
    """

    virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = rest_field(
        name="virtualMachines", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of virtual machine naming details."""
    availability_set_name: Optional[str] = rest_field(
        name="availabilitySetName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name for availability set. In case name is not provided, it will be defaulted to
     {SID}-App-AvSet."""

    @overload
    def __init__(
        self,
        *,
        virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = None,
        availability_set_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationServerVmDetails(_model_base.Model):
    """The Application Server VM Details.

    :ivar type: Defines the type of application server VM. Known values are: "Active", "Standby",
     and "Unknown".
    :vartype type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerVirtualMachineType
    :ivar virtual_machine_id: The virtual machine id.
    :vartype virtual_machine_id: str
    :ivar storage_details: Storage details of all the Storage Accounts attached to the App Virtual
     Machine. For e.g. NFS on AFS Shared Storage.
    :vartype storage_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.StorageInformation]
    """

    type: Optional[Union[str, "_models.ApplicationServerVirtualMachineType"]] = rest_field(visibility=["read"])
    """Defines the type of application server VM. Known values are: \"Active\", \"Standby\", and
     \"Unknown\"."""
    virtual_machine_id: Optional[str] = rest_field(name="virtualMachineId", visibility=["read"])
    """The virtual machine id."""
    storage_details: Optional[List["_models.StorageInformation"]] = rest_field(
        name="storageDetails", visibility=["read"]
    )
    """Storage details of all the Storage Accounts attached to the App Virtual Machine. For e.g. NFS
     on AFS Shared Storage."""


class CentralServerConfiguration(_model_base.Model):
    """Gets or sets the central server configuration.

    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar instance_count: The number of central server VMs. Required.
    :vartype instance_count: int
    """

    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The subnet id. Required."""
    virtual_machine_configuration: "_models.VirtualMachineConfiguration" = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the virtual machine configuration. Required."""
    instance_count: int = rest_field(name="instanceCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of central server VMs. Required."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        instance_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CentralServerFullResourceNames(_model_base.Model):
    """The full resource names object for central server layer resources.

    :ivar virtual_machines: The list of names for all ASCS virtual machines to be deployed. The
     number of entries in this list should be equal to the number VMs to be created for ASCS layer.
     At maximum, there can be two virtual machines at this layer: ASCS and ERS.
    :vartype virtual_machines:
     list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
    :ivar availability_set_name: The full name for availability set. In case name is not provided,
     it will be defaulted to {SID}-ASCS-AvSet.
    :vartype availability_set_name: str
    :ivar load_balancer: The resource names object for load balancer and related resources.
    :vartype load_balancer:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerResourceNames
    """

    virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = rest_field(
        name="virtualMachines", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of names for all ASCS virtual machines to be deployed. The number of entries in this
     list should be equal to the number VMs to be created for ASCS layer. At maximum, there can be
     two virtual machines at this layer: ASCS and ERS."""
    availability_set_name: Optional[str] = rest_field(
        name="availabilitySetName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name for availability set. In case name is not provided, it will be defaulted to
     {SID}-ASCS-AvSet."""
    load_balancer: Optional["_models.LoadBalancerResourceNames"] = rest_field(
        name="loadBalancer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource names object for load balancer and related resources."""

    @overload
    def __init__(
        self,
        *,
        virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = None,
        availability_set_name: Optional[str] = None,
        load_balancer: Optional["_models.LoadBalancerResourceNames"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CentralServerVmDetails(_model_base.Model):
    """The SAP Central Services Instance VM details.

    :ivar type: Defines the type of central server VM. Known values are: "Primary", "Secondary",
     "Unknown", "ASCS", "ERSInactive", "ERS", and "Standby".
    :vartype type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerVirtualMachineType
    :ivar virtual_machine_id: The virtual machine id.
    :vartype virtual_machine_id: str
    :ivar storage_details: Storage details of all the Storage Accounts attached to the ASCS Virtual
     Machine. For e.g. NFS on AFS Shared Storage.
    :vartype storage_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.StorageInformation]
    """

    type: Optional[Union[str, "_models.CentralServerVirtualMachineType"]] = rest_field(visibility=["read"])
    """Defines the type of central server VM. Known values are: \"Primary\", \"Secondary\",
     \"Unknown\", \"ASCS\", \"ERSInactive\", \"ERS\", and \"Standby\"."""
    virtual_machine_id: Optional[str] = rest_field(name="virtualMachineId", visibility=["read"])
    """The virtual machine id."""
    storage_details: Optional[List["_models.StorageInformation"]] = rest_field(
        name="storageDetails", visibility=["read"]
    )
    """Storage details of all the Storage Accounts attached to the ASCS Virtual Machine. For e.g. NFS
     on AFS Shared Storage."""


class FileShareConfiguration(_model_base.Model):
    """File Share configuration details, populated with information on storage configuration mounted
    on the VIS. The createAndMount option is selected in case of missing input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CreateAndMountFileShareConfiguration, MountFileShareConfiguration, SkipFileShareConfiguration

    :ivar configuration_type: The type of file share config, eg: Mount/CreateAndMount/Skip.
     Required. Known values are: "Skip", "CreateAndMount", and "Mount".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.FileShareConfigurationType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    configuration_type: str = rest_discriminator(
        name="configurationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of file share config, eg: Mount/CreateAndMount/Skip. Required. Known values are:
     \"Skip\", \"CreateAndMount\", and \"Mount\"."""

    @overload
    def __init__(
        self,
        *,
        configuration_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CreateAndMountFileShareConfiguration(FileShareConfiguration, discriminator="CreateAndMount"):
    """Gets or sets the file share configuration where the transport directory fileshare is created
    and mounted as a part of the create infra flow. Please pre-create the resource group you intend
    to place the transport directory in. The storage account and fileshare will be auto-created by
    the ACSS and doesn't need to be pre-created.

    :ivar resource_group: The name of transport file share resource group. This should be pre
     created by the customer. The app rg is used in case of missing input.
    :vartype resource_group: str
    :ivar storage_account_name: The name of file share storage account name . A custom name is used
     in case of missing input.
    :vartype storage_account_name: str
    :ivar configuration_type: The type of file share config. Required. Fileshare will be created
     and mounted by service.
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.CREATE_AND_MOUNT
    """

    resource_group: Optional[str] = rest_field(
        name="resourceGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of transport file share resource group. This should be pre created by the customer.
     The app rg is used in case of missing input."""
    storage_account_name: Optional[str] = rest_field(
        name="storageAccountName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of file share storage account name . A custom name is used in case of missing input."""
    configuration_type: Literal[FileShareConfigurationType.CREATE_AND_MOUNT] = rest_discriminator(name="configurationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of file share config. Required. Fileshare will be created and mounted by service."""

    @overload
    def __init__(
        self,
        *,
        resource_group: Optional[str] = None,
        storage_account_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, configuration_type=FileShareConfigurationType.CREATE_AND_MOUNT, **kwargs)


class DatabaseConfiguration(_model_base.Model):
    """Gets or sets the database configuration.

    :ivar database_type: The database type. Known values are: "HANA" and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar instance_count: The number of database VMs. Required.
    :vartype instance_count: int
    :ivar disk_configuration: Gets or sets the disk configuration.
    :vartype disk_configuration: ~azure.mgmt.workloadssapvirtualinstance.models.DiskConfiguration
    """

    database_type: Optional[Union[str, "_models.SAPDatabaseType"]] = rest_field(
        name="databaseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database type. Known values are: \"HANA\" and \"DB2\"."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The subnet id. Required."""
    virtual_machine_configuration: "_models.VirtualMachineConfiguration" = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the virtual machine configuration. Required."""
    instance_count: int = rest_field(name="instanceCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of database VMs. Required."""
    disk_configuration: Optional["_models.DiskConfiguration"] = rest_field(
        name="diskConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the disk configuration."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        instance_count: int,
        database_type: Optional[Union[str, "_models.SAPDatabaseType"]] = None,
        disk_configuration: Optional["_models.DiskConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DatabaseServerFullResourceNames(_model_base.Model):
    """The full resource names object for database layer resources. The number of entries in this list
    should be equal to the number VMs to be created for database layer.

    :ivar virtual_machines: The list of virtual machine naming details.
    :vartype virtual_machines:
     list[~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames]
    :ivar availability_set_name: The full name for availability set. In case name is not provided,
     it will be defaulted to {SID}-DB-AvSet.
    :vartype availability_set_name: str
    :ivar load_balancer: The resource names object for load balancer and related resources.
    :vartype load_balancer:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerResourceNames
    """

    virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = rest_field(
        name="virtualMachines", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of virtual machine naming details."""
    availability_set_name: Optional[str] = rest_field(
        name="availabilitySetName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name for availability set. In case name is not provided, it will be defaulted to
     {SID}-DB-AvSet."""
    load_balancer: Optional["_models.LoadBalancerResourceNames"] = rest_field(
        name="loadBalancer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource names object for load balancer and related resources."""

    @overload
    def __init__(
        self,
        *,
        virtual_machines: Optional[List["_models.VirtualMachineResourceNames"]] = None,
        availability_set_name: Optional[str] = None,
        load_balancer: Optional["_models.LoadBalancerResourceNames"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DatabaseVmDetails(_model_base.Model):
    """Database VM details.

    :ivar virtual_machine_id: The virtual machine id.
    :vartype virtual_machine_id: str
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar storage_details: Storage details of all the Storage Accounts attached to the Database
     Virtual Machine. For e.g. NFS on AFS Shared Storage.
    :vartype storage_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.StorageInformation]
    """

    virtual_machine_id: Optional[str] = rest_field(name="virtualMachineId", visibility=["read"])
    """The virtual machine id."""
    status: Optional[Union[str, "_models.SAPVirtualInstanceStatus"]] = rest_field(visibility=["read"])
    """Defines the SAP Instance status. Known values are: \"Starting\", \"Running\", \"Stopping\",
     \"Offline\", \"PartiallyRunning\", \"Unavailable\", and \"SoftShutdown\"."""
    storage_details: Optional[List["_models.StorageInformation"]] = rest_field(
        name="storageDetails", visibility=["read"]
    )
    """Storage details of all the Storage Accounts attached to the Database Virtual Machine. For e.g.
     NFS on AFS Shared Storage."""


class DeployerVmPackages(_model_base.Model):
    """Defines the url and storage account ID where deployer VM packages are uploaded.

    :ivar url: The URL to the deployer VM packages file.
    :vartype url: str
    :ivar storage_account_id: The deployer VM packages storage account id.
    :vartype storage_account_id: str
    """

    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL to the deployer VM packages file."""
    storage_account_id: Optional[str] = rest_field(
        name="storageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The deployer VM packages storage account id."""

    @overload
    def __init__(
        self,
        *,
        url: Optional[str] = None,
        storage_account_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPConfiguration(_model_base.Model):
    """The SAP Configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DeploymentConfiguration, DeploymentWithOSConfiguration, DiscoveryConfiguration

    :ivar configuration_type: The configuration type. Eg: Deployment/Discovery. Required. Known
     values are: "Deployment", "Discovery", and "DeploymentWithOSConfig".
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfigurationType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    configuration_type: str = rest_discriminator(
        name="configurationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration type. Eg: Deployment/Discovery. Required. Known values are: \"Deployment\",
     \"Discovery\", and \"DeploymentWithOSConfig\"."""

    @overload
    def __init__(
        self,
        *,
        configuration_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentConfiguration(SAPConfiguration, discriminator="Deployment"):
    """Deployment Configuration.

    :ivar app_location: The geo-location where the SAP system is to be created.
    :vartype app_location: str
    :ivar infrastructure_configuration: The infrastructure configuration.
    :vartype infrastructure_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.InfrastructureConfiguration
    :ivar software_configuration: The software configuration.
    :vartype software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.SoftwareConfiguration
    :ivar configuration_type: The deployment configuration Type. Required. SAP system will be
     deployed by service. No OS configurations will be done.
    :vartype configuration_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.DEPLOYMENT
    """

    app_location: Optional[str] = rest_field(
        name="appLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The geo-location where the SAP system is to be created."""
    infrastructure_configuration: Optional["_models.InfrastructureConfiguration"] = rest_field(
        name="infrastructureConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The infrastructure configuration."""
    software_configuration: Optional["_models.SoftwareConfiguration"] = rest_field(
        name="softwareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The software configuration."""
    configuration_type: Literal[SAPConfigurationType.DEPLOYMENT] = rest_discriminator(name="configurationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The deployment configuration Type. Required. SAP system will be deployed by service. No OS
     configurations will be done."""

    @overload
    def __init__(
        self,
        *,
        app_location: Optional[str] = None,
        infrastructure_configuration: Optional["_models.InfrastructureConfiguration"] = None,
        software_configuration: Optional["_models.SoftwareConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, configuration_type=SAPConfigurationType.DEPLOYMENT, **kwargs)


class DeploymentWithOSConfiguration(SAPConfiguration, discriminator="DeploymentWithOSConfig"):
    """Deployment along with OS Configuration.

    :ivar app_location: The geo-location where the SAP system is to be created.
    :vartype app_location: str
    :ivar infrastructure_configuration: The infrastructure configuration.
    :vartype infrastructure_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.InfrastructureConfiguration
    :ivar software_configuration: The software configuration.
    :vartype software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.SoftwareConfiguration
    :ivar os_sap_configuration: The OS and SAP configuration.
    :vartype os_sap_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.OsSapConfiguration
    :ivar configuration_type: The configuration Type. Required. SAP system will be deployed by
     service. OS configurations will be done.
    :vartype configuration_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.DEPLOYMENT_WITH_OS_CONFIG
    """

    app_location: Optional[str] = rest_field(
        name="appLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The geo-location where the SAP system is to be created."""
    infrastructure_configuration: Optional["_models.InfrastructureConfiguration"] = rest_field(
        name="infrastructureConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The infrastructure configuration."""
    software_configuration: Optional["_models.SoftwareConfiguration"] = rest_field(
        name="softwareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The software configuration."""
    os_sap_configuration: Optional["_models.OsSapConfiguration"] = rest_field(
        name="osSapConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OS and SAP configuration."""
    configuration_type: Literal[SAPConfigurationType.DEPLOYMENT_WITH_OS_CONFIG] = rest_discriminator(name="configurationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The configuration Type. Required. SAP system will be deployed by service. OS configurations
     will be done."""

    @overload
    def __init__(
        self,
        *,
        app_location: Optional[str] = None,
        infrastructure_configuration: Optional["_models.InfrastructureConfiguration"] = None,
        software_configuration: Optional["_models.SoftwareConfiguration"] = None,
        os_sap_configuration: Optional["_models.OsSapConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, configuration_type=SAPConfigurationType.DEPLOYMENT_WITH_OS_CONFIG, **kwargs)


class DiscoveryConfiguration(SAPConfiguration, discriminator="Discovery"):
    """Discovery Details.

    :ivar central_server_vm_id: The virtual machine ID of the Central Server.
    :vartype central_server_vm_id: str
    :ivar managed_rg_storage_account_name: The custom storage account name for the storage account
     created by the service in the managed resource group created as part of VIS
     deployment.<br><br>Refer to the storage account naming rules `here
     <https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage>`_.<br><br>If
     not provided, the service will create the storage account with a random name.
    :vartype managed_rg_storage_account_name: str
    :ivar app_location: The geo-location where the SAP system exists.
    :vartype app_location: str
    :ivar configuration_type: The configuration Type. Required. Existing SAP system will be
     registered.
    :vartype configuration_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.DISCOVERY
    """

    central_server_vm_id: Optional[str] = rest_field(
        name="centralServerVmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine ID of the Central Server."""
    managed_rg_storage_account_name: Optional[str] = rest_field(
        name="managedRgStorageAccountName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The custom storage account name for the storage account created by the service in the managed
     resource group created as part of VIS deployment.<br><br>Refer to the storage account naming
     rules `here
     <https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage>`_.<br><br>If
     not provided, the service will create the storage account with a random name."""
    app_location: Optional[str] = rest_field(name="appLocation", visibility=["read"])
    """The geo-location where the SAP system exists."""
    configuration_type: Literal[SAPConfigurationType.DISCOVERY] = rest_discriminator(name="configurationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The configuration Type. Required. Existing SAP system will be registered."""

    @overload
    def __init__(
        self,
        *,
        central_server_vm_id: Optional[str] = None,
        managed_rg_storage_account_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, configuration_type=SAPConfigurationType.DISCOVERY, **kwargs)


class DiskConfiguration(_model_base.Model):
    """The Disk Configuration Details.

    :ivar disk_volume_configurations: The disk configuration for the db volume. For HANA, Required
     volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume :
     ['backup'].
    :vartype disk_volume_configurations: dict[str,
     ~azure.mgmt.workloadssapvirtualinstance.models.DiskVolumeConfiguration]
    """

    disk_volume_configurations: Optional[Dict[str, "_models.DiskVolumeConfiguration"]] = rest_field(
        name="diskVolumeConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data',
     'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup']."""

    @overload
    def __init__(
        self,
        *,
        disk_volume_configurations: Optional[Dict[str, "_models.DiskVolumeConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskDetails(_model_base.Model):
    """The supported disk size details for a disk type.

    :ivar sku: The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS,
     Premium_ZRS.
    :vartype sku: ~azure.mgmt.workloadssapvirtualinstance.models.DiskSku
    :ivar size_gb: The disk size in GB.
    :vartype size_gb: int
    :ivar minimum_supported_disk_count: The minimum supported disk count.
    :vartype minimum_supported_disk_count: int
    :ivar maximum_supported_disk_count: The maximum supported disk count.
    :vartype maximum_supported_disk_count: int
    :ivar iops_read_write: The disk Iops.
    :vartype iops_read_write: int
    :ivar mbps_read_write: The disk provisioned throughput in MBps.
    :vartype mbps_read_write: int
    :ivar disk_tier: The disk tier, e.g. P10, E10.
    :vartype disk_tier: str
    """

    sku: Optional["_models.DiskSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS."""
    size_gb: Optional[int] = rest_field(name="sizeGB", visibility=["read", "create", "update", "delete", "query"])
    """The disk size in GB."""
    minimum_supported_disk_count: Optional[int] = rest_field(
        name="minimumSupportedDiskCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum supported disk count."""
    maximum_supported_disk_count: Optional[int] = rest_field(
        name="maximumSupportedDiskCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum supported disk count."""
    iops_read_write: Optional[int] = rest_field(
        name="iopsReadWrite", visibility=["read", "create", "update", "delete", "query"]
    )
    """The disk Iops."""
    mbps_read_write: Optional[int] = rest_field(
        name="mbpsReadWrite", visibility=["read", "create", "update", "delete", "query"]
    )
    """The disk provisioned throughput in MBps."""
    disk_tier: Optional[str] = rest_field(name="diskTier", visibility=["read", "create", "update", "delete", "query"])
    """The disk tier, e.g. P10, E10."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.DiskSku"] = None,
        size_gb: Optional[int] = None,
        minimum_supported_disk_count: Optional[int] = None,
        maximum_supported_disk_count: Optional[int] = None,
        iops_read_write: Optional[int] = None,
        mbps_read_write: Optional[int] = None,
        disk_tier: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskSku(_model_base.Model):
    """The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.

    :ivar name: Defines the disk sku name. Known values are: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype name: str or ~azure.mgmt.workloadssapvirtualinstance.models.DiskSkuName
    """

    name: Optional[Union[str, "_models.DiskSkuName"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the disk sku name. Known values are: \"Standard_LRS\", \"Premium_LRS\",
     \"StandardSSD_LRS\", \"UltraSSD_LRS\", \"Premium_ZRS\", \"StandardSSD_ZRS\", and
     \"PremiumV2_LRS\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.DiskSkuName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskVolumeConfiguration(_model_base.Model):
    """The disk configuration required for the selected volume.

    :ivar count: The total number of disks required for the concerned volume.
    :vartype count: int
    :ivar size_gb: The disk size in GB.
    :vartype size_gb: int
    :ivar sku: The disk SKU details.
    :vartype sku: ~azure.mgmt.workloadssapvirtualinstance.models.DiskSku
    """

    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The total number of disks required for the concerned volume."""
    size_gb: Optional[int] = rest_field(name="sizeGB", visibility=["read", "create", "update", "delete", "query"])
    """The disk size in GB."""
    sku: Optional["_models.DiskSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The disk SKU details."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[int] = None,
        size_gb: Optional[int] = None,
        sku: Optional["_models.DiskSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnqueueReplicationServerProperties(_model_base.Model):
    """Defines the SAP Enqueue Replication Server (ERS) properties.

    :ivar ers_version: Defines the type of Enqueue Replication Server. Known values are:
     "EnqueueReplicator1" and "EnqueueReplicator2".
    :vartype ers_version: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueReplicationServerType
    :ivar instance_no: ERS Instance Number.
    :vartype instance_no: str
    :ivar hostname: ERS SAP Hostname.
    :vartype hostname: str
    :ivar kernel_version: ERS SAP Kernel Version.
    :vartype kernel_version: str
    :ivar kernel_patch: ERS SAP Kernel Patch level.
    :vartype kernel_patch: str
    :ivar ip_address: ERS SAP IP Address.
    :vartype ip_address: str
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    ers_version: Optional[Union[str, "_models.EnqueueReplicationServerType"]] = rest_field(
        name="ersVersion", visibility=["read"]
    )
    """Defines the type of Enqueue Replication Server. Known values are: \"EnqueueReplicator1\" and
     \"EnqueueReplicator2\"."""
    instance_no: Optional[str] = rest_field(name="instanceNo", visibility=["read"])
    """ERS Instance Number."""
    hostname: Optional[str] = rest_field(visibility=["read"])
    """ERS SAP Hostname."""
    kernel_version: Optional[str] = rest_field(name="kernelVersion", visibility=["read"])
    """ERS SAP Kernel Version."""
    kernel_patch: Optional[str] = rest_field(name="kernelPatch", visibility=["read"])
    """ERS SAP Kernel Patch level."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """ERS SAP IP Address."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""


class EnqueueServerProperties(_model_base.Model):
    """Defines the SAP Enqueue Server properties.

    :ivar hostname: Enqueue Server SAP Hostname.
    :vartype hostname: str
    :ivar ip_address: Enqueue Server SAP IP Address.
    :vartype ip_address: str
    :ivar port: Enqueue Server Port.
    :vartype port: int
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    hostname: Optional[str] = rest_field(visibility=["read"])
    """Enqueue Server SAP Hostname."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """Enqueue Server SAP IP Address."""
    port: Optional[int] = rest_field(visibility=["read"])
    """Enqueue Server Port."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDefinition(_model_base.Model):
    """Error definition.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.workloadssapvirtualinstance.models.ErrorDefinition]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """Service specific error code which serves as the substatus for the HTTP error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Description of the error."""
    details: Optional[List["_models.ErrorDefinition"]] = rest_field(visibility=["read"])
    """Internal error details."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.workloadssapvirtualinstance.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SoftwareConfiguration(_model_base.Model):
    """The SAP Software configuration Input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExternalInstallationSoftwareConfiguration, SAPInstallWithoutOSConfigSoftwareConfiguration,
    ServiceInitiatedSoftwareConfiguration

    :ivar software_installation_type: The SAP software installation type. Required. Known values
     are: "ServiceInitiated", "SAPInstallWithoutOSConfig", and "External".
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPSoftwareInstallationType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    software_installation_type: str = rest_discriminator(
        name="softwareInstallationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SAP software installation type. Required. Known values are: \"ServiceInitiated\",
     \"SAPInstallWithoutOSConfig\", and \"External\"."""

    @overload
    def __init__(
        self,
        *,
        software_installation_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExternalInstallationSoftwareConfiguration(
    SoftwareConfiguration, discriminator="External"
):  # pylint: disable=name-too-long
    """The SAP Software configuration Input when the software is installed externally outside the
    service.

    :ivar central_server_vm_id: The resource ID of the virtual machine containing the central
     server instance.
    :vartype central_server_vm_id: str
    :ivar software_installation_type: The SAP software installation Type. Required. External
     software installation type.
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.EXTERNAL
    """

    central_server_vm_id: Optional[str] = rest_field(
        name="centralServerVmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of the virtual machine containing the central server instance."""
    software_installation_type: Literal[SAPSoftwareInstallationType.EXTERNAL] = rest_discriminator(name="softwareInstallationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The SAP software installation Type. Required. External software installation type."""

    @overload
    def __init__(
        self,
        *,
        central_server_vm_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, software_installation_type=SAPSoftwareInstallationType.EXTERNAL, **kwargs)


class GatewayServerProperties(_model_base.Model):
    """Defines the SAP Gateway Server properties.

    :ivar port: Gateway Port.
    :vartype port: int
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    port: Optional[int] = rest_field(visibility=["read"])
    """Gateway Port."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""


class HighAvailabilityConfiguration(_model_base.Model):
    """Gets or sets the high availability configuration.

    :ivar high_availability_type: The high availability type. Required. Known values are:
     "AvailabilitySet" and "AvailabilityZone".
    :vartype high_availability_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
    """

    high_availability_type: Union[str, "_models.SAPHighAvailabilityType"] = rest_field(
        name="highAvailabilityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The high availability type. Required. Known values are: \"AvailabilitySet\" and
     \"AvailabilityZone\"."""

    @overload
    def __init__(
        self,
        *,
        high_availability_type: Union[str, "_models.SAPHighAvailabilityType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HighAvailabilitySoftwareConfiguration(_model_base.Model):
    """Gets or sets the HA software configuration.

    :ivar fencing_client_id: The fencing client id. Required.
    :vartype fencing_client_id: str
    :ivar fencing_client_password: The fencing client id secret/password. The secret should never
     expire. This will be used pacemaker to start/stop the cluster VMs. Required.
    :vartype fencing_client_password: str
    """

    fencing_client_id: str = rest_field(
        name="fencingClientId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The fencing client id. Required."""
    fencing_client_password: str = rest_field(
        name="fencingClientPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """The fencing client id secret/password. The secret should never expire. This will be used
     pacemaker to start/stop the cluster VMs. Required."""

    @overload
    def __init__(
        self,
        *,
        fencing_client_id: str,
        fencing_client_password: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageReference(_model_base.Model):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations. NOTE: Image reference publisher and offer can only be set when you create
    the scale set.

    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :vartype version: str
    :ivar id: Specifies the ARM resource ID of the Azure Compute Gallery image version used for
     creating ACSS VMs. You will need to provide this input when you choose to deploy virtual
     machines in ACSS with OS image from the Azure Compute gallery.
    :vartype id: str
    """

    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image publisher."""
    offer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the offer of the platform image or marketplace image used to create the virtual
     machine."""
    sku: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image SKU."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the version of the platform image or marketplace image used to create the virtual
     machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are
     decimal numbers. Specify 'latest' to use the latest version of an image available at deploy
     time. Even if you use 'latest', the VM image will not automatically update after deploy time
     even if a new version becomes available."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the ARM resource ID of the Azure Compute Gallery image version used for creating ACSS
     VMs. You will need to provide this input when you choose to deploy virtual machines in ACSS
     with OS image from the Azure Compute gallery."""

    @overload
    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InfrastructureConfiguration(_model_base.Model):
    """Deploy SAP Infrastructure Details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SingleServerConfiguration, ThreeTierConfiguration

    :ivar app_resource_group: The application resource group where SAP system resources will be
     deployed. Required.
    :vartype app_resource_group: str
    :ivar deployment_type: The SAP deployment type. Eg: SingleServer/ThreeTier. Required. Known
     values are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    app_resource_group: str = rest_field(
        name="appResourceGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """The application resource group where SAP system resources will be deployed. Required."""
    deployment_type: str = rest_discriminator(
        name="deploymentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SAP deployment type. Eg: SingleServer/ThreeTier. Required. Known values are:
     \"SingleServer\" and \"ThreeTier\"."""

    @overload
    def __init__(
        self,
        *,
        app_resource_group: str,
        deployment_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OSConfiguration(_model_base.Model):
    """Defines the OS configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LinuxConfiguration, WindowsConfiguration

    :ivar os_type: The OS Type. Required. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.OSType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    os_type: str = rest_discriminator(name="osType", visibility=["read", "create", "update", "delete", "query"])
    """The OS Type. Required. Known values are: \"Linux\" and \"Windows\"."""

    @overload
    def __init__(
        self,
        *,
        os_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LinuxConfiguration(OSConfiguration, discriminator="Linux"):
    """Specifies the Linux operating system settings on the virtual machine. For a list of supported
    Linux distributions, see `Linux on Azure-Endorsed Distributions
    <https://learn.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated,
     please use 'sshKeyPair' instead).
    :vartype ssh: ~azure.mgmt.workloadssapvirtualinstance.models.SshConfiguration
    :ivar ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
    :vartype ssh_key_pair: ~azure.mgmt.workloadssapvirtualinstance.models.SshKeyPair
    :ivar os_type: The OS Type. Required. Linux OS Type.
    :vartype os_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.LINUX
    """

    disable_password_authentication: Optional[bool] = rest_field(
        name="disablePasswordAuthentication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether password authentication should be disabled."""
    ssh: Optional["_models.SshConfiguration"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use
     'sshKeyPair' instead)."""
    ssh_key_pair: Optional["_models.SshKeyPair"] = rest_field(
        name="sshKeyPair", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SSH Key-pair used to authenticate with the VM's."""
    os_type: Literal[OSType.LINUX] = rest_discriminator(name="osType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The OS Type. Required. Linux OS Type."""

    @overload
    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        ssh_key_pair: Optional["_models.SshKeyPair"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, os_type=OSType.LINUX, **kwargs)


class LoadBalancerDetails(_model_base.Model):
    """The Load Balancer details such as Load Balancer ID.

    :ivar id: Fully qualified resource ID for the load balancer.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the load balancer."""


class LoadBalancerResourceNames(_model_base.Model):
    """The resource names object for load balancer and related resources.

    :ivar load_balancer_name: The full resource name for load balancer. If this value is not
     provided, load balancer will be name as {ASCS/DB}-loadBalancer.
    :vartype load_balancer_name: str
    :ivar frontend_ip_configuration_names: The list of frontend IP configuration names. If provided
     as input, size of this list should be 2 for cs layer and should be 1 for database layer.
    :vartype frontend_ip_configuration_names: list[str]
    :ivar backend_pool_names: The list of backend pool names. Currently, ACSS deploys only one
     backend pool and hence, size of this list should be 1.
    :vartype backend_pool_names: list[str]
    :ivar health_probe_names: The list of health probe names. If provided as input, size of this
     list should be 2 for cs layer and should be 1 for database layer.
    :vartype health_probe_names: list[str]
    """

    load_balancer_name: Optional[str] = rest_field(
        name="loadBalancerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full resource name for load balancer. If this value is not provided, load balancer will be
     name as {ASCS/DB}-loadBalancer."""
    frontend_ip_configuration_names: Optional[List[str]] = rest_field(
        name="frontendIpConfigurationNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of frontend IP configuration names. If provided as input, size of this list should be
     2 for cs layer and should be 1 for database layer."""
    backend_pool_names: Optional[List[str]] = rest_field(
        name="backendPoolNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size
     of this list should be 1."""
    health_probe_names: Optional[List[str]] = rest_field(
        name="healthProbeNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of health probe names. If provided as input, size of this list should be 2 for cs
     layer and should be 1 for database layer."""

    @overload
    def __init__(
        self,
        *,
        load_balancer_name: Optional[str] = None,
        frontend_ip_configuration_names: Optional[List[str]] = None,
        backend_pool_names: Optional[List[str]] = None,
        health_probe_names: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedRGConfiguration(_model_base.Model):
    """Managed resource group configuration.

    :ivar name: Managed resource group name.
    :vartype name: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Managed resource group name."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageServerProperties(_model_base.Model):
    """Defines the SAP message server properties.

    :ivar ms_port: message server port.
    :vartype ms_port: int
    :ivar internal_ms_port: message server internal MS port.
    :vartype internal_ms_port: int
    :ivar http_port: message server HTTP Port.
    :vartype http_port: int
    :ivar https_port: message server HTTPS Port.
    :vartype https_port: int
    :ivar hostname: message server SAP Hostname.
    :vartype hostname: str
    :ivar ip_address: message server IP Address.
    :vartype ip_address: str
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    """

    ms_port: Optional[int] = rest_field(name="msPort", visibility=["read"])
    """message server port."""
    internal_ms_port: Optional[int] = rest_field(name="internalMsPort", visibility=["read"])
    """message server internal MS port."""
    http_port: Optional[int] = rest_field(name="httpPort", visibility=["read"])
    """message server HTTP Port."""
    https_port: Optional[int] = rest_field(name="httpsPort", visibility=["read"])
    """message server HTTPS Port."""
    hostname: Optional[str] = rest_field(visibility=["read"])
    """message server SAP Hostname."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """message server IP Address."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""


class MountFileShareConfiguration(FileShareConfiguration, discriminator="Mount"):
    """Gets or sets the file share configuration where the transport directory fileshare already
    exists, and user wishes to mount the fileshare as a part of the create infra flow.

    :ivar id: The fileshare resource ID. Required.
    :vartype id: str
    :ivar private_endpoint_id: The private endpoint resource ID. Required.
    :vartype private_endpoint_id: str
    :ivar configuration_type: The type of file share config, mount in this case. Required. Existing
     fileshare provided will be mounted by service.
    :vartype configuration_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.MOUNT
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The fileshare resource ID. Required."""
    private_endpoint_id: str = rest_field(
        name="privateEndpointId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint resource ID. Required."""
    configuration_type: Literal[FileShareConfigurationType.MOUNT] = rest_discriminator(name="configurationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of file share config, mount in this case. Required. Existing fileshare provided will
     be mounted by service."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        private_endpoint_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, configuration_type=FileShareConfigurationType.MOUNT, **kwargs)


class NetworkConfiguration(_model_base.Model):
    """Defines the network configuration type for SAP system infrastructure that is being deployed.

    :ivar is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to the
     network interface on all VMs of the SAP system being deployed.
    :vartype is_secondary_ip_enabled: bool
    """

    is_secondary_ip_enabled: Optional[bool] = rest_field(
        name="isSecondaryIpEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether a secondary IP address should be added to the network interface on all VMs of
     the SAP system being deployed."""

    @overload
    def __init__(
        self,
        *,
        is_secondary_ip_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceResourceNames(_model_base.Model):
    """The resource names object for network interface and related resources.

    :ivar network_interface_name: The full name for network interface. If name is not provided,
     service uses a default name based on the deployment type. For SingleServer, default name is
     {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic
     with an incrementor at the end in case of more than 1 instance per layer. For distributed and
     HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end
     in case of more than 1 instance per layer.
    :vartype network_interface_name: str
    """

    network_interface_name: Optional[str] = rest_field(
        name="networkInterfaceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name for network interface. If name is not provided, service uses a default name based
     on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone
     systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end
     in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name
     will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance
     per layer."""

    @overload
    def __init__(
        self,
        *,
        network_interface_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.workloadssapvirtualinstance.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.workloadssapvirtualinstance.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperationStatusResult(_model_base.Model):
    """The current status of an async operation.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.workloadssapvirtualinstance.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDetail
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified ID for the async operation."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the async operation."""
    status: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation status. Required."""
    percent_complete: Optional[float] = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Percent of the operation that is complete."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the operation."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the operation."""
    operations: Optional[List["_models.OperationStatusResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The operations list."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If present, details of the operation error."""
    resource_id: Optional[str] = rest_field(name="resourceId", visibility=["read"])
    """Fully qualified ID of the resource against which the original async operation was started."""

    @overload
    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OSProfile(_model_base.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be
    changed once VM is provisioned.

    :ivar admin_username: Specifies the name of the administrator account. <br><br> This property
     cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in
     "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2",
     "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup",
     "console", "david", "guest", "john", "owner", "root", "server", "sql", "support",
     "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length
     (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length
     (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account. <br><br>
     **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters
     <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72
     characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a
     special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd",
     "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22",
     "iloveyou!" <br><br> For resetting the password, see `How to reset the Remote Desktop service
     or its login password in a Windows VM
     <https://learn.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_ <br><br> For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension
     <https://learn.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar os_configuration: Specifies Windows operating system settings on the virtual machine.
    :vartype os_configuration: ~azure.mgmt.workloadssapvirtualinstance.models.OSConfiguration
    """

    admin_username: Optional[str] = rest_field(
        name="adminUsername", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the name of the administrator account. <br><br> This property cannot be updated after
     the VM is created. <br><br> **Windows-only restriction:** Cannot end in \".\" <br><br>
     **Disallowed values:** \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\",
     \"test1\", \"user3\", \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\",
     \"aspnet\", \"backup\", \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\",
     \"server\", \"sql\", \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\",
     \"user4\", \"user5\". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length
     (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters."""
    admin_password: Optional[str] = rest_field(
        name="adminPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8
     characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):**
     123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity
     requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters
     <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_])
     <br><br> **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\", \"P@ssword123\",
     \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\", \"Password22\", \"iloveyou!\"
     <br><br> For resetting the password, see `How to reset the Remote Desktop service or its login
     password in a Windows VM
     <https://learn.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_ <br><br> For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension
     <https://learn.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_."""
    os_configuration: Optional["_models.OSConfiguration"] = rest_field(
        name="osConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies Windows operating system settings on the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        os_configuration: Optional["_models.OSConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OsSapConfiguration(_model_base.Model):
    """Defines the OS and SAP Configurations for Deployment.

    :ivar deployer_vm_packages: The url and storage account ID where deployer VM packages are
     uploaded.
    :vartype deployer_vm_packages:
     ~azure.mgmt.workloadssapvirtualinstance.models.DeployerVmPackages
    :ivar sap_fqdn: The FQDN to set for the SAP system.
    :vartype sap_fqdn: str
    """

    deployer_vm_packages: Optional["_models.DeployerVmPackages"] = rest_field(
        name="deployerVmPackages", visibility=["read", "create", "update", "delete", "query"]
    )
    """The url and storage account ID where deployer VM packages are uploaded."""
    sap_fqdn: Optional[str] = rest_field(name="sapFqdn", visibility=["read", "create", "update", "delete", "query"])
    """The FQDN to set for the SAP system."""

    @overload
    def __init__(
        self,
        *,
        deployer_vm_packages: Optional["_models.DeployerVmPackages"] = None,
        sap_fqdn: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPApplicationServerInstance(TrackedResource):
    """Define the SAP Application Server Instance resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPApplicationServerProperties
    """

    properties: Optional["_models.SAPApplicationServerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPApplicationServerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPApplicationServerProperties(_model_base.Model):
    """Defines the SAP Application Server instance properties.

    :ivar instance_no: Application server Instance Number.
    :vartype instance_no: str
    :ivar subnet: Application server Subnet.
    :vartype subnet: str
    :ivar hostname: Application server instance SAP hostname.
    :vartype hostname: str
    :ivar kernel_version: Application server instance SAP Kernel Version.
    :vartype kernel_version: str
    :ivar kernel_patch: Application server instance SAP Kernel Patch level.
    :vartype kernel_patch: str
    :ivar ip_address: Application server instance SAP IP Address.
    :vartype ip_address: str
    :ivar gateway_port: Application server instance gateway Port.
    :vartype gateway_port: int
    :ivar icm_http_port: Application server instance ICM HTTP Port.
    :vartype icm_http_port: int
    :ivar icm_https_port: Application server instance ICM HTTPS Port.
    :vartype icm_https_port: int
    :ivar dispatcher_status: Application server instance dispatcher status.
    :vartype dispatcher_status: str
    :ivar load_balancer_details: The Load Balancer details such as LoadBalancer ID attached to
     Application Server Virtual Machines.
    :vartype load_balancer_details:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerDetails
    :ivar vm_details: The list of virtual machines.
    :vartype vm_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerVmDetails]
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Defines the Application Instance errors.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    instance_no: Optional[str] = rest_field(name="instanceNo", visibility=["read"])
    """Application server Instance Number."""
    subnet: Optional[str] = rest_field(visibility=["read"])
    """Application server Subnet."""
    hostname: Optional[str] = rest_field(visibility=["read"])
    """Application server instance SAP hostname."""
    kernel_version: Optional[str] = rest_field(name="kernelVersion", visibility=["read"])
    """Application server instance SAP Kernel Version."""
    kernel_patch: Optional[str] = rest_field(name="kernelPatch", visibility=["read"])
    """Application server instance SAP Kernel Patch level."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """Application server instance SAP IP Address."""
    gateway_port: Optional[int] = rest_field(name="gatewayPort", visibility=["read"])
    """Application server instance gateway Port."""
    icm_http_port: Optional[int] = rest_field(name="icmHttpPort", visibility=["read"])
    """Application server instance ICM HTTP Port."""
    icm_https_port: Optional[int] = rest_field(name="icmHttpsPort", visibility=["read"])
    """Application server instance ICM HTTPS Port."""
    dispatcher_status: Optional[str] = rest_field(name="dispatcherStatus", visibility=["read"])
    """Application server instance dispatcher status."""
    load_balancer_details: Optional["_models.LoadBalancerDetails"] = rest_field(
        name="loadBalancerDetails", visibility=["read"]
    )
    """The Load Balancer details such as LoadBalancer ID attached to Application Server Virtual
     Machines."""
    vm_details: Optional[List["_models.ApplicationServerVmDetails"]] = rest_field(name="vmDetails", visibility=["read"])
    """The list of virtual machines."""
    status: Optional[Union[str, "_models.SAPVirtualInstanceStatus"]] = rest_field(visibility=["read"])
    """Defines the SAP Instance status. Known values are: \"Starting\", \"Running\", \"Stopping\",
     \"Offline\", \"PartiallyRunning\", \"Unavailable\", and \"SoftShutdown\"."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""
    provisioning_state: Optional[Union[str, "_models.SapVirtualInstanceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Defines the provisioning states. Known values are: \"Succeeded\", \"Updating\", \"Creating\",
     \"Failed\", \"Deleting\", and \"Canceled\"."""
    errors: Optional["_models.SAPVirtualInstanceError"] = rest_field(visibility=["read"])
    """Defines the Application Instance errors."""


class SAPAvailabilityZoneDetailsRequest(_model_base.Model):
    """The SAP request to get list of availability zones.

    :ivar app_location: The geo-location where the SAP resources will be created. Required.
    :vartype app_location: str
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are: "HANA"
     and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    """

    app_location: str = rest_field(name="appLocation", visibility=["read", "create", "update", "delete", "query"])
    """The geo-location where the SAP resources will be created. Required."""
    sap_product: Union[str, "_models.SAPProductType"] = rest_field(
        name="sapProduct", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Product type. Required. Known values are: \"ECC\", \"S4HANA\", and \"Other\"."""
    database_type: Union[str, "_models.SAPDatabaseType"] = rest_field(
        name="databaseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database type. Eg: HANA, DB2, etc. Required. Known values are: \"HANA\" and \"DB2\"."""

    @overload
    def __init__(
        self,
        *,
        app_location: str,
        sap_product: Union[str, "_models.SAPProductType"],
        database_type: Union[str, "_models.SAPDatabaseType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPAvailabilityZoneDetailsResult(_model_base.Model):
    """The list of supported availability zone pairs which are part of SAP HA deployment.

    :ivar availability_zone_pairs: Gets the list of availability zone pairs.
    :vartype availability_zone_pairs:
     list[~azure.mgmt.workloadssapvirtualinstance.models.SAPAvailabilityZonePair]
    """

    availability_zone_pairs: Optional[List["_models.SAPAvailabilityZonePair"]] = rest_field(
        name="availabilityZonePairs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets the list of availability zone pairs."""

    @overload
    def __init__(
        self,
        *,
        availability_zone_pairs: Optional[List["_models.SAPAvailabilityZonePair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPAvailabilityZonePair(_model_base.Model):
    """The SAP Availability Zone Pair.

    :ivar zone_a: The zone A.
    :vartype zone_a: int
    :ivar zone_b: The zone B.
    :vartype zone_b: int
    """

    zone_a: Optional[int] = rest_field(name="zoneA", visibility=["read", "create", "update", "delete", "query"])
    """The zone A."""
    zone_b: Optional[int] = rest_field(name="zoneB", visibility=["read", "create", "update", "delete", "query"])
    """The zone B."""

    @overload
    def __init__(
        self,
        *,
        zone_a: Optional[int] = None,
        zone_b: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPCentralServerInstance(TrackedResource):
    """Define the SAP Central Services Instance resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadssapvirtualinstance.models.SAPCentralServerProperties
    """

    properties: Optional["_models.SAPCentralServerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPCentralServerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPCentralServerProperties(_model_base.Model):
    """Defines the SAP Central Services Instance properties.

    :ivar instance_no: The central services instance number.
    :vartype instance_no: str
    :ivar subnet: The central services instance subnet.
    :vartype subnet: str
    :ivar message_server_properties: Defines the SAP message server properties.
    :vartype message_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.MessageServerProperties
    :ivar enqueue_server_properties: Defines the SAP Enqueue Server properties.
    :vartype enqueue_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueServerProperties
    :ivar gateway_server_properties: Defines the SAP Gateway Server properties.
    :vartype gateway_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.GatewayServerProperties
    :ivar enqueue_replication_server_properties: Defines the SAP Enqueue Replication Server (ERS)
     properties.
    :vartype enqueue_replication_server_properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.EnqueueReplicationServerProperties
    :ivar kernel_version: The central services instance Kernel Version.
    :vartype kernel_version: str
    :ivar kernel_patch: The central services instance Kernel Patch level.
    :vartype kernel_patch: str
    :ivar load_balancer_details: The Load Balancer details such as LoadBalancer ID attached to ASCS
     Virtual Machines.
    :vartype load_balancer_details:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerDetails
    :ivar vm_details: The list of virtual machines corresponding to the Central Services instance.
    :vartype vm_details:
     list[~azure.mgmt.workloadssapvirtualinstance.models.CentralServerVmDetails]
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Defines the errors related to SAP Central Services Instance resource.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    instance_no: Optional[str] = rest_field(name="instanceNo", visibility=["read"])
    """The central services instance number."""
    subnet: Optional[str] = rest_field(visibility=["read"])
    """The central services instance subnet."""
    message_server_properties: Optional["_models.MessageServerProperties"] = rest_field(
        name="messageServerProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP message server properties."""
    enqueue_server_properties: Optional["_models.EnqueueServerProperties"] = rest_field(
        name="enqueueServerProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Enqueue Server properties."""
    gateway_server_properties: Optional["_models.GatewayServerProperties"] = rest_field(
        name="gatewayServerProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Gateway Server properties."""
    enqueue_replication_server_properties: Optional["_models.EnqueueReplicationServerProperties"] = rest_field(
        name="enqueueReplicationServerProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Enqueue Replication Server (ERS) properties."""
    kernel_version: Optional[str] = rest_field(name="kernelVersion", visibility=["read"])
    """The central services instance Kernel Version."""
    kernel_patch: Optional[str] = rest_field(name="kernelPatch", visibility=["read"])
    """The central services instance Kernel Patch level."""
    load_balancer_details: Optional["_models.LoadBalancerDetails"] = rest_field(
        name="loadBalancerDetails", visibility=["read"]
    )
    """The Load Balancer details such as LoadBalancer ID attached to ASCS Virtual Machines."""
    vm_details: Optional[List["_models.CentralServerVmDetails"]] = rest_field(name="vmDetails", visibility=["read"])
    """The list of virtual machines corresponding to the Central Services instance."""
    status: Optional[Union[str, "_models.SAPVirtualInstanceStatus"]] = rest_field(visibility=["read"])
    """Defines the SAP Instance status. Known values are: \"Starting\", \"Running\", \"Stopping\",
     \"Offline\", \"PartiallyRunning\", \"Unavailable\", and \"SoftShutdown\"."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""
    provisioning_state: Optional[Union[str, "_models.SapVirtualInstanceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Defines the provisioning states. Known values are: \"Succeeded\", \"Updating\", \"Creating\",
     \"Failed\", \"Deleting\", and \"Canceled\"."""
    errors: Optional["_models.SAPVirtualInstanceError"] = rest_field(visibility=["read"])
    """Defines the errors related to SAP Central Services Instance resource."""

    @overload
    def __init__(
        self,
        *,
        message_server_properties: Optional["_models.MessageServerProperties"] = None,
        enqueue_server_properties: Optional["_models.EnqueueServerProperties"] = None,
        gateway_server_properties: Optional["_models.GatewayServerProperties"] = None,
        enqueue_replication_server_properties: Optional["_models.EnqueueReplicationServerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPDatabaseInstance(TrackedResource):
    """Define the Database resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseProperties
    """

    properties: Optional["_models.SAPDatabaseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPDatabaseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPDatabaseProperties(_model_base.Model):
    """Defines the Database properties.

    :ivar subnet: Database subnet.
    :vartype subnet: str
    :ivar database_sid: Database SID name.
    :vartype database_sid: str
    :ivar database_type: Database type, that is if the DB is HANA, DB2, Oracle, SAP ASE, Max DB or
     MS SQL Server.
    :vartype database_type: str
    :ivar ip_address: Database IP Address.
    :vartype ip_address: str
    :ivar load_balancer_details: The Load Balancer details such as LoadBalancer ID attached to
     Database Virtual Machines.
    :vartype load_balancer_details:
     ~azure.mgmt.workloadssapvirtualinstance.models.LoadBalancerDetails
    :ivar vm_details: The list of virtual machines corresponding to the Database resource.
    :vartype vm_details: list[~azure.mgmt.workloadssapvirtualinstance.models.DatabaseVmDetails]
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Defines the errors related to Database resource.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    subnet: Optional[str] = rest_field(visibility=["read"])
    """Database subnet."""
    database_sid: Optional[str] = rest_field(name="databaseSid", visibility=["read"])
    """Database SID name."""
    database_type: Optional[str] = rest_field(name="databaseType", visibility=["read"])
    """Database type, that is if the DB is HANA, DB2, Oracle, SAP ASE, Max DB or MS SQL Server."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """Database IP Address."""
    load_balancer_details: Optional["_models.LoadBalancerDetails"] = rest_field(
        name="loadBalancerDetails", visibility=["read"]
    )
    """The Load Balancer details such as LoadBalancer ID attached to Database Virtual Machines."""
    vm_details: Optional[List["_models.DatabaseVmDetails"]] = rest_field(name="vmDetails", visibility=["read"])
    """The list of virtual machines corresponding to the Database resource."""
    status: Optional[Union[str, "_models.SAPVirtualInstanceStatus"]] = rest_field(visibility=["read"])
    """Defines the SAP Instance status. Known values are: \"Starting\", \"Running\", \"Stopping\",
     \"Offline\", \"PartiallyRunning\", \"Unavailable\", and \"SoftShutdown\"."""
    provisioning_state: Optional[Union[str, "_models.SapVirtualInstanceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Defines the provisioning states. Known values are: \"Succeeded\", \"Updating\", \"Creating\",
     \"Failed\", \"Deleting\", and \"Canceled\"."""
    errors: Optional["_models.SAPVirtualInstanceError"] = rest_field(visibility=["read"])
    """Defines the errors related to Database resource."""


class SAPDiskConfiguration(_model_base.Model):
    """The SAP Disk Configuration contains 'recommended disk' details and list of supported disks
    detail for a volume type.

    :ivar recommended_configuration: The recommended disk details for a given VM Sku.
    :vartype recommended_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.DiskVolumeConfiguration
    :ivar supported_configurations: The list of supported disks for a given VM Sku.
    :vartype supported_configurations:
     list[~azure.mgmt.workloadssapvirtualinstance.models.DiskDetails]
    """

    recommended_configuration: Optional["_models.DiskVolumeConfiguration"] = rest_field(
        name="recommendedConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The recommended disk details for a given VM Sku."""
    supported_configurations: Optional[List["_models.DiskDetails"]] = rest_field(
        name="supportedConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of supported disks for a given VM Sku."""

    @overload
    def __init__(
        self,
        *,
        recommended_configuration: Optional["_models.DiskVolumeConfiguration"] = None,
        supported_configurations: Optional[List["_models.DiskDetails"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPDiskConfigurationsRequest(_model_base.Model):
    """The SAP request to get list of disk configurations.

    :ivar app_location: The geo-location where the SAP resources will be created. Required.
    :vartype app_location: str
    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are: "HANA"
     and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar db_vm_sku: The VM SKU for database instance. Required.
    :vartype db_vm_sku: str
    """

    app_location: str = rest_field(name="appLocation", visibility=["read", "create", "update", "delete", "query"])
    """The geo-location where the SAP resources will be created. Required."""
    environment: Union[str, "_models.SAPEnvironmentType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the environment type - Production/Non Production. Required. Known values are:
     \"NonProd\" and \"Prod\"."""
    sap_product: Union[str, "_models.SAPProductType"] = rest_field(
        name="sapProduct", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Product type. Required. Known values are: \"ECC\", \"S4HANA\", and \"Other\"."""
    database_type: Union[str, "_models.SAPDatabaseType"] = rest_field(
        name="databaseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database type. Eg: HANA, DB2, etc. Required. Known values are: \"HANA\" and \"DB2\"."""
    deployment_type: Union[str, "_models.SAPDeploymentType"] = rest_field(
        name="deploymentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The deployment type. Eg: SingleServer/ThreeTier. Required. Known values are: \"SingleServer\"
     and \"ThreeTier\"."""
    db_vm_sku: str = rest_field(name="dbVmSku", visibility=["read", "create", "update", "delete", "query"])
    """The VM SKU for database instance. Required."""

    @overload
    def __init__(
        self,
        *,
        app_location: str,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        database_type: Union[str, "_models.SAPDatabaseType"],
        deployment_type: Union[str, "_models.SAPDeploymentType"],
        db_vm_sku: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPDiskConfigurationsResult(_model_base.Model):
    """The list of disk configuration for vmSku which are part of SAP deployment.

    :ivar volume_configurations: The disk configuration for the db volume. For HANA, Required
     volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume :
     ['backup'].
    :vartype volume_configurations: dict[str,
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDiskConfiguration]
    """

    volume_configurations: Optional[Dict[str, "_models.SAPDiskConfiguration"]] = rest_field(
        name="volumeConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data',
     'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup']."""

    @overload
    def __init__(
        self,
        *,
        volume_configurations: Optional[Dict[str, "_models.SAPDiskConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPInstallWithoutOSConfigSoftwareConfiguration(
    SoftwareConfiguration, discriminator="SAPInstallWithoutOSConfig"
):  # pylint: disable=name-too-long
    """The SAP Software configuration Input when the software is to be installed by service without OS
    Configurations.

    :ivar bom_url: The URL to the SAP Build of Materials(BOM) file. Required.
    :vartype bom_url: str
    :ivar sap_bits_storage_account_id: The SAP bits storage account id. Required.
    :vartype sap_bits_storage_account_id: str
    :ivar software_version: The software version to install. Required.
    :vartype software_version: str
    :ivar high_availability_software_configuration: Gets or sets the HA software configuration.
    :vartype high_availability_software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration
    :ivar software_installation_type: The SAP software installation Type. Required. SAP Install
     without OS Config.
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAP_INSTALL_WITHOUT_OS_CONFIG
    """

    bom_url: str = rest_field(name="bomUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL to the SAP Build of Materials(BOM) file. Required."""
    sap_bits_storage_account_id: str = rest_field(
        name="sapBitsStorageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SAP bits storage account id. Required."""
    software_version: str = rest_field(
        name="softwareVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The software version to install. Required."""
    high_availability_software_configuration: Optional["_models.HighAvailabilitySoftwareConfiguration"] = rest_field(
        name="highAvailabilitySoftwareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the HA software configuration."""
    software_installation_type: Literal[SAPSoftwareInstallationType.SAP_INSTALL_WITHOUT_OS_CONFIG] = rest_discriminator(name="softwareInstallationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The SAP software installation Type. Required. SAP Install without OS Config."""

    @overload
    def __init__(
        self,
        *,
        bom_url: str,
        sap_bits_storage_account_id: str,
        software_version: str,
        high_availability_software_configuration: Optional["_models.HighAvailabilitySoftwareConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, software_installation_type=SAPSoftwareInstallationType.SAP_INSTALL_WITHOUT_OS_CONFIG, **kwargs
        )


class SAPSizingRecommendationRequest(_model_base.Model):
    """The SAP Sizing Recommendation request.

    :ivar app_location: The geo-location where the resource is to be created. Required.
    :vartype app_location: str
    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar saps: The SAP Application Performance Standard measurement. Required.
    :vartype saps: int
    :ivar db_memory: The database memory configuration. Required.
    :vartype db_memory: int
    :ivar database_type: The database type. Required. Known values are: "HANA" and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar db_scale_method: The DB scale method. "ScaleUp"
    :vartype db_scale_method: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseScaleMethod
    :ivar high_availability_type: The high availability type. Known values are: "AvailabilitySet"
     and "AvailabilityZone".
    :vartype high_availability_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
    """

    app_location: str = rest_field(name="appLocation", visibility=["read", "create", "update", "delete", "query"])
    """The geo-location where the resource is to be created. Required."""
    environment: Union[str, "_models.SAPEnvironmentType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the environment type - Production/Non Production. Required. Known values are:
     \"NonProd\" and \"Prod\"."""
    sap_product: Union[str, "_models.SAPProductType"] = rest_field(
        name="sapProduct", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Product type. Required. Known values are: \"ECC\", \"S4HANA\", and \"Other\"."""
    deployment_type: Union[str, "_models.SAPDeploymentType"] = rest_field(
        name="deploymentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The deployment type. Eg: SingleServer/ThreeTier. Required. Known values are: \"SingleServer\"
     and \"ThreeTier\"."""
    saps: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SAP Application Performance Standard measurement. Required."""
    db_memory: int = rest_field(name="dbMemory", visibility=["read", "create", "update", "delete", "query"])
    """The database memory configuration. Required."""
    database_type: Union[str, "_models.SAPDatabaseType"] = rest_field(
        name="databaseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database type. Required. Known values are: \"HANA\" and \"DB2\"."""
    db_scale_method: Optional[Union[str, "_models.SAPDatabaseScaleMethod"]] = rest_field(
        name="dbScaleMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """The DB scale method. \"ScaleUp\""""
    high_availability_type: Optional[Union[str, "_models.SAPHighAvailabilityType"]] = rest_field(
        name="highAvailabilityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The high availability type. Known values are: \"AvailabilitySet\" and \"AvailabilityZone\"."""

    @overload
    def __init__(
        self,
        *,
        app_location: str,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        deployment_type: Union[str, "_models.SAPDeploymentType"],
        saps: int,
        db_memory: int,
        database_type: Union[str, "_models.SAPDatabaseType"],
        db_scale_method: Optional[Union[str, "_models.SAPDatabaseScaleMethod"]] = None,
        high_availability_type: Optional[Union[str, "_models.SAPHighAvailabilityType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPSizingRecommendationResult(_model_base.Model):
    """The SAP sizing recommendation result.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SingleServerRecommendationResult, ThreeTierRecommendationResult

    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    deployment_type: str = rest_discriminator(
        name="deploymentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The deployment type. Eg: SingleServer/ThreeTier. Required. Known values are: \"SingleServer\"
     and \"ThreeTier\"."""

    @overload
    def __init__(
        self,
        *,
        deployment_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPSupportedResourceSkusResult(_model_base.Model):
    """The list of supported SKUs for different resources which are part of SAP deployment.

    :ivar supported_skus: Gets the list of SAP supported SKUs.
    :vartype supported_skus: list[~azure.mgmt.workloadssapvirtualinstance.models.SAPSupportedSku]
    """

    supported_skus: Optional[List["_models.SAPSupportedSku"]] = rest_field(
        name="supportedSkus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets the list of SAP supported SKUs."""

    @overload
    def __init__(
        self,
        *,
        supported_skus: Optional[List["_models.SAPSupportedSku"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPSupportedSku(_model_base.Model):
    """The SAP supported SKU.

    :ivar vm_sku: The VM Sku.
    :vartype vm_sku: str
    :ivar is_app_server_certified: True if the Sku is certified for App server in the SAP system.
    :vartype is_app_server_certified: bool
    :ivar is_database_certified: True if the Sku is certified for Database server in the SAP
     system.
    :vartype is_database_certified: bool
    """

    vm_sku: Optional[str] = rest_field(name="vmSku", visibility=["read", "create", "update", "delete", "query"])
    """The VM Sku."""
    is_app_server_certified: Optional[bool] = rest_field(
        name="isAppServerCertified", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if the Sku is certified for App server in the SAP system."""
    is_database_certified: Optional[bool] = rest_field(
        name="isDatabaseCertified", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if the Sku is certified for Database server in the SAP system."""

    @overload
    def __init__(
        self,
        *,
        vm_sku: Optional[str] = None,
        is_app_server_certified: Optional[bool] = None,
        is_database_certified: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPSupportedSkusRequest(_model_base.Model):
    """The SAP request to get list of supported SKUs.

    :ivar app_location: The geo-location where the resource is to be created. Required.
    :vartype app_location: str
    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar deployment_type: The deployment type. Eg: SingleServer/ThreeTier. Required. Known values
     are: "SingleServer" and "ThreeTier".
    :vartype deployment_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPDeploymentType
    :ivar database_type: The database type. Eg: HANA, DB2, etc. Required. Known values are: "HANA"
     and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar high_availability_type: The high availability type. Known values are: "AvailabilitySet"
     and "AvailabilityZone".
    :vartype high_availability_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPHighAvailabilityType
    """

    app_location: str = rest_field(name="appLocation", visibility=["read", "create", "update", "delete", "query"])
    """The geo-location where the resource is to be created. Required."""
    environment: Union[str, "_models.SAPEnvironmentType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the environment type - Production/Non Production. Required. Known values are:
     \"NonProd\" and \"Prod\"."""
    sap_product: Union[str, "_models.SAPProductType"] = rest_field(
        name="sapProduct", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the SAP Product type. Required. Known values are: \"ECC\", \"S4HANA\", and \"Other\"."""
    deployment_type: Union[str, "_models.SAPDeploymentType"] = rest_field(
        name="deploymentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The deployment type. Eg: SingleServer/ThreeTier. Required. Known values are: \"SingleServer\"
     and \"ThreeTier\"."""
    database_type: Union[str, "_models.SAPDatabaseType"] = rest_field(
        name="databaseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database type. Eg: HANA, DB2, etc. Required. Known values are: \"HANA\" and \"DB2\"."""
    high_availability_type: Optional[Union[str, "_models.SAPHighAvailabilityType"]] = rest_field(
        name="highAvailabilityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The high availability type. Known values are: \"AvailabilitySet\" and \"AvailabilityZone\"."""

    @overload
    def __init__(
        self,
        *,
        app_location: str,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        deployment_type: Union[str, "_models.SAPDeploymentType"],
        database_type: Union[str, "_models.SAPDatabaseType"],
        high_availability_type: Optional[Union[str, "_models.SAPHighAvailabilityType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPVirtualInstance(TrackedResource):
    """Define the Virtual Instance for SAP solutions resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.workloadssapvirtualinstance.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentity
    """

    properties: Optional["_models.SAPVirtualInstanceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.SAPVirtualInstanceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPVirtualInstanceProperties"] = None,
        identity: Optional["_models.SAPVirtualInstanceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPVirtualInstanceError(_model_base.Model):
    """An error response from the Virtual Instance for SAP Workload service.

    :ivar properties: The Virtual Instance for SAP error body.
    :vartype properties: ~azure.mgmt.workloadssapvirtualinstance.models.ErrorDefinition
    """

    properties: Optional["_models.ErrorDefinition"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Virtual Instance for SAP error body."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ErrorDefinition"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPVirtualInstanceIdentity(_model_base.Model):
    """Managed service identity (user assigned identities).

    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None" and "UserAssigned".
    :vartype type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.workloadssapvirtualinstance.models.UserAssignedIdentity]
    """

    type: Union[str, "_models.SAPVirtualInstanceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\"
     and \"UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.SAPVirtualInstanceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SAPVirtualInstanceProperties(_model_base.Model):
    """Defines the Virtual Instance for SAP solutions resource properties.

    :ivar environment: Defines the environment type - Production/Non Production. Required. Known
     values are: "NonProd" and "Prod".
    :vartype environment: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPEnvironmentType
    :ivar sap_product: Defines the SAP Product type. Required. Known values are: "ECC", "S4HANA",
     and "Other".
    :vartype sap_product: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPProductType
    :ivar managed_resources_network_access_type: Specifies the network access configuration for the
     resources that will be deployed in the Managed Resource Group. The options to choose from are
     Public and Private. If 'Private' is chosen, the Storage Account service tag should be enabled
     on the subnets in which the SAP VMs exist. This is required for establishing connectivity
     between VM extensions and the managed resource group storage account. This setting is currently
     applicable only to Storage Account. Learn more here
     `https://go.microsoft.com/fwlink/?linkid=2247228
     <https://go.microsoft.com/fwlink/?linkid=2247228>`_. Known values are: "Public" and "Private".
    :vartype managed_resources_network_access_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType
    :ivar configuration: Defines if the SAP system is being created using Azure Center for SAP
     solutions (ACSS) or if an existing SAP system is being registered with ACSS. Required.
    :vartype configuration: ~azure.mgmt.workloadssapvirtualinstance.models.SAPConfiguration
    :ivar managed_resource_group_configuration: Managed resource group configuration.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.ManagedRGConfiguration
    :ivar status: Defines the SAP Instance status. Known values are: "Starting", "Running",
     "Stopping", "Offline", "PartiallyRunning", "Unavailable", and "SoftShutdown".
    :vartype status: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceStatus
    :ivar health: Defines the health of SAP Instances. Known values are: "Unknown", "Healthy",
     "Unhealthy", and "Degraded".
    :vartype health: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPHealthState
    :ivar state: Defines the Virtual Instance for SAP state. Known values are:
     "InfrastructureDeploymentPending", "InfrastructureDeploymentInProgress",
     "InfrastructureDeploymentFailed", "SoftwareInstallationPending",
     "SoftwareInstallationInProgress", "SoftwareInstallationFailed", "SoftwareDetectionInProgress",
     "SoftwareDetectionFailed", "DiscoveryPending", "DiscoveryInProgress", "DiscoveryFailed",
     "RegistrationComplete", and "ACSSInstallationBlocked".
    :vartype state: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceState
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Creating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState
    :ivar errors: Indicates any errors on the Virtual Instance for SAP solutions resource.
    :vartype errors: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceError
    """

    environment: Union[str, "_models.SAPEnvironmentType"] = rest_field(visibility=["read", "create"])
    """Defines the environment type - Production/Non Production. Required. Known values are:
     \"NonProd\" and \"Prod\"."""
    sap_product: Union[str, "_models.SAPProductType"] = rest_field(name="sapProduct", visibility=["read", "create"])
    """Defines the SAP Product type. Required. Known values are: \"ECC\", \"S4HANA\", and \"Other\"."""
    managed_resources_network_access_type: Optional[Union[str, "_models.ManagedResourcesNetworkAccessType"]] = (
        rest_field(name="managedResourcesNetworkAccessType", visibility=["read", "create", "update", "delete", "query"])
    )
    """Specifies the network access configuration for the resources that will be deployed in the
     Managed Resource Group. The options to choose from are Public and Private. If 'Private' is
     chosen, the Storage Account service tag should be enabled on the subnets in which the SAP VMs
     exist. This is required for establishing connectivity between VM extensions and the managed
     resource group storage account. This setting is currently applicable only to Storage Account.
     Learn more here `https://go.microsoft.com/fwlink/?linkid=2247228
     <https://go.microsoft.com/fwlink/?linkid=2247228>`_. Known values are: \"Public\" and
     \"Private\"."""
    configuration: "_models.SAPConfiguration" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Defines if the SAP system is being created using Azure Center for SAP solutions (ACSS) or if an
     existing SAP system is being registered with ACSS. Required."""
    managed_resource_group_configuration: Optional["_models.ManagedRGConfiguration"] = rest_field(
        name="managedResourceGroupConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed resource group configuration."""
    status: Optional[Union[str, "_models.SAPVirtualInstanceStatus"]] = rest_field(visibility=["read"])
    """Defines the SAP Instance status. Known values are: \"Starting\", \"Running\", \"Stopping\",
     \"Offline\", \"PartiallyRunning\", \"Unavailable\", and \"SoftShutdown\"."""
    health: Optional[Union[str, "_models.SAPHealthState"]] = rest_field(visibility=["read"])
    """Defines the health of SAP Instances. Known values are: \"Unknown\", \"Healthy\", \"Unhealthy\",
     and \"Degraded\"."""
    state: Optional[Union[str, "_models.SAPVirtualInstanceState"]] = rest_field(visibility=["read"])
    """Defines the Virtual Instance for SAP state. Known values are:
     \"InfrastructureDeploymentPending\", \"InfrastructureDeploymentInProgress\",
     \"InfrastructureDeploymentFailed\", \"SoftwareInstallationPending\",
     \"SoftwareInstallationInProgress\", \"SoftwareInstallationFailed\",
     \"SoftwareDetectionInProgress\", \"SoftwareDetectionFailed\", \"DiscoveryPending\",
     \"DiscoveryInProgress\", \"DiscoveryFailed\", \"RegistrationComplete\", and
     \"ACSSInstallationBlocked\"."""
    provisioning_state: Optional[Union[str, "_models.SapVirtualInstanceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Defines the provisioning states. Known values are: \"Succeeded\", \"Updating\", \"Creating\",
     \"Failed\", \"Deleting\", and \"Canceled\"."""
    errors: Optional["_models.SAPVirtualInstanceError"] = rest_field(visibility=["read"])
    """Indicates any errors on the Virtual Instance for SAP solutions resource."""

    @overload
    def __init__(
        self,
        *,
        environment: Union[str, "_models.SAPEnvironmentType"],
        sap_product: Union[str, "_models.SAPProductType"],
        configuration: "_models.SAPConfiguration",
        managed_resources_network_access_type: Optional[Union[str, "_models.ManagedResourcesNetworkAccessType"]] = None,
        managed_resource_group_configuration: Optional["_models.ManagedRGConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceInitiatedSoftwareConfiguration(SoftwareConfiguration, discriminator="ServiceInitiated"):
    """The SAP Software configuration Input when the software is to be installed by service.

    :ivar bom_url: The URL to the SAP Build of Materials(BOM) file. Required.
    :vartype bom_url: str
    :ivar software_version: The software version to install. Required.
    :vartype software_version: str
    :ivar sap_bits_storage_account_id: The SAP bits storage account id. Required.
    :vartype sap_bits_storage_account_id: str
    :ivar sap_fqdn: The FQDN to set for the SAP system during install. Required.
    :vartype sap_fqdn: str
    :ivar ssh_private_key: The SSH private key. Required.
    :vartype ssh_private_key: str
    :ivar high_availability_software_configuration: Gets or sets the HA software configuration.
    :vartype high_availability_software_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration
    :ivar software_installation_type: The SAP software installation Type, service initiated in this
     case. Required. SAP Install managed by service.
    :vartype software_installation_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.SERVICE_INITIATED
    """

    bom_url: str = rest_field(name="bomUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL to the SAP Build of Materials(BOM) file. Required."""
    software_version: str = rest_field(
        name="softwareVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The software version to install. Required."""
    sap_bits_storage_account_id: str = rest_field(
        name="sapBitsStorageAccountId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SAP bits storage account id. Required."""
    sap_fqdn: str = rest_field(name="sapFqdn", visibility=["read", "create", "update", "delete", "query"])
    """The FQDN to set for the SAP system during install. Required."""
    ssh_private_key: str = rest_field(name="sshPrivateKey", visibility=["read", "create", "update", "delete", "query"])
    """The SSH private key. Required."""
    high_availability_software_configuration: Optional["_models.HighAvailabilitySoftwareConfiguration"] = rest_field(
        name="highAvailabilitySoftwareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the HA software configuration."""
    software_installation_type: Literal[SAPSoftwareInstallationType.SERVICE_INITIATED] = rest_discriminator(name="softwareInstallationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The SAP software installation Type, service initiated in this case. Required. SAP Install
     managed by service."""

    @overload
    def __init__(
        self,
        *,
        bom_url: str,
        software_version: str,
        sap_bits_storage_account_id: str,
        sap_fqdn: str,
        ssh_private_key: str,
        high_availability_software_configuration: Optional["_models.HighAvailabilitySoftwareConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, software_installation_type=SAPSoftwareInstallationType.SERVICE_INITIATED, **kwargs)


class SharedStorageResourceNames(_model_base.Model):
    """The resource names object for shared storage.

    :ivar shared_storage_account_name: The full name of the shared storage account. If it is not
     provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
    :vartype shared_storage_account_name: str
    :ivar shared_storage_account_private_end_point_name: The full name of private end point for the
     shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe.
    :vartype shared_storage_account_private_end_point_name: str
    """

    shared_storage_account_name: Optional[str] = rest_field(
        name="sharedStorageAccountName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name of the shared storage account. If it is not provided, it will be defaulted to
     {SID}nfs{guid of 15 chars}."""
    shared_storage_account_private_end_point_name: Optional[str] = rest_field(
        name="sharedStorageAccountPrivateEndPointName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name of private end point for the shared storage account. If it is not provided, it
     will be defaulted to {storageAccountName}_pe."""

    @overload
    def __init__(
        self,
        *,
        shared_storage_account_name: Optional[str] = None,
        shared_storage_account_private_end_point_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SingleServerConfiguration(InfrastructureConfiguration, discriminator="SingleServer"):
    """Gets or sets the single server configuration. For prerequisites for creating the
    infrastructure, please see `here
    <https://go.microsoft.com/fwlink/?linkid=2212611&amp;clcid=0x409>`_.

    :ivar app_resource_group: The application resource group where SAP system resources will be
     deployed. Required.
    :vartype app_resource_group: str
    :ivar network_configuration: Network configuration for the server.
    :vartype network_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.NetworkConfiguration
    :ivar database_type: The database type. Known values are: "HANA" and "DB2".
    :vartype database_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SAPDatabaseType
    :ivar subnet_id: The subnet id. Required.
    :vartype subnet_id: str
    :ivar virtual_machine_configuration: Gets or sets the virtual machine configuration. Required.
    :vartype virtual_machine_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineConfiguration
    :ivar db_disk_configuration: Gets or sets the disk configuration.
    :vartype db_disk_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.DiskConfiguration
    :ivar custom_resource_names: The set of custom names to be used for underlying azure resources
     that are part of the SAP system.
    :vartype custom_resource_names:
     ~azure.mgmt.workloadssapvirtualinstance.models.SingleServerCustomResourceNames
    :ivar deployment_type: The type of SAP deployment, single server in this case. Required. SAP
     Single server deployment type.
    :vartype deployment_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SINGLE_SERVER
    """

    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network configuration for the server."""
    database_type: Optional[Union[str, "_models.SAPDatabaseType"]] = rest_field(
        name="databaseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database type. Known values are: \"HANA\" and \"DB2\"."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The subnet id. Required."""
    virtual_machine_configuration: "_models.VirtualMachineConfiguration" = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the virtual machine configuration. Required."""
    db_disk_configuration: Optional["_models.DiskConfiguration"] = rest_field(
        name="dbDiskConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the disk configuration."""
    custom_resource_names: Optional["_models.SingleServerCustomResourceNames"] = rest_field(
        name="customResourceNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of custom names to be used for underlying azure resources that are part of the SAP
     system."""
    deployment_type: Literal[SAPDeploymentType.SINGLE_SERVER] = rest_discriminator(name="deploymentType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of SAP deployment, single server in this case. Required. SAP Single server deployment
     type."""

    @overload
    def __init__(
        self,
        *,
        app_resource_group: str,
        subnet_id: str,
        virtual_machine_configuration: "_models.VirtualMachineConfiguration",
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        database_type: Optional[Union[str, "_models.SAPDatabaseType"]] = None,
        db_disk_configuration: Optional["_models.DiskConfiguration"] = None,
        custom_resource_names: Optional["_models.SingleServerCustomResourceNames"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, deployment_type=SAPDeploymentType.SINGLE_SERVER, **kwargs)


class SingleServerCustomResourceNames(_model_base.Model):
    """The resource-names input to specify custom names for underlying azure resources that are part
    of a single server SAP system.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SingleServerFullResourceNames

    :ivar naming_pattern_type: The naming pattern type. Required. "FullResourceName"
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.NamingPatternType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    naming_pattern_type: str = rest_discriminator(
        name="namingPatternType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The naming pattern type. Required. \"FullResourceName\""""

    @overload
    def __init__(
        self,
        *,
        naming_pattern_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SingleServerFullResourceNames(SingleServerCustomResourceNames, discriminator="FullResourceName"):
    """The resource name object where the specified values will be full resource names of the
    corresponding resources in a single server SAP system.

    :ivar virtual_machine: The resource names object for virtual machine and related resources.
    :vartype virtual_machine:
     ~azure.mgmt.workloadssapvirtualinstance.models.VirtualMachineResourceNames
    :ivar naming_pattern_type: The pattern type to be used for resource naming. Required. Full
     resource names that will be created by service.
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.FULL_RESOURCE_NAME
    """

    virtual_machine: Optional["_models.VirtualMachineResourceNames"] = rest_field(
        name="virtualMachine", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource names object for virtual machine and related resources."""
    naming_pattern_type: Literal[NamingPatternType.FULL_RESOURCE_NAME] = rest_discriminator(name="namingPatternType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The pattern type to be used for resource naming. Required. Full resource names that will be
     created by service."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine: Optional["_models.VirtualMachineResourceNames"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, naming_pattern_type=NamingPatternType.FULL_RESOURCE_NAME, **kwargs)


class SingleServerRecommendationResult(SAPSizingRecommendationResult, discriminator="SingleServer"):
    """The recommended configuration for a single server SAP system.

    :ivar vm_sku: The recommended VM SKU for single server.
    :vartype vm_sku: str
    :ivar deployment_type: The single server SAP deployment type. Required. SAP Single server
     deployment type.
    :vartype deployment_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SINGLE_SERVER
    """

    vm_sku: Optional[str] = rest_field(name="vmSku", visibility=["read", "create", "update", "delete", "query"])
    """The recommended VM SKU for single server."""
    deployment_type: Literal[SAPDeploymentType.SINGLE_SERVER] = rest_discriminator(name="deploymentType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The single server SAP deployment type. Required. SAP Single server deployment type."""

    @overload
    def __init__(
        self,
        *,
        vm_sku: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, deployment_type=SAPDeploymentType.SINGLE_SERVER, **kwargs)


class SkipFileShareConfiguration(FileShareConfiguration, discriminator="Skip"):
    """Gets or sets the file share configuration for scenarios where transport directory fileshare is
    not created or required.

    :ivar configuration_type: The type of file share config, skip in this case i.e. fileshare is
     not created or required. Required. Skip creating the file share.
    :vartype configuration_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.SKIP
    """

    configuration_type: Literal[FileShareConfigurationType.SKIP] = rest_discriminator(name="configurationType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of file share config, skip in this case i.e. fileshare is not created or required.
     Required. Skip creating the file share."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, configuration_type=FileShareConfigurationType.SKIP, **kwargs)


class SshConfiguration(_model_base.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.workloadssapvirtualinstance.models.SshPublicKey]
    """

    public_keys: Optional[List["_models.SshPublicKey"]] = rest_field(
        name="publicKeys", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of SSH public keys used to authenticate with linux based VMs."""

    @overload
    def __init__(
        self,
        *,
        public_keys: Optional[List["_models.SshPublicKey"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SshKeyPair(_model_base.Model):
    """The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in
    ssh-rsa format. For creating ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in
    Azure <https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.

    :ivar public_key: SSH public key.
    :vartype public_key: str
    :ivar private_key: SSH private key.
    :vartype private_key: str
    """

    public_key: Optional[str] = rest_field(name="publicKey", visibility=["read", "create", "update", "delete", "query"])
    """SSH public key."""
    private_key: Optional[str] = rest_field(
        name="privateKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """SSH private key."""

    @overload
    def __init__(
        self,
        *,
        public_key: Optional[str] = None,
        private_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SshPublicKey(_model_base.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see
     `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_.
    :vartype key_data: str
    """

    key_data: Optional[str] = rest_field(name="keyData", visibility=["read", "create", "update", "delete", "query"])
    """SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at
     least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see `Create SSH keys on
     Linux and Mac for Linux VMs in Azure
     <https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_."""

    @overload
    def __init__(
        self,
        *,
        key_data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StartRequest(_model_base.Model):
    """Start SAP instance(s) request body.

    :ivar start_vm: The boolean value indicates whether to start the virtual machines before
     starting the SAP instances.
    :vartype start_vm: bool
    """

    start_vm: Optional[bool] = rest_field(name="startVm", visibility=["read", "create", "update", "delete", "query"])
    """The boolean value indicates whether to start the virtual machines before starting the SAP
     instances."""

    @overload
    def __init__(
        self,
        *,
        start_vm: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StopRequest(_model_base.Model):
    """Stop SAP instance(s) request body.

    :ivar soft_stop_timeout_seconds: This parameter defines how long (in seconds) the soft shutdown
     waits until the RFC/HTTP clients no longer consider the server for calls with load balancing.
     Value 0 means that the kernel does not wait, but goes directly into the next shutdown state,
     i.e. hard stop.
    :vartype soft_stop_timeout_seconds: int
    :ivar deallocate_vm: The boolean value indicates whether to Stop and deallocate the virtual
     machines along with the SAP instances.
    :vartype deallocate_vm: bool
    """

    soft_stop_timeout_seconds: Optional[int] = rest_field(
        name="softStopTimeoutSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """This parameter defines how long (in seconds) the soft shutdown waits until the RFC/HTTP clients
     no longer consider the server for calls with load balancing. Value 0 means that the kernel does
     not wait, but goes directly into the next shutdown state, i.e. hard stop."""
    deallocate_vm: Optional[bool] = rest_field(
        name="deallocateVm", visibility=["read", "create", "update", "delete", "query"]
    )
    """The boolean value indicates whether to Stop and deallocate the virtual machines along with the
     SAP instances."""

    @overload
    def __init__(
        self,
        *,
        soft_stop_timeout_seconds: Optional[int] = None,
        deallocate_vm: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageConfiguration(_model_base.Model):
    """Gets or sets the storage configuration.

    :ivar transport_file_share_configuration: The properties of the transport directory attached to
     the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage
     configuration is missing.
    :vartype transport_file_share_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.FileShareConfiguration
    """

    transport_file_share_configuration: Optional["_models.FileShareConfiguration"] = rest_field(
        name="transportFileShareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the transport directory attached to the VIS. The default for
     transportFileShareConfiguration is the createAndMount flow if storage configuration is missing."""

    @overload
    def __init__(
        self,
        *,
        transport_file_share_configuration: Optional["_models.FileShareConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageInformation(_model_base.Model):
    """Storage details of all the Storage accounts attached to the VM. For e.g. NFS on AFS Shared
    Storage.

    :ivar id: Fully qualified resource ID for the storage account.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the storage account."""


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ThreeTierConfiguration(InfrastructureConfiguration, discriminator="ThreeTier"):
    """Gets or sets the three tier SAP configuration. For prerequisites for creating the
    infrastructure, please see `here
    <https://go.microsoft.com/fwlink/?linkid=2212611&amp;clcid=0x409>`_.

    :ivar app_resource_group: The application resource group where SAP system resources will be
     deployed. Required.
    :vartype app_resource_group: str
    :ivar network_configuration: Network configuration common to all servers.
    :vartype network_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.NetworkConfiguration
    :ivar central_server: The central server configuration. Required.
    :vartype central_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerConfiguration
    :ivar application_server: The application server configuration. Required.
    :vartype application_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerConfiguration
    :ivar database_server: The database configuration. Required.
    :vartype database_server: ~azure.mgmt.workloadssapvirtualinstance.models.DatabaseConfiguration
    :ivar high_availability_config: The high availability configuration.
    :vartype high_availability_config:
     ~azure.mgmt.workloadssapvirtualinstance.models.HighAvailabilityConfiguration
    :ivar storage_configuration: The storage configuration.
    :vartype storage_configuration:
     ~azure.mgmt.workloadssapvirtualinstance.models.StorageConfiguration
    :ivar custom_resource_names: The set of custom names to be used for underlying azure resources
     that are part of the SAP system.
    :vartype custom_resource_names:
     ~azure.mgmt.workloadssapvirtualinstance.models.ThreeTierCustomResourceNames
    :ivar deployment_type: The type of SAP deployment, ThreeTier in this case. Required. SAP
     Distributed deployment type.
    :vartype deployment_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.THREE_TIER
    """

    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network configuration common to all servers."""
    central_server: "_models.CentralServerConfiguration" = rest_field(
        name="centralServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The central server configuration. Required."""
    application_server: "_models.ApplicationServerConfiguration" = rest_field(
        name="applicationServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The application server configuration. Required."""
    database_server: "_models.DatabaseConfiguration" = rest_field(
        name="databaseServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database configuration. Required."""
    high_availability_config: Optional["_models.HighAvailabilityConfiguration"] = rest_field(
        name="highAvailabilityConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """The high availability configuration."""
    storage_configuration: Optional["_models.StorageConfiguration"] = rest_field(
        name="storageConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage configuration."""
    custom_resource_names: Optional["_models.ThreeTierCustomResourceNames"] = rest_field(
        name="customResourceNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of custom names to be used for underlying azure resources that are part of the SAP
     system."""
    deployment_type: Literal[SAPDeploymentType.THREE_TIER] = rest_discriminator(name="deploymentType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of SAP deployment, ThreeTier in this case. Required. SAP Distributed deployment type."""

    @overload
    def __init__(
        self,
        *,
        app_resource_group: str,
        central_server: "_models.CentralServerConfiguration",
        application_server: "_models.ApplicationServerConfiguration",
        database_server: "_models.DatabaseConfiguration",
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        high_availability_config: Optional["_models.HighAvailabilityConfiguration"] = None,
        storage_configuration: Optional["_models.StorageConfiguration"] = None,
        custom_resource_names: Optional["_models.ThreeTierCustomResourceNames"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, deployment_type=SAPDeploymentType.THREE_TIER, **kwargs)


class ThreeTierCustomResourceNames(_model_base.Model):
    """The resource-names input to specify custom names for underlying azure resources that are part
    of a three tier SAP system.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ThreeTierFullResourceNames

    :ivar naming_pattern_type: The pattern type to be used for resource naming. Required.
     "FullResourceName"
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.NamingPatternType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    naming_pattern_type: str = rest_discriminator(
        name="namingPatternType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The pattern type to be used for resource naming. Required. \"FullResourceName\""""

    @overload
    def __init__(
        self,
        *,
        naming_pattern_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ThreeTierFullResourceNames(ThreeTierCustomResourceNames, discriminator="FullResourceName"):
    """The resource name object where the specified values will be full resource names of the
    corresponding resources in a three tier SAP system.

    :ivar central_server: The full resource names object for central server layer resources.
    :vartype central_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.CentralServerFullResourceNames
    :ivar application_server: The full resource names object for application layer resources. The
     number of entries in this list should be equal to the number VMs to be created for application
     layer.
    :vartype application_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.ApplicationServerFullResourceNames
    :ivar database_server: The full resource names object for database layer resources. The number
     of entries in this list should be equal to the number VMs to be created for database layer.
    :vartype database_server:
     ~azure.mgmt.workloadssapvirtualinstance.models.DatabaseServerFullResourceNames
    :ivar shared_storage: The resource names object for shared storage.
    :vartype shared_storage:
     ~azure.mgmt.workloadssapvirtualinstance.models.SharedStorageResourceNames
    :ivar naming_pattern_type: The pattern type to be used for resource naming, FullResourceName in
     this case. Required. Full resource names that will be created by service.
    :vartype naming_pattern_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.FULL_RESOURCE_NAME
    """

    central_server: Optional["_models.CentralServerFullResourceNames"] = rest_field(
        name="centralServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full resource names object for central server layer resources."""
    application_server: Optional["_models.ApplicationServerFullResourceNames"] = rest_field(
        name="applicationServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full resource names object for application layer resources. The number of entries in this
     list should be equal to the number VMs to be created for application layer."""
    database_server: Optional["_models.DatabaseServerFullResourceNames"] = rest_field(
        name="databaseServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full resource names object for database layer resources. The number of entries in this list
     should be equal to the number VMs to be created for database layer."""
    shared_storage: Optional["_models.SharedStorageResourceNames"] = rest_field(
        name="sharedStorage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource names object for shared storage."""
    naming_pattern_type: Literal[NamingPatternType.FULL_RESOURCE_NAME] = rest_discriminator(name="namingPatternType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The pattern type to be used for resource naming, FullResourceName in this case. Required. Full
     resource names that will be created by service."""

    @overload
    def __init__(
        self,
        *,
        central_server: Optional["_models.CentralServerFullResourceNames"] = None,
        application_server: Optional["_models.ApplicationServerFullResourceNames"] = None,
        database_server: Optional["_models.DatabaseServerFullResourceNames"] = None,
        shared_storage: Optional["_models.SharedStorageResourceNames"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, naming_pattern_type=NamingPatternType.FULL_RESOURCE_NAME, **kwargs)


class ThreeTierRecommendationResult(SAPSizingRecommendationResult, discriminator="ThreeTier"):
    """The recommended configuration for a three tier SAP system.

    :ivar db_vm_sku: The database VM SKU.
    :vartype db_vm_sku: str
    :ivar database_instance_count: The database server instance count.
    :vartype database_instance_count: int
    :ivar central_server_vm_sku: The central server VM SKU.
    :vartype central_server_vm_sku: str
    :ivar central_server_instance_count: The central server instance count.
    :vartype central_server_instance_count: int
    :ivar application_server_vm_sku: The application server VM SKU.
    :vartype application_server_vm_sku: str
    :ivar application_server_instance_count: The application server instance count.
    :vartype application_server_instance_count: int
    :ivar deployment_type: The three tier SAP deployment type. Required. SAP Distributed deployment
     type.
    :vartype deployment_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.THREE_TIER
    """

    db_vm_sku: Optional[str] = rest_field(name="dbVmSku", visibility=["read", "create", "update", "delete", "query"])
    """The database VM SKU."""
    database_instance_count: Optional[int] = rest_field(
        name="databaseInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The database server instance count."""
    central_server_vm_sku: Optional[str] = rest_field(
        name="centralServerVmSku", visibility=["read", "create", "update", "delete", "query"]
    )
    """The central server VM SKU."""
    central_server_instance_count: Optional[int] = rest_field(
        name="centralServerInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The central server instance count."""
    application_server_vm_sku: Optional[str] = rest_field(
        name="applicationServerVmSku", visibility=["read", "create", "update", "delete", "query"]
    )
    """The application server VM SKU."""
    application_server_instance_count: Optional[int] = rest_field(
        name="applicationServerInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The application server instance count."""
    deployment_type: Literal[SAPDeploymentType.THREE_TIER] = rest_discriminator(name="deploymentType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The three tier SAP deployment type. Required. SAP Distributed deployment type."""

    @overload
    def __init__(
        self,
        *,
        db_vm_sku: Optional[str] = None,
        database_instance_count: Optional[int] = None,
        central_server_vm_sku: Optional[str] = None,
        central_server_instance_count: Optional[int] = None,
        application_server_vm_sku: Optional[str] = None,
        application_server_instance_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, deployment_type=SAPDeploymentType.THREE_TIER, **kwargs)


class UpdateSAPApplicationInstanceRequest(_model_base.Model):
    """Defines the request body for updating SAP Application Instance.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSAPCentralInstanceRequest(_model_base.Model):
    """Defines the request body for updating SAP Central Instance.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSAPDatabaseInstanceRequest(_model_base.Model):
    """Defines the request body for updating SAP Database Instance.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSAPVirtualInstanceProperties(_model_base.Model):
    """Defines the update request body properties for updating Virtual Instance for SAP.

    :ivar managed_resources_network_access_type: Specifies the network access configuration for the
     resources that will be deployed in the Managed Resource Group. The options to choose from are
     Public and Private. If 'Private' is chosen, the Storage Account service tag should be enabled
     on the subnets in which the SAP VMs exist. This is required for establishing connectivity
     between VM extensions and the managed resource group storage account. This setting is currently
     applicable only to Storage Account. Learn more here
     `https://go.microsoft.com/fwlink/?linkid=2247228
     <https://go.microsoft.com/fwlink/?linkid=2247228>`_. Known values are: "Public" and "Private".
    :vartype managed_resources_network_access_type: str or
     ~azure.mgmt.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType
    """

    managed_resources_network_access_type: Optional[Union[str, "_models.ManagedResourcesNetworkAccessType"]] = (
        rest_field(name="managedResourcesNetworkAccessType", visibility=["read", "create", "update", "delete", "query"])
    )
    """Specifies the network access configuration for the resources that will be deployed in the
     Managed Resource Group. The options to choose from are Public and Private. If 'Private' is
     chosen, the Storage Account service tag should be enabled on the subnets in which the SAP VMs
     exist. This is required for establishing connectivity between VM extensions and the managed
     resource group storage account. This setting is currently applicable only to Storage Account.
     Learn more here `https://go.microsoft.com/fwlink/?linkid=2247228
     <https://go.microsoft.com/fwlink/?linkid=2247228>`_. Known values are: \"Public\" and
     \"Private\"."""

    @overload
    def __init__(
        self,
        *,
        managed_resources_network_access_type: Optional[Union[str, "_models.ManagedResourcesNetworkAccessType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateSAPVirtualInstanceRequest(_model_base.Model):
    """Defines the request body for updating Virtual Instance for SAP.

    :ivar tags: Gets or sets the Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity (user assigned identities).
    :vartype identity: ~azure.mgmt.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentity
    :ivar properties: The update properties.
    :vartype properties:
     ~azure.mgmt.workloadssapvirtualinstance.models.UpdateSAPVirtualInstanceProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets or sets the Resource tags."""
    identity: Optional["_models.SAPVirtualInstanceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed service identity (user assigned identities)."""
    properties: Optional["_models.UpdateSAPVirtualInstanceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The update properties."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.SAPVirtualInstanceIdentity"] = None,
        properties: Optional["_models.UpdateSAPVirtualInstanceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_model_base.Model):
    """User assigned identity properties.

    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    """

    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""


class VirtualMachineConfiguration(_model_base.Model):
    """Defines the virtual machine configuration.

    :ivar vm_size: The virtual machine size. Required.
    :vartype vm_size: str
    :ivar image_reference: The image reference. Required.
    :vartype image_reference: ~azure.mgmt.workloadssapvirtualinstance.models.ImageReference
    :ivar os_profile: The OS profile. Required.
    :vartype os_profile: ~azure.mgmt.workloadssapvirtualinstance.models.OSProfile
    """

    vm_size: str = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The virtual machine size. Required."""
    image_reference: "_models.ImageReference" = rest_field(
        name="imageReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The image reference. Required."""
    os_profile: "_models.OSProfile" = rest_field(
        name="osProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OS profile. Required."""

    @overload
    def __init__(
        self,
        *,
        vm_size: str,
        image_reference: "_models.ImageReference",
        os_profile: "_models.OSProfile",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineResourceNames(_model_base.Model):
    """The resource names object for virtual machine and related resources.

    :ivar vm_name: The full name for virtual machine. The length of this field can be upto 64
     characters. If name is not provided, service uses a default name based on the deployment type.
     For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be
     {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer.
     For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an
     incrementor at the end in case of more than 1 vm per layer.
    :vartype vm_name: str
    :ivar host_name: The full name for virtual-machine's host (computer name). Currently, ACSS only
     supports host names which are less than or equal to 13 characters long. If this value is not
     provided, vmName will be used as host name.
    :vartype host_name: str
    :ivar network_interfaces: The list of network interface name objects for the selected virtual
     machine. Currently, only one network interface is supported per virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.workloadssapvirtualinstance.models.NetworkInterfaceResourceNames]
    :ivar os_disk_name: The full name for OS disk attached to the VM. If this value is not
     provided, it will be named by ARM as per its default naming standards (prefixed with vm name).
     There is only one OS disk attached per Virtual Machine.
    :vartype os_disk_name: str
    :ivar data_disk_names: The full resource names for virtual machine data disks. This is a
     dictionary containing list of names of data disks per volume. Currently supported volumes for
     database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For
     application and cs layers, only 'default' volume is supported.
    :vartype data_disk_names: dict[str, list[str]]
    """

    vm_name: Optional[str] = rest_field(name="vmName", visibility=["read", "create", "update", "delete", "query"])
    """The full name for virtual machine. The length of this field can be upto 64 characters. If name
     is not provided, service uses a default name based on the deployment type. For SingleServer,
     default name is {SID}vm. In case of HA-AvZone systems, default name will be
     {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer.
     For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an
     incrementor at the end in case of more than 1 vm per layer."""
    host_name: Optional[str] = rest_field(name="hostName", visibility=["read", "create", "update", "delete", "query"])
    """The full name for virtual-machine's host (computer name). Currently, ACSS only supports host
     names which are less than or equal to 13 characters long. If this value is not provided, vmName
     will be used as host name."""
    network_interfaces: Optional[List["_models.NetworkInterfaceResourceNames"]] = rest_field(
        name="networkInterfaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of network interface name objects for the selected virtual machine. Currently, only
     one network interface is supported per virtual machine."""
    os_disk_name: Optional[str] = rest_field(
        name="osDiskName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full name for OS disk attached to the VM. If this value is not provided, it will be named
     by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk
     attached per Virtual Machine."""
    data_disk_names: Optional[Dict[str, List[str]]] = rest_field(
        name="dataDiskNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full resource names for virtual machine data disks. This is a dictionary containing list of
     names of data disks per volume. Currently supported volumes for database layer are
     ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs
     layers, only 'default' volume is supported."""

    @overload
    def __init__(
        self,
        *,
        vm_name: Optional[str] = None,
        host_name: Optional[str] = None,
        network_interfaces: Optional[List["_models.NetworkInterfaceResourceNames"]] = None,
        os_disk_name: Optional[str] = None,
        data_disk_names: Optional[Dict[str, List[str]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsConfiguration(OSConfiguration, discriminator="Windows"):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar os_type: The OS Type. Required. Windows OS Type.
    :vartype os_type: str or ~azure.mgmt.workloadssapvirtualinstance.models.WINDOWS
    """

    os_type: Literal[OSType.WINDOWS] = rest_discriminator(name="osType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The OS Type. Required. Windows OS Type."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, os_type=OSType.WINDOWS, **kwargs)
