/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.thread;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public abstract class TerminatableRunnable
implements Runnable {
    private final AtomicInteger runState = new AtomicInteger(0);
    private final AtomicBoolean unschedule = new AtomicBoolean();
    private volatile ScheduledFuture<?> scheduledFuture = null;

    protected abstract void doRun();

    public TerminatableRunnable(ScheduledExecutorService scheduler, long initialDelay, long delay, TimeUnit unit) {
        this.scheduledFuture = scheduler.scheduleWithFixedDelay(this, initialDelay, delay, unit);
    }

    @Override
    public final void run() {
        if (!this.runState.compareAndSet(0, 1)) {
            return;
        }
        try {
            this.doRun();
        }
        finally {
            this.runState.compareAndSet(1, 0);
        }
    }

    public void blockTillTerminated() {
        this.unscheduleTask();
        while (!this.runState.compareAndSet(0, -1)) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            if (!Thread.currentThread().isInterrupted()) continue;
            this.runState.set(-1);
            return;
        }
    }

    public boolean isUnschedule() {
        return this.unschedule.get();
    }

    public void unscheduleTask() {
        if (this.unschedule.compareAndSet(false, true)) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
            return;
        }
    }
}

