/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.tomcat.util.buf.UriUtil;

public abstract class AbstractSingleArchiveResourceSet
extends AbstractArchiveResourceSet {
    private volatile Boolean multiRelease;

    public AbstractSingleArchiveResourceSet() {
    }

    public AbstractSingleArchiveResourceSet(WebResourceRoot webResourceRoot, String string, String string2, String string3) throws IllegalArgumentException {
        this.setRoot(webResourceRoot);
        this.setWebAppMount(string);
        this.setBase(string2);
        this.setInternalPath(string3);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException lifecycleException) {
                throw new IllegalStateException(lifecycleException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, JarEntry> getArchiveEntries(boolean bl) {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archiveEntries == null && !bl) {
                JarFile jarFile = null;
                this.archiveEntries = new HashMap();
                try {
                    jarFile = this.openJarFile();
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        this.archiveEntries.put(jarEntry.getName(), jarEntry);
                    }
                }
                catch (IOException iOException) {
                    this.archiveEntries = null;
                    throw new IllegalStateException(iOException);
                }
                finally {
                    if (jarFile != null) {
                        this.closeJarFile();
                    }
                }
            }
            return this.archiveEntries;
        }
    }

    @Override
    protected JarEntry getArchiveEntry(String string) {
        JarFile jarFile = null;
        try {
            jarFile = this.openJarFile();
            JarEntry jarEntry = jarFile.getJarEntry(string);
            return jarEntry;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            if (jarFile != null) {
                this.closeJarFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isMultiRelease() {
        if (this.multiRelease == null) {
            Object object = this.archiveLock;
            synchronized (object) {
                if (this.multiRelease == null) {
                    JarFile jarFile = null;
                    try {
                        jarFile = this.openJarFile();
                        this.multiRelease = jarFile.isMultiRelease();
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException);
                    }
                    finally {
                        if (jarFile != null) {
                            this.closeJarFile();
                        }
                    }
                }
            }
        }
        return this.multiRelease;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile jarFile = new JarFile(new File(this.getBase()), true, 1, Runtime.version());){
            this.setManifest(jarFile.getManifest());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        try {
            this.setBaseUrl(UriUtil.buildJarSafeUrl((File)new File(this.getBase())));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }
}

