/* Included once by translate.cxx c_unparser::emit_common_header ()
   Defines all common fields and probe flags for struct context.
   Available to C-based probe handlers as fields of the CONTEXT ptr.

   NB: new fields may need manual initialization as a part of
   tapsets.cxx common_probe_entryfn_prologue()!
*/

#ifdef __DYNINST__

/* The index of this context structure with the array of allocated
   context structures. */
int data_index;

/* The index of the active probe within stap_probes[].  */
size_t probe_index;

/* The lock for this context structure. */
pthread_mutex_t lock;

/* The transport data for this context structure. */
struct _stp_transport_context_data transport_data;

#else

/* Used to indicate whether a probe context is in use.
   Tested in the probe prologue by _stp_runtime_entryfn_get_context
   and cleared in the epilogue via _stp_runtime_entryfn_put_context.
   All context busy flags are tested on module unload to prevent unloading
   while some probe is still running.  */
atomic_t busy;

#endif

/* The fully-resolved probe point associated with a currently running probe
   handler, including alias and wild-card expansion effects.
   aka stap_probe->pp.  Setup by common_probe_entryfn_prologue.
   Used in warning/error messages and accessible by pp() tapset function.  */
const char *probe_point;

/* The script-level probe point associated with a currently running probe
   handler, including  wild-card expansion effects as per 'stap -l'.
   Guarded by STP_NEED_PROBE_NAME as setup in pn() tapset function.  */
#ifdef STP_NEED_PROBE_NAME
const char *probe_name;
#endif

/* The kind of probe this is.  One of the stp_probe_type constants.
   Used to determined what other fields are setup and how.  Often the
   probe context fields depend on how the probe handler is triggered
   and what information it gets passed.  */
enum stp_probe_type probe_type;

/* Common status flags of probe.  */
unsigned user_mode_p:1;
unsigned full_uregs_p:1;

/* Number of "actions" this probe handler is still allowed to do.
   Setup in common_probe_entryfn_prologue to either MAXACTION or
   Checked by code generated by c_unparser::record_actions (), which will
   set last_error in case this goes to zero and then jumps to out.
   MAXACTION_INTERRUPTIBLE.  Note special case in enter_all_profile_probes.  */
#if !defined(STAP_SUPPRESS_TIME_LIMITS_ENABLE)
int actionremaining;
#endif

/* The current nesting of a function. Needed to determine which "level" of
   locals to use. See the recursion_info traversing_visitor for how the
   maximum is calculated.  Locals of a function are stored at
   c->locals[c->nesting], see c_unparser::emit_function ().  */
int nesting;

/* A flag used for runtime function overloading. It is unset by a function
 * if no more alternatives are to be executed. */
int next;

/* A flag to signal aborting the currently running probe handler.
   While it's 0, execution continues
   When it's 1, probe code unwnds. */
int aborted;

/* A flag to indicate whether globals used by this probe handler have
   been locked or not. PR26296 */
int locked;

/* A place to format error messages into if some error occurs, last_error
   will then be pointed here.  */
string_t error_buffer;

/* Only used when stap script uses tokenize.stp tapset.  */
#ifdef STAP_NEED_CONTEXT_TOKENIZE
string_t tok_str;
char *tok_start;
char *tok_end;
#endif

/* Only used in file tapset/linux/aux_syscalls.stp
 * function: _struct_sockaddr_u_impl.
 * We need bigger buffers than is frame limit of function.
 */
#ifdef STAP_NEED_CONTEXT_SOCKADDR_BIG_BUFFERS
char buf[128];
string_t out_str;
#endif

/* Only used when stap script needs regexp subexpressions. */
#ifdef STAP_NEED_CONTEXT_SUBEXPRESSION
struct stapregex_match {
  string_t matched_str;
  unsigned result:1;
  unsigned num_final_tags;

  // TODOXXX: could use a more efficient single-level array for tag_states
  int tag_states[STAPREGEX_MAX_TAG][STAPREGEX_MAX_MAP];
  int tag_vals[STAPREGEX_MAX_TAG];
} last_match;
#endif

/* Used in errno.stp for deprecated use of returnval() in syscall.*.return aliases */
#ifdef STAP_NEED_CONTEXT_RETURNVAL
  int64_t returnval_override;
  int returnval_override_p;
#endif

/* NB: last_error is used as a health flag within a probe.
   While it's 0, execution continues
   When it's "something", probe code unwinds, _stp_error's, sets error state */
const char *last_error;
/* Last statement (token) executed. Often set together with last_error. */
const char *last_stmt;

/* Set when probe handler gets pt_regs handed to it. kregs holds the kernel
   registers when availble. uregs holds the user registers when available.
   uregs are at least available when user_mode_p == 1.  */
struct pt_regs *kregs; /* !user_mode_p */
struct pt_regs *uregs; /* user_mode_p */
struct pt_regs *sregs; /* syscall mode only, untrustworthy since user-controlled */

/* unwaddr is caching unwound address in each probe handler on ia64. */
#if defined __ia64__
unsigned long *unwaddr;
#endif

/* Individual Probe State (ips).
   A union since only one can be active at a time.  */
union {

  /* kretprobe state. */
  struct {
    struct kretprobe_instance *pi;
    /* int64_t count in pi->data, the rest is string_t.
       See the kretprobe.stp tapset.  */
    int pi_longs;
  } krp;

  /* State for mark_derived_probes.  */
  struct {
    va_list *mark_va_list;
    const char *marker_name;
    const char *marker_format;
  } kmark;

  /* State for tracepoint probes. */
  struct {
     const char *tracepoint_system;
     const char *tracepoint_name;
  } tp;

  /* uretprobe state */
  struct uretprobe_instance *ri;

  /* State for procfs probes, see tapset-procfs.cxx.  */
  void *procfs_data;
} ips;


/* Only used when stap script uses the i386 or x86_64 register.stp tapset. */
#ifdef STAP_NEED_REGPARM
int regparm;
#endif

/* Only used for overload processing. */
#ifdef STP_OVERLOAD
cycles_t cycles_base;
cycles_t cycles_sum;
#endif

/* Current state of the unwinder (as used in the unwind.c dwarf unwinder). */
#if defined(STP_NEED_UNWIND_DATA)
struct stp_unwind_cache uwcache_user;
struct stp_unwind_cache uwcache_kernel;
struct stp_unwind_context uwcontext_user;
struct stp_unwind_context uwcontext_kernel;
#endif

/* Only used when perf dervied probes have been defined. */
#ifdef _HAVE_PERF_
long *perf_read_values;
#endif

/* Maximum number of backtrace levels. */
#ifndef MAXBACKTRACE
#define MAXBACKTRACE 20
#endif

/* PR26673 we should allocate this array in struct context instead of on the
 * kernel stack */
unsigned long kern_bt_entries[MAXBACKTRACE];

/* PR30407 storage for dwarf data */
#define STP_MAX_DW_SOURCES 255
struct {
  struct { uint16_t desc; uint16_t form; } dir_enc[STP_MAX_DW_SOURCES];
  struct { uint16_t desc; uint16_t form; } file_enc[STP_MAX_DW_SOURCES];
  struct { uint32_t offset; char *name; } src_dir[STP_MAX_DW_SOURCES];
  struct { uint32_t offset; uint8_t dirindex; char *name; } src_file[STP_MAX_DW_SOURCES];
} dw_data;
