/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.Token;

public final class GenericTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(GenericTokenExpression.class);
    private static final long serialVersionUID = 7913229642187691263L;

    GenericTokenExpression(String value) {
        super(value);
    }

    @Override
    public String toString() {
        return this.getStringRepresentation();
    }

    public static GenericTokenExpression parseGenericTokenExpression(String input) {
        if (input == null) {
            return null;
        }
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            if (GenericTokenExpression.isTokenChar(input, i)) continue;
            return null;
        }
        return new GenericTokenExpression(input);
    }

    static Object executeGenericTokenExpression(IExpressionContext context, GenericTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating generic token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

