/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedByteValueProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.FastDoubleParser;
import com.oracle.truffle.api.strings.IndexOfCodePointSet;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.NumberConversion;
import com.oracle.truffle.api.strings.Stride;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TStringUnsafe;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.lang.ref.Reference;
import java.util.Arrays;

final class TStringInternalNodes {
    TStringInternalNodes() {
    }

    @CompilerDirectives.TruffleBoundary
    static long updateAttributes(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding, int impreciseCodeRange) {
        assert (!TSCodeRange.isPrecise(impreciseCodeRange));
        long attrs = CalcStringAttributesNode.getUncached().execute(node, a, arrayA, offsetA, a.length(), a.stride(), encoding, 0, impreciseCodeRange);
        a.updateAttributes(StringAttributes.getCodePointLength(attrs), StringAttributes.getCodeRange(attrs));
        return attrs;
    }

    static int indexOfFixedWidth(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, int codepoint, int fromIndex, int toIndex, TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
        if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
            return -1;
        }
        return indexOfNode.execute(node, a, arrayA, offsetA, codepoint, fromIndex, toIndex);
    }

    static int lastIndexOfFixedWidth(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, int codepoint, int fromIndex, int toIndex, TStringOpsNodes.RawLastIndexOfCodePointNode indexOfNode) {
        if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
            return -1;
        }
        return indexOfNode.execute(node, a, arrayA, offsetA, codepoint, fromIndex, toIndex);
    }

    static abstract class CalcStringAttributesNode
    extends AbstractInternalNode {
        CalcStringAttributesNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, TruffleString.Encoding var8, int var9, int var10);

        @Specialization
        static long calc(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached CalcStringAttributesInnerNode calcNode) {
            if (length == 0) {
                return StringAttributes.create(length, TSCodeRange.getAsciiCodeRange(encoding));
            }
            if (TStringGuards.is7Bit(knownCodeRange)) {
                return StringAttributes.create(length, TSCodeRange.get7Bit());
            }
            return calcNode.execute(node, a, arrayA, offsetA, length, stride, encoding, fromIndex, knownCodeRange);
        }

        static CalcStringAttributesNode getUncached() {
            return TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached();
        }
    }

    static abstract class TransCodeIntlNode
    extends AbstractInternalNode {
        TransCodeIntlNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, TruffleString.Encoding var8, TruffleString.Encoding var9, TranscodingErrorHandler var10);

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "isAscii(targetEncoding) || isBytes(targetEncoding)"})
        static TruffleString targetAscii(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (!TStringGuards.is7Bit(codeRangeA));
            byte[] buffer = new byte[codePointLengthA];
            int length = 0;
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            boolean replacedChars = false;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, sourceEncoding, DecodingErrorHandler.DEFAULT_UTF8_INCOMPLETE_SEQUENCES);
                if (codepoint > 127) {
                    buffer[length++] = 63;
                    replacedChars = true;
                } else {
                    buffer[length++] = (byte)codepoint;
                }
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length), length, 0, targetEncoding, length, TSCodeRange.get7Bit(), replacedChars);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "isLatin1(targetEncoding)"})
        static TruffleString latin1Transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (!TStringGuards.is7Or8Bit(codeRangeA));
            byte[] buffer = new byte[codePointLengthA];
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            int codeRange = TSCodeRange.get7Bit();
            boolean replacedChars = false;
            int length = 0;
            while (it.hasNext()) {
                int latin1;
                int codepoint = iteratorNextNode.execute(node, it, sourceEncoding, DecodingErrorHandler.DEFAULT_UTF8_INCOMPLETE_SEQUENCES);
                if (codepoint > 255) {
                    latin1 = 63;
                    replacedChars = true;
                } else {
                    latin1 = (byte)codepoint;
                }
                buffer[length++] = latin1;
                if (latin1 < 0) {
                    codeRange = TSCodeRange.get8Bit();
                }
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length), length, 0, TruffleString.Encoding.ISO_8859_1, length, codeRange, replacedChars);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "!isLarge(codePointLengthA)", "isUTF8(targetEncoding)"})
        static TruffleString utf8Transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached InlinedConditionProfile brokenProfile, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile, @Cached @Cached.Shared InlinedConditionProfile largeProfile) {
            return TransCodeIntlNode.utf8Transcode(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode, largeProfile.profile(node, TransCodeIntlNode.isLarge(codePointLengthA)), brokenProfile, outOfMemoryProfile);
        }

        static boolean isLarge(int codePointLengthA) {
            return codePointLengthA > 0x1FFFFFFD;
        }

        private static TruffleString utf8Transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedConditionProfile brokenProfile, InlinedBranchProfile outOfMemoryProfile) {
            int codePointLength;
            assert (!TStringGuards.is7Bit(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            boolean allowUTF16Surrogates = errorHandler == TranscodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8;
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : codePointLengthA * 4];
            int codeRange = TSCodeRange.get7Bit();
            int length = 0;
            int loopCount = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, allowUTF16Surrogates);
                } else if (codepoint > 127 && TSCodeRange.is7Bit(codeRange)) {
                    codeRange = TSCodeRange.getValidMultiByte();
                }
                int n = Encodings.utf8EncodedSize(codepoint);
                assert (isLarge || length + n <= buffer.length);
                if (isLarge && length > 0x7FFFFFF7 - n) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                Encodings.utf8Encode(codepoint, buffer, length, n);
                length += n;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF8(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, false, false, brokenProfile);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = codePointLengthA;
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length), length, 0, TruffleString.Encoding.UTF_8, codePointLength, codeRange);
        }

        @Specialization(guards={"isUTF32(sourceEncoding)", "isUTF16(targetEncoding)"})
        TruffleString utf16Fixed32Bit(AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            int codePointLength;
            assert (TStringGuards.isValidFixedWidth(codeRangeA) || TStringGuards.isBrokenFixedWidth(codeRangeA));
            assert (TStringGuards.isStride2(a));
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            byte[] buffer = new byte[codePointLengthA * 4];
            int length = 0;
            int codeRange = TStringGuards.isValidFixedWidth(codeRangeA) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            for (int i = 0; i < a.length(); ++i) {
                length += Encodings.utf16Encode(TransCodeIntlNode.utfReplaceInvalid(TStringOps.readS2(a, arrayA, offsetA, i), allowUTF16Surrogates), buffer, length);
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(this, buffer, TStringUnsafe.byteArrayBaseOffset(), length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = codePointLengthA;
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization(guards={"isUTF16(sourceEncoding)", "isUTF16FE(targetEncoding)"})
        static TruffleString utf16ByteSwapToFE(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            long inflatedOffset;
            byte[] inflatedBuffer;
            int length = a.length();
            if (TStringGuards.isStride0(a)) {
                inflatedBuffer = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, a.length(), 0, length, 1);
                inflatedOffset = TStringUnsafe.byteArrayBaseOffset();
            } else {
                inflatedBuffer = arrayA;
                inflatedOffset = offsetA;
            }
            byte[] buffer = new byte[a.byteLength(TruffleString.Encoding.UTF_16)];
            TStringOps.byteSwapS1(node, inflatedBuffer, inflatedOffset, buffer, TStringUnsafe.byteArrayBaseOffset(), length);
            int codeRange = TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, TSCodeRange.getValidMultiByte()) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            return TransCodeIntlNode.create(a, buffer, buffer.length, 0, TruffleString.Encoding.UTF_16_FOREIGN_ENDIAN, codePointLengthA, codeRange);
        }

        @Specialization(guards={"isUTF16FE(sourceEncoding)", "isUTF16(targetEncoding)"})
        static TruffleString utf16ByteSwapFromFE(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            assert (TStringGuards.isValidMultiByte(codeRangeA) || TStringGuards.isBrokenMultiByte(codeRangeA));
            assert (TStringGuards.isStride0(a));
            byte[] buffer = new byte[a.length()];
            int length = buffer.length >> 1;
            TStringOps.byteSwapS1(node, arrayA, offsetA, buffer, TStringUnsafe.byteArrayBaseOffset(), length);
            long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, false);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            assert (codePointLength == codePointLengthA);
            int stride = Stride.fromCodeRangeUTF16(codeRange);
            if (stride == 0) {
                buffer = TStringOps.arraycopyOfWithStride(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, 1, length, 0);
            }
            return TransCodeIntlNode.create(a, buffer, length, stride, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization(guards={"isUTF32FE(sourceEncoding)", "isUTF32(targetEncoding)"})
        static TruffleString utf32ByteSwap(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            assert (TStringGuards.isValidMultiByte(codeRangeA) || TStringGuards.isBrokenMultiByte(codeRangeA));
            assert (TStringGuards.isStride0(a));
            byte[] buffer = new byte[a.length()];
            int length = buffer.length >> 2;
            TStringOps.byteSwapS2(node, arrayA, offsetA, buffer, TStringUnsafe.byteArrayBaseOffset(), length);
            int codeRange = TStringOps.calcStringAttributesUTF32(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length);
            int stride = Stride.fromCodeRangeUTF32(codeRange);
            if (stride < 2) {
                buffer = TStringOps.arraycopyOfWithStride(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, 2, length, stride);
            }
            return TransCodeIntlNode.create(a, buffer, length, stride, TruffleString.Encoding.UTF_32, length, codeRange);
        }

        @Specialization(guards={"isUTF32(sourceEncoding)", "isUTF32FE(targetEncoding)"})
        static TruffleString utf32ByteSwapToFE(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            long inflatedOffset;
            byte[] inflatedBuffer;
            int length = a.length();
            if (a.stride() < 2) {
                inflatedBuffer = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, a.length(), a.stride(), length, 2);
                inflatedOffset = TStringUnsafe.byteArrayBaseOffset();
            } else {
                inflatedBuffer = arrayA;
                inflatedOffset = offsetA;
            }
            byte[] buffer = new byte[a.byteLength(TruffleString.Encoding.UTF_32)];
            TStringOps.byteSwapS2(node, inflatedBuffer, inflatedOffset, buffer, TStringUnsafe.byteArrayBaseOffset(), length);
            int codeRange = TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, TSCodeRange.getValidFixedWidth()) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            return TransCodeIntlNode.create(a, buffer, buffer.length, 0, TruffleString.Encoding.UTF_32_FOREIGN_ENDIAN, codePointLengthA, codeRange);
        }

        @Specialization(guards={"isSupportedEncodingWithCompaction(sourceEncoding) || isUTF32FE(sourceEncoding)", "!isFixedWidth(codeRangeA)", "isUTF16(targetEncoding)"})
        static TruffleString utf16Transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile, @Cached @Cached.Shared InlinedConditionProfile largeProfile) {
            return TransCodeIntlNode.utf16Transcode(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode, largeProfile.profile(node, TransCodeIntlNode.isLarge(codePointLengthA)), outOfMemoryProfile);
        }

        private static TruffleString utf16Transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedBranchProfile outOfMemoryProfile) {
            boolean isSurrogate;
            int codepoint;
            int curIndex;
            assert (TStringGuards.isValidOrBrokenMultiByte(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            byte[] buffer = new byte[codePointLengthA];
            int codePointLength = codePointLengthA;
            int length = 0;
            int codeRange = TSCodeRange.get7Bit();
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                if (codepoint > 255) {
                    buffer = TStringOps.arraycopyOfWithStride(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, 0, codePointLengthA, 1);
                    codeRange = TSCodeRange.get16Bit();
                    it.setRawIndex(curIndex);
                    break;
                }
                if (codepoint > 127) {
                    codeRange = TSCodeRange.get8Bit();
                }
                buffer[length++] = (byte)codepoint;
                TStringConstants.truffleSafePointPoll(node, length);
            }
            if (!it.hasNext()) {
                assert (length == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length, 0, TruffleString.Encoding.UTF_16, codePointLengthA, codeRange);
            }
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                if (codepoint > 65535) {
                    buffer = Arrays.copyOf(buffer, isLarge ? 0x7FFFFFF7 : buffer.length * 2);
                    codeRange = TSCodeRange.commonCodeRange(codeRange, TSCodeRange.getValidMultiByte());
                    it.setRawIndex(curIndex);
                    break;
                }
                isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                if (isSurrogate) {
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, true, false, allowUTF16Surrogates);
                    codeRange = TSCodeRange.getBrokenMultiByte();
                }
                TStringOps.writeToByteArrayS1(buffer, length++, codepoint);
                TStringConstants.truffleSafePointPoll(node, length);
            }
            codePointLength = length;
            if (!it.hasNext()) {
                if (TStringGuards.isBrokenMultiByte(codeRange)) {
                    long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
                return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
            }
            int loopCount = 0;
            while (it.hasNext()) {
                codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, allowUTF16Surrogates);
                }
                if (isLarge && length + Encodings.utf16EncodedSize(codepoint) > 0x3FFFFFFB) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                length += Encodings.utf16Encode(codepoint, buffer, length);
                ++codePointLength;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization(guards={"isSupportedEncodingWithCompaction(sourceEncoding) || isUTF32FE(sourceEncoding)", "!isUTF16(sourceEncoding)", "isUTF16FE(targetEncoding)"})
        static TruffleString utf16FETranscode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile, @Cached @Cached.Shared InlinedConditionProfile largeProfile) {
            return TransCodeIntlNode.utf16FETranscode(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode, largeProfile.profile(node, TransCodeIntlNode.isLarge(codePointLengthA)), outOfMemoryProfile);
        }

        private static TruffleString utf16FETranscode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedBranchProfile outOfMemoryProfile) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : codePointLengthA << 2];
            int codePointLength = 0;
            int length = 0;
            int codeRange = TSCodeRange.getValidMultiByte();
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            int loopCount = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, allowUTF16Surrogates);
                }
                if (isLarge && length + Encodings.utf16EncodedSize(codepoint) > 0x3FFFFFFB) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                length += Encodings.utf16FEEncode(codepoint, buffer, length);
                ++codePointLength;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16FE(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length * 2), length << 1, 0, TruffleString.Encoding.UTF_16_FOREIGN_ENDIAN, codePointLength, codeRange);
        }

        @Specialization(guards={"!isUTF16(sourceEncoding)", "isSupportedEncodingWithCompaction(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeRegular(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            return TransCodeIntlNode.utf32Transcode(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode);
        }

        @Specialization(guards={"isSupportedEncodingWithCompaction(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isFixedWidth(codeRangeA)", "isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeLarge(AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            throw InternalErrors.outOfMemory();
        }

        @Specialization(guards={"isUTF16(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeUTF16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            int codeRange;
            assert (TransCodeIntlNode.containsSurrogates(a));
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            byte[] buffer = new byte[codePointLengthA << 2];
            int length = 0;
            while (it.hasNext()) {
                TStringOps.writeToByteArrayS2(buffer, length++, TransCodeIntlNode.utfReplaceInvalid(iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler), allowUTF16Surrogates));
                TStringConstants.truffleSafePointPoll(node, length);
            }
            assert (length == codePointLengthA);
            boolean isBroken = TStringGuards.isBrokenMultiByte(codeRangeA);
            int codePointLength = codePointLengthA;
            int n = codeRange = isBroken ? TSCodeRange.getBrokenFixedWidth() : TSCodeRange.getValidFixedWidth();
            if (isBroken && !allowUTF16Surrogates) {
                long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, TStringUnsafe.byteArrayBaseOffset(), length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, buffer, length, 2, TruffleString.Encoding.UTF_32, codePointLength, codeRange);
        }

        private static TruffleString utf32Transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode) {
            int curIndex;
            assert (TStringGuards.isValidOrBrokenMultiByte(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            byte[] buffer = new byte[codePointLengthA];
            int offsetBuf = TStringUnsafe.byteArrayBaseOffset();
            int length = 0;
            int codeRange = TSCodeRange.get7Bit();
            int codepoint = 0;
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                if (codepoint > 255) {
                    if (Encodings.isUTF16Surrogate(codepoint)) {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, offsetBuf, length, 0, codePointLengthA, 2);
                        codeRange = TSCodeRange.getBrokenFixedWidth();
                    } else {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, offsetBuf, length, 0, codePointLengthA, 1);
                        codeRange = TSCodeRange.get16Bit();
                    }
                    it.setRawIndex(curIndex);
                    break;
                }
                if (codepoint > 127) {
                    codeRange = TSCodeRange.get8Bit();
                }
                buffer[length++] = (byte)codepoint;
                TStringConstants.truffleSafePointPoll(node, length);
            }
            if (!it.hasNext()) {
                assert (length == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length, 0, TruffleString.Encoding.UTF_32, codePointLengthA, codeRange);
            }
            if (TStringGuards.is16Bit(codeRange)) {
                while (it.hasNext()) {
                    curIndex = it.getRawIndex();
                    codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                    if (codepoint > 65535 || Encodings.isUTF16Surrogate(codepoint)) {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, offsetBuf, length, 1, codePointLengthA, 2);
                        codeRange = Encodings.isValidUnicodeCodepoint(codepoint) ? TSCodeRange.getValidFixedWidth() : TSCodeRange.getBrokenFixedWidth();
                        it.setRawIndex(curIndex);
                        break;
                    }
                    TStringOps.writeToByteArrayS1(buffer, length++, codepoint);
                    TStringConstants.truffleSafePointPoll(node, length);
                }
            }
            if (!it.hasNext()) {
                assert (length == codePointLengthA || sourceEncoding == TruffleString.Encoding.UTF_8 && TStringGuards.isBrokenMultiByte(codeRangeA));
                return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_32, length, codeRange);
            }
            while (it.hasNext()) {
                codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenFixedWidth();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler));
                }
                TStringOps.writeToByteArrayS2(buffer, length++, codepoint);
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length * 4), length, 2, TruffleString.Encoding.UTF_32, length, codeRange);
        }

        @Specialization(guards={"isSupportedEncodingWithCompaction(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isUTF32(sourceEncoding)", "!isLarge(codePointLengthA)", "isUTF32FE(targetEncoding)"})
        static TruffleString utf32FETranscodeRegular(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            return TransCodeIntlNode.utf32FETranscode(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode);
        }

        @Specialization(guards={"isSupportedEncodingWithCompaction(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isUTF32(sourceEncoding)", "isLarge(codePointLengthA)", "isUTF32FE(targetEncoding)"})
        static TruffleString utf32FETranscodeLarge(AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            throw InternalErrors.outOfMemory();
        }

        private static TruffleString utf32FETranscode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            byte[] buffer = new byte[codePointLengthA << 2];
            int length = 0;
            int codeRange = TSCodeRange.getValidMultiByte();
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, sourceEncoding, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler));
                }
                TStringOps.writeToByteArrayS2(buffer, length++, Integer.reverseBytes(codepoint));
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length << 2), length << 2, 0, TruffleString.Encoding.UTF_32_FOREIGN_ENDIAN, length, codeRange);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(sourceEncoding) || isUnsupportedEncoding(targetEncoding)"})
        static TruffleString unsupported(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            return JCodings.getInstance().transcode(node, a, arrayA, codePointLengthA, targetEncoding, errorHandler);
        }

        private static byte[] trim(byte[] array, int byteLength) {
            if (byteLength != array.length) {
                return Arrays.copyOf(array, byteLength);
            }
            return array;
        }

        private static DecodingErrorHandler getDecodingErrorHandler(TranscodingErrorHandler errorHandler) {
            assert (errorHandler == TranscodingErrorHandler.DEFAULT || errorHandler == TranscodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8);
            CompilerAsserts.partialEvaluationConstant(errorHandler);
            DecodingErrorHandler decodingErrorHandler = errorHandler == TranscodingErrorHandler.DEFAULT ? DecodingErrorHandler.DEFAULT_UTF8_INCOMPLETE_SEQUENCES : DecodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8;
            CompilerAsserts.partialEvaluationConstant(decodingErrorHandler);
            return decodingErrorHandler;
        }

        static boolean isAllowUTF16SurrogatesUTF16Or32(TranscodingErrorHandler errorHandler) {
            return TStringGuards.isBuiltin(errorHandler);
        }

        private static boolean isGreaterThanMaxUTFCodepoint(int codepoint) {
            return Integer.toUnsignedLong(codepoint) > 0x10FFFFL;
        }

        private static int utfReplaceInvalid(int codepoint, boolean allowUTF16Surrogates) {
            return TransCodeIntlNode.utfReplaceInvalid(codepoint, Encodings.isUTF16Surrogate(codepoint), TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint), allowUTF16Surrogates);
        }

        private static int utfReplaceInvalid(int codepoint, boolean isSurrogate, boolean isGreaterThanMaxCodepoint, boolean allowUTF16Surrogates) {
            if (isGreaterThanMaxCodepoint || isSurrogate && !allowUTF16Surrogates) {
                return Encodings.invalidCodepoint();
            }
            return codepoint;
        }

        private static TruffleString create(AbstractTruffleString a, byte[] buffer, int length, int stride, TruffleString.Encoding encoding, int codePointLength, int codeRange) {
            return TransCodeIntlNode.create(a, buffer, length, stride, encoding, codePointLength, codeRange, false);
        }

        private static TruffleString create(AbstractTruffleString a, byte[] buffer, int length, int stride, TruffleString.Encoding encoding, int codePointLength, int codeRange, boolean replacedChars) {
            return TruffleString.createFromByteArray(buffer, length, stride, encoding, codePointLength, codeRange, TSCodeRange.isBroken(a.codeRange()) || TSCodeRange.isBroken(codeRange) || a.isMutable() || replacedChars);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean containsSurrogates(AbstractTruffleString a) {
            CompilerAsserts.neverPartOfCompilation();
            for (int i = 0; i < a.length(); ++i) {
                if (!Encodings.isUTF16Surrogate(a.readCharUTF16Uncached(i))) continue;
                return true;
            }
            return false;
        }
    }

    static abstract class TransCodeIntlWithErrorHandlerNode
    extends AbstractInternalNode {
        TransCodeIntlWithErrorHandlerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, TruffleString.Encoding var8, TruffleString.Encoding var9, TranscodingErrorHandler var10);

        @Specialization(guards={"isBroken(codeRangeA) || isAsciiBytesOrLatin1(targetEncoding)", "isSupportedEncodingWithCompaction(sourceEncoding)", "isSupportedEncodingWithCompaction(targetEncoding)", "!isBuiltin(errorHandler)"})
        static TruffleString supportedWithCustomErrorHandler(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached TruffleStringBuilder.AppendCodePointIntlNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringIntlNode appendStringNode, @Cached TruffleStringBuilder.ToStringIntlNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create(targetEncoding);
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, sourceEncoding);
            int maxCodePoint = Encodings.maxCodePoint(targetEncoding);
            int i = 1;
            while (it.hasNext()) {
                int pos = it.getRawIndex();
                int bytePos = it.getByteIndex();
                int codepoint = iteratorNextNode.execute(node, it, sourceEncoding, DecodingErrorHandler.RETURN_NEGATIVE_UTF8_INCOMPLETE_SEQUENCES);
                if (Integer.compareUnsigned(codepoint, maxCodePoint) <= 0) {
                    appendCodePointNode.execute(node, sb, codepoint, 1, false);
                } else {
                    TranscodingErrorHandler.ReplacementString replacementString = errorHandler.apply(a, bytePos, it.getByteIndex() - bytePos, sourceEncoding, targetEncoding);
                    if (replacementString.byteLength() >= 0) {
                        it.setRawIndex(pos);
                        it.errorHandlerSkipBytes(replacementString.byteLength(), true);
                    }
                    appendStringNode.execute(node, sb, replacementString.replacement());
                }
                TStringConstants.truffleSafePointPoll(node, i++);
            }
            return toStringNode.execute(node, sb, false);
        }

        @Fallback
        static TruffleString transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached TransCodeIntlNode transCodeIntlNode) {
            return transCodeIntlNode.execute(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, sourceEncoding, targetEncoding, errorHandler);
        }
    }

    static abstract class TransCodeNode
    extends AbstractInternalNode {
        TransCodeNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, TruffleString.Encoding var8, TranscodingErrorHandler var9);

        @Specialization
        static TruffleString transcode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codePointLengthA, int codeRangeA, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached InlinedConditionProfile asciiBytesInvalidProfile, @Cached TransCodeIntlWithErrorHandlerNode transCodeIntlNode) {
            CompilerAsserts.partialEvaluationConstant(errorHandler);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS && a.isImmutable() && TSCodeRange.isMoreRestrictiveThan(codeRangeA, targetEncoding.maxCompatibleCodeRange)) {
                if (a.stride() == 0) {
                    return TruffleString.createFromByteArray(arrayA, a.offset(), a.length(), 0, targetEncoding, codePointLengthA, codeRangeA, false);
                }
                int targetStride = Stride.fromCodeRange(codeRangeA, targetEncoding);
                byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, a.length(), a.stride(), a.length(), targetStride);
                return TruffleString.createFromByteArray(array, 0, a.length(), targetStride, targetEncoding, codePointLengthA, codeRangeA, false);
            }
            assert (!a.isEmpty());
            if (asciiBytesInvalidProfile.profile(node, (TStringGuards.isAscii(a.encoding()) || TStringGuards.isBytes(a.encoding())) && TStringGuards.isSupportedEncodingWithCompaction(targetEncoding) && TStringGuards.isBuiltin(errorHandler))) {
                assert ((TStringGuards.isBrokenFixedWidth(codeRangeA) || TStringGuards.isValidFixedWidth(codeRangeA)) && TStringGuards.isStride0(a) && codePointLengthA == a.length());
                boolean replacedChars = false;
                byte[] buffer = new byte[codePointLengthA];
                for (int i = 0; i < buffer.length; ++i) {
                    int c = TStringOps.readS0(a, arrayA, offsetA, i);
                    if (c > 127) {
                        buffer[i] = 63;
                        replacedChars = true;
                    } else {
                        buffer[i] = (byte)c;
                    }
                    TStringConstants.truffleSafePointPoll(node, i + 1);
                }
                return TransCodeIntlNode.create(a, buffer, buffer.length, 0, targetEncoding, codePointLengthA, TSCodeRange.get7Bit(), replacedChars);
            }
            return transCodeIntlNode.execute(node, a, arrayA, offsetA, codePointLengthA, codeRangeA, TruffleString.Encoding.get(a.encoding()), targetEncoding, errorHandler);
        }
    }

    static abstract class ToValidStringNode
    extends AbstractInternalNode {
        private static final int[] UTF_32_ASTRAL_RANGE = new int[]{65536, 0x10FFFF};
        private static final int[] UTF_32_INVALID_RANGES = new int[]{55296, 57343, 0x110000, -1};

        ToValidStringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, TruffleString.Encoding var6);

        @Specialization(guards={"isAscii(encoding)"})
        static TruffleString ascii(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding) {
            assert (TStringGuards.isStride0(a));
            int length = a.length();
            byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 0, length, 0);
            int pos = 0;
            int loopCount = 0;
            while (pos < length && (pos = TStringOps.indexOfCodePointWithMaskWithStrideIntl(node, array, TStringUnsafe.byteArrayBaseOffset(), length, 0, pos, 255, 127)) >= 0) {
                array[pos++] = 63;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return TruffleString.createFromByteArray(array, length, 0, TruffleString.Encoding.US_ASCII, length, TSCodeRange.get7Bit());
        }

        @Specialization(guards={"isUTF8(encoding)"})
        static TruffleString utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding, @Cached InlinedBranchProfile outOfMemoryProfile) {
            assert (TStringGuards.isStride0(a));
            assert (TSCodeRange.isPrecise(a.codeRange()));
            assert (a.isCodePointLengthKnown());
            boolean isLarge = TransCodeIntlNode.isLarge(a.codePointLength());
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : a.codePointLength() * 4];
            int length = 0;
            int state = 0;
            int lastCodePointPos = 0;
            int lastErrorPos = 0;
            int codePointLength = a.codePointLength();
            byte[] stateMachine = Encodings.UTF_8_STATE_MACHINE;
            int i = 0;
            while (i < a.length()) {
                int b;
                byte type;
                if ((state = stateMachine[256 + state + (type = stateMachine[b = TStringOps.readS0(a, arrayA, offsetA, i++)])]) == 0) {
                    lastCodePointPos = i;
                } else if (state == 12) {
                    int curCPLength = i - (lastCodePointPos + 1);
                    length = ToValidStringNode.utf8CopyValidRegion(node, arrayA, offsetA, outOfMemoryProfile, isLarge, buffer, length, lastCodePointPos, lastErrorPos);
                    System.arraycopy(Encodings.CONVERSION_REPLACEMENT_UTF_8, 0, buffer, length, Encodings.CONVERSION_REPLACEMENT_UTF_8.length);
                    length += Encodings.CONVERSION_REPLACEMENT_UTF_8.length;
                    state = 0;
                    if (curCPLength > 1) {
                        codePointLength -= curCPLength - 1;
                    }
                    lastErrorPos = --i;
                    lastCodePointPos = i;
                }
                TStringConstants.truffleSafePointPoll(node, i);
            }
            length = ToValidStringNode.utf8CopyValidRegion(node, arrayA, offsetA, outOfMemoryProfile, isLarge, buffer, length, lastCodePointPos, lastErrorPos);
            if (lastCodePointPos != a.length() && lastErrorPos != lastCodePointPos) {
                System.arraycopy(Encodings.CONVERSION_REPLACEMENT_UTF_8, 0, buffer, length, Encodings.CONVERSION_REPLACEMENT_UTF_8.length);
                length += Encodings.CONVERSION_REPLACEMENT_UTF_8.length;
                int curCPLength = a.length() - lastCodePointPos;
                if (curCPLength > 1) {
                    codePointLength -= curCPLength - 1;
                }
            }
            return TruffleString.createFromByteArray(Arrays.copyOf(buffer, length), length, 0, TruffleString.Encoding.UTF_8, codePointLength, TSCodeRange.getValidMultiByte());
        }

        private static int utf8CopyValidRegion(Node node, byte[] arrayA, long offsetA, InlinedBranchProfile outOfMemoryProfile, boolean isLarge, byte[] buffer, int length, int lastCodePointPos, int lastErrorPos) {
            int lengthCPY = lastCodePointPos - lastErrorPos;
            if (isLarge && Integer.compareUnsigned(length + lengthCPY + Encodings.CONVERSION_REPLACEMENT_UTF_8.length, buffer.length) > 0) {
                outOfMemoryProfile.enter(node);
                throw InternalErrors.outOfMemory();
            }
            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, lastErrorPos, buffer, TStringUnsafe.byteArrayBaseOffset(), 0, length, lengthCPY);
            return length + lengthCPY;
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static TruffleString utf16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding) {
            assert (TStringGuards.isStride1(a));
            int length = a.length();
            byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 1, length, 1);
            int pos = 0;
            int codeRange = TSCodeRange.get16Bit();
            int loopCount = 0;
            while ((pos = TStringOps.indexOfCodePointWithMaskWithStrideIntl(node, array, TStringUnsafe.byteArrayBaseOffset(), length, 1, pos, 57343, 2047)) >= 0) {
                boolean invalid = true;
                if (pos != length - 1) {
                    char c = (char)TStringOps.readFromByteArrayS1(array, pos);
                    assert (Encodings.isUTF16Surrogate(c));
                    if (!Encodings.isUTF16LowSurrogate(c)) {
                        assert (Encodings.isUTF16HighSurrogate(c));
                        if (Encodings.isUTF16LowSurrogate((char)TStringOps.readFromByteArrayS1(array, pos + 1))) {
                            invalid = false;
                            codeRange = TSCodeRange.getValidMultiByte();
                            ++pos;
                        }
                    }
                }
                if (invalid) {
                    TStringOps.writeToByteArrayS1(array, pos, 65533);
                }
                if (++pos == length) break;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return TruffleString.createFromByteArray(array, length, 1, TruffleString.Encoding.UTF_16, a.codePointLength(), codeRange);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static TruffleString utf32(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding, @Cached InlinedConditionProfile strideProfile) {
            int codeRange;
            int stride;
            byte[] array;
            assert (TStringGuards.isStride2(a));
            int length = a.length();
            if (strideProfile.profile(node, TStringOps.indexOfAnyIntRange(node, arrayA, offsetA, 2, 0, a.length(), UTF_32_ASTRAL_RANGE) < 0)) {
                array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 2, length, 1);
                stride = 1;
                codeRange = TSCodeRange.get16Bit();
                ToValidStringNode.utf32ReplaceInvalid(node, arrayA, offsetA, length, array, 1);
            } else {
                array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 2, length, 2);
                stride = 2;
                codeRange = TSCodeRange.getValidFixedWidth();
                ToValidStringNode.utf32ReplaceInvalid(node, arrayA, offsetA, length, array, 2);
            }
            return TruffleString.createFromByteArray(array, length, stride, TruffleString.Encoding.UTF_32, a.codePointLength(), codeRange);
        }

        private static void utf32ReplaceInvalid(Node node, byte[] arrayA, long offsetA, int length, byte[] array, int stride) {
            int pos = 0;
            int loopCount = 0;
            while (pos < length && (pos = TStringOps.indexOfAnyIntRange(node, arrayA, offsetA, 2, pos, length, UTF_32_INVALID_RANGES)) >= 0) {
                TStringOps.writeToByteArray(array, stride, pos++, 65533);
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
        }

        @Specialization(guards={"JCODINGS_ENABLED", "isUnsupportedEncoding(encoding)"})
        static TruffleString unsupported(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding) {
            throw InternalErrors.unsupportedOperation();
        }
    }

    static abstract class CreateJavaStringNode
    extends AbstractInternalNode {
        CreateJavaStringNode() {
        }

        abstract String execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4);

        @Specialization
        static String createJavaString(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, @Cached InlinedConditionProfile reuseProfile) {
            byte[] bytes;
            assert (TSCodeRange.is7Or8Bit(a.codeRange()) || TSCodeRange.isPrecise(a.codeRange()));
            assert (a.isLooselyCompatibleTo(TruffleString.Encoding.UTF_16));
            int stride = TStringUnsafe.COMPACT_STRINGS_ENABLED ? Stride.fromCodeRangeUTF16(a.codeRange()) : 1;
            if (reuseProfile.profile(node, a instanceof TruffleString && arrayA != null && a.length() << a.stride() == arrayA.length && a.stride() == stride)) {
                assert (offsetA == (long)TStringUnsafe.byteArrayBaseOffset());
                bytes = arrayA;
            } else {
                bytes = new byte[a.length() << stride];
                TStringOps.arraycopyWithStride(node, arrayA, offsetA, a.stride(), 0, bytes, TStringUnsafe.byteArrayBaseOffset(), stride, 0, a.length());
            }
            int javaStringHash = a.hashCode;
            if (javaStringHash == -1) {
                javaStringHash = 0;
            }
            return TStringUnsafe.createJavaString(bytes, stride, javaStringHash);
        }
    }

    static abstract class FromJavaStringUTF16Node
    extends AbstractInternalNode {
        FromJavaStringUTF16Node() {
        }

        abstract TruffleString execute(Node var1, String var2, int var3, int var4, boolean var5);

        @Specialization
        static TruffleString doNonEmpty(Node node, String javaString, int charOffset, int length, boolean copy, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile length1Profile, @Cached InlinedConditionProfile fullLengthProfile, @Cached InlinedConditionProfile equalStrideProfile) {
            TruffleString cacheEntry;
            byte[] array;
            int offset;
            int codePointLength;
            int codeRange;
            AbstractTruffleString.checkArrayRange(javaString.length(), charOffset, length);
            CompilerAsserts.partialEvaluationConstant(copy);
            if (length == 0) {
                return TruffleString.Encoding.UTF_16.getEmpty();
            }
            int strideJS = TStringUnsafe.getJavaStringStride(javaString);
            int offsetJS = charOffset << strideJS;
            byte[] arrayJS = TStringUnsafe.getJavaStringArray(javaString);
            boolean fullLength = fullLengthProfile.profile(node, length == javaString.length());
            if (utf16CompactProfile.profile(node, strideJS == 0)) {
                if (length1Profile.profile(node, length == 1)) {
                    return TStringConstants.getSingleByte(TruffleString.Encoding.UTF_16, Byte.toUnsignedInt(arrayJS[charOffset]));
                }
                codeRange = TSCodeRange.markImprecise(TSCodeRange.get8Bit());
                codePointLength = length;
            } else {
                assert (strideJS == 1);
                if (length1Profile.profile(node, length == 1 && TStringOps.readFromByteArrayS1(arrayJS, charOffset) <= 255)) {
                    return TStringConstants.getSingleByte(TruffleString.Encoding.UTF_16, TStringOps.readFromByteArrayS1(arrayJS, charOffset));
                }
                if (TStringUnsafe.COMPACT_STRINGS_ENABLED && fullLength) {
                    codePointLength = -1;
                    codeRange = TSCodeRange.markImprecise(TSCodeRange.getBrokenMultiByte());
                } else {
                    long attrs = TStringOps.calcStringAttributesUTF16(node, arrayJS, offsetJS + TStringUnsafe.byteArrayBaseOffset(), length, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
            }
            int stride = Stride.fromCodeRangeUTF16AllowImprecise(codeRange);
            if (TStringUnsafe.COMPACT_STRINGS_ENABLED && (fullLength || !copy && equalStrideProfile.profile(node, stride == strideJS))) {
                offset = offsetJS;
                array = arrayJS;
            } else {
                array = new byte[length << stride];
                offset = 0;
                if (strideJS == 1 && stride == 0) {
                    TStringOps.arraycopyWithStride(node, arrayJS, offsetJS + TStringUnsafe.byteArrayBaseOffset(), 1, 0, array, offset + TStringUnsafe.byteArrayBaseOffset(), 0, 0, length);
                } else {
                    assert (strideJS == stride);
                    TStringOps.arraycopyWithStride(node, arrayJS, offsetJS + TStringUnsafe.byteArrayBaseOffset(), 0, 0, array, offset + TStringUnsafe.byteArrayBaseOffset(), 0, 0, length << stride);
                }
            }
            if (length == javaString.length()) {
                assert (charOffset == 0);
                cacheEntry = TruffleString.createWrapJavaString(javaString, codePointLength, codeRange);
            } else {
                cacheEntry = null;
            }
            int hash = fullLength ? TStringUnsafe.getJavaStringHashMasked(javaString) : 0;
            return TruffleString.createFromByteArrayWithCacheEntry(array, offset, length, stride, TruffleString.Encoding.UTF_16, codePointLength, codeRange, hash, cacheEntry);
        }
    }

    static abstract class ParseDoubleNode
    extends AbstractInternalNode {
        ParseDoubleNode() {
        }

        abstract double execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4) throws TruffleString.NumberFormatException;

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static double doParse(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction) throws TruffleString.NumberFormatException {
            return FastDoubleParser.parseDouble(node, a, arrayA, offsetA, cachedCompaction.getStride(), 0, a.length());
        }
    }

    static abstract class ParseLongNode
    extends AbstractInternalNode {
        ParseLongNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8) throws TruffleString.NumberFormatException;

        @Specialization(guards={"is7Bit(codeRangeA)", "compaction == cachedCompaction"}, limit="3", unroll=3)
        static long do7Bit(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseLong7Bit(node, a, arrayA, offsetA, cachedCompaction.getStride(), radix, errorProfile);
        }

        @Specialization(guards={"!is7Bit(codeRangeA)"})
        static long parseLong(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Cached TruffleStringIterator.InternalNextNode nextNode, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseLong(node, AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding), encoding, radix, errorProfile, nextNode);
        }
    }

    static abstract class ParseIntNode
    extends AbstractInternalNode {
        ParseIntNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8) throws TruffleString.NumberFormatException;

        @Specialization(guards={"is7Bit(codeRangeA)", "compaction == cachedCompaction"}, limit="3", unroll=3)
        static int do7Bit(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseInt7Bit(node, a, arrayA, offsetA, cachedCompaction.getStride(), radix, errorProfile);
        }

        @Specialization(guards={"!is7Bit(codeRangeA)"})
        static int doGeneric(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Cached TruffleStringIterator.InternalNextNode nextNode, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseInt(node, AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding), encoding, radix, errorProfile, nextNode);
        }
    }

    static abstract class CalcStringAttributesInnerNode
    extends AbstractInternalNode {
        CalcStringAttributesInnerNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, TruffleString.Encoding var8, int var9, int var10);

        @Specialization(guards={"isUTF8(encoding)"})
        static long utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile validProfile, @Cached.Exclusive @Cached InlinedConditionProfile brokenProfile) {
            assert (stride == 0);
            long off = offsetA + (long)fromIndex;
            if (validProfile.profile(node, TStringGuards.isValid(knownCodeRange) && a != null)) {
                return TStringOps.calcStringAttributesUTF8(node, arrayA, off, length, true, fromIndex + length == a.length(), brokenProfile);
            }
            return TStringOps.calcStringAttributesUTF8(node, arrayA, off, length, false, false, brokenProfile);
        }

        @Specialization(guards={"isUTF16Or32(encoding)"})
        static long utf16Or32(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile oneByteProfile, @Cached.Exclusive @Cached InlinedConditionProfile twoByteProfile, @Cached.Exclusive @Cached InlinedConditionProfile utf16Profile, @Cached.Exclusive @Cached InlinedConditionProfile utf16ValidProfile) {
            if (oneByteProfile.profile(node, TStringGuards.is8Bit(knownCodeRange) && stride == 0)) {
                return StringAttributes.create(length, TStringOps.calcStringAttributesLatin1(node, arrayA, offsetA + (long)fromIndex, length));
            }
            if (twoByteProfile.profile(node, TStringGuards.isUpTo16Bit(knownCodeRange) && stride == 1)) {
                return StringAttributes.create(length, TStringOps.calcStringAttributesBMP(node, arrayA, offsetA + (long)(fromIndex << 1), length));
            }
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                assert (stride == 1);
                if (utf16ValidProfile.profile(node, TStringGuards.isValid(knownCodeRange))) {
                    return TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA + (long)(fromIndex << 1), length, true);
                }
                assert (TSCodeRange.isBroken(knownCodeRange));
                return TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA + (long)(fromIndex << 1), length, false);
            }
            assert (TStringGuards.isUTF32(encoding));
            assert (stride == 2);
            return StringAttributes.create(length, TStringOps.calcStringAttributesUTF32(node, arrayA, offsetA + (long)(fromIndex << 2), length));
        }

        @Fallback
        static long unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile asciiBytesLatinProfile, @Cached.Exclusive @Cached InlinedConditionProfile utf16FEProfile, @Cached.Exclusive @Cached InlinedConditionProfile utf32FEProfile) {
            assert (stride == 0);
            if (asciiBytesLatinProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(encoding))) {
                int codeRange = TStringOps.calcStringAttributesLatin1(node, arrayA, offsetA + (long)fromIndex, length);
                return StringAttributes.create(length, TStringGuards.is8Bit(codeRange) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : codeRange);
            }
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                return TStringOps.calcStringAttributesUTF16FE(node, arrayA, offsetA + (long)fromIndex, length >> 1);
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return StringAttributes.create(length >> 2, TStringOps.calcStringAttributesUTF32FE(node, arrayA, offsetA + (long)fromIndex, length >> 2));
            }
            assert (TStringGuards.isUnsupportedEncoding(encoding));
            return JCodings.getInstance().calcStringAttributes(node, a, arrayA, offsetA, length, encoding, fromIndex);
        }
    }

    static abstract class StrideFromCodeRangeNode
    extends AbstractInternalNode {
        StrideFromCodeRangeNode() {
        }

        abstract int execute(Node var1, int var2, TruffleString.Encoding var3);

        @Specialization(guards={"isUTF16(encoding)"})
        int doUTF16(int codeRange, TruffleString.Encoding encoding) {
            return Stride.fromCodeRangeUTF16(codeRange);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        int doUTF32(int codeRange, TruffleString.Encoding encoding) {
            return Stride.fromCodeRangeUTF32(codeRange);
        }

        @Specialization(guards={"!isUTF16(encoding)", "!isUTF32(encoding)"})
        int doOther(int codeRange, TruffleString.Encoding encoding) {
            return 0;
        }
    }

    static abstract class LastIndexOfStringRawNode
    extends AbstractInternalNode {
        LastIndexOfStringRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, AbstractTruffleString var7, byte[] var8, long var9, int var11, int var12, int var13, byte[] var14, TruffleString.Encoding var15);

        @Specialization(guards={"isSupportedEncodingWithCompaction(encoding) || isFixedWidth(codeRangeA)"})
        static int direct(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawLastIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, fromIndex - toIndex));
            return indexOfStringNode.execute(node, a, arrayA, offsetA, b, arrayB, offsetB, fromIndex, toIndex, mask);
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeB, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32FEProfile, @Cached InlinedConditionProfile oneLengthProfile) {
            assert (mask == null);
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, null, fromIndex - toIndex));
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                return TStringOpsNodes.RawLastIndexOfStringNode.runIndexOf(node, arrayA, offsetA, a.length() >> 1, 1, arrayB, offsetB, b.length() >> 1, 1, fromIndex >> 1, toIndex >> 1, null, oneLengthProfile) << 1;
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return TStringOpsNodes.RawLastIndexOfStringNode.runIndexOf(node, arrayA, offsetA, a.length() >> 2, 2, arrayB, offsetB, b.length() >> 2, 2, fromIndex >> 2, toIndex >> 2, null, oneLengthProfile) << 2;
            }
            if (!JCodings.JCODINGS_ENABLED) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.backwardIterator(b, arrayB, offsetB, codeRangeB, encoding);
            return TruffleStringIterator.lastByteIndexOfString(node, aIt, bIt, encoding, fromIndex, toIndex, nextNodeA, prevNodeA, prevNodeB);
        }
    }

    static abstract class LastIndexOfStringNode
    extends AbstractInternalNode {
        LastIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, AbstractTruffleString var7, byte[] var8, long var9, int var11, int var12, int var13, TruffleString.Encoding var14);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        static int direct(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawLastIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex - toIndex, encoding, GetCodePointLengthNode.getUncached()));
            return indexOfStringNode.execute(node, a, arrayA, offsetA, b, arrayB, offsetB, fromIndex, toIndex, null);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static int decode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeB) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, arrayB, offsetB, codeRangeB, fromIndex - toIndex, encoding, GetCodePointLengthNode.getUncached()));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.backwardIterator(b, arrayB, offsetB, codeRangeB, encoding);
            return TruffleStringIterator.lastIndexOfString(node, aIt, bIt, encoding, fromIndex, toIndex, nextNodeA, prevNodeA, prevNodeB);
        }
    }

    static abstract class IndexOfStringRawNode
    extends AbstractInternalNode {
        IndexOfStringRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, AbstractTruffleString var7, byte[] var8, long var9, int var11, int var12, int var13, byte[] var14, TruffleString.Encoding var15);

        @Specialization(guards={"isSupportedEncodingWithCompaction(encoding) || isFixedWidth(codeRangeA)"})
        static int supported(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, toIndex - fromIndex));
            return indexOfStringNode.execute(node, a, arrayA, offsetA, b, arrayB, offsetB, fromIndex, toIndex, mask);
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32FEProfile, @Cached InlinedConditionProfile oneLengthProfile) {
            assert (mask == null);
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, null, toIndex - fromIndex));
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                return TStringOpsNodes.RawIndexOfStringNode.runIndexOf(node, arrayA, offsetA, a.length() >> 1, 1, arrayB, offsetB, b.length() >> 1, 1, fromIndex >> 1, toIndex >> 1, null, oneLengthProfile) << 1;
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return TStringOpsNodes.RawIndexOfStringNode.runIndexOf(node, arrayA, offsetA, a.length() >> 2, 2, arrayB, offsetB, b.length() >> 2, 2, fromIndex >> 2, toIndex >> 2, null, oneLengthProfile) << 2;
            }
            if (!JCodings.JCODINGS_ENABLED) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b, arrayB, offsetB, codeRangeB, encoding);
            return TruffleStringIterator.byteIndexOfString(node, aIt, bIt, encoding, fromIndex, toIndex, nextNodeA, nextNodeB);
        }
    }

    static abstract class InternalIndexOfStringNode
    extends AbstractInternalNode {
        InternalIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, AbstractTruffleString var7, byte[] var8, long var9, int var11, int var12, int var13, TruffleString.Encoding var14);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        static int direct(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, arrayB, offsetB, codeRangeB, toIndex - fromIndex, encoding, GetCodePointLengthNode.getUncached()));
            return indexOfStringNode.execute(node, a, arrayA, offsetA, b, arrayB, offsetB, fromIndex, toIndex, null);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static int decode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, arrayB, offsetB, codeRangeB, toIndex - fromIndex, encoding, GetCodePointLengthNode.getUncached()));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b, arrayB, offsetB, codeRangeB, encoding);
            return TruffleStringIterator.indexOfString(node, aIt, bIt, encoding, fromIndex, toIndex, nextNodeA, nextNodeB);
        }
    }

    static abstract class RegionEqualsNode
    extends AbstractInternalNode {
        RegionEqualsNode() {
        }

        abstract boolean execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, int var7, AbstractTruffleString var8, byte[] var9, long var10, int var12, int var13, int var14, TruffleString.Encoding var15);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        boolean direct(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, int fromIndexA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndexB, int length, TruffleString.Encoding encoding) {
            return TStringOps.regionEqualsWithOrMaskWithStride(this, a, arrayA, offsetA, a.stride(), fromIndexA, b, arrayB, offsetB, b.stride(), fromIndexB, null, length);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static boolean decode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, int fromIndexA, AbstractTruffleString b, byte[] arrayB, long offsetB, int codeRangeB, int fromIndexB, int length, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            int i;
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b, arrayB, offsetB, codeRangeB, encoding);
            for (i = 0; i < fromIndexA; ++i) {
                if (!aIt.hasNext()) {
                    return false;
                }
                nextNodeA.execute(node, aIt, encoding);
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            for (i = 0; i < fromIndexB; ++i) {
                if (!bIt.hasNext()) {
                    return false;
                }
                nextNodeB.execute(node, bIt, encoding);
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            for (i = 0; i < length; ++i) {
                if (!aIt.hasNext() || !bIt.hasNext() || nextNodeA.execute(node, aIt, encoding) != nextNodeB.execute(node, bIt, encoding)) {
                    return false;
                }
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            return true;
        }
    }

    static abstract class ConcatMaterializeBytesNode
    extends AbstractInternalNode {
        ConcatMaterializeBytesNode() {
        }

        abstract byte[] execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, AbstractTruffleString var6, byte[] var7, long var8, TruffleString.Encoding var10, int var11, int var12);

        @Specialization(guards={"isUTF16(encoding) || isUTF32(encoding)"})
        static byte[] doWithCompression(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, AbstractTruffleString b, byte[] arrayB, long offsetB, TruffleString.Encoding encoding, int concatLength, int concatStride) {
            byte[] bytes = new byte[concatLength << concatStride];
            TStringOps.arraycopyWithStride(node, arrayA, offsetA, a.stride(), 0, bytes, TStringUnsafe.byteArrayBaseOffset(), concatStride, 0, a.length());
            TStringOps.arraycopyWithStride(node, arrayB, offsetB, b.stride(), 0, bytes, TStringUnsafe.byteArrayBaseOffset(), concatStride, a.length(), b.length());
            return bytes;
        }

        @Specialization(guards={"!isUTF16(encoding)", "!isUTF32(encoding)"})
        byte[] doNoCompression(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, AbstractTruffleString b, byte[] arrayB, long offsetB, TruffleString.Encoding encoding, int concatLength, int concatStride) {
            assert (TStringGuards.isStride0(a));
            assert (TStringGuards.isStride0(b));
            assert (concatStride == 0);
            byte[] bytes = new byte[concatLength];
            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, bytes, TStringUnsafe.byteArrayBaseOffset(), 0, 0, a.length());
            TStringOps.arraycopyWithStride(node, arrayB, offsetB, 0, 0, bytes, TStringUnsafe.byteArrayBaseOffset(), 0, a.length(), b.length());
            return bytes;
        }
    }

    static abstract class ConcatEagerNode
    extends AbstractInternalNode {
        ConcatEagerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, AbstractTruffleString var3, TruffleString.Encoding var4, int var5, int var6, int var7);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString concat(Node node, AbstractTruffleString a, AbstractTruffleString b, TruffleString.Encoding encoding, int concatLength, int concatStride, int concatCodeRange, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached InlinedConditionProfile managedProfileB, @Cached InlinedConditionProfile nativeProfileB, @Cached GetCodePointLengthNode getCodePointLengthANode, @Cached GetCodePointLengthNode getCodePointLengthBNode, @Cached ConcatMaterializeBytesNode materializeBytesNode, @Cached CalcStringAttributesNode calculateAttributesNode, @Cached InlinedConditionProfile brokenProfile) {
            Object dataA = a.data();
            Object dataB = b.data();
            try {
                int codeRange;
                int codePointLength;
                long addOffsetB;
                byte[] arrayB;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                if (managedProfileB.profile(node, dataB instanceof byte[])) {
                    arrayB = (byte[])dataB;
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileB.profile(node, dataB instanceof AbstractTruffleString.NativePointer)) {
                    arrayB = null;
                    addOffsetB = AbstractTruffleString.NativePointer.unwrap(dataB);
                } else {
                    arrayB = b.materializeLazy(node, dataB);
                    addOffsetB = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetB = (long)b.offset() + addOffsetB;
                byte[] bytes = materializeBytesNode.execute(node, a, arrayA, offsetA, b, arrayB, offsetB, encoding, concatLength, concatStride);
                if (brokenProfile.profile(node, TStringGuards.isBrokenMultiByte(concatCodeRange))) {
                    long attrs = calculateAttributesNode.execute(node, null, bytes, TStringUnsafe.byteArrayBaseOffset(), concatLength, concatStride, encoding, 0, TSCodeRange.getBrokenMultiByte());
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                } else {
                    codePointLength = getCodePointLengthANode.execute(node, a, arrayA, offsetA, encoding) + getCodePointLengthBNode.execute(node, b, arrayB, offsetB, encoding);
                    codeRange = concatCodeRange;
                }
                TruffleString truffleString = TruffleString.createFromByteArray(bytes, concatLength, concatStride, encoding, codePointLength, codeRange);
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
                Reference.reachabilityFence(dataB);
            }
        }
    }

    static abstract class SubstringNode
    extends AbstractInternalNode {
        SubstringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9, boolean var10);

        @Specialization(guards={"length == 0"})
        static TruffleString lengthZero(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy) {
            return encoding.getEmpty();
        }

        @Specialization(guards={"fromIndex == 0", "length == length(a)"})
        static TruffleString sameStr(TruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy) {
            return a;
        }

        @Specialization(guards={"length > 0", "length != length(a) || a.isMutable()", "!lazy"})
        static TruffleString materializeSubstring(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy, @Cached.Shared(value="attributes") @Cached CalcStringAttributesNode calcAttributesNode, @Cached.Exclusive @Cached InlinedConditionProfile utf16Profile, @Cached.Exclusive @Cached InlinedConditionProfile utf32Profile) {
            int newStride;
            int codeRange;
            long attrs;
            int stride;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                stride = a.stride();
                attrs = calcAttributesNode.execute(node, a, arrayA, offsetA, length, stride, TruffleString.Encoding.UTF_16, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = Stride.fromCodeRangeUTF16(codeRange);
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                stride = a.stride();
                attrs = calcAttributesNode.execute(node, a, arrayA, offsetA, length, stride, TruffleString.Encoding.UTF_32, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = Stride.fromCodeRangeUTF32(codeRange);
            } else {
                stride = 0;
                attrs = calcAttributesNode.execute(node, a, arrayA, offsetA, length, stride, encoding, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = 0;
            }
            byte[] newBytes = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA + (long)(fromIndex << stride), length, stride, length, newStride);
            return TruffleString.createFromByteArray(newBytes, length, newStride, encoding, StringAttributes.getCodePointLength(attrs), codeRange);
        }

        @Specialization(guards={"length > 0", "length != length(a)", "lazy"})
        static TruffleString createLazySubstring(Node node, TruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy, @Cached.Shared(value="attributes") @Cached CalcStringAttributesNode calcAttributesNode, @Cached.Exclusive @Cached InlinedConditionProfile stride1MustMaterializeProfile, @Cached.Exclusive @Cached InlinedConditionProfile stride2MustMaterializeProfile) {
            Object data;
            int offset;
            int stride;
            long lazyOffset = offsetA + (long)(fromIndex << a.stride());
            long attrs = calcAttributesNode.execute(node, a, arrayA, offsetA, length, a.stride(), encoding, fromIndex, codeRangeA);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            if (stride1MustMaterializeProfile.profile(node, a.stride() == 1 && TSCodeRange.isMoreRestrictiveOrEqual(codeRange, TSCodeRange.get8Bit()))) {
                assert (TStringGuards.isUTF16Or32(encoding));
                stride = 0;
                offset = 0;
                byte[] newBytes = new byte[length];
                TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 1, 0, newBytes, TStringUnsafe.byteArrayBaseOffset(), 0, 0, length);
                data = newBytes;
            } else if (stride2MustMaterializeProfile.profile(node, a.stride() == 2 && TSCodeRange.isMoreRestrictiveOrEqual(codeRange, TSCodeRange.get16Bit()))) {
                assert (TStringGuards.isUTF32(encoding));
                stride = Stride.fromCodeRangeUTF32(StringAttributes.getCodeRange(attrs));
                offset = 0;
                byte[] newBytes = new byte[length << stride];
                if (stride == 0) {
                    TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 2, 0, newBytes, TStringUnsafe.byteArrayBaseOffset(), 0, 0, length);
                } else {
                    assert (stride == 1);
                    TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 2, 0, newBytes, TStringUnsafe.byteArrayBaseOffset(), 1, 0, length);
                }
                data = newBytes;
            } else {
                if (arrayA == null) {
                    if (TStringGuards.isUnsupportedEncoding(encoding)) {
                        if (!JCodings.JCODINGS_ENABLED) {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                        data = ((AbstractTruffleString.NativePointer)a.data()).copy();
                    } else {
                        data = a.data();
                    }
                } else {
                    data = arrayA;
                }
                offset = a.offset() + (fromIndex << a.stride());
                stride = a.stride();
            }
            return TruffleString.createFromArray(data, offset, length, stride, encoding, codePointLength, codeRange);
        }
    }

    @ImportStatic(value={TStringGuards.class, TruffleString.Encoding.class})
    static abstract class IndexOfCodePointSetNode
    extends Node {
        static final int POSSIBLE_STRIDE_VALUES = 3;
        @Node.Children
        IndexOfCodePointSet.IndexOfNode[] indexOfNodes;
        final TruffleString.Encoding encoding;
        final boolean isUTF16Or32;

        IndexOfCodePointSetNode(IndexOfCodePointSet.IndexOfNode[] indexOfNodes, TruffleString.Encoding encoding) {
            this.indexOfNodes = this.insert(indexOfNodes);
            this.encoding = encoding;
            this.isUTF16Or32 = TStringGuards.isUTF16Or32(encoding);
        }

        abstract int execute(byte[] var1, long var2, int var4, int var5, int var6, int var7, int var8);

        @Specialization(guards={"!isUTF16Or32"})
        int stride0(byte[] arrayA, long offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex) {
            return this.doIndexOf(arrayA, offsetA, lengthA, 0, codeRangeA, fromIndex, toIndex);
        }

        @Specialization(guards={"isUTF16Or32", "strideA == cachedStride"}, limit="POSSIBLE_STRIDE_VALUES")
        int dynamicStride(byte[] arrayA, long offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, @Cached(value="strideA", allowUncached=true) int cachedStride) {
            return this.doIndexOf(arrayA, offsetA, lengthA, cachedStride, codeRangeA, fromIndex, toIndex);
        }

        @ExplodeLoop
        private int doIndexOf(byte[] arrayA, long offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex) {
            CompilerAsserts.partialEvaluationConstant(this.indexOfNodes);
            for (int i = 0; i < this.indexOfNodes.length - 1; ++i) {
                CompilerAsserts.partialEvaluationConstant(i);
                IndexOfCodePointSet.IndexOfNode node = this.indexOfNodes[i];
                CompilerAsserts.partialEvaluationConstant(node);
                if (!TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, Byte.toUnsignedInt(node.maxCodeRange))) continue;
                return node.execute(this, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, this.encoding);
            }
            return this.indexOfNodes[this.indexOfNodes.length - 1].execute(this, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, this.encoding);
        }
    }

    static abstract class LastIndexOfCodePointRawNode
    extends AbstractInternalNode {
        LastIndexOfCodePointRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9, int var10);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int utf8Fixed(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, offsetA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf8Variable(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            int encodedSize = Encodings.utf8EncodedSize(codepoint);
            if (encodedSize > fromIndex - toIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, offsetA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
            }
            byte[] encoded = Encodings.utf8EncodeNonAscii(codepoint, encodedSize);
            return TStringOps.lastIndexOfStringWithOrMaskWithStride(node, arrayA, offsetA, a.length(), 0, encoded, TStringUnsafe.byteArrayBaseOffset(), encoded.length, 0, fromIndex, toIndex, null);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf16Variable(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            assert (TStringGuards.isStride1(a));
            int encodedSize = Encodings.utf16EncodedSize(codepoint);
            if (encodedSize > fromIndex - toIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, offsetA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
            }
            return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStride(node, arrayA, offsetA, 1, fromIndex, toIndex, Character.highSurrogate(codepoint), Character.lowSurrogate(codepoint), 0, 0);
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32FEProfile) {
            assert (TStringGuards.isStride0(a));
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                int fromIndexRaw = fromIndex >> 1;
                int toIndexRaw = toIndex >> 1;
                int encodedSize = Encodings.utf16EncodedSize(codepoint);
                if (encodedSize > fromIndexRaw - toIndexRaw) {
                    return -1;
                }
                if (encodedSize == 1) {
                    if (!TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
                        return -1;
                    }
                    return TStringOps.lastIndexOfCodePointWithOrMaskWithStride(node, arrayA, offsetA, 1, fromIndexRaw, toIndexRaw, Character.reverseBytes((char)codepoint), 0) << 1;
                }
                char hiSurrogate = Character.reverseBytes(Character.highSurrogate(codepoint));
                char loSurrogate = Character.reverseBytes(Character.lowSurrogate(codepoint));
                return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStride(node, arrayA, offsetA, 1, fromIndexRaw, toIndexRaw, hiSurrogate, loSurrogate, 0, 0) << 1;
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
                    return -1;
                }
                int fromIndexRaw = fromIndex >> 2;
                int toIndexRaw = toIndex >> 2;
                return TStringOps.lastIndexOfCodePointWithOrMaskWithStride(node, arrayA, offsetA, 2, fromIndexRaw, toIndexRaw, Integer.reverseBytes(codepoint), 0) << 2;
            }
            return LastIndexOfCodePointRawNode.unsupported(node, a, arrayA, offsetA, codeRangeA, encoding, codepoint, fromIndex, toIndex);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            TruffleStringIterator it = TruffleString.backwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            int loopCount = 0;
            while (it.hasPrevious() && it.getRawIndex() >= toIndex) {
                if (TruffleStringIterator.InternalPreviousNode.getUncached().execute(node, it, encoding, DecodingErrorHandler.DEFAULT) == codepoint) {
                    return it.getRawIndex();
                }
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return -1;
        }
    }

    static abstract class LastIndexOfCodePointNode
    extends AbstractInternalNode {
        LastIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9, int var10);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixedWidth(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, offsetA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA)"})
        static int decode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            return TruffleStringIterator.lastIndexOf(node, AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding), encoding, codepoint, fromIndex, toIndex, nextNode);
        }
    }

    static abstract class IndexOfCodePointRawNode
    extends AbstractInternalNode {
        IndexOfCodePointRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9, int var10);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int fixed(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
            return TStringInternalNodes.indexOfFixedWidth(node, a, arrayA, offsetA, codeRangeA, codepoint, fromIndex, toIndex, indexOfNode);
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf8Variable(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            assert (TStringGuards.isStride0(a));
            int encodedSize = Encodings.utf8EncodedSize(codepoint);
            if (encodedSize > toIndex - fromIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringOps.indexOfCodePointWithStride(node, arrayA, offsetA, 0, fromIndex, toIndex, codepoint);
            }
            byte[] encoded = Encodings.utf8EncodeNonAscii(codepoint, encodedSize);
            TruffleString b = TruffleString.createFromByteArray(encoded, encoded.length, 0, TruffleString.Encoding.UTF_8, 1, TSCodeRange.getValidMultiByte());
            return TStringOps.indexOfStringWithOrMaskWithStride(node, a, arrayA, offsetA, 0, b, encoded, (long)TStringUnsafe.byteArrayBaseOffset(), 0, fromIndex, toIndex, null);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf16Variable(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            assert (TStringGuards.isStride1(a));
            int encodedSize = Encodings.utf16EncodedSize(codepoint);
            if (encodedSize > toIndex - fromIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringOps.indexOfCodePointWithStride(node, arrayA, offsetA, 1, fromIndex, toIndex, codepoint);
            }
            return TStringOps.indexOf2ConsecutiveWithStride(node, arrayA, offsetA, 1, fromIndex, toIndex, Character.highSurrogate(codepoint), Character.lowSurrogate(codepoint));
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32FEProfile) {
            assert (TStringGuards.isStride0(a));
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                int fromIndexRaw = fromIndex >> 1;
                int toIndexRaw = toIndex >> 1;
                int encodedSize = Encodings.utf16EncodedSize(codepoint);
                if (encodedSize > toIndexRaw - fromIndexRaw) {
                    return -1;
                }
                if (encodedSize == 1) {
                    return TStringOps.indexOfCodePointWithStride(node, arrayA, offsetA, 1, fromIndexRaw, toIndexRaw, Character.reverseBytes((char)codepoint)) << 1;
                }
                char hiSurrogate = Character.reverseBytes(Character.highSurrogate(codepoint));
                char loSurrogate = Character.reverseBytes(Character.lowSurrogate(codepoint));
                return TStringOps.indexOf2ConsecutiveWithStride(node, arrayA, offsetA, 1, fromIndexRaw, toIndexRaw, hiSurrogate, loSurrogate) << 1;
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
                    return -1;
                }
                int fromIndexRaw = fromIndex >> 2;
                int toIndexRaw = toIndex >> 2;
                return TStringOps.indexOfCodePointWithStride(node, arrayA, offsetA, 2, fromIndexRaw, toIndexRaw, Integer.reverseBytes(codepoint)) << 2;
            }
            return IndexOfCodePointRawNode.unsupported(node, a, arrayA, offsetA, codeRangeA, encoding, codepoint, fromIndex, toIndex);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            int loopCount = 0;
            while (it.hasNext() && it.getRawIndex() < toIndex) {
                int ret = it.getRawIndex();
                if (TruffleStringIterator.InternalNextNode.getUncached().execute(node, it, encoding) == codepoint) {
                    return ret;
                }
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return -1;
        }
    }

    static abstract class IndexOfCodePointNode
    extends AbstractInternalNode {
        IndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9, int var10);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixedWidth(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
            return TStringInternalNodes.indexOfFixedWidth(node, a, arrayA, offsetA, codeRangeA, codepoint, fromIndex, toIndex, indexOfNode);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA)"})
        static int decode(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            return TruffleStringIterator.indexOf(node, AbstractTruffleString.forwardIterator(a, arrayA, offsetA, codeRangeA, encoding), encoding, codepoint, fromIndex, toIndex, nextNode);
        }
    }

    static abstract class CodePointAtRawNode
    extends AbstractInternalNode {
        CodePointAtRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, TruffleString.ErrorHandling var9);

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Exclusive @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.is7Bit(codeRangeA))) {
                return TStringOps.readS0(a, arrayA, offsetA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8DecodeValid(a, arrayA, offsetA, i);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf8DecodeBroken(a, arrayA, offsetA, i, errorHandling);
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Exclusive @Cached InlinedConditionProfile validProfile, @Cached.Exclusive @Cached InlinedConditionProfile stride0Profile) {
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                return TStringOps.readS0(a, arrayA, offsetA, i);
            }
            if (fixedWidthProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                assert (TStringGuards.isStride1(a));
                return TStringOps.readS1(a, arrayA, offsetA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf16DecodeValid(a, arrayA, offsetA, i);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16DecodeBroken(a, arrayA, offsetA, i, errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                return TStringOps.readS0(a, arrayA, offsetA, i);
            }
            if (stride1Profile.profile(node, TStringGuards.isStride1(a))) {
                char c = TStringOps.readS1(a, arrayA, offsetA, i);
                if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && Encodings.isUTF16Surrogate(c)) {
                    return -1;
                }
                return c;
            }
            assert (TStringGuards.isStride2(a));
            int c = TStringOps.readS2(a, arrayA, offsetA, i);
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && !Encodings.isValidUnicodeCodepoint(c)) {
                return -1;
            }
            return c;
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile fixedProfile, @Cached @Cached.Exclusive InlinedConditionProfile asciiBrokenProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEValidProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf32FEProfile) {
            if (fixedProfile.profile(node, TStringGuards.isBytes(encoding) || TStringGuards.is7Or8Bit(codeRangeA))) {
                assert (TStringGuards.isStride0(a));
                return TStringOps.readS0(a, arrayA, offsetA, i);
            }
            if (asciiBrokenProfile.profile(node, TStringGuards.isAscii(encoding))) {
                return CodePointAtRawNode.asciiBroken(a, arrayA, offsetA, codeRangeA, encoding, i, errorHandling);
            }
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                assert (TStringGuards.isStride0(a));
                if (utf16FEValidProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                    return Encodings.utf16FEDecodeValid(arrayA, offsetA, a.length() >> 1, i >> 1);
                }
                assert (TStringGuards.isBroken(codeRangeA));
                return Encodings.utf16FEDecodeBroken(arrayA, offsetA, a.length() >> 1, i >> 1, errorHandling);
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return CodePointAtRawNode.utf32FE(a, arrayA, offsetA, codeRangeA, encoding, i, errorHandling);
            }
            assert (TStringGuards.isUnsupportedEncoding(encoding));
            return CodePointAtRawNode.unsupported(a, arrayA, encoding, i, errorHandling);
        }

        static int asciiBroken(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int c = TStringOps.readS0(a, arrayA, offsetA, i);
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && c > 127) {
                return -1;
            }
            assert (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT || !TSCodeRange.isPrecise(codeRangeA));
            return c;
        }

        static int utf32FE(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int c = Integer.reverseBytes(TStringOps.readS2(arrayA, offsetA, a.length() >> 2, i >> 2));
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && !Encodings.isValidUnicodeCodepoint(c)) {
                return -1;
            }
            return c;
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(AbstractTruffleString a, byte[] arrayA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return JCodings.getInstance().decode(a, JCodings.asByteArray(a, arrayA), i, encoding, errorHandling);
        }
    }

    static abstract class CodePointAtNode
    extends AbstractInternalNode {
        CodePointAtNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, TruffleString.ErrorHandling var9);

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile fixedWidthProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.is7Bit(codeRangeA))) {
                return TStringOps.readS0(a, arrayA, offsetA, i);
            }
            int byteIndex = Encodings.utf8CodePointToByteIndex(node, a, arrayA, offsetA, i);
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8DecodeValid(a, arrayA, offsetA, byteIndex);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf8DecodeBroken(a, arrayA, offsetA, byteIndex, errorHandling);
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile fixedWidthProfile, @Cached @Cached.Exclusive InlinedConditionProfile stride0Profile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                    return TStringOps.readS0(a, arrayA, offsetA, i);
                }
                assert (TStringGuards.isStride1(a));
                return TStringOps.readS1(a, arrayA, offsetA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                assert (TStringGuards.isStride1(a));
                return Encodings.utf16DecodeValid(a, arrayA, offsetA, Encodings.utf16ValidCodePointToCharIndex(node, a, arrayA, offsetA, i));
            }
            assert (TStringGuards.isStride1(a));
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16DecodeBroken(a, arrayA, offsetA, Encodings.utf16BrokenCodePointToCharIndex(node, a, arrayA, offsetA, i), errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile stride0Profile, @Cached @Cached.Exclusive InlinedConditionProfile stride1Profile) {
            return CodePointAtRawNode.utf32(node, a, arrayA, offsetA, codeRangeA, encoding, i, errorHandling, stride0Profile, stride1Profile);
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile fixedProfile, @Cached @Cached.Exclusive InlinedConditionProfile asciiBrokenProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEValidProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf32FEProfile) {
            if (fixedProfile.profile(node, TStringGuards.isBytes(encoding) || TStringGuards.is7Or8Bit(codeRangeA))) {
                assert (TStringGuards.isStride0(a));
                return TStringOps.readS0(a, arrayA, offsetA, i);
            }
            if (asciiBrokenProfile.profile(node, TStringGuards.isAscii(encoding))) {
                return CodePointAtRawNode.asciiBroken(a, arrayA, offsetA, codeRangeA, encoding, i, errorHandling);
            }
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                return CodePointAtNode.utf16FE(node, a, arrayA, offsetA, codeRangeA, i, errorHandling, utf16FEValidProfile);
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return CodePointAtRawNode.utf32FE(a, arrayA, offsetA, codeRangeA, encoding, i << 2, errorHandling);
            }
            assert (TStringGuards.isUnsupportedEncoding(encoding));
            assert (TStringGuards.isStride0(a));
            return CodePointAtNode.unsupported(node, a, arrayA, encoding, i, errorHandling);
        }

        private static int utf16FE(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, int i, TruffleString.ErrorHandling errorHandling, InlinedConditionProfile utf16FEValidProfile) {
            assert (TStringGuards.isStride0(a));
            int lengthA = a.length() >> 1;
            if (utf16FEValidProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf16FEDecodeValid(arrayA, offsetA, lengthA, Encodings.utf16FEValidCodePointToCharIndex(node, arrayA, offsetA, lengthA, i));
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16FEDecodeBroken(arrayA, offsetA, lengthA, Encodings.utf16FEBrokenCodePointToCharIndex(node, arrayA, offsetA, lengthA, i), errorHandling);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(Node node, AbstractTruffleString a, byte[] arrayA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            JCodings jcodings = JCodings.getInstance();
            byte[] bytes = JCodings.asByteArray(a, arrayA);
            return jcodings.decode(a, bytes, jcodings.codePointIndexToRaw(node, a, bytes, 0, i, false, encoding), encoding, errorHandling);
        }
    }

    static abstract class ReadByteNode
    extends AbstractInternalNode {
        ReadByteNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7);

        @Specialization(guards={"isUTF16(encoding)"})
        static int doUTF16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int i, TruffleString.Encoding encoding, @Cached @Cached.Exclusive InlinedConditionProfile stride0Profile) {
            int index;
            a.boundsCheckByteIndexUTF16(i);
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                if (TStringGuards.bigEndian() == ((i & 1) == 0)) {
                    return 0;
                }
                index = i >> 1;
            } else {
                assert (TStringGuards.isStride1(a));
                index = i;
            }
            return TStringOps.readS0(arrayA, offsetA, a.length() << a.stride(), index);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int doUTF32(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int i, TruffleString.Encoding encoding, @Cached @Cached.Exclusive InlinedConditionProfile stride0Profile, @Cached @Cached.Exclusive InlinedConditionProfile stride1Profile) {
            int index;
            a.boundsCheckByteIndexUTF32(i);
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                if ((i & 3) != (TStringGuards.bigEndian() ? 3 : 0)) {
                    return 0;
                }
                index = i >> 2;
            } else if (stride1Profile.profile(node, TStringGuards.isStride1(a))) {
                if (TStringGuards.bigEndian() == ((i & 2) == 0)) {
                    return 0;
                }
                index = TStringGuards.bigEndian() ? i >> 1 | i & 1 : i >> 1 & 0xFFFFFFFE | i & 1;
            } else {
                assert (TStringGuards.isStride2(a));
                index = i;
            }
            return TStringOps.readS0(arrayA, offsetA, a.length() << a.stride(), index);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)"})
        static int doRest(AbstractTruffleString a, byte[] arrayA, long offsetA, int i, TruffleString.Encoding encoding) {
            a.boundsCheckByteIndexS0(i);
            return TStringOps.readS0(a, arrayA, offsetA, i);
        }
    }

    static abstract class CodePointIndexToRawNode
    extends AbstractInternalNode {
        CodePointIndexToRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9, boolean var10);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixed(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            return index;
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                assert (TStringGuards.isStride0(a));
                long regionOffset = offsetA + (long)extraOffsetRaw;
                int regionLength = a.length() - extraOffsetRaw;
                int byteIndex = TStringOps.codePointIndexToByteIndexUTF8Valid(node, arrayA, regionOffset, regionLength, index);
                if (byteIndex < 0 || !isLength && byteIndex == regionLength) {
                    throw InternalErrors.indexOutOfBounds(regionLength, byteIndex);
                }
                return byteIndex;
            }
            return CodePointIndexToRawNode.utf8Broken(node, a, arrayA, offsetA, extraOffsetRaw, index, isLength);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                assert (TStringGuards.isStride1(a));
                long regionOffset = offsetA + (long)(extraOffsetRaw << 1);
                int regionLength = a.length() - extraOffsetRaw;
                int result = TStringOps.codePointIndexToByteIndexUTF16Valid(node, arrayA, regionOffset, regionLength, index);
                if (result < 0 || !isLength && result == regionLength) {
                    throw InternalErrors.indexOutOfBounds(regionLength, result);
                }
                return result;
            }
            return CodePointIndexToRawNode.utf16Broken(node, a, arrayA, offsetA, extraOffsetRaw, index, isLength);
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf32FEProfile) {
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                return CodePointIndexToRawNode.utf16FE(node, a, arrayA, offsetA, extraOffsetRaw, index, isLength);
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return index << 2;
            }
            assert (TStringGuards.isUnsupportedEncoding(encoding));
            return CodePointIndexToRawNode.unsupported(node, a, arrayA, encoding, extraOffsetRaw, index, isLength);
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf8Broken(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int extraOffsetRaw, int index, boolean isLength) {
            assert (TStringGuards.isStride0(a));
            int cpi = 0;
            for (int i = extraOffsetRaw; i < a.length(); i += Encodings.utf8GetCodePointLength(a, arrayA, offsetA, i, DecodingErrorHandler.DEFAULT)) {
                if (cpi == index) {
                    return i - extraOffsetRaw;
                }
                TStringConstants.truffleSafePointPoll(node, ++cpi);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf16Broken(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int extraOffsetRaw, int index, boolean isLength) {
            assert (TStringGuards.isStride1(a));
            int cpi = 0;
            for (int i = extraOffsetRaw; i < a.length(); ++i) {
                if (i <= extraOffsetRaw || !Encodings.isUTF16LowSurrogate(TStringOps.readS1(a, arrayA, offsetA, i)) || !Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, offsetA, i - 1))) {
                    if (cpi == index) {
                        return i - extraOffsetRaw;
                    }
                    ++cpi;
                }
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf16FE(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int extraOffsetRaw, int index, boolean isLength) {
            int extraOffsetScaled;
            assert (TStringGuards.isStride0(a));
            int cpi = 0;
            int lengthA = a.length() >> 1;
            for (int i = extraOffsetScaled = extraOffsetRaw >> 1; i < lengthA; ++i) {
                if (i <= extraOffsetScaled || !Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i))) || !Encodings.isUTF16HighSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, lengthA, i - 1)))) {
                    if (cpi == index) {
                        return i - extraOffsetScaled << 1;
                    }
                    ++cpi;
                }
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(Node node, AbstractTruffleString a, byte[] arrayA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            return JCodings.getInstance().codePointIndexToRaw(node, a, JCodings.asByteArray(a, arrayA), extraOffsetRaw, index, isLength, encoding);
        }

        static int atEnd(AbstractTruffleString a, int extraOffsetRaw, int index, boolean isLength, int cpi) {
            int regionLength = a.length() - extraOffsetRaw;
            if (isLength && cpi == index) {
                return regionLength;
            }
            throw InternalErrors.indexOutOfBounds(regionLength, index);
        }
    }

    static abstract class RawIndexToCodePointIndexNode
    extends AbstractInternalNode {
        RawIndexToCodePointIndexNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, int var9);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixed(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            return index;
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached @Cached.Exclusive InlinedConditionProfile validProfile, @Cached @Cached.Exclusive InlinedConditionProfile brokenProfile) {
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF8(node, arrayA, offsetA + (long)byteOffset, index, true, byteOffset + index == a.length(), brokenProfile));
            }
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF8(node, arrayA, offsetA + (long)byteOffset, index, false, false, brokenProfile));
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            assert (TStringGuards.isStride1(a));
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA + (long)byteOffset, index, true));
            }
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA + (long)byteOffset, index, false));
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf32FEProfile) {
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                assert (TStringGuards.isStride0(a));
                return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16FE(node, arrayA, offsetA + (long)byteOffset, index >> 1));
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                return index >> 2;
            }
            assert (TStringGuards.isUnsupportedEncoding(encoding));
            return StringAttributes.getCodePointLength(JCodings.getInstance().calcStringAttributes(node, a, arrayA, offsetA, index, encoding, byteOffset));
        }
    }

    static abstract class ByteLengthOfCodePointNode
    extends AbstractInternalNode {
        ByteLengthOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, int var6, TruffleString.Encoding var7, int var8, TruffleString.ErrorHandling var9);

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            assert (TStringGuards.isStride0(a));
            int firstByte = TStringOps.readS0(a, arrayA, offsetA, index);
            if (firstByte <= 127) {
                return 1;
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8CodePointLength(firstByte);
            }
            return Encodings.utf8GetCodePointLength(a, arrayA, offsetA, index, errorHandling.errorHandler);
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile fixedProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            if (fixedProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                return 2;
            }
            assert (TStringGuards.isStride1(a));
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, offsetA, index)) ? 4 : 2;
            }
            assert (TSCodeRange.isBroken(codeRangeA));
            return Encodings.utf16BrokenGetCodePointByteLength(a, arrayA, offsetA, index, errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile returnNegativeProfile) {
            if (returnNegativeProfile.profile(node, !TStringGuards.isBestEffort(errorHandling) && !TSCodeRange.isUpToValid(codeRangeA))) {
                assert (TStringGuards.isStride2(a));
                int c = TStringOps.readS2(a, arrayA, offsetA, index);
                if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && !Encodings.isValidUnicodeCodepoint(c)) {
                    return -1;
                }
            }
            return 4;
        }

        @Fallback
        static int unlikelyCases(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Exclusive InlinedConditionProfile fixedProfile, @Cached @Cached.Exclusive InlinedConditionProfile asciiBrokenReturnNegativeProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf16FEBrokenProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf32FEProfile, @Cached @Cached.Exclusive InlinedConditionProfile utf32FEBrokenProfile) {
            boolean isBroken = TSCodeRange.isBroken(codeRangeA);
            assert (TStringGuards.isStride0(a));
            if (fixedProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA) && (TSCodeRange.isUpToValid(codeRangeA) || TStringGuards.isBestEffort(errorHandling)))) {
                assert (encoding.naturalStride == 0);
                return 1;
            }
            if (asciiBrokenReturnNegativeProfile.profile(node, TStringGuards.isAscii(encoding))) {
                assert (isBroken && TStringGuards.isReturnNegative(errorHandling));
                return TStringOps.readS0(a, arrayA, offsetA, index) < 128 ? 1 : -1;
            }
            if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                if (utf16FEBrokenProfile.profile(node, isBroken)) {
                    return Encodings.utf16FEBrokenGetCodePointByteLength(arrayA, offsetA, a.length() >> 1, index >> 1, errorHandling);
                }
                return Encodings.isUTF16HighSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, offsetA, a.length() >> 1, index >> 1))) ? 4 : 2;
            }
            if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                if (utf32FEBrokenProfile.profile(node, isBroken && TStringGuards.isReturnNegative(errorHandling))) {
                    return CodePointAtRawNode.utf32FE(a, arrayA, offsetA, codeRangeA, encoding, index, TruffleString.ErrorHandling.RETURN_NEGATIVE) < 0 ? -1 : 4;
                }
                return 4;
            }
            assert (TStringGuards.isUnsupportedEncoding(encoding));
            return ByteLengthOfCodePointNode.unsupported(a, arrayA, encoding, index, errorHandling);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(AbstractTruffleString a, byte[] arrayA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            JCodings jcodings = JCodings.getInstance();
            int cpLength = jcodings.getCodePointLength(encoding, JCodings.asByteArray(a, arrayA), a.byteArrayOffset() + index, a.byteArrayOffset() + a.length());
            int regionLength = a.length() - index;
            if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
                if (cpLength > 0 && cpLength <= regionLength) {
                    return cpLength;
                }
                return Math.min(jcodings.minLength(encoding), regionLength);
            }
            assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (cpLength <= regionLength) {
                return cpLength;
            }
            return -1 - (cpLength - regionLength);
        }
    }

    static abstract class FromNativePointerNode
    extends AbstractInternalNode {
        FromNativePointerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString.NativePointer var2, int var3, int var4, TruffleString.Encoding var5, boolean var6);

        @Specialization
        static TruffleString fromNativePointerInternal(Node node, AbstractTruffleString.NativePointer pointer, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean isCacheHead, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedByteValueProfile unlikelyEncodingProfile) {
            int stride;
            int codeRange;
            int codePointLength;
            int length;
            long offsetA = pointer.pointer + (long)byteOffset;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                length = byteLength >> 1;
                long attrs = TStringOps.calcStringAttributesUTF16(node, null, offsetA, length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
                stride = 1;
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                length = byteLength >> 2;
                codeRange = TStringOps.calcStringAttributesUTF32(node, null, offsetA, length);
                codePointLength = length;
                stride = 2;
            } else {
                length = byteLength;
                stride = 0;
                long attrs = utf8Profile.profile(node, TStringGuards.isUTF8(encoding)) ? TStringOps.calcStringAttributesUTF8(node, null, offsetA, length, false, false, utf8BrokenProfile) : FromBufferWithStringCompactionNode.unlikelyCases(node, null, offsetA, byteLength, encoding, unlikelyEncodingProfile.profile(node, encoding.id));
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            }
            return TruffleString.createFromArray(pointer, byteOffset, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        }
    }

    @GenerateInline(value=false)
    @GenerateCached(value=false)
    static abstract class FromNativePointerEmbedderNode
    extends AbstractInternalNode {
        FromNativePointerEmbedderNode() {
        }

        abstract TruffleString execute(long var1, int var3, int var4, TruffleString.Encoding var5, boolean var6);

        @Specialization
        final TruffleString fromNativePointer(long rawPointer, int byteOffset, int byteLength, TruffleString.Encoding enc, boolean copy, @Cached FromNativePointerNode fromNativePointerNode, @Cached FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            AbstractTruffleString.NativePointer pointer = new AbstractTruffleString.NativePointer(TruffleString.ETERNAL_POINTER, rawPointer);
            if (copy) {
                return fromBufferWithStringCompactionNode.execute(this, pointer, byteOffset, byteLength, enc, true, true);
            }
            return fromNativePointerNode.execute(this, pointer, byteOffset, byteLength, enc, true);
        }
    }

    static abstract class FromBufferWithStringCompactionKnownAttributesNode
    extends AbstractInternalNode {
        FromBufferWithStringCompactionKnownAttributesNode() {
        }

        final TruffleString execute(Node node, AbstractTruffleString a, TruffleString.Encoding encoding) {
            return this.execute(node, a, true, encoding);
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, boolean var3, TruffleString.Encoding var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString fromBufferWithStringCompaction(Node node, AbstractTruffleString a, boolean isCacheHead, TruffleString.Encoding encoding, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA, @Cached GetCodePointLengthNode getCodePointLengthNode, @Cached GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile) {
            Object dataA = a.data();
            assert (dataA instanceof byte[] || dataA instanceof AbstractTruffleString.NativePointer);
            try {
                byte[] array;
                int stride;
                long addOffsetA;
                byte[] arrayA;
                if (managedProfileA.profile(node, dataA instanceof byte[])) {
                    arrayA = (byte[])dataA;
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                    arrayA = null;
                    addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                } else {
                    arrayA = a.materializeLazy(node, dataA);
                    addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                }
                long offsetA = (long)a.offset() + addOffsetA;
                int codeRange = getPreciseCodeRangeNode.execute(node, a, arrayA, offsetA, encoding);
                a.looseCheckEncoding(encoding, codeRange);
                int length = a.length();
                if (length == 0) {
                    TruffleString truffleString = encoding.getEmpty();
                    return truffleString;
                }
                int strideA = a.stride();
                int offset = TStringUnsafe.byteArrayBaseOffset();
                if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                    stride = Stride.fromCodeRangeUTF16(codeRange);
                    array = new byte[length << stride];
                    if (utf16CompactProfile.profile(node, strideA == 1 && stride == 0)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, offset, 0, 0, length);
                    } else {
                        assert (stride == strideA);
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, array, offset, 0, 0, length << stride);
                    }
                } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                    stride = Stride.fromCodeRangeUTF32(codeRange);
                    array = new byte[length << stride];
                    if (utf32Compact0Profile.profile(node, strideA == 2 && stride == 0)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 0, 0, length);
                    } else if (utf32Compact1Profile.profile(node, strideA == 2 && stride == 1)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 1, 0, length);
                    } else {
                        assert (stride == strideA);
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, array, offset, 0, 0, length << stride);
                    }
                } else {
                    stride = 0;
                    array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 0, length, 0);
                }
                int codePointLength = getCodePointLengthNode.execute(node, a, arrayA, offsetA, encoding);
                TruffleString truffleString = TruffleString.createFromByteArray(array, 0, length, stride, encoding, codePointLength, codeRange, isCacheHead);
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        static FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return TStringInternalNodesFactory.FromBufferWithStringCompactionKnownAttributesNodeGen.getUncached();
        }
    }

    static abstract class FromBufferWithStringCompactionNode
    extends AbstractInternalNode {
        FromBufferWithStringCompactionNode() {
        }

        abstract TruffleString execute(Node var1, Object var2, int var3, int var4, TruffleString.Encoding var5, boolean var6, boolean var7);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString fromBufferWithStringCompaction(Node node, Object dataA, int strOffsetA, int byteLength, TruffleString.Encoding encoding, boolean copy, boolean isCacheHead, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile, @Cached InlinedByteValueProfile unlikelyEncodingProfile) {
            assert (dataA instanceof byte[] || dataA instanceof AbstractTruffleString.NativePointer);
            try {
                byte[] array;
                int offset;
                int stride;
                int codeRange;
                int codePointLength;
                int length;
                long offsetA;
                byte[] arrayA;
                if (dataA instanceof byte[]) {
                    byte[] byteArray;
                    arrayA = byteArray = (byte[])dataA;
                    offsetA = TStringUnsafe.byteArrayBaseOffset() + strOffsetA;
                } else {
                    arrayA = null;
                    offsetA = AbstractTruffleString.NativePointer.unwrap(dataA) + (long)strOffsetA;
                }
                if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                    AbstractTruffleString.checkByteLengthUTF16(byteLength);
                    length = byteLength >> 1;
                    attrs = TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA, length, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    stride = Stride.fromCodeRangeUTF16(codeRange);
                    if (copy || stride == 0) {
                        offset = 0;
                        array = new byte[length << stride];
                        if (utf16CompactProfile.profile(node, stride == 0)) {
                            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, TStringUnsafe.byteArrayBaseOffset(), 0, 0, length);
                        } else {
                            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, TStringUnsafe.byteArrayBaseOffset(), 1, 0, length);
                        }
                    } else {
                        offset = strOffsetA;
                        array = arrayA;
                    }
                } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                    AbstractTruffleString.checkByteLengthUTF32(byteLength);
                    length = byteLength >> 2;
                    codeRange = TStringOps.calcStringAttributesUTF32(node, arrayA, offsetA, length);
                    codePointLength = length;
                    stride = Stride.fromCodeRangeUTF32(codeRange);
                    if (copy || stride < 2) {
                        offset = 0;
                        array = new byte[length << stride];
                        if (utf32Compact0Profile.profile(node, stride == 0)) {
                            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, TStringUnsafe.byteArrayBaseOffset(), 0, 0, length);
                        } else if (utf32Compact1Profile.profile(node, stride == 1)) {
                            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, TStringUnsafe.byteArrayBaseOffset(), 1, 0, length);
                        } else {
                            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, TStringUnsafe.byteArrayBaseOffset(), 2, 0, length);
                        }
                    } else {
                        offset = strOffsetA;
                        array = arrayA;
                    }
                } else {
                    length = byteLength;
                    stride = 0;
                    attrs = utf8Profile.profile(node, TStringGuards.isUTF8(encoding)) ? TStringOps.calcStringAttributesUTF8(node, arrayA, offsetA, length, false, false, utf8BrokenProfile) : FromBufferWithStringCompactionNode.unlikelyCases(node, arrayA, offsetA, byteLength, encoding, unlikelyEncodingProfile.profile(node, encoding.id));
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    if (copy) {
                        offset = 0;
                        array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 0, length, 0);
                    } else {
                        offset = strOffsetA;
                        array = arrayA;
                    }
                }
                Object data = array == null ? dataA : (Object)array;
                TruffleString truffleString = TruffleString.createFromArray(data, offset, length, stride, encoding, codePointLength, codeRange, isCacheHead);
                return truffleString;
            }
            finally {
                Reference.reachabilityFence(dataA);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private static long unlikelyCases(Node node, byte[] arrayA, long offsetA, int byteLength, TruffleString.Encoding encodingObj, int encoding) {
            if (TStringGuards.isAsciiBytesOrLatin1(encoding)) {
                int cr = TStringOps.calcStringAttributesLatin1(node, arrayA, offsetA, byteLength);
                return StringAttributes.create(byteLength, TStringGuards.is8Bit(cr) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : cr);
            }
            if (TStringGuards.isUTF16FE(encoding)) {
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                return TStringOps.calcStringAttributesUTF16FE(node, arrayA, offsetA, byteLength >> 1);
            }
            if (TStringGuards.isUTF32FE(encoding)) {
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                return StringAttributes.create(byteLength >> 2, TStringOps.calcStringAttributesUTF32FE(node, arrayA, offsetA, byteLength >> 2));
            }
            return JCodings.getInstance().calcStringAttributes(node, null, arrayA, offsetA, byteLength, encodingObj, 0);
        }
    }

    static abstract class GetCodePointLengthWithMaterializationNode
    extends AbstractInternalNode {
        GetCodePointLengthWithMaterializationNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile cacheMissProfile, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            int codePointLength = a.codePointLength();
            if (cacheMissProfile.profile(node, codePointLength < 0)) {
                Object dataA = a.data();
                try {
                    long addOffsetA;
                    byte[] arrayA;
                    if (managedProfileA.profile(node, dataA instanceof byte[])) {
                        arrayA = (byte[])dataA;
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                        arrayA = null;
                        addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                    } else {
                        arrayA = a.materializeLazy(node, dataA);
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    }
                    long offsetA = (long)a.offset() + addOffsetA;
                    int n = StringAttributes.getCodePointLength(TStringInternalNodes.updateAttributes(node, a, arrayA, offsetA, encoding, a.codeRange()));
                    return n;
                }
                finally {
                    Reference.reachabilityFence(dataA);
                }
            }
            return codePointLength;
        }
    }

    static abstract class GetCodePointLengthNode
    extends AbstractInternalNode {
        GetCodePointLengthNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, TruffleString.Encoding var6);

        @Specialization
        static int get(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding, @Cached InlinedConditionProfile cacheMissProfile) {
            int codePointLength = a.codePointLength();
            if (cacheMissProfile.profile(node, codePointLength < 0)) {
                return StringAttributes.getCodePointLength(TStringInternalNodes.updateAttributes(node, a, arrayA, offsetA, encoding, a.codeRange()));
            }
            return codePointLength;
        }

        static GetCodePointLengthNode getUncached() {
            return TStringInternalNodesFactory.GetCodePointLengthNodeGen.getUncached();
        }
    }

    static abstract class GetPreciseCodeRangeWithMaterializationNode
    extends AbstractInternalNode {
        GetPreciseCodeRangeWithMaterializationNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange))) {
                Object dataA = a.data();
                try {
                    long addOffsetA;
                    byte[] arrayA;
                    if (managedProfileA.profile(node, dataA instanceof byte[])) {
                        arrayA = (byte[])dataA;
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                        arrayA = null;
                        addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                    } else {
                        arrayA = a.materializeLazy(node, dataA);
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    }
                    long offsetA = (long)a.offset() + addOffsetA;
                    int n = StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, arrayA, offsetA, encoding, codeRange));
                    return n;
                }
                finally {
                    Reference.reachabilityFence(dataA);
                }
            }
            return codeRange;
        }
    }

    static abstract class GetPreciseCodeRangeNode
    extends AbstractInternalNode {
        GetPreciseCodeRangeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, TruffleString.Encoding var6);

        @Specialization
        static int get(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, arrayA, offsetA, encoding, codeRange));
            }
            return codeRange;
        }
    }

    static abstract class GetValidOrBrokenCodeRangeNode
    extends AbstractInternalNode {
        GetValidOrBrokenCodeRangeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached InlinedConditionProfile managedProfileA, @Cached InlinedConditionProfile nativeProfileA) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange) && TSCodeRange.isBroken(codeRange))) {
                Object dataA = a.data();
                try {
                    long addOffsetA;
                    byte[] arrayA;
                    if (managedProfileA.profile(node, dataA instanceof byte[])) {
                        arrayA = (byte[])dataA;
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    } else if (nativeProfileA.profile(node, dataA instanceof AbstractTruffleString.NativePointer)) {
                        arrayA = null;
                        addOffsetA = AbstractTruffleString.NativePointer.unwrap(dataA);
                    } else {
                        arrayA = a.materializeLazy(node, dataA);
                        addOffsetA = TStringUnsafe.byteArrayBaseOffset();
                    }
                    long offsetA = (long)a.offset() + addOffsetA;
                    int n = StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, arrayA, offsetA, encoding, codeRange));
                    return n;
                }
                finally {
                    Reference.reachabilityFence(dataA);
                }
            }
            return codeRange;
        }
    }

    static abstract class GetCodeRangeForIndexCalculationNode
    extends AbstractInternalNode {
        GetCodeRangeForIndexCalculationNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, byte[] var3, long var4, TruffleString.Encoding var6);

        @Specialization
        static int get(Node node, AbstractTruffleString a, byte[] arrayA, long offsetA, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange) && !TStringGuards.isFixedWidth(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, arrayA, offsetA, encoding, codeRange));
            }
            return codeRange;
        }
    }

    static abstract class ToIndexableNode
    extends AbstractInternalNode {
        ToIndexableNode() {
        }

        abstract Object execute(Node var1, AbstractTruffleString var2, Object var3);

        @Specialization
        static byte[] doByteArray(AbstractTruffleString a, byte[] data) {
            return data;
        }

        @Specialization
        static AbstractTruffleString.NativePointer doNativePointer(AbstractTruffleString a, AbstractTruffleString.NativePointer data) {
            return data;
        }

        @Fallback
        static byte[] slowpath(Node node, AbstractTruffleString a, Object data) {
            return a.materializeLazy(node, data);
        }

        static ToIndexableNode getUncached() {
            return TStringInternalNodesFactory.ToIndexableNodeGen.getUncached();
        }
    }
}

