/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import java.util.Arrays;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.EnumNamingStrategyFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.EnumValuesToWrite;

public class EnumDefinition {
    private final AnnotatedClass _annotatedClass;
    private final EnumNamingStrategy _enumNamingStrategy;
    private final Enum<?>[] _enumConstants;
    private final String[] _explicitNames;

    private EnumDefinition(AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy, Enum<?>[] enumConstants, String[] explicitNames) {
        this._annotatedClass = annotatedClass;
        this._enumNamingStrategy = enumNamingStrategy;
        this._enumConstants = enumConstants;
        this._explicitNames = explicitNames;
    }

    public static EnumDefinition construct(MapperConfig<?> config, AnnotatedClass annotatedClass) {
        Class<?> enumCls0 = annotatedClass.getRawType();
        Enum<?>[] enumConstants = EnumDefinition._enumConstants(enumCls0);
        String[] explicitNames = new String[enumConstants.length];
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        if (ai != null) {
            explicitNames = ai.findEnumValues(config, annotatedClass, enumConstants, explicitNames);
        }
        Object namingDef = config.getAnnotationIntrospector().findEnumNamingStrategy(config, annotatedClass);
        EnumNamingStrategy enumNamingStrategy = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(namingDef, config.canOverrideAccessModifiers(), config.getEnumNamingStrategy());
        return new EnumDefinition(annotatedClass, enumNamingStrategy, enumConstants, explicitNames);
    }

    public EnumValuesToWrite valuesToWrite(MapperConfig<?> config) {
        return EnumValuesToWrite.construct(config, this._annotatedClass, this._enumNamingStrategy, this._enumConstants, this._explicitNames);
    }

    public int size() {
        return this._enumConstants.length;
    }

    public Class<Enum<?>> enumClass() {
        Class<Enum<?>> cls = this._annotatedClass.getRawType();
        return cls;
    }

    public Enum<?>[] enumConstants() {
        return this._enumConstants;
    }

    public List<String> explicitNames() {
        return Arrays.asList(this._explicitNames);
    }

    private static Enum<?>[] _enumConstants(Class<?> enumCls) {
        Enum<?>[] enumValues = ClassUtil.findEnumType(enumCls).getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("Internal error: no Enum constants for Class " + enumCls.getName());
        }
        return enumValues;
    }
}

