/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyCFunctionWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;

public abstract class CApiGuards {
    public static boolean isPrimitiveNativeWrapper(Object object) {
        return object instanceof PrimitiveNativeWrapper;
    }

    public static boolean isNativeWrapper(Object object) {
        return object instanceof PythonNativeWrapper || object instanceof PyCFunctionWrapper;
    }

    public static boolean isNativeNull(Object object) {
        NativePointer nativePointer;
        return object instanceof NativePointer && (nativePointer = (NativePointer)object).isNull();
    }

    public static boolean isSpecialSingleton(Object delegate) {
        return CApiContext.getSingletonNativeWrapperIdx(delegate) != -1;
    }

    public static boolean isSmallInteger(int i) {
        return -5 <= i && i < 257;
    }

    public static boolean isSmallLong(long i) {
        return -5L <= i && i < 257L;
    }

    public static boolean isSmallIntegerWrapper(PrimitiveNativeWrapper nativeWrapper) {
        return nativeWrapper.isIntLike() && CApiGuards.isSmallLong(nativeWrapper.getLong());
    }
}

