module org.graalvm.truffle {
    /* static phase */ requires java.desktop;
    requires java.logging;
    requires java.management;
    requires java.sql;
    requires jdk.management;
    requires jdk.unsupported;
    requires org.graalvm.collections;
    requires org.graalvm.nativeimage;
    requires org.graalvm.polyglot;
    /* transitive */ requires org.graalvm.word;

    exports com.oracle.truffle.api;
    exports com.oracle.truffle.api.bytecode;
    exports com.oracle.truffle.api.bytecode.debug;
    exports com.oracle.truffle.api.bytecode.serialization;
    exports com.oracle.truffle.api.debug;
    exports com.oracle.truffle.api.dsl;
    exports com.oracle.truffle.api.exception;
    exports com.oracle.truffle.api.frame;
    exports com.oracle.truffle.api.impl to com.oracle.truffle.enterprise, com.oracle.truffle.enterprise.svm, com.oracle.truffle.truffle_nfi_panama, org.graalvm.locator, org.graalvm.truffle.runtime, org.graalvm.truffle.runtime.svm;
    exports com.oracle.truffle.api.instrumentation;
    exports com.oracle.truffle.api.instrumentation.provider;
    exports com.oracle.truffle.api.interop;
    exports com.oracle.truffle.api.io;
    exports com.oracle.truffle.api.library;
    exports com.oracle.truffle.api.library.provider;
    exports com.oracle.truffle.api.memory;
    exports com.oracle.truffle.api.nodes;
    exports com.oracle.truffle.api.object;
    exports com.oracle.truffle.api.profiles;
    exports com.oracle.truffle.api.provider;
    exports com.oracle.truffle.api.source;
    exports com.oracle.truffle.api.staticobject;
    exports com.oracle.truffle.api.strings;
    exports com.oracle.truffle.api.strings.provider;
    exports com.oracle.truffle.api.utilities;
    exports com.oracle.truffle.object to com.oracle.truffle.enterprise, com.oracle.truffle.enterprise.svm, org.graalvm.truffle.runtime, org.graalvm.truffle.runtime.svm;
    exports com.oracle.truffle.object.enterprise to com.oracle.truffle.enterprise;

    opens com.oracle.truffle.polyglot to org.graalvm.truffle.runtime;

    provides TruffleInstrumentProvider with DebuggerInstrumentProvider;
    provides InternalResourceProvider with JDKSupportLibTruffleAttachResourceProvider;
    provides AbstractPolyglotImpl with PolyglotImpl;

}

