/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.intl.DurationFormatFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.DurationFormatPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.AbstractInternalState;
import com.oracle.truffle.js.runtime.builtins.intl.JSDurationFormatObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.graalvm.shadowed.com.ibm.icu.number.FormattedNumber;
import org.graalvm.shadowed.com.ibm.icu.number.IntegerWidth;
import org.graalvm.shadowed.com.ibm.icu.number.LocalizedNumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.NumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.Precision;
import org.graalvm.shadowed.com.ibm.icu.text.ConstrainedFieldPosition;
import org.graalvm.shadowed.com.ibm.icu.text.DateFormatSymbols;
import org.graalvm.shadowed.com.ibm.icu.text.FormattedValue;
import org.graalvm.shadowed.com.ibm.icu.text.ListFormatter;
import org.graalvm.shadowed.com.ibm.icu.util.MeasureUnit;
import org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSDurationFormat
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    private static final BigDecimal BD_1E3 = BigDecimal.valueOf(1000L);
    private static final BigDecimal BD_1E6 = BigDecimal.valueOf(1000000L);
    private static final BigDecimal BD_1E9 = BigDecimal.valueOf(1000000000L);
    public static final TruffleString CLASS_NAME = Strings.constant("DurationFormat");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("DurationFormat.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.DurationFormat");
    public static final JSDurationFormat INSTANCE = new JSDurationFormat();

    private JSDurationFormat() {
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject durationFormatPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(durationFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, durationFormatPrototype, DurationFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(durationFormatPrototype, TO_STRING_TAG);
        return durationFormatPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, DurationFormatFunctionBuiltins.BUILTINS);
    }

    public static JSDurationFormatObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getDurationFormatFactory();
        Shape shape = factory.getShape(realm, proto);
        JSDurationFormatObject newObj = factory.initProto(new JSDurationFormatObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject resolvedOptions(JSContext context, JSRealm realm, JSDurationFormatObject durationFormat) {
        return durationFormat.getInternalState().toResolvedOptions(context, realm);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getPluralRulesPrototype();
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(InternalState state, JSTemporalDurationRecord duration) {
        String separator = JSDurationFormat.getSeparator(state.javaLocale);
        List<FormattedNumber> numbers = JSDurationFormat.toFormattedNumbers(state, duration, null);
        Deque<String> strings = JSDurationFormat.toFormattedStrings(separator, numbers);
        ListFormatter listFormatter = ListFormatter.getInstance((ULocale)ULocale.forLocale((Locale)state.javaLocale), (ListFormatter.Type)ListFormatter.Type.UNITS, (ListFormatter.Width)JSDurationFormat.toICUListFormatterWidth(state.style));
        return listFormatter.format(strings);
    }

    private static Deque<String> toFormattedStrings(String separator, List<FormattedNumber> numbers) {
        ArrayDeque<String> strings = new ArrayDeque<String>();
        boolean addSeparator = false;
        for (FormattedNumber number : numbers) {
            if (number == null) {
                addSeparator = true;
                continue;
            }
            if (addSeparator && !strings.isEmpty()) {
                addSeparator = false;
                strings.add((String)strings.removeLast() + separator + String.valueOf(number));
                continue;
            }
            addSeparator = false;
            strings.add(number.toString());
        }
        return strings;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object formatToParts(JSContext context, JSRealm realm, InternalState state, JSTemporalDurationRecord duration) {
        String separator = JSDurationFormat.getSeparator(state.javaLocale);
        ArrayList<MeasureUnit> units = new ArrayList<MeasureUnit>();
        List<FormattedNumber> numbers = JSDurationFormat.toFormattedNumbers(state, duration, units);
        Deque<String> strings = JSDurationFormat.toFormattedStrings(separator, numbers);
        ListFormatter listFormatter = ListFormatter.getInstance((ULocale)ULocale.forLocale((Locale)state.javaLocale), (ListFormatter.Type)ListFormatter.Type.UNITS, (ListFormatter.Width)JSDurationFormat.toICUListFormatterWidth(state.style));
        ListFormatter.FormattedList formattedList = listFormatter.formatToValue(strings);
        ArrayList<JSObject> resultParts = new ArrayList<JSObject>();
        int idx = 0;
        Iterator unitsIterator = units.iterator();
        ConstrainedFieldPosition cfPos = new ConstrainedFieldPosition();
        while (formattedList.nextPosition(cfPos)) {
            Format.Field field = cfPos.getField();
            if (field == ListFormatter.Field.LITERAL) {
                String value = formattedList.subSequence(cfPos.getStart(), cfPos.getLimit()).toString();
                resultParts.add(IntlUtil.makePart(context, realm, "literal", value));
                continue;
            }
            if (field != ListFormatter.Field.ELEMENT) continue;
            do {
                FormattedValue formattedValue;
                if ((formattedValue = (FormattedValue)numbers.get(idx++)) == null) {
                    resultParts.add(IntlUtil.makePart(context, realm, "literal", separator));
                    formattedValue = (FormattedValue)numbers.get(idx++);
                }
                MeasureUnit icuUnit = (MeasureUnit)unitsIterator.next();
                String unit = icuUnit.getIdentifier();
                AttributedCharacterIterator fit = formattedValue.toCharacterIterator();
                String formatted = formattedValue.toString();
                resultParts.addAll(JSNumberFormat.innerFormatToParts(context, realm, fit, 0.0, formatted, unit, false));
            } while (idx < numbers.size() && numbers.get(idx) == null);
        }
        return JSArray.createConstant(context, realm, resultParts.toArray());
    }

    private static ListFormatter.Width toICUListFormatterWidth(String style) {
        return switch (style) {
            case "digital" -> ListFormatter.Width.SHORT;
            case "long" -> ListFormatter.Width.WIDE;
            case "narrow" -> ListFormatter.Width.NARROW;
            case "short" -> ListFormatter.Width.SHORT;
            default -> throw Errors.shouldNotReachHereUnexpectedValue(style);
        };
    }

    @CompilerDirectives.TruffleBoundary
    public static List<FormattedNumber> toFormattedNumbers(InternalState state, JSTemporalDurationRecord duration, List<MeasureUnit> units) {
        int minimumFractionDigits;
        int maximumFractionDigits;
        boolean displaySign = TemporalUtil.durationSign(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds()) < 0;
        ArrayList<FormattedNumber> numbers = new ArrayList<FormattedNumber>();
        LocalizedNumberFormatter numberFormatter = NumberFormatter.withLocale((Locale)state.javaLocale);
        displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getYears(), (MeasureUnit)MeasureUnit.YEAR, state.yearsStyle, state.yearsDisplay, numbers, false, displaySign, units);
        displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getMonths(), (MeasureUnit)MeasureUnit.MONTH, state.monthsStyle, state.monthsDisplay, numbers, false, displaySign, units);
        displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getWeeks(), (MeasureUnit)MeasureUnit.WEEK, state.weeksStyle, state.weeksDisplay, numbers, false, displaySign, units);
        displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getDays(), (MeasureUnit)MeasureUnit.DAY, state.daysStyle, state.daysDisplay, numbers, false, displaySign, units);
        displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getHours(), (MeasureUnit)MeasureUnit.HOUR, state.hoursStyle, state.hoursDisplay, numbers, false, displaySign, units);
        boolean addSeparator = (duration.getHours() != 0.0 || "always".equals(state.hoursDisplay)) && "numeric".equals(state.hoursStyle) || "2-digit".equals(state.hoursStyle);
        String minutesDisplay = addSeparator && ("always".equals(state.secondsDisplay) || duration.getSeconds() != 0.0 || duration.getMilliseconds() != 0.0 || duration.getMicroseconds() != 0.0 || duration.getNanoseconds() != 0.0) ? "always" : state.minutesDisplay;
        displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getMinutes(), (MeasureUnit)MeasureUnit.MINUTE, state.minutesStyle, minutesDisplay, numbers, addSeparator, displaySign, units);
        if (state.fractionalDigits == -1) {
            maximumFractionDigits = 9;
            minimumFractionDigits = 0;
        } else {
            maximumFractionDigits = minimumFractionDigits = state.fractionalDigits;
        }
        numberFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)numberFormatter.precision((Precision)Precision.minMaxFraction((int)minimumFractionDigits, (int)maximumFractionDigits))).roundingMode(RoundingMode.DOWN);
        if ("fractional".equals(state.millisecondsStyle)) {
            BigDecimal value = new BigDecimal(duration.getSeconds());
            value = value.add(new BigDecimal(duration.getMilliseconds()).divide(BD_1E3));
            value = value.add(new BigDecimal(duration.getMicroseconds()).divide(BD_1E6));
            value = value.add(new BigDecimal(duration.getNanoseconds()).divide(BD_1E9));
            JSDurationFormat.formatUnit(numberFormatter, value, (MeasureUnit)MeasureUnit.SECOND, state.secondsStyle, state.secondsDisplay, numbers, true, displaySign, units);
        } else {
            displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getSeconds(), (MeasureUnit)MeasureUnit.SECOND, state.secondsStyle, state.secondsDisplay, numbers, true, displaySign, units);
            if ("fractional".equals(state.microsecondsStyle)) {
                BigDecimal value = new BigDecimal(duration.getMilliseconds());
                value = value.add(new BigDecimal(duration.getMicroseconds()).divide(BD_1E3));
                value = value.add(new BigDecimal(duration.getNanoseconds()).divide(BD_1E6));
                JSDurationFormat.formatUnit(numberFormatter, value, MeasureUnit.MILLISECOND, state.millisecondsStyle, state.millisecondsDisplay, numbers, false, displaySign, units);
            } else {
                displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getMilliseconds(), MeasureUnit.MILLISECOND, state.millisecondsStyle, state.millisecondsDisplay, numbers, false, displaySign, units);
                if ("fractional".equals(state.nanosecondsStyle)) {
                    BigDecimal value = new BigDecimal(duration.getMicroseconds());
                    value = value.add(new BigDecimal(duration.getNanoseconds()).divide(BD_1E3));
                    JSDurationFormat.formatUnit(numberFormatter, value, MeasureUnit.MICROSECOND, state.microsecondsStyle, state.microsecondsDisplay, numbers, false, displaySign, units);
                } else {
                    displaySign &= JSDurationFormat.formatUnit(numberFormatter, duration.getMicroseconds(), MeasureUnit.MICROSECOND, state.microsecondsStyle, state.microsecondsDisplay, numbers, false, displaySign, units);
                    JSDurationFormat.formatUnit(numberFormatter, duration.getNanoseconds(), MeasureUnit.NANOSECOND, state.nanosecondsStyle, state.nanosecondsDisplay, numbers, false, displaySign, units);
                }
            }
        }
        return numbers;
    }

    private static String getSeparator(Locale locale) {
        return DateFormatSymbols.getInstance((Locale)locale).getTimeSeparatorString();
    }

    private static boolean formatUnit(LocalizedNumberFormatter baseFormatter, Number value, MeasureUnit unit, String style, String display, List<FormattedNumber> numbers, boolean addSeparator, boolean displaySign, List<MeasureUnit> units) {
        boolean style2Digit;
        boolean valueIsZero;
        boolean bl = valueIsZero = value.doubleValue() == 0.0;
        if (valueIsZero && !"always".equals(display)) {
            return true;
        }
        boolean styleNumeric = "numeric".equals(style);
        boolean bl2 = style2Digit = !styleNumeric && "2-digit".equals(style);
        if (addSeparator && !numbers.isEmpty() && (unit == MeasureUnit.SECOND || unit == MeasureUnit.MINUTE) && (styleNumeric || style2Digit)) {
            numbers.add(null);
        }
        Number valueToFormat = value;
        LocalizedNumberFormatter signedFormatter = baseFormatter;
        boolean signDisplayed = false;
        if (displaySign) {
            signDisplayed = true;
            if (valueIsZero) {
                valueToFormat = -0.0;
            }
        } else {
            signedFormatter = (LocalizedNumberFormatter)baseFormatter.sign(NumberFormatter.SignDisplay.NEVER);
        }
        FormattedNumber formatted = styleNumeric ? ((LocalizedNumberFormatter)signedFormatter.grouping(NumberFormatter.GroupingStrategy.OFF)).format(valueToFormat) : (style2Digit ? ((LocalizedNumberFormatter)((LocalizedNumberFormatter)signedFormatter.integerWidth(IntegerWidth.zeroFillTo((int)2))).grouping(NumberFormatter.GroupingStrategy.OFF)).format(valueToFormat) : ((LocalizedNumberFormatter)((LocalizedNumberFormatter)signedFormatter.unit(unit)).unitWidth(JSDurationFormat.toICUUnitWidth(style))).format(valueToFormat));
        numbers.add(formatted);
        if (units != null) {
            units.add(unit);
        }
        return !signDisplayed;
    }

    private static NumberFormatter.UnitWidth toICUUnitWidth(String style) {
        return switch (style) {
            case "long" -> NumberFormatter.UnitWidth.FULL_NAME;
            case "short" -> NumberFormatter.UnitWidth.SHORT;
            case "narrow" -> NumberFormatter.UnitWidth.NARROW;
            default -> throw Errors.shouldNotReachHereUnexpectedValue(style);
        };
    }

    public static class InternalState
    extends AbstractInternalState {
        private String style;
        private String yearsStyle;
        private String yearsDisplay;
        private String monthsStyle;
        private String monthsDisplay;
        private String weeksStyle;
        private String weeksDisplay;
        private String daysStyle;
        private String daysDisplay;
        private String hoursStyle;
        private String hoursDisplay;
        private String minutesStyle;
        private String minutesDisplay;
        private String secondsStyle;
        private String secondsDisplay;
        private String millisecondsStyle;
        private String millisecondsDisplay;
        private String microsecondsStyle;
        private String microsecondsDisplay;
        private String nanosecondsStyle;
        private String nanosecondsDisplay;
        private int fractionalDigits;

        public void setStyle(String style) {
            this.style = style;
        }

        public void setYearsOptions(Pair<String, String> options) {
            this.yearsStyle = options.getFirst();
            this.yearsDisplay = options.getSecond();
        }

        public void setMonthsOptions(Pair<String, String> options) {
            this.monthsStyle = options.getFirst();
            this.monthsDisplay = options.getSecond();
        }

        public void setWeeksOptions(Pair<String, String> options) {
            this.weeksStyle = options.getFirst();
            this.weeksDisplay = options.getSecond();
        }

        public void setDaysOptions(Pair<String, String> options) {
            this.daysStyle = options.getFirst();
            this.daysDisplay = options.getSecond();
        }

        public void setHoursOptions(Pair<String, String> options) {
            this.hoursStyle = options.getFirst();
            this.hoursDisplay = options.getSecond();
        }

        public void setMinutesOptions(Pair<String, String> options) {
            this.minutesStyle = options.getFirst();
            this.minutesDisplay = options.getSecond();
        }

        public void setSecondsOptions(Pair<String, String> options) {
            this.secondsStyle = options.getFirst();
            this.secondsDisplay = options.getSecond();
        }

        public void setMillisecondsOptions(Pair<String, String> options) {
            this.millisecondsStyle = options.getFirst();
            this.millisecondsDisplay = options.getSecond();
        }

        public void setMicrosecondsOptions(Pair<String, String> options) {
            this.microsecondsStyle = options.getFirst();
            this.microsecondsDisplay = options.getSecond();
        }

        public void setNanosecondsOptions(Pair<String, String> options) {
            this.nanosecondsStyle = options.getFirst();
            this.nanosecondsDisplay = options.getSecond();
        }

        public void setFractionalDigits(int fractionalDigits) {
            this.fractionalDigits = fractionalDigits;
        }

        public JSObject toResolvedOptions(JSContext context, JSRealm realm) {
            JSObject result = JSOrdinary.create(context, realm);
            int defaultAttrs = JSAttributes.getDefault();
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.locale), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NUMBERING_SYSTEM, Strings.fromJavaString(this.numberingSystem), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_STYLE, Strings.fromJavaString(this.style), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_YEARS, Strings.fromJavaString(this.yearsStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_YEARS_DISPLAY, Strings.fromJavaString(this.yearsDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MONTHS, Strings.fromJavaString(this.monthsStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MONTHS_DISPLAY, Strings.fromJavaString(this.monthsDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_WEEKS, Strings.fromJavaString(this.weeksStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_WEEKS_DISPLAY, Strings.fromJavaString(this.weeksDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_DAYS, Strings.fromJavaString(this.daysStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_DAYS_DISPLAY, Strings.fromJavaString(this.daysDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_HOURS, Strings.fromJavaString(this.hoursStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_HOURS_DISPLAY, Strings.fromJavaString(this.hoursDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MINUTES, Strings.fromJavaString(this.minutesStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MINUTES_DISPLAY, Strings.fromJavaString(this.minutesDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_SECONDS, Strings.fromJavaString(this.secondsStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_SECONDS_DISPLAY, Strings.fromJavaString(this.secondsDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MILLISECONDS, InternalState.toResolvedOption(this.millisecondsStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MILLISECONDS_DISPLAY, Strings.fromJavaString(this.millisecondsDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MICROSECONDS, InternalState.toResolvedOption(this.microsecondsStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_MICROSECONDS_DISPLAY, Strings.fromJavaString(this.microsecondsDisplay), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NANOSECONDS, InternalState.toResolvedOption(this.nanosecondsStyle), defaultAttrs);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NANOSECONDS_DISPLAY, Strings.fromJavaString(this.nanosecondsDisplay), defaultAttrs);
            if (this.fractionalDigits >= 0) {
                JSObjectUtil.putDataProperty(result, IntlUtil.KEY_FRACTIONAL_DIGITS, this.fractionalDigits, defaultAttrs);
            }
            return result;
        }

        private static TruffleString toResolvedOption(String subSecondStyle) {
            if ("fractional".equals(subSecondStyle)) {
                return IntlUtil.KEY_NUMERIC;
            }
            return Strings.fromJavaString(subSecondStyle);
        }
    }
}

