/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.json;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONModuleBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONScannerBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.json.JSONScannerBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.json.JSONScannerBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.json.PJSONScanner;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.floats.FloatUtils;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyFloatCheckExactNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyLongFromUnicodeObject;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.JSONScanner})
public final class JSONScannerBuiltins
extends PythonBuiltins {
    public static final TruffleString T_JSON_DECODE_ERROR = PythonUtils.tsLiteral("JSONDecodeError");
    public static final TpSlots SLOTS = JSONScannerBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return JSONScannerBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleString scanStringUnicode(String string, int start, boolean strict, IntRef nextIdx, Node raisingNode) {
        StringBuilder builder = null;
        if (start < 0 || start > string.length()) {
            throw PRaiseNode.raiseStatic(raisingNode, PythonBuiltinClassType.ValueError, ErrorMessages.END_IS_OUT_OF_BOUNDS);
        }
        int idx = start;
        while (idx < string.length()) {
            char c;
            if ((c = string.charAt(idx++)) == '\"') {
                String result = builder == null ? string.substring(start, idx - 1) : builder.toString();
                nextIdx.value = idx;
                return PythonUtils.toTruffleStringUncached(result);
            }
            if (c == '\\') {
                if (builder == null) {
                    builder = new StringBuilder().append(string, start, idx - 1);
                }
                if (idx >= string.length()) {
                    throw JSONScannerBuiltins.decodeError(raisingNode, string, start - 1, ErrorMessages.UTERMINATED_STR_STARTING);
                }
                if ((c = string.charAt(idx++)) == 'u') {
                    if (idx + 3 >= string.length()) {
                        throw JSONScannerBuiltins.decodeError(raisingNode, string, idx - 1, ErrorMessages.INVALID_UXXXX_ESCAPE);
                    }
                    c = '\u0000';
                    for (int i = 0; i < 4; ++i) {
                        char d = string.charAt(idx++);
                        int digit = switch (d) {
                            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> d - 48;
                            case 'a', 'b', 'c', 'd', 'e', 'f' -> d - 97 + 10;
                            case 'A', 'B', 'C', 'D', 'E', 'F' -> d - 65 + 10;
                            default -> throw JSONScannerBuiltins.decodeError(raisingNode, string, idx - 1, ErrorMessages.INVALID_UXXXX_ESCAPE);
                        };
                        c = (char)((c << 4) + digit);
                    }
                } else {
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        default: {
                            throw JSONScannerBuiltins.decodeError(raisingNode, string, idx - 1, ErrorMessages.INVALID_ESCAPE);
                        }
                    }
                }
                builder.append(c);
                continue;
            }
            if (strict && c < ' ') {
                throw JSONScannerBuiltins.decodeError(raisingNode, string, idx - 1, ErrorMessages.INVALID_CTRL_CHARACTER_AT);
            }
            if (builder == null) continue;
            builder.append(c);
        }
        throw JSONScannerBuiltins.decodeError(raisingNode, string, start - 1, ErrorMessages.UNTERMINATED_STR_STARTING_AT);
    }

    private static RuntimeException decodeError(Node raisingNode, String jsonString, int pos, TruffleString format) {
        CompilerAsserts.neverPartOfCompilation();
        PythonModule module = AbstractImportNode.importModule(PythonUtils.toTruffleStringUncached("json.decoder"));
        Object errorClass = PyObjectLookupAttr.executeUncached(module, T_JSON_DECODE_ERROR);
        Object exception = CallNode.executeUncached(errorClass, format, PythonUtils.toTruffleStringUncached(jsonString), pos);
        throw PRaiseNode.raiseExceptionObjectStatic(raisingNode, exception, false);
    }

    private static RuntimeException stopIteration(Node raisingNode, Object value) {
        CompilerAsserts.neverPartOfCompilation();
        Object exception = CallNode.executeUncached((Object)PythonContext.get(raisingNode).lookupType(PythonBuiltinClassType.StopIteration), value);
        throw PRaiseNode.raiseExceptionObjectStatic(raisingNode, exception, false);
    }

    static final class IntRef {
        int value;

        IntRef() {
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(name="scan_once", minNumOfPositionalArgs=1, parameterNames={"$self", "string", "idx"})
    @ArgumentsClinic(value={@ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="idx", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CallScannerNode
    extends PythonTernaryClinicBuiltinNode {
        @Node.Child
        private CallUnaryMethodNode callParseFloat = CallUnaryMethodNode.create();
        @Node.Child
        private CallUnaryMethodNode callParseInt = CallUnaryMethodNode.create();
        @Node.Child
        private CallUnaryMethodNode callParseConstant = CallUnaryMethodNode.create();
        @Node.Child
        private CallUnaryMethodNode callObjectHook = CallUnaryMethodNode.create();
        @Node.Child
        private CallUnaryMethodNode callObjectPairsHook = CallUnaryMethodNode.create();

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONScannerBuiltinsClinicProviders.CallScannerNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        protected PTuple call(PJSONScanner self, TruffleString string, int idx, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            IntRef nextIdx = new IntRef();
            Object result = this.scanOnceUnicode(self, toJavaStringNode.execute((AbstractTruffleString)string), idx, nextIdx);
            return PFactory.createTuple(PythonLanguage.get(this), new Object[]{result, nextIdx.value});
        }

        @CompilerDirectives.TruffleBoundary
        private Object parseObjectUnicode(PJSONScanner scanner, String string, int start, IntRef nextIdx) {
            boolean hasPairsHook = scanner.objectPairsHook != PNone.NONE;
            PythonLanguage language = PythonLanguage.get(null);
            int idx = start;
            int length = string.length();
            ObjectSequenceStorage listStorage = null;
            EconomicMapStorage mapStorage = null;
            if (hasPairsHook) {
                listStorage = new ObjectSequenceStorage(4);
            } else {
                mapStorage = EconomicMapStorage.create();
            }
            idx = CallScannerNode.skipWhitespace(string, idx, length);
            if (idx >= length || string.charAt(idx) != '}') {
                while (true) {
                    if (idx >= length || string.charAt(idx) != '\"') {
                        throw JSONScannerBuiltins.decodeError(this, string, idx, ErrorMessages.EXPECTING_PROP_NAME_ECLOSED_IN_DBL_QUOTES);
                    }
                    TruffleString newKey = JSONScannerBuiltins.scanStringUnicode(string, idx + 1, scanner.strict, nextIdx, this);
                    TruffleString key = scanner.memo.putIfAbsent(newKey, newKey);
                    if (key == null) {
                        key = newKey;
                    }
                    idx = nextIdx.value;
                    if ((idx = CallScannerNode.skipWhitespace(string, idx, length)) >= length || string.charAt(idx) != ':') {
                        throw JSONScannerBuiltins.decodeError(this, string, idx, ErrorMessages.EXPECTING_COLON_DELIMITER);
                    }
                    idx = CallScannerNode.skipWhitespace(string, idx + 1, length);
                    Object val = this.scanOnceUnicode(scanner, string, idx, nextIdx);
                    idx = nextIdx.value;
                    if (hasPairsHook) {
                        listStorage.insertItem(listStorage.length(), PFactory.createTuple(language, new Object[]{key, val}));
                    } else {
                        HashingStorage newStorage = HashingStorageNodes.HashingStorageSetItem.executeUncached(mapStorage, key, val);
                        assert (newStorage == mapStorage);
                    }
                    idx = CallScannerNode.skipWhitespace(string, idx, length);
                    if (idx < length && string.charAt(idx) == '}') break;
                    if (idx >= length || string.charAt(idx) != ',') {
                        throw JSONScannerBuiltins.decodeError(this, string, idx, ErrorMessages.EXPECTING_COMMA_DELIMITER);
                    }
                    idx = CallScannerNode.skipWhitespace(string, idx + 1, length);
                }
            }
            nextIdx.value = idx + 1;
            if (hasPairsHook) {
                return this.callObjectPairsHook.executeObject(scanner.objectPairsHook, PFactory.createList(language, listStorage));
            }
            PDict rval = PFactory.createDict(language, mapStorage);
            if (scanner.objectHook != PNone.NONE) {
                return this.callObjectHook.executeObject(scanner.objectHook, rval);
            }
            return rval;
        }

        @CompilerDirectives.TruffleBoundary
        private Object parseArrayUnicode(PJSONScanner scanner, String string, int start, IntRef nextIdx) {
            int idx = start;
            ObjectSequenceStorage storage = new ObjectSequenceStorage(4);
            int length = string.length();
            if ((idx = CallScannerNode.skipWhitespace(string, idx, length)) >= length || string.charAt(idx) != ']') {
                while (true) {
                    Object val = this.scanOnceUnicode(scanner, string, idx, nextIdx);
                    storage.insertItem(storage.length(), val);
                    idx = nextIdx.value;
                    idx = CallScannerNode.skipWhitespace(string, idx, length);
                    if (idx < length && string.charAt(idx) == ']') break;
                    if (idx >= length || string.charAt(idx) != ',') {
                        throw JSONScannerBuiltins.decodeError(this, string, idx, ErrorMessages.EXPECTING_COMMA_DELIMITER);
                    }
                    ++idx;
                    idx = CallScannerNode.skipWhitespace(string, idx, length);
                }
            }
            if (idx >= length || string.charAt(idx) != ']') {
                throw JSONScannerBuiltins.decodeError(this, string, length - 1, ErrorMessages.EXPECTING_VALUE);
            }
            nextIdx.value = idx + 1;
            return PFactory.createList(PythonLanguage.get(null), storage);
        }

        private static int skipWhitespace(String string, int start, int length) {
            int idx;
            for (idx = start; idx < length && JSONModuleBuiltins.isWhitespace(string.charAt(idx)); ++idx) {
            }
            return idx;
        }

        private Object parseConstant(PJSONScanner scanner, String constant, int idx, IntRef nextIdx) {
            nextIdx.value = idx + constant.length();
            return this.callParseConstant.executeObject(scanner.parseConstant, PythonUtils.toTruffleStringUncached(constant));
        }

        @CompilerDirectives.TruffleBoundary
        private Object matchNumberUnicode(PJSONScanner scanner, String string, int start, IntRef nextIdx) {
            int idx = start;
            int length = string.length();
            if (string.charAt(idx) == '-' && ++idx >= length) {
                throw JSONScannerBuiltins.stopIteration(this, start);
            }
            if (string.charAt(idx) >= '1' && string.charAt(idx) <= '9') {
                ++idx;
                while (idx < length && string.charAt(idx) >= '0' && string.charAt(idx) <= '9') {
                    ++idx;
                }
            } else if (string.charAt(idx) == '0') {
                ++idx;
            } else {
                throw JSONScannerBuiltins.stopIteration(this, start);
            }
            boolean isFloat = false;
            if (idx < length - 1 && string.charAt(idx) == '.' && string.charAt(idx + 1) >= '0' && string.charAt(idx + 1) <= '9') {
                isFloat = true;
                idx += 2;
                while (idx < length && string.charAt(idx) >= '0' && string.charAt(idx) <= '9') {
                    ++idx;
                }
            }
            if (idx < length - 1 && (string.charAt(idx) == 'e' || string.charAt(idx) == 'E')) {
                int e_start = idx++;
                if (idx < length - 1 && (string.charAt(idx) == '-' || string.charAt(idx) == '+')) {
                    ++idx;
                }
                while (idx < length && string.charAt(idx) >= '0' && string.charAt(idx) <= '9') {
                    ++idx;
                }
                if (string.charAt(idx - 1) >= '0' && string.charAt(idx - 1) <= '9') {
                    isFloat = true;
                } else {
                    idx = e_start;
                }
            }
            nextIdx.value = idx;
            if (isFloat) {
                if (PyFloatCheckExactNode.executeUncached(scanner.parseFloat)) {
                    String numStr = string.substring(start, idx);
                    return FloatUtils.parseValidString(numStr);
                }
                TruffleString numStr = PythonUtils.toTruffleStringUncached(string.substring(start, idx));
                return this.callParseFloat.executeObject(scanner.parseFloat, numStr);
            }
            if (PyLongCheckExactNode.executeUncached(scanner.parseInt)) {
                TruffleString numStr = TruffleString.fromJavaStringUncached((String)string, (int)start, (int)(idx - start), (TruffleString.Encoding)PythonUtils.TS_ENCODING, (boolean)false);
                return PyLongFromUnicodeObject.executeUncached(numStr, 10);
            }
            TruffleString numStr = PythonUtils.toTruffleStringUncached(string.substring(start, idx));
            return this.callParseInt.executeObject(scanner.parseInt, numStr);
        }

        @CompilerDirectives.TruffleBoundary
        private Object scanOnceUnicode(PJSONScanner scanner, String string, int idx, IntRef nextIdx) {
            if (idx < 0) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.IDX_CANNOT_BE_NEG);
            }
            int length = string.length();
            if (idx >= length) {
                throw JSONScannerBuiltins.stopIteration(this, idx);
            }
            switch (string.charAt(idx)) {
                case '\"': {
                    return JSONScannerBuiltins.scanStringUnicode(string, idx + 1, scanner.strict, nextIdx, this);
                }
                case '{': {
                    return this.parseObjectUnicode(scanner, string, idx + 1, nextIdx);
                }
                case '[': {
                    return this.parseArrayUnicode(scanner, string, idx + 1, nextIdx);
                }
                case 'n': {
                    if (idx + 3 >= length || string.charAt(idx + 1) != 'u' || string.charAt(idx + 2) != 'l' || string.charAt(idx + 3) != 'l') break;
                    nextIdx.value = idx + 4;
                    return PNone.NONE;
                }
                case 't': {
                    if (idx + 3 >= length || string.charAt(idx + 1) != 'r' || string.charAt(idx + 2) != 'u' || string.charAt(idx + 3) != 'e') break;
                    nextIdx.value = idx + 4;
                    return true;
                }
                case 'f': {
                    if (idx + 4 >= length || string.charAt(idx + 1) != 'a' || string.charAt(idx + 2) != 'l' || string.charAt(idx + 3) != 's' || string.charAt(idx + 4) != 'e') break;
                    nextIdx.value = idx + 5;
                    return false;
                }
                case 'N': {
                    if (idx + 2 >= length || string.charAt(idx + 1) != 'a' || string.charAt(idx + 2) != 'N') break;
                    return this.parseConstant(scanner, "NaN", idx, nextIdx);
                }
                case 'I': {
                    if (idx + 7 >= length || string.charAt(idx + 1) != 'n' || string.charAt(idx + 2) != 'f' || string.charAt(idx + 3) != 'i' || string.charAt(idx + 4) != 'n' || string.charAt(idx + 5) != 'i' || string.charAt(idx + 6) != 't' || string.charAt(idx + 7) != 'y') break;
                    return this.parseConstant(scanner, "Infinity", idx, nextIdx);
                }
                case '-': {
                    if (idx + 8 >= length || string.charAt(idx + 1) != 'I' || string.charAt(idx + 2) != 'n' || string.charAt(idx + 3) != 'f' || string.charAt(idx + 4) != 'i' || string.charAt(idx + 5) != 'n' || string.charAt(idx + 6) != 'i' || string.charAt(idx + 7) != 't' || string.charAt(idx + 8) != 'y') break;
                    return this.parseConstant(scanner, "-Infinity", idx, nextIdx);
                }
            }
            return this.matchNumberUnicode(scanner, string, idx, nextIdx);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="make_scanner", parameterNames={"$cls", "context"})
    @GenerateNodeFactory
    public static abstract class MakeScanner
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getStrict = GetAttributeNode.GetFixedAttributeNode.create(StringLiterals.T_STRICT);
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getObjectHook = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("object_hook"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getObjectPairsHook = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("object_pairs_hook"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getParseFloat = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("parse_float"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getParseInt = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("parse_int"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getParseConstant = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("parse_constant"));

        @Specialization
        public PJSONScanner doNew(VirtualFrame frame, Object cls, Object context, @Cached PyObjectIsTrueNode castStrict, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            boolean strict = castStrict.execute((Frame)frame, this.getStrict.execute(frame, context));
            Object objectHook = this.getObjectHook.execute(frame, context);
            Object objectPairsHook = this.getObjectPairsHook.execute(frame, context);
            Object parseFloat = this.getParseFloat.execute(frame, context);
            Object parseInt = this.getParseInt.execute(frame, context);
            Object parseConstant = this.getParseConstant.execute(frame, context);
            return PFactory.createJSONScanner(language, cls, getInstanceShape.execute(cls), strict, objectHook, objectPairsHook, parseFloat, parseInt, parseConstant);
        }
    }
}

