/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class PythonNativeWrapper
implements TruffleObject {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PythonNativeWrapper.class);
    private static final long UNINITIALIZED = -1L;
    private final boolean replacing;
    private Object delegate;
    private long nativePointer = -1L;
    protected Object replacement;
    public CApiTransitions.PythonObjectReference ref;

    private PythonNativeWrapper() {
        this.replacing = false;
    }

    private PythonNativeWrapper(Object delegate, boolean replacing) {
        this.replacing = replacing;
        this.delegate = delegate;
    }

    public final Object getDelegate() {
        return this.delegate;
    }

    protected final void setDelegate(Object delegate) {
        assert (this.delegate == null || this.delegate == delegate);
        this.delegate = delegate;
    }

    public final long getNativePointer() {
        return this.nativePointer;
    }

    public final void setNativePointer(long nativePointer) {
        assert (this.nativePointer == -1L || this.nativePointer == nativePointer || nativePointer == -1L);
        this.nativePointer = nativePointer;
    }

    public final boolean isNative(Node inliningTarget, InlinedConditionProfile hasNativePointerProfile) {
        return hasNativePointerProfile.profile(inliningTarget, this.nativePointer != -1L);
    }

    public final boolean isNative() {
        return this.nativePointer != -1L;
    }

    public final boolean isReplacingWrapper() {
        return this.replacing;
    }

    public final void setReplacement(Object replacement) {
        this.replacement = replacement;
    }

    public Object getReplacement(InteropLibrary lib) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public final Object registerReplacement(Object pointer, boolean freeAtCollection, InteropLibrary lib) {
        Object result;
        LOGGER.finest(() -> PythonUtils.formatJString("assigning %s with %s", this.getDelegate(), pointer));
        if (pointer instanceof Long) {
            Long lptr = (Long)pointer;
            result = CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_CONVERT_POINTER, lptr);
            CApiTransitions.createReference(this, lptr, freeAtCollection);
        } else {
            result = pointer;
            if (lib.isPointer(pointer)) {
                assert (CApiContext.isPointerObject(pointer));
                try {
                    CApiTransitions.createReference(this, lib.asPointer(pointer), freeAtCollection);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            } else {
                assert (pointer.getClass().getSimpleName().contains("LLVMPointer"));
                CApiTransitions.createManagedReference(this.getDelegate(), pointer);
            }
        }
        return result;
    }

    public static abstract class PythonStructNativeWrapper
    extends PythonNativeWrapper {
        protected PythonStructNativeWrapper() {
        }

        protected PythonStructNativeWrapper(Object delegate) {
            super(delegate, false);
        }

        protected PythonStructNativeWrapper(Object delegate, boolean replacing) {
            super(delegate, replacing);
        }
    }

    public static abstract class PythonAbstractObjectNativeWrapper
    extends PythonNativeWrapper {
        public static final long MANAGED_REFCNT = 10L;
        public static final long IMMORTAL_REFCNT = 0xFFFFFFFFL;

        protected PythonAbstractObjectNativeWrapper() {
        }

        protected PythonAbstractObjectNativeWrapper(Object delegate) {
            super(delegate, false);
        }

        protected PythonAbstractObjectNativeWrapper(Object delegate, boolean replacing) {
            super(delegate, replacing);
        }

        public final long getRefCount() {
            if (this.isNative()) {
                return CApiTransitions.readNativeRefCount(CApiTransitions.HandlePointerConverter.pointerToStub(this.getNativePointer()));
            }
            return 10L;
        }

        public long incRef() {
            assert (this.isNative());
            long pointer = CApiTransitions.HandlePointerConverter.pointerToStub(this.getNativePointer());
            long refCount = CApiTransitions.readNativeRefCount(pointer);
            assert (refCount >= 10L) : "invalid refcnt " + refCount + " during incRef in " + Long.toHexString(this.getNativePointer());
            if (refCount != 0xFFFFFFFFL) {
                CApiTransitions.writeNativeRefCount(pointer, refCount + 1L);
                return refCount + 1L;
            }
            return 0xFFFFFFFFL;
        }

        public long decRef() {
            assert (this.isNative());
            long pointer = CApiTransitions.HandlePointerConverter.pointerToStub(this.getNativePointer());
            long refCount = CApiTransitions.readNativeRefCount(pointer);
            if (refCount != 0xFFFFFFFFL) {
                long updatedRefCount = refCount - 1L;
                CApiTransitions.writeNativeRefCount(pointer, updatedRefCount);
                assert (updatedRefCount >= 10L) : "invalid refcnt " + updatedRefCount + " during decRef in " + Long.toHexString(this.getNativePointer());
                return updatedRefCount;
            }
            return refCount;
        }
    }
}

