/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ArrayModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ArrayModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.array.ArrayBuiltins;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.List;

@CoreFunctions(defineModule="array")
public final class ArrayModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ArrayModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule arrayModule = core.lookupBuiltinModule(BuiltinNames.T_ARRAY);
        arrayModule.setAttribute(PythonUtils.tsLiteral("ArrayType"), core.lookupType(PythonBuiltinClassType.PArray));
        arrayModule.setAttribute(PythonUtils.tsLiteral("typecodes"), PythonUtils.tsLiteral("bBuhHiIlLqQfd"));
    }

    @Builtin(name="_array_reconstructor", minNumOfPositionalArgs=4, numOfPositionalOnlyArgs=4, parameterNames={"arrayType", "typeCode", "mformatCode", "items"})
    @ArgumentsClinic(value={@ArgumentClinic(name="typeCode", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="mformatCode", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    static abstract class ArrayReconstructorNode
    extends PythonClinicBuiltinNode {
        ArrayReconstructorNode() {
        }

        @Specialization(guards={"mformatCode == cachedCode"}, limit="3")
        static Object reconstructCached(VirtualFrame frame, Object arrayType, TruffleString typeCode, int mformatCode, PBytes bytes, @Bind Node inliningTarget, @Cached(value="mformatCode") int cachedCode, @Cached(value="createIdentityProfile()", inline=false) ValueProfile formatProfile, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callDecode, @Cached.Exclusive @Cached ArrayBuiltins.FromBytesNode fromBytesNode, @Cached.Exclusive @Cached ArrayBuiltins.FromUnicodeNode fromUnicodeNode, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached ArrayBuiltins.ByteSwapNode byteSwapNode, @Cached.Exclusive @Cached TruffleString.CodePointLengthNode lengthNode, @Cached.Exclusive @Cached TruffleString.CodePointAtIndexNode atIndexNode, @Cached.Exclusive @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            BufferFormat format = BufferFormat.forArray(typeCode, lengthNode, atIndexNode);
            if (format == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.BAD_TYPECODE);
            }
            return ArrayReconstructorNode.doReconstruct(frame, inliningTarget, arrayType, typeCode, cachedCode, bytes, callDecode, fromBytesNode, fromUnicodeNode, isTypeNode, isSubtypeNode, byteSwapNode, (BufferFormat)((Object)formatProfile.profile((Object)format)), getInstanceShape, raiseNode);
        }

        @Specialization(replaces={"reconstructCached"})
        static Object reconstruct(VirtualFrame frame, Object arrayType, TruffleString typeCode, int mformatCode, PBytes bytes, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callDecode, @Cached.Exclusive @Cached ArrayBuiltins.FromBytesNode fromBytesNode, @Cached.Exclusive @Cached ArrayBuiltins.FromUnicodeNode fromUnicodeNode, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached ArrayBuiltins.ByteSwapNode byteSwapNode, @Cached.Exclusive @Cached TruffleString.CodePointLengthNode lengthNode, @Cached.Exclusive @Cached TruffleString.CodePointAtIndexNode atIndexNode, @Cached.Exclusive @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            BufferFormat format = BufferFormat.forArray(typeCode, lengthNode, atIndexNode);
            if (format == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.BAD_TYPECODE);
            }
            return ArrayReconstructorNode.doReconstruct(frame, inliningTarget, arrayType, typeCode, mformatCode, bytes, callDecode, fromBytesNode, fromUnicodeNode, isTypeNode, isSubtypeNode, byteSwapNode, format, getInstanceShape, raiseNode);
        }

        private static Object doReconstruct(VirtualFrame frame, Node inliningTarget, Object arrayType, TruffleString typeCode, int mformatCode, PBytes bytes, PyObjectCallMethodObjArgs callDecode, ArrayBuiltins.FromBytesNode fromBytesNode, ArrayBuiltins.FromUnicodeNode fromUnicodeNode, TypeNodes.IsTypeNode isTypeNode, IsSubtypeNode isSubtypeNode, ArrayBuiltins.ByteSwapNode byteSwapNode, BufferFormat format, TypeNodes.GetInstanceShape getInstanceShape, PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, arrayType)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.FIRST_ARGUMENT_MUST_BE_A_TYPE_OBJECT_NOT_P, arrayType);
            }
            if (!isSubtypeNode.execute(arrayType, (Object)PythonBuiltinClassType.PArray)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.N_NOT_SUBTYPE_OF_ARRAY, arrayType);
            }
            PArray.MachineFormat machineFormat = PArray.MachineFormat.fromCode(mformatCode);
            if (machineFormat != null) {
                PArray array;
                if (machineFormat == PArray.MachineFormat.forFormat(format)) {
                    array = PFactory.createArray(PythonLanguage.get(inliningTarget), arrayType, getInstanceShape.execute(arrayType), typeCode, machineFormat.format);
                    fromBytesNode.executeWithoutClinic(frame, array, bytes);
                } else {
                    TruffleString newTypeCode = machineFormat.format == format ? typeCode : machineFormat.format.baseTypeCode;
                    array = PFactory.createArray(PythonLanguage.get(inliningTarget), arrayType, getInstanceShape.execute(arrayType), newTypeCode, machineFormat.format);
                    if (machineFormat.unicodeEncoding != null) {
                        Object decoded = callDecode.execute((Frame)frame, inliningTarget, bytes, SpecialMethodNames.T_DECODE, machineFormat.unicodeEncoding);
                        fromUnicodeNode.execute(frame, array, decoded);
                    } else {
                        fromBytesNode.executeWithoutClinic(frame, array, bytes);
                        if (machineFormat.order != ByteOrder.nativeOrder()) {
                            byteSwapNode.execute(frame, array);
                        }
                    }
                }
                return array;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.THIRD_ARG_MUST_BE_A_VALID_MACHINE_CODE_FMT);
        }

        @Specialization(guards={"!isPBytes(value)"})
        static Object error(Object arrayType, TruffleString typeCode, int mformatCode, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.FOURTH_ARG_SHOULD_BE_BYTES, value);
        }

        protected static boolean isPBytes(Object obj) {
            return obj instanceof PBytes;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayModuleBuiltinsClinicProviders.ArrayReconstructorNodeClinicProviderGen.INSTANCE;
        }
    }
}

