/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.transport.controller.MLDeployControllerNodeRequest;
import org.opensearch.ml.common.transport.controller.MLDeployControllerNodeResponse;
import org.opensearch.ml.common.transport.controller.MLDeployControllerNodesRequest;
import org.opensearch.ml.common.transport.controller.MLDeployControllerNodesResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeployControllerTransportAction
extends TransportNodesAction<MLDeployControllerNodesRequest, MLDeployControllerNodesResponse, MLDeployControllerNodeRequest, MLDeployControllerNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeployControllerTransportAction.class);
    private final MLModelManager mlModelManager;
    private final ClusterService clusterService;
    private final Client client;
    private DiscoveryNodeHelper nodeFilter;
    private final MLStats mlStats;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public DeployControllerTransportAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, ClusterService clusterService, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLStats mlStats, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/controllers/deploy", threadPool, clusterService, transportService, actionFilters, MLDeployControllerNodesRequest::new, MLDeployControllerNodeRequest::new, "management", MLDeployControllerNodeResponse.class);
        this.mlModelManager = mlModelManager;
        this.clusterService = clusterService;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlStats = mlStats;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected MLDeployControllerNodesResponse newResponse(MLDeployControllerNodesRequest request, List<MLDeployControllerNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLDeployControllerNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLDeployControllerNodeRequest newNodeRequest(MLDeployControllerNodesRequest request) {
        return new MLDeployControllerNodeRequest(request);
    }

    protected MLDeployControllerNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLDeployControllerNodeResponse(in);
    }

    protected MLDeployControllerNodeResponse nodeOperation(MLDeployControllerNodeRequest request) {
        return this.createDeployControllerNodeResponse(request.getDeployControllerNodesRequest());
    }

    private MLDeployControllerNodeResponse createDeployControllerNodeResponse(MLDeployControllerNodesRequest deployControllerNodesRequest) {
        String modelId = deployControllerNodesRequest.getModelId();
        HashMap<String, String> controllerDeployStatus = new HashMap<String, String>();
        controllerDeployStatus.put(modelId, "received");
        String localNodeId = this.clusterService.localNode().getId();
        this.mlModelManager.deployControllerWithDeployedModel(modelId, (ActionListener<String>)ActionListener.wrap(r -> log.info("Successfully deployed model controller on node {}", (Object)localNodeId), e -> log.error("Failed to deploy model controller on node {}", (Object)localNodeId, e)));
        return new MLDeployControllerNodeResponse(this.clusterService.localNode(), controllerDeployStatus);
    }
}

