/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.allocation_explain.AllocationDecision;
import org.opensearch.client.opensearch.cluster.allocation_explain.AllocationStore;
import org.opensearch.client.opensearch.cluster.allocation_explain.Decision;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeAllocationExplanation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeAllocationExplanation> {
    @Nonnull
    private final List<AllocationDecision> deciders;
    @Nonnull
    private final Map<String, String> nodeAttributes;
    @Nonnull
    private final Decision nodeDecision;
    @Nonnull
    private final String nodeId;
    @Nonnull
    private final String nodeName;
    @Nullable
    private final AllocationStore store;
    @Nonnull
    private final String transportAddress;
    @Nullable
    private final Integer weightRanking;
    public static final JsonpDeserializer<NodeAllocationExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAllocationExplanation::setupNodeAllocationExplanationDeserializer);

    private NodeAllocationExplanation(Builder builder) {
        this.deciders = ApiTypeHelper.unmodifiableRequired(builder.deciders, (Object)this, "deciders");
        this.nodeAttributes = ApiTypeHelper.unmodifiableRequired(builder.nodeAttributes, (Object)this, "nodeAttributes");
        this.nodeDecision = ApiTypeHelper.requireNonNull(builder.nodeDecision, this, "nodeDecision");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.nodeName = ApiTypeHelper.requireNonNull(builder.nodeName, this, "nodeName");
        this.store = builder.store;
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.weightRanking = builder.weightRanking;
    }

    public static NodeAllocationExplanation of(Function<Builder, ObjectBuilder<NodeAllocationExplanation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<AllocationDecision> deciders() {
        return this.deciders;
    }

    @Nonnull
    public final Map<String, String> nodeAttributes() {
        return this.nodeAttributes;
    }

    @Nonnull
    public final Decision nodeDecision() {
        return this.nodeDecision;
    }

    @Nonnull
    public final String nodeId() {
        return this.nodeId;
    }

    @Nonnull
    public final String nodeName() {
        return this.nodeName;
    }

    @Nullable
    public final AllocationStore store() {
        return this.store;
    }

    @Nonnull
    public final String transportAddress() {
        return this.transportAddress;
    }

    @Nullable
    public final Integer weightRanking() {
        return this.weightRanking;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("deciders");
        generator.writeStartArray();
        for (AllocationDecision allocationDecision : this.deciders) {
            allocationDecision.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("node_attributes");
        generator.writeStartObject();
        for (Map.Entry entry : this.nodeAttributes.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("node_decision");
        this.nodeDecision.serialize(generator, mapper);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        if (this.store != null) {
            generator.writeKey("store");
            this.store.serialize(generator, mapper);
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        if (this.weightRanking != null) {
            generator.writeKey("weight_ranking");
            generator.write(this.weightRanking.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeAllocationExplanationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deciders, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "deciders");
        op.add(Builder::nodeAttributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "node_attributes");
        op.add(Builder::nodeDecision, Decision._DESERIALIZER, "node_decision");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name");
        op.add(Builder::store, AllocationStore._DESERIALIZER, "store");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::weightRanking, JsonpDeserializer.integerDeserializer(), "weight_ranking");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.deciders.hashCode();
        result = 31 * result + this.nodeAttributes.hashCode();
        result = 31 * result + this.nodeDecision.hashCode();
        result = 31 * result + this.nodeId.hashCode();
        result = 31 * result + this.nodeName.hashCode();
        result = 31 * result + Objects.hashCode(this.store);
        result = 31 * result + this.transportAddress.hashCode();
        result = 31 * result + Objects.hashCode(this.weightRanking);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeAllocationExplanation other = (NodeAllocationExplanation)o;
        return this.deciders.equals(other.deciders) && this.nodeAttributes.equals(other.nodeAttributes) && this.nodeDecision.equals(other.nodeDecision) && this.nodeId.equals(other.nodeId) && this.nodeName.equals(other.nodeName) && Objects.equals(this.store, other.store) && this.transportAddress.equals(other.transportAddress) && Objects.equals(this.weightRanking, other.weightRanking);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeAllocationExplanation> {
        private List<AllocationDecision> deciders;
        private Map<String, String> nodeAttributes;
        private Decision nodeDecision;
        private String nodeId;
        private String nodeName;
        @Nullable
        private AllocationStore store;
        private String transportAddress;
        @Nullable
        private Integer weightRanking;

        public Builder() {
        }

        private Builder(NodeAllocationExplanation o) {
            this.deciders = Builder._listCopy(o.deciders);
            this.nodeAttributes = Builder._mapCopy(o.nodeAttributes);
            this.nodeDecision = o.nodeDecision;
            this.nodeId = o.nodeId;
            this.nodeName = o.nodeName;
            this.store = o.store;
            this.transportAddress = o.transportAddress;
            this.weightRanking = o.weightRanking;
        }

        private Builder(Builder o) {
            this.deciders = Builder._listCopy(o.deciders);
            this.nodeAttributes = Builder._mapCopy(o.nodeAttributes);
            this.nodeDecision = o.nodeDecision;
            this.nodeId = o.nodeId;
            this.nodeName = o.nodeName;
            this.store = o.store;
            this.transportAddress = o.transportAddress;
            this.weightRanking = o.weightRanking;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder deciders(List<AllocationDecision> list) {
            this.deciders = Builder._listAddAll(this.deciders, list);
            return this;
        }

        @Nonnull
        public final Builder deciders(AllocationDecision value, AllocationDecision ... values) {
            this.deciders = Builder._listAdd(this.deciders, value, values);
            return this;
        }

        @Nonnull
        public final Builder deciders(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.deciders(fn.apply(new AllocationDecision.Builder()).build(), new AllocationDecision[0]);
        }

        @Nonnull
        public final Builder nodeAttributes(Map<String, String> map) {
            this.nodeAttributes = Builder._mapPutAll(this.nodeAttributes, map);
            return this;
        }

        @Nonnull
        public final Builder nodeAttributes(String key, String value) {
            this.nodeAttributes = Builder._mapPut(this.nodeAttributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodeDecision(Decision value) {
            this.nodeDecision = value;
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Nonnull
        public final Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        @Nonnull
        public final Builder store(@Nullable AllocationStore value) {
            this.store = value;
            return this;
        }

        @Nonnull
        public final Builder store(Function<AllocationStore.Builder, ObjectBuilder<AllocationStore>> fn) {
            return this.store(fn.apply(new AllocationStore.Builder()).build());
        }

        @Nonnull
        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Nonnull
        public final Builder weightRanking(@Nullable Integer value) {
            this.weightRanking = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeAllocationExplanation build() {
            this._checkSingleUse();
            return new NodeAllocationExplanation(this);
        }
    }
}

