/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.sessions.StickySessionEncoderProviderFactory;

public class RemoteStickySessionEncoderProviderFactory
implements StickySessionEncoderProviderFactory,
EnvironmentDependentProviderFactory,
StickySessionEncoderProvider {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final char SEPARATOR = '.';
    private volatile boolean shouldAttachRoute;
    private volatile String route;

    public StickySessionEncoderProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
        this.setShouldAttachRoute(config.getBoolean("shouldAttachRoute", Boolean.valueOf(true)));
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.route = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getNodeInfo().nodeName();
        }
    }

    public void close() {
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("shouldAttachRoute").type("boolean").helpText("If the route should be attached to cookies to reflect the node that owns a particular session.").defaultValue((Object)true).add().build();
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class);
    }

    public void setShouldAttachRoute(boolean shouldAttachRoute) {
        this.shouldAttachRoute = shouldAttachRoute;
        log.debugf("Should attach route to the sticky session cookie: %b", (Object)shouldAttachRoute);
    }

    public String encodeSessionId(String message, String ignored) {
        Objects.requireNonNull(message);
        return this.shouldAttachRoute ? message + "." + this.route : message;
    }

    public StickySessionEncoderProvider.SessionIdAndRoute decodeSessionIdAndRoute(String encodedSessionId) {
        int index = encodedSessionId.indexOf(46);
        if (index == -1) {
            return new StickySessionEncoderProvider.SessionIdAndRoute(encodedSessionId, null);
        }
        return new StickySessionEncoderProvider.SessionIdAndRoute(encodedSessionId.substring(0, index), encodedSessionId.substring(index, encodedSessionId.length() - 1));
    }

    public boolean shouldAttachRoute() {
        return this.shouldAttachRoute;
    }

    public String sessionIdRoute(String ignored) {
        return this.shouldAttachRoute ? this.route : null;
    }
}

