/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.x509.Rfc9440ClientCertificateLookup;
import org.keycloak.services.x509.X509ClientCertificateLookup;
import org.keycloak.services.x509.X509ClientCertificateLookupFactory;

public class Rfc9440ClientCertificateLookupFactory
implements X509ClientCertificateLookupFactory {
    private static final Logger logger = Logger.getLogger(Rfc9440ClientCertificateLookupFactory.class);
    private static final String PROVIDER = "rfc9440";
    protected static final String HTTP_HEADER_CLIENT_CERT = "sslClientCert";
    protected static final String HTTP_HEADER_CLIENT_CERT_DEFAULT = "Client-Cert";
    protected static final String HTTP_HEADER_CERT_CHAIN = "sslCertChain";
    protected static final String HTTP_HEADER_CERT_CHAIN_DEFAULT = "Client-Cert-Chain";
    protected static final String HTTP_HEADER_CERT_CHAIN_LENGTH = "certificateChainLength";
    protected static final int HTTP_HEADER_CERT_CHAIN_LENGTH_DEFAULT = 1;
    protected String sslClientCertHttpHeader;
    protected String sslChainHttpHeader;
    protected int certificateChainLength;

    public void init(Config.Scope config) {
        this.certificateChainLength = config.getInt(HTTP_HEADER_CERT_CHAIN_LENGTH, Integer.valueOf(1));
        this.sslClientCertHttpHeader = config.get(HTTP_HEADER_CLIENT_CERT, HTTP_HEADER_CLIENT_CERT_DEFAULT);
        this.sslChainHttpHeader = config.get(HTTP_HEADER_CERT_CHAIN, HTTP_HEADER_CERT_CHAIN_DEFAULT);
        logger.tracev("{0}:   ''{1}''", (Object)HTTP_HEADER_CLIENT_CERT, (Object)this.sslClientCertHttpHeader);
        logger.tracev("{0}:   ''{1}''", (Object)HTTP_HEADER_CERT_CHAIN, (Object)this.sslChainHttpHeader);
        logger.tracev("{0}:   ''{1}''", (Object)HTTP_HEADER_CERT_CHAIN_LENGTH, (Object)this.certificateChainLength);
    }

    public X509ClientCertificateLookup create(KeycloakSession session) {
        return new Rfc9440ClientCertificateLookup(this.sslClientCertHttpHeader, this.sslChainHttpHeader, this.certificateChainLength);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER;
    }
}

