/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.context;

import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.context.AbstractDynamicClientCRUDContext;
import org.keycloak.services.clientregistration.ClientRegistrationContext;

public class DynamicClientUpdateContext
extends AbstractDynamicClientCRUDContext {
    private final ClientModel clientToBeUpdated;
    private final ClientRepresentation proposedClientRepresentation;

    public DynamicClientUpdateContext(ClientRegistrationContext context, ClientModel proposedClientRepresentation, JsonWebToken token, RealmModel realm) {
        super(context.getSession(), token, realm);
        this.clientToBeUpdated = proposedClientRepresentation;
        this.proposedClientRepresentation = context.getClient();
    }

    public ClientPolicyEvent getEvent() {
        return ClientPolicyEvent.UPDATE;
    }

    @Override
    public ClientRepresentation getProposedClientRepresentation() {
        return this.proposedClientRepresentation;
    }

    @Override
    public ClientModel getTargetClient() {
        return this.clientToBeUpdated;
    }
}

