/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.opentelemetry.runtime;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeterRegistry;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

@Recorder
public class MicrometerOtelBridgeRecorder {
    public Function<SyntheticCreationalContext<MeterRegistry>, MeterRegistry> createBridge() {
        return new Function<SyntheticCreationalContext<MeterRegistry>, MeterRegistry>(){

            @Override
            public MeterRegistry apply(SyntheticCreationalContext<MeterRegistry> context) {
                Instance openTelemetry = (Instance)context.getInjectedReference((TypeLiteral)new TypeLiteral<Instance<OpenTelemetry>>(){}, new Annotation[0]);
                if (openTelemetry.isUnsatisfied()) {
                    throw new IllegalStateException("OpenTelemetry instance not found");
                }
                MeterRegistry meterRegistry = OpenTelemetryMeterRegistry.builder((OpenTelemetry)((OpenTelemetry)openTelemetry.get())).setPrometheusMode(false).setMicrometerHistogramGaugesEnabled(true).setBaseTimeUnit(TimeUnit.MILLISECONDS).setClock(Clock.SYSTEM).build();
                Metrics.addRegistry((MeterRegistry)meterRegistry);
                return meterRegistry;
            }
        };
    }
}

