/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.PanacheConstants;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.common.deployment.visitors.KotlinPanacheClassOperationGenerationVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheRepositoryClassOperationGenerationVisitor
extends ClassVisitor {
    public static final ByteCodeType CLASS = new ByteCodeType(Class.class);
    protected org.objectweb.asm.Type entityType;
    protected String entitySignature;
    protected String daoBinaryName;
    protected ClassInfo daoClassInfo;
    protected ClassInfo panacheRepositoryBaseClassInfo;
    protected IndexView indexView;
    protected Map<String, ByteCodeType> typeArguments = new HashMap<String, ByteCodeType>();
    protected Set<String> userMethods = new HashSet<String>();
    private final TypeBundle typeBundle;
    protected Function<String, Type> argMapper;
    protected ByteCodeType entityUpperBound;
    private final Map<String, String> erasures = new HashMap<String, String>();

    public PanacheRepositoryClassOperationGenerationVisitor(String className, ClassVisitor outputClassVisitor, IndexView indexView, TypeBundle typeBundle) {
        super(589824, outputClassVisitor);
        this.typeBundle = typeBundle;
        this.daoClassInfo = indexView.getClassByName(DotName.createSimple((String)className));
        this.daoBinaryName = className.replace('.', '/');
        this.indexView = indexView;
    }

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.entityType);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        DotName baseType = this.typeBundle.repositoryBase().dotName();
        List typeVariables = this.indexView.getClassByName(baseType).typeParameters();
        this.entityUpperBound = !typeVariables.isEmpty() ? new ByteCodeType((Type)((TypeVariable)typeVariables.get(0)).bounds().get(0)) : KotlinPanacheClassOperationGenerationVisitor.OBJECT;
        this.discoverTypeParameters(this.daoClassInfo, this.indexView, this.typeBundle, this.typeBundle.repositoryBase());
        this.entityType = this.typeArguments.getOrDefault("Entity", KotlinPanacheClassOperationGenerationVisitor.OBJECT).type();
        this.panacheRepositoryBaseClassInfo = this.indexView.getClassByName(baseType);
        this.argMapper = type -> {
            ByteCodeType byteCodeType = this.typeArguments.get(type);
            return byteCodeType != null ? byteCodeType.get() : null;
        };
    }

    protected void discoverTypeParameters(ClassInfo classInfo, IndexView indexView, TypeBundle types, ByteCodeType baseType) {
        List<ByteCodeType> foundTypeArguments = KotlinPanacheClassOperationGenerationVisitor.recursivelyFindEntityTypeArguments(indexView, classInfo.name(), baseType.dotName());
        ByteCodeType entityType = foundTypeArguments.size() > 0 ? foundTypeArguments.get(0) : KotlinPanacheClassOperationGenerationVisitor.OBJECT;
        ByteCodeType idType = foundTypeArguments.size() > 1 ? foundTypeArguments.get(1) : KotlinPanacheClassOperationGenerationVisitor.OBJECT;
        this.typeArguments.put("Entity", entityType);
        this.typeArguments.put("Id", idType);
        this.typeArguments.keySet().stream().filter(k -> !k.equals("Id")).forEach(k -> this.erasures.put((String)k, KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor()));
        try {
            ByteCodeType entity = this.typeArguments.get("Entity");
            this.erasures.put(entity.dotName().toString(), this.entityUpperBound.descriptor());
            this.erasures.put(types.queryType().dotName().toString(), KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor());
            this.erasures.put(types.updateType().dotName().toString(), KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this.userMethods.add(methodName + "/" + descriptor);
        return super.visitMethod(access, methodName, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        for (MethodInfo method : this.panacheRepositoryBaseClassInfo.methods()) {
            AnnotationInstance bridge;
            String descriptor = method.descriptor(type -> this.typeArguments.getOrDefault(type, KotlinPanacheClassOperationGenerationVisitor.OBJECT).get());
            if (this.userMethods.contains(method.name() + "/" + descriptor) || (bridge = method.annotation(PanacheConstants.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            this.generateModelBridge(method, bridge);
            if (!this.needsJvmBridge(method)) continue;
            this.generateJvmBridge(method);
        }
        super.visitEnd();
    }

    private boolean needsJvmBridge(MethodInfo method) {
        if (this.needsJvmBridge(method.returnType())) {
            return true;
        }
        for (Type paramType : method.parameterTypes()) {
            if (!this.needsJvmBridge(paramType)) continue;
            return true;
        }
        return false;
    }

    private boolean needsJvmBridge(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            String typeParamName = type.asTypeVariable().identifier();
            return this.typeArguments.containsKey(typeParamName);
        }
        return false;
    }

    protected void generateJvmBridge(MethodInfo method) {
        String descriptor = method.descriptor();
        if (!this.userMethods.contains(method.name() + "/" + descriptor)) {
            MethodVisitor mv = super.visitMethod(4161, method.name(), descriptor, null, null);
            List parameters = method.parameterTypes();
            AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            for (int i = 0; i < parameters.size(); ++i) {
                Type paramType = (Type)parameters.get(i);
                if (paramType.kind() == Type.Kind.PRIMITIVE) {
                    throw new IllegalStateException("BUG: Don't know how to generate JVM bridge method for " + String.valueOf(method) + ": has primitive parameters");
                }
                mv.visitIntInsn(25, i + 1);
                if (paramType.kind() != Type.Kind.TYPE_VARIABLE) continue;
                String typeParamName = paramType.asTypeVariable().identifier();
                org.objectweb.asm.Type type = this.typeArguments.get(typeParamName).type();
                if (type.getSort() > 8) {
                    mv.visitTypeInsn(192, type.getInternalName());
                    continue;
                }
                AsmUtil.unboxIfRequired((MethodVisitor)mv, (org.objectweb.asm.Type)type);
            }
            String targetDescriptor = method.descriptor(this.argMapper);
            mv.visitMethodInsn(182, this.daoBinaryName, method.name(), targetDescriptor, false);
            String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
            mv.visitInsn(AsmUtil.getReturnInstruction((String)targetReturnTypeDescriptor));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected void generateModelBridge(MethodInfo method, AnnotationInstance bridge) {
        List parameters = method.parameterTypes();
        MethodVisitor mv = super.visitMethod(1, method.name(), method.descriptor(this.argMapper), method.genericSignature(this.argMapper), null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        this.loadOperations(mv);
        boolean ignoreEntityTypeParam = this.isIgnoreEntityTypeParam(bridge);
        this.loadArguments(parameters, mv, ignoreEntityTypeParam);
        this.invokeOperations(mv, method, ignoreEntityTypeParam);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private boolean isIgnoreEntityTypeParam(AnnotationInstance bridge) {
        AnnotationValue ignoreEntityTypeParam = bridge.value("ignoreEntityTypeParam");
        if (ignoreEntityTypeParam == null) {
            return false;
        }
        return ignoreEntityTypeParam.asBoolean();
    }

    private void invokeOperations(MethodVisitor mv, MethodInfo method, boolean ignoreEntityTypeParam) {
        StringJoiner joiner = new StringJoiner("", "(", ")");
        if (!ignoreEntityTypeParam) {
            joiner.add(CLASS.descriptor());
        }
        this.descriptors(method, joiner);
        Type returnType = method.returnType();
        String descriptor = returnType.descriptor(this.argMapper);
        String key = returnType.kind() == Type.Kind.TYPE_VARIABLE ? returnType.asTypeVariable().identifier() : returnType.name().toString();
        String operationDescriptor = String.valueOf(joiner) + this.erasures.getOrDefault(key, descriptor);
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (returnType.kind() != Type.Kind.PRIMITIVE) {
            String cast;
            if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
                ByteCodeType type = this.typeArguments.getOrDefault(returnType.asTypeVariable().identifier(), this.entityUpperBound);
                cast = type.internalName();
            } else {
                cast = returnType.name().toString().replace('.', '/');
            }
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
    }

    private void descriptors(MethodInfo method, StringJoiner joiner) {
        for (Type parameter : method.parameterTypes()) {
            if (parameter.kind() == Type.Kind.TYPE_VARIABLE || method.name().endsWith("ById") && parameter.name().equals((Object)this.typeArguments.get("Id").dotName())) {
                joiner.add(KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor());
                continue;
            }
            joiner.add(this.mapType(parameter));
        }
    }

    private String mapType(Type parameter) {
        return switch (parameter.kind()) {
            case Type.Kind.PRIMITIVE, Type.Kind.TYPE_VARIABLE -> KotlinPanacheClassOperationGenerationVisitor.OBJECT.descriptor();
            default -> {
                String value = parameter.descriptor(this.argMapper);
                yield this.erasures.getOrDefault(value, value);
            }
        };
    }

    private void loadArguments(List<Type> parameters, MethodVisitor mv, boolean ignoreEntityTypeParam) {
        if (!ignoreEntityTypeParam) {
            this.injectModel(mv);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i + 1);
        }
    }

    private void loadOperations(MethodVisitor mv) {
        mv.visitFieldInsn(178, this.typeBundle.operations().internalName(), "INSTANCE", this.typeBundle.operations().descriptor());
    }
}

