/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.provider.ProviderEvent;

public enum ResourceOperationType {
    USER_ADD(OperationType.CREATE, EventType.REGISTER),
    USER_LOGIN(EventType.LOGIN),
    USER_FEDERATED_IDENTITY_ADD(FederatedIdentityModel.FederatedIdentityCreatedEvent.class),
    USER_FEDERATED_IDENTITY_REMOVE(FederatedIdentityModel.FederatedIdentityRemovedEvent.class),
    USER_GROUP_MEMBERSHIP_ADD(GroupModel.GroupMemberJoinEvent.class),
    USER_ROLE_ADD(RoleModel.RoleGrantedEvent.class),
    AD_HOC(new Class[0]);

    private final List<Object> types;
    private final List<Object> deactivationTypes;

    private ResourceOperationType(Enum<?> ... types) {
        this.types = List.of(types);
        this.deactivationTypes = List.of();
    }

    @SafeVarargs
    private ResourceOperationType(Class<? extends ProviderEvent> ... types) {
        this.types = List.of(types);
        this.deactivationTypes = List.of();
    }

    private ResourceOperationType(Class<? extends ProviderEvent>[] types, Class<? extends ProviderEvent>[] deactivationTypes) {
        this.types = List.of(types);
        this.deactivationTypes = List.of(deactivationTypes);
    }

    public static ResourceOperationType toOperationType(Enum<?> from) {
        return ResourceOperationType.toOperationType(from);
    }

    public static ResourceOperationType toOperationType(Class<?> from) {
        return ResourceOperationType.toOperationType(from);
    }

    private static ResourceOperationType toOperationType(Object from) {
        for (ResourceOperationType value : ResourceOperationType.values()) {
            if (value.types.contains(from)) {
                return value;
            }
            for (Object type : value.types) {
                Class cls;
                if (!(type instanceof Class) || !(cls = (Class)type).isAssignableFrom((Class)from)) continue;
                return value;
            }
        }
        return null;
    }

    public String getResourceId(ProviderEvent event) {
        if (event instanceof GroupModel.GroupMemberJoinEvent) {
            GroupModel.GroupMemberJoinEvent gme = (GroupModel.GroupMemberJoinEvent)event;
            return gme.getUser().getId();
        }
        if (event instanceof FederatedIdentityModel.FederatedIdentityCreatedEvent) {
            FederatedIdentityModel.FederatedIdentityCreatedEvent fie = (FederatedIdentityModel.FederatedIdentityCreatedEvent)event;
            return fie.getUser().getId();
        }
        if (event instanceof FederatedIdentityModel.FederatedIdentityRemovedEvent) {
            FederatedIdentityModel.FederatedIdentityRemovedEvent fie = (FederatedIdentityModel.FederatedIdentityRemovedEvent)event;
            return fie.getUser().getId();
        }
        if (event instanceof RoleModel.RoleGrantedEvent) {
            RoleModel.RoleGrantedEvent rge = (RoleModel.RoleGrantedEvent)event;
            return rge.getUser().getId();
        }
        if (event instanceof RoleModel.RoleRevokedEvent) {
            RoleModel.RoleRevokedEvent rre = (RoleModel.RoleRevokedEvent)event;
            return rre.getUser().getId();
        }
        return null;
    }

    public boolean isDeactivationEvent(Class<?> eventType) {
        for (Object deactivationType : this.deactivationTypes) {
            Class cls;
            if (!(deactivationType instanceof Class) || !(cls = (Class)deactivationType).isAssignableFrom(eventType)) continue;
            return true;
        }
        return false;
    }
}

