/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.pymol.JmolObject;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLGroup;
import org.jmol.adapter.readers.pymol.PyMOLReader;
import org.jmol.api.JmolSceneGenerator;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Text;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

class PyMOLScene
implements JmolSceneGenerator {
    private static final int[] MEAS_DIGITS = new int[]{530, 531, 532};
    private static final double PYMOL_FONT_SIZE_FACTOR = 1.25;
    private Viewer vwr;
    private int pymolVersion;
    BS bsHidden = new BS();
    BS bsNucleic = new BS();
    BS bsNonbonded = new BS();
    BS bsLabeled = new BS();
    BS bsHydrogen = new BS();
    BS bsNoSurface = new BS();
    Map<Double, BS> htSpacefill = new Hashtable<Double, BS>();
    private BS bsSpacefillSphere = new BS();
    private Map<String, BS> ssMapAtom = new Hashtable<String, BS>();
    private Lst<Integer> atomColorList = new Lst();
    private Map<String, Boolean> occludedObjects = new Hashtable<String, Boolean>();
    private Map<Integer, Text> labels = new Hashtable<Integer, Text>();
    private short[] colixes;
    private JmolObject frameObj;
    private Map<String, PyMOLGroup> groups;
    private Map<Integer, Lst<Object>> objectSettings;
    int[] jmolToUniqueID;
    private final P3 ptTemp = new P3();
    private BS bsCartoon = new BS();
    private Map<String, BS> htCarveSets = new Hashtable<String, BS>();
    private Map<String, BS> htDefinedAtoms = new Hashtable<String, BS>();
    private Map<String, Boolean> htHiddenObjects = new Hashtable<String, Boolean>();
    private Lst<String> moleculeNames = new Lst();
    private Lst<JmolObject> jmolObjects = new Lst();
    private Map<String, int[]> htAtomMap = new Hashtable<String, int[]>();
    private Map<String, BS> htObjectAtoms = new Hashtable<String, BS>();
    private Map<String, String> htObjectGroups = new Hashtable<String, String>();
    private Map<String, MeasurementData[]> htMeasures = new Hashtable<String, MeasurementData[]>();
    private Map<String, Map<Integer, Lst<Object>>> htObjectSettings = new Hashtable<String, Map<Integer, Lst<Object>>>();
    private Map<String, Object[]> objectInfo = new Hashtable<String, Object[]>();
    private Lst<Object> globalSettings;
    private Map<String, Map<Integer, Lst<Object>>> htStateSettings = new Hashtable<String, Map<Integer, Lst<Object>>>();
    private Map<Integer, Lst<Object>> stateSettings;
    private Map<Integer, Lst<Object>> uniqueSettings;
    private Map<Integer, Integer> uniqueList;
    private BS bsUniqueBonds;
    private boolean haveNucleicLadder;
    private P3 labelPosition;
    private P3 labelPosition0 = new P3();
    private String objectName;
    private String objectStateName;
    private String objectJmolName;
    private int objectType;
    private BS bsAtoms;
    private boolean objectHidden;
    private PyMOLReader reader;
    private int[] uniqueIDs;
    private int[] cartoonTypes;
    private int[] sequenceNumbers;
    private boolean[] newChain;
    private double[] radii;
    private int baseModelIndex;
    private int baseAtomIndex;
    private int stateCount;
    String mepList = "";
    boolean doCache;
    private boolean haveScenes;
    private BS bsCarve;
    private BS bsLineBonds = new BS();
    private BS bsStickBonds = new BS();
    private int thisState;
    int currentAtomSetIndex;
    String surfaceInfoName;
    String modelName;
    private int bgRgb;
    private double[] sceneSettings;

    private void clearReaderData() {
        this.reader = null;
        this.colixes = null;
        this.atomColorList = null;
        this.objectSettings = null;
        this.stateSettings = null;
        if (this.haveScenes) {
            return;
        }
        this.globalSettings = null;
        this.groups = null;
        this.labels = null;
        this.ssMapAtom = null;
        this.htSpacefill = null;
        this.htAtomMap = null;
        this.htMeasures = null;
        this.htObjectGroups = null;
        this.htObjectAtoms = null;
        this.htObjectSettings = null;
        this.htStateSettings = null;
        this.htHiddenObjects = null;
        this.objectInfo = null;
        this.occludedObjects = null;
        this.bsCartoon = null;
        this.bsNoSurface = null;
        this.bsHydrogen = null;
        this.bsLabeled = null;
        this.bsNonbonded = null;
        this.bsNucleic = null;
        this.bsHidden = null;
    }

    PyMOLScene(PyMOLReader reader, Viewer vwr, Lst<Object> settings, Map<Integer, Lst<Object>> uniqueSettings, int pymolVersion, boolean haveScenes, int baseAtomIndex, int baseModelIndex, boolean doCache, String filePath) {
        this.reader = reader;
        this.vwr = vwr;
        this.globalSettings = settings;
        this.uniqueSettings = uniqueSettings;
        this.pymolVersion = pymolVersion;
        this.haveScenes = haveScenes;
        this.baseAtomIndex = baseAtomIndex;
        this.baseModelIndex = baseModelIndex;
        this.doCache = doCache;
        this.surfaceInfoName = filePath + "##JmolSurfaceInfo##";
        this.sceneSettings = new double[1000];
        int i = 1000;
        while (--i >= 0) {
            this.sceneSettings[i] = Double.NaN;
        }
        this.addVersionSettings();
        settings.trimToSize();
        this.bgRgb = PyMOL.getRGB(this.colorSetting(6));
        this.labelPosition0 = this.pointSetting(471);
    }

    void setUniqueBond(int index, int uniqueID) {
        if (uniqueID < 0) {
            return;
        }
        if (this.uniqueList == null) {
            this.uniqueList = new Hashtable<Integer, Integer>();
            this.bsUniqueBonds = new BS();
        }
        this.uniqueList.put(index, uniqueID);
        this.bsUniqueBonds.set(index);
    }

    void setStateCount(int stateCount) {
        this.stateCount = stateCount;
    }

    private int colorSetting(int i) {
        Object o;
        Lst<Object> pos = PyMOLReader.listAt(this.globalSettings, i);
        Object v0 = o = pos == null || pos.size() != 3 ? null : pos.get(2);
        if (o == null) {
            return (int)PyMOL.getDefaultSetting(i, this.pymolVersion);
        }
        return o instanceof Integer ? (Integer)o : CU.colorPtToFFRGB(PyMOLReader.pointAt(o, 0, this.ptTemp));
    }

    private P3 pointSetting(int i) {
        P3 pt = new P3();
        Lst<Object> pos = PyMOLReader.listAt(this.globalSettings, i);
        if (pos != null && pos.size() == 3) {
            return PyMOLReader.pointAt((Lst)pos.get(2), 0, pt);
        }
        return PyMOL.getDefaultSettingPt(i, this.pymolVersion, pt);
    }

    void ensureCapacity(int n) {
        this.atomColorList.ensureCapacity(this.atomColorList.size() + n);
    }

    void setReaderObjectInfo(String name, int type, String groupName, boolean isHidden, Lst<Object> listObjSettings, Lst<Object> listStateSettings, String ext) {
        this.objectName = name;
        this.objectHidden = isHidden;
        String string = this.objectStateName = this.objectName == null ? null : this.fixName(this.objectName + ext);
        if (this.objectName == null) {
            this.objectSettings = new Hashtable<Integer, Lst<Object>>();
            this.stateSettings = new Hashtable<Integer, Lst<Object>>();
        } else {
            this.objectJmolName = this.getJmolName(name);
            if (groupName != null) {
                this.htObjectGroups.put(this.objectName, groupName);
                this.htObjectGroups.put(this.objectStateName, groupName);
            }
            this.objectInfo.put(this.objectName, new Object[]{this.objectStateName, type});
            this.objectSettings = this.htObjectSettings.get(this.objectName);
            if (this.objectSettings == null) {
                this.objectSettings = new Hashtable<Integer, Lst<Object>>();
                this.listToSettings(listObjSettings, this.objectSettings);
                this.htObjectSettings.put(this.objectName, this.objectSettings);
            }
            this.stateSettings = this.htStateSettings.get(this.objectStateName);
            if (this.stateSettings == null) {
                this.stateSettings = new Hashtable<Integer, Lst<Object>>();
                this.listToSettings(listStateSettings, this.stateSettings);
                this.htStateSettings.put(this.objectStateName, this.stateSettings);
            }
        }
        this.getObjectSettings();
    }

    private void listToSettings(Lst<Object> list, Map<Integer, Lst<Object>> objectSettings) {
        if (list != null && list.size() != 0) {
            int i = list.size();
            while (--i >= 0) {
                Lst setting = (Lst)list.get(i);
                objectSettings.put((Integer)setting.get(0), setting);
            }
        }
    }

    double getDoubleOrDefault(int key) {
        return this.doubleSetting(key);
    }

    int getIntOrDefault(int key) {
        return (int)this.getDoubleOrDefault(key);
    }

    boolean getBooleanOrDefault(int key) {
        return this.getDoubleOrDefault(key) != 0.0;
    }

    private void getObjectSettings() {
        String carveSet = this.stringSetting(342).trim();
        if (carveSet.length() == 0) {
            this.bsCarve = null;
        } else {
            this.bsCarve = this.htCarveSets.get(carveSet);
            if (this.bsCarve == null) {
                this.bsCarve = new BS();
                this.htCarveSets.put(carveSet, this.bsCarve);
            }
        }
        this.labelPosition = new P3();
        try {
            Lst<Object> setting = this.getSetting(471);
            PyMOLReader.pointAt(PyMOLReader.listAt(setting, 2), 0, this.labelPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.labelPosition.add(this.labelPosition0);
    }

    void setAtomInfo(int[] uniqueIDs, int[] cartoonTypes, int[] sequenceNumbers, boolean[] newChain, double[] radii) {
        this.uniqueIDs = uniqueIDs;
        this.cartoonTypes = cartoonTypes;
        this.sequenceNumbers = sequenceNumbers;
        this.newChain = newChain;
        this.radii = radii;
    }

    private void setSceneObject(String name, int istate) {
        this.objectName = name;
        this.objectType = this.getObjectType(name);
        this.objectJmolName = this.getJmolName(name);
        this.objectStateName = istate == 0 && this.objectType != 0 ? this.getObjectID(name) : this.objectJmolName + "_" + istate;
        this.bsAtoms = this.htObjectAtoms.get(name);
        this.objectSettings = this.htObjectSettings.get(name);
        this.stateSettings = this.htStateSettings.get(name + "_" + istate);
        String groupName = this.htObjectGroups.get(name);
        this.objectHidden = this.htHiddenObjects.containsKey(name) || groupName != null && !this.groups.get((Object)groupName).visible;
        this.getObjectSettings();
    }

    void buildScene(String name, Lst<Object> thisScene, Map<String, Lst<Object>> htObjNames, Map<String, Lst<Object>> htSecrets) {
        Object frame = thisScene.get(2);
        Hashtable<String, Object> smap = new Hashtable<String, Object>();
        smap.put("pymolFrame", frame);
        smap.put("generator", this);
        smap.put("name", name);
        Lst<Object> view = PyMOLReader.listAt(thisScene, 0);
        if (view != null) {
            smap.put("pymolView", this.getPymolView(view, false));
        }
        Map visibilities = (Map)thisScene.get(1);
        smap.put("visibilities", visibilities);
        String sname = "_scene_" + name + "_";
        Object[] reps = new Object[PyMOL.REP_LIST.length];
        int j = PyMOL.REP_LIST.length;
        while (--j >= 0) {
            Lst<Object> list = htObjNames.get(sname + PyMOL.REP_LIST[j]);
            Lst<Object> data = PyMOLReader.listAt(list, 5);
            if (data == null || data.size() <= 0) continue;
            reps[j] = PyMOLReader.listToMap(data);
        }
        smap.put("moleculeReps", reps);
        sname = "_!c_" + name + "_";
        Lst<Object> colorection = PyMOLReader.listAt(thisScene, 3);
        int n = colorection.size();
        n -= n % 2;
        Object[] colors = new Object[n / 2];
        int i = 0;
        for (int j2 = 0; j2 < n; j2 += 2) {
            int color = PyMOLReader.intAt(colorection, j2);
            Lst<Object> c = htSecrets.get(sname + color);
            if (c == null || c.size() <= 1) continue;
            colors[i++] = new Object[]{color, c.get(1)};
        }
        smap.put("colors", colors);
        this.addJmolObject((int)1073742139, null, smap).jmolName = name;
    }

    @Override
    public void generateScene(Map<String, Object> scene) {
        Logger.info("PyMOLScene - generateScene " + scene.get("name"));
        this.jmolObjects.clear();
        this.bsHidden.clearAll();
        this.occludedObjects.clear();
        this.htHiddenObjects.clear();
        Integer frame = (Integer)scene.get("pymolFrame");
        this.thisState = frame;
        this.addJmolObject(4115, null, this.thisState - 1);
        try {
            this.generateVisibilities((Map)scene.get("visibilities"));
            this.generateColors((Object[])scene.get("colors"));
            this.generateShapes((Object[])scene.get("moleculeReps"));
            this.finalizeVisibility();
            this.offsetObjects();
            this.finalizeObjects();
        }
        catch (Exception e) {
            Logger.info("PyMOLScene exception " + e);
            e.printStackTrace();
        }
    }

    private void generateColors(Object[] colors) {
        if (colors == null) {
            return;
        }
        int i = colors.length;
        while (--i >= 0) {
            Object[] item = (Object[])colors[i];
            int color = (Integer)item[0];
            int icolor = PyMOL.getRGB(color);
            Lst molecules = (Lst)item[1];
            BS bs = this.getSelectionAtoms(molecules, this.thisState, new BS());
            this.addJmolObjectNoInfo((int)1153433601, (BS)bs).argb = icolor;
        }
    }

    void processSelection(Lst<Object> selection) {
        String id = PyMOLReader.stringAt(selection, 0);
        id = "_" + (id.equals("sele") ? id : "sele_" + id);
        PyMOLGroup g = this.getGroup(id);
        this.getSelectionAtoms(PyMOLReader.listAt(selection, 5), 0, g.bsAtoms);
    }

    private BS getSelectionAtoms(Lst<Object> molecules, int istate, BS bs) {
        if (molecules != null) {
            int j = molecules.size();
            while (--j >= 0) {
                this.selectAllAtoms(PyMOLReader.listAt(molecules, j), istate, bs);
            }
        }
        return bs;
    }

    private void selectAllAtoms(Lst<Object> obj, int istate, BS bs) {
        String name = PyMOLReader.stringAt(obj, 0);
        this.setSceneObject(name, istate);
        Lst<Object> atomList = PyMOLReader.listAt(obj, 1);
        int k0 = istate == 0 ? 1 : istate;
        int k1 = istate == 0 ? this.stateCount : istate;
        for (int k = k0; k <= k1; ++k) {
            int[] atomMap = this.htAtomMap.get(this.fixName(name + "_" + k));
            if (atomMap == null) continue;
            this.getBsAtoms(atomList, atomMap, bs);
        }
    }

    private void generateVisibilities(Map<String, Object> vis) {
        int tok;
        Lst list;
        String name;
        if (vis == null) {
            return;
        }
        BS bs = new BS();
        this.addJmolObjectNoInfo(12294, null);
        for (Map.Entry<String, PyMOLGroup> entry : this.groups.entrySet()) {
            entry.getValue().visible = true;
        }
        for (Map.Entry<String, Object> entry : vis.entrySet()) {
            name = entry.getKey();
            if (name.equals("all")) continue;
            list = (Lst)entry.getValue();
            int n = tok = PyMOLReader.intAt(list, 0) == 1 ? 1610625028 : 12294;
            if (tok == 12294) {
                this.htHiddenObjects.put(name, Boolean.TRUE);
            }
            switch (this.getObjectType(name)) {
                case 12: {
                    PyMOLGroup g = this.groups.get(name);
                    if (g == null) break;
                    g.visible = tok == 1610625028;
                }
            }
        }
        this.setGroupVisibilities();
        block10: for (Map.Entry<String, Object> entry : vis.entrySet()) {
            name = entry.getKey();
            if (name.equals("all")) continue;
            this.setSceneObject(name, this.thisState);
            if (this.objectHidden) continue;
            list = (Lst)entry.getValue();
            tok = this.objectHidden ? 12294 : 1610625028;
            bs = null;
            String info = this.objectJmolName;
            switch (this.objectType) {
                case 0: 
                case 12: {
                    continue block10;
                }
                case 1: {
                    bs = this.vwr.getDefinedAtomSet(info);
                    if (bs.nextSetBit(0) >= 0) break;
                    continue block10;
                }
                case 4: {
                    MeasurementData[] mdList;
                    if (tok == 1610625028 && (mdList = this.htMeasures.get(name)) != null) {
                        this.addMeasurements(mdList, mdList[0].points.size(), null, this.getBS(PyMOLReader.listAt(list, 2)), PyMOLReader.intAt(list, 3), null, true);
                    }
                    info = info + "_*";
                    break;
                }
            }
            this.addJmolObject(tok, bs, info);
        }
    }

    private void generateShapes(Object[] reps) {
        if (reps == null) {
            return;
        }
        this.addJmolObjectNoInfo((int)12295, null).argb = this.thisState - 1;
        for (int m = 0; m < this.moleculeNames.size(); ++m) {
            int i;
            String name = (String)this.moleculeNames.get(m);
            this.setSceneObject(name, this.thisState);
            if (this.objectHidden) continue;
            BS[] molReps = new BS[23];
            for (i = 0; i < 23; ++i) {
                molReps[i] = new BS();
            }
            i = reps.length;
            while (--i >= 0) {
                Map repMap = (Map)reps[i];
                Lst list = repMap == null ? null : (Lst)repMap.get(this.objectName);
                if (list == null) continue;
                this.selectAllAtoms(list, this.thisState, molReps[i]);
            }
            this.createShapeObjects(molReps, true, -1, -1);
        }
    }

    private BS getBS(Lst<Object> list) {
        BS bs = new BS();
        int i = list.size();
        while (--i >= 0) {
            bs.set(PyMOLReader.intAt(list, i));
        }
        return bs;
    }

    private void getBsAtoms(Lst<Object> list, int[] atomMap, BS bs) {
        int i = list.size();
        while (--i >= 0) {
            bs.set(atomMap[PyMOLReader.intAt(list, i)]);
        }
    }

    void setReaderObjects() {
        this.finalizeObjects();
        this.clearReaderData();
        if (!this.haveScenes) {
            this.uniqueSettings = null;
            this.bsLineBonds = null;
            this.bsStickBonds = null;
            this.bsUniqueBonds = null;
        }
    }

    private void finalizeObjects() {
        this.vwr.setStringProperty("defaults", "PyMOL");
        for (int i = 0; i < this.jmolObjects.size(); ++i) {
            try {
                JmolObject obj = (JmolObject)this.jmolObjects.get(i);
                obj.finalizeObject(this, this.vwr.ms, this.mepList, this.doCache);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        this.finalizeUniqueBonds();
        this.jmolObjects.clear();
    }

    void offsetObjects() {
        int n = this.jmolObjects.size();
        for (int i = 0; i < n; ++i) {
            ((JmolObject)this.jmolObjects.get(i)).offset(this.baseModelIndex, this.baseAtomIndex);
        }
    }

    private JmolObject getJmolObject(int shape, BS bsAtoms, Object info) {
        if (this.baseAtomIndex > 0) {
            bsAtoms = BSUtil.copy(bsAtoms);
        }
        return new JmolObject(shape, this.objectStateName, bsAtoms, info);
    }

    private JmolObject addJmolObjectNoInfo(int shape, BS bsAtoms) {
        return this.addObject(this.getJmolObject(shape, bsAtoms, null));
    }

    private JmolObject addJmolObject(int shape, BS bsAtoms, Object info) {
        return this.addObject(this.getJmolObject(shape, bsAtoms, info));
    }

    private double[] getPymolView(Lst<Object> view, boolean isViewObj) {
        int j;
        double[] pymolView = new double[21];
        boolean depthCue = this.getBooleanOrDefault(84);
        boolean fog = this.getBooleanOrDefault(88);
        double fog_start = this.getDoubleOrDefault(192);
        int pt = 0;
        int i = 0;
        for (j = 0; j < 3; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        if (isViewObj) {
            ++i;
        }
        for (j = 0; j < 3; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        if (isViewObj) {
            ++i;
        }
        for (j = 0; j < 3; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        if (isViewObj) {
            i += 5;
        }
        for (j = 0; j < 8; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        boolean isOrtho = this.getBooleanOrDefault(23);
        double fov = this.getDoubleOrDefault(152);
        pymolView[pt++] = isOrtho ? fov : -fov;
        pymolView[pt++] = depthCue ? 1 : 0;
        pymolView[pt++] = fog ? 1 : 0;
        pymolView[pt++] = fog_start;
        return pymolView;
    }

    double globalSetting(int i) {
        Lst<Object> setting = PyMOLReader.listAt(this.globalSettings, i);
        if (setting != null && setting.size() == 3) {
            return ((Number)setting.get(2)).doubleValue();
        }
        return PyMOL.getDefaultSetting(i, this.pymolVersion);
    }

    PyMOLGroup addGroup(Lst<Object> object, String parent, int type, BS bsAtoms) {
        if (this.groups == null) {
            this.groups = new Hashtable<String, PyMOLGroup>();
        }
        PyMOLGroup myGroup = this.getGroup(this.objectName);
        myGroup.object = object;
        myGroup.objectNameID = this.objectStateName;
        myGroup.visible = !this.objectHidden;
        myGroup.type = type;
        if (!myGroup.visible) {
            this.occludedObjects.put(this.objectStateName, Boolean.TRUE);
            this.htHiddenObjects.put(this.objectName, Boolean.TRUE);
        }
        if (parent != null && parent.length() != 0) {
            this.getGroup(parent).addList(myGroup);
        }
        if (bsAtoms != null) {
            myGroup.addGroupAtoms(bsAtoms);
        }
        return myGroup;
    }

    PyMOLGroup getGroup(String name) {
        PyMOLGroup g = this.groups.get(name);
        if (g == null) {
            g = new PyMOLGroup(name);
            this.groups.put(name, g);
            this.defineAtoms(name, g.bsAtoms);
        }
        return g;
    }

    void finalizeVisibility() {
        this.setGroupVisibilities();
        if (this.groups != null) {
            int i = this.jmolObjects.size();
            while (--i >= 0) {
                JmolObject obj = (JmolObject)this.jmolObjects.get(i);
                if (obj.jmolName == null || !this.occludedObjects.containsKey(obj.jmolName)) continue;
                obj.visible = false;
            }
        }
        if (!this.bsHidden.isEmpty()) {
            this.addJmolObjectNoInfo(0x20002A, this.bsHidden);
        }
    }

    void setCarveSets(Map<String, Lst<Object>> htObjNames) {
        if (this.htCarveSets.isEmpty()) {
            return;
        }
        for (Map.Entry<String, BS> e : this.htCarveSets.entrySet()) {
            this.getSelectionAtoms(PyMOLReader.listAt(htObjNames.get(e.getKey()), 5), 0, e.getValue());
        }
    }

    private void setGroupVisibilities() {
        if (this.groups == null) {
            return;
        }
        Collection<PyMOLGroup> list = this.groups.values();
        BS bsAll = new BS();
        for (PyMOLGroup g : list) {
            bsAll.or(g.bsAtoms);
            if (g.parent == null) {
                this.setGroupVisible(g, true);
                continue;
            }
            if (!g.list.isEmpty()) continue;
            g.addGroupAtoms(new BS());
        }
        this.defineAtoms("all", bsAll);
    }

    private void defineAtoms(String name, BS bs) {
        this.htDefinedAtoms.put(this.getJmolName(name), bs);
    }

    private String getJmolName(String name) {
        return "__" + this.fixName(name);
    }

    void createShapeObjects(BS[] reps, boolean allowSurface, int ac0, int ac) {
        if (ac >= 0) {
            this.bsAtoms = BSUtil.newBitSet2(ac0, ac);
            JmolObject jo = this.addJmolObjectNoInfo(1153433601, this.bsAtoms);
            this.colixes = AU.ensureLengthShort(this.colixes, ac);
            int i = ac;
            while (--i >= ac0) {
                this.colixes[i] = (short)((Integer)this.atomColorList.get(i)).intValue();
            }
            jo.setColors(this.colixes, 0.0);
            jo.setSize(0.0);
            jo = this.addJmolObjectNoInfo(1, this.bsAtoms);
            jo.setSize(0.0);
        }
        this.createShapeObject(7, reps[7]);
        this.createShapeObject(0, reps[0]);
        this.fixReps(reps);
        this.createSpacefillObjects();
        block10: for (int i = 0; i < 23; ++i) {
            switch (i) {
                case 0: 
                case 7: {
                    continue block10;
                }
                case 2: 
                case 8: {
                    if (!allowSurface) continue block10;
                    switch (this.getIntOrDefault(143)) {
                        case 0: {
                            reps[i].andNot(this.bsNoSurface);
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: 
                        case 4: {
                            reps[i].andNot(this.bsHydrogen);
                        }
                    }
                }
                default: {
                    this.createShapeObject(i, reps[i]);
                }
            }
        }
        this.bsAtoms = null;
    }

    void addLabel(int atomIndex, int uniqueID, int atomColor, float[] labelPos, String label) {
        P3 offset;
        int icolor = (int)this.getUniqueDoubleDef(uniqueID, 66);
        if (icolor != -7 && icolor != -6 && icolor < 0) {
            icolor = atomColor;
        }
        if (labelPos == null) {
            labelPos = this.setLabelPosition(this.getUniquePoint(uniqueID, 471, this.labelPosition), labelPos, false);
        }
        if ((offset = this.getUniquePoint(uniqueID, 718, null)) != null) {
            labelPos = this.setLabelPosition(offset, labelPos, true);
        }
        this.labels.put(atomIndex, this.newTextLabel(label, labelPos, icolor));
    }

    boolean isDefaultSettingID(int id, int key) {
        return this.isDefaultSetting(key) && this.getUniqueSetting(id, key) == null;
    }

    double getUniqueDoubleDef(int id, int key) {
        return this.getUniqueFloatDefVal(id, key, Double.NaN);
    }

    double getUniqueFloatDefVal(int id, int key, double defValue) {
        Lst<Object> setting = this.getUniqueSetting(id, key);
        if (setting == null) {
            return Double.isNaN(defValue) ? this.getDoubleOrDefault(key) : defValue;
        }
        double v = ((Number)setting.get(2)).doubleValue();
        if (Logger.debugging) {
            Logger.debug("Pymol unique setting for " + id + ": [" + key + "] = " + v);
        }
        return v;
    }

    P3 getUniquePoint(int id, int key, P3 pt) {
        Lst<Object> setting = this.getUniqueSetting(id, key);
        if (setting == null) {
            return pt;
        }
        pt = new P3();
        PyMOLReader.pointAt((Lst)setting.get(2), 0, pt);
        Logger.info("Pymol unique setting for " + id + ": " + key + " = " + pt);
        return pt;
    }

    private Lst<Object> getUniqueSetting(int id, int key) {
        return id < 0 ? null : this.uniqueSettings.get(id * 1000 + key);
    }

    boolean isDefaultSetting(int i) {
        Lst<Object> setting = this.getSetting(i);
        return setting == null || setting.size() != 3;
    }

    double doubleSetting(int i) {
        Lst<Object> setting = this.getSetting(i);
        if (setting != null && setting.size() == 3) {
            return ((Number)setting.get(2)).doubleValue();
        }
        return PyMOL.getDefaultSetting(i, this.pymolVersion);
    }

    String stringSetting(int i) {
        Lst<Object> setting = this.getSetting(i);
        if (setting != null && setting.size() == 3) {
            return PyMOLReader.stringAt(setting, 2);
        }
        return PyMOL.getDefaultSettingS(i, this.pymolVersion);
    }

    private Lst<Object> getSetting(int i) {
        Lst setting = null;
        if (this.stateSettings != null) {
            setting = this.stateSettings.get(i);
        }
        if (setting == null && this.objectSettings != null) {
            setting = this.objectSettings.get(i);
        }
        if (setting == null && i < this.globalSettings.size()) {
            setting = (Lst)this.globalSettings.get(i);
        }
        return setting;
    }

    float[] setLabelPosition(P3 offset, float[] labelPos, boolean isPlacement) {
        if (labelPos == null) {
            labelPos = new float[7];
        }
        labelPos[0] = 1.0f;
        if (isPlacement) {
            labelPos[4] = offset.x;
            labelPos[5] = offset.y;
            labelPos[6] = offset.z;
        } else {
            labelPos[1] = offset.x;
            labelPos[2] = offset.y;
            labelPos[3] = offset.z;
        }
        return labelPos;
    }

    String addCGO(Lst<Object> data, int color) {
        data.addLast(this.objectName);
        JmolObject jo = this.addJmolObject(23, null, data);
        jo.argb = color;
        jo.translucency = this.getDoubleOrDefault(441);
        return this.fixName(this.objectName);
    }

    boolean addMeasurements(MeasurementData[] mdList, int nCoord, Lst<Object> list, BS bsReps, int color, Lst<Object> offsets, boolean haveLabels) {
        int clabel;
        int n;
        boolean isNew = mdList == null;
        int n2 = n = isNew ? list.size() / 3 / nCoord : mdList.length;
        if (n == 0) {
            return false;
        }
        boolean drawLabel = haveLabels && (bsReps == null || bsReps.get(3));
        boolean drawDashes = bsReps == null || bsReps.get(10);
        double rad = this.getDoubleOrDefault(107);
        if ((rad /= 400.0) == 0.0) {
            rad = 0.05;
        }
        if (!drawDashes) {
            rad = -5.0E-4;
        }
        if (color < 0) {
            color = this.getIntOrDefault(574);
        }
        int c = PyMOL.getRGB(color);
        short colix = C.getColix(c);
        int labelColor = this.getIntOrDefault(66);
        int n3 = clabel = labelColor < 0 ? color : labelColor;
        if (isNew) {
            mdList = new MeasurementData[n];
            this.htMeasures.put(this.objectName, mdList);
        }
        BS bs = BSUtil.newAndSetBit(0);
        int p = 0;
        for (int index = 0; index < n; ++index) {
            MeasurementData md;
            float[] offset;
            if (isNew) {
                Lst<Object> points = new Lst<Object>();
                int i = 0;
                while (i < nCoord) {
                    points.addLast(Point3fi.newPF(PyMOLReader.pointAt(list, p, new P3()), 0));
                    ++i;
                    p += 3;
                }
                offset = PyMOLReader.floatsAt(PyMOLReader.listAt(offsets, index), 0, new float[7], 7);
                if (offset == null) {
                    offset = this.setLabelPosition(this.labelPosition, new float[7], false);
                }
                md = mdList[index] = this.vwr.newMeasurementData(this.objectStateName + "_" + (index + 1), points);
                md.note = this.objectName;
            } else {
                md = mdList[index];
                offset = md.text.pymolOffset;
            }
            offset = PyMOL.fixAllZeroLabelPosition(offset);
            if (offset == null) {
                offset = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            }
            int nDigits = this.getIntOrDefault(MEAS_DIGITS[nCoord - 2]);
            String strFormat = nCoord + ": " + (drawLabel ? "%0." + (nDigits < 0 ? 1 : nDigits) + "VALUE" : "");
            Text text = this.newTextLabel(strFormat, offset, clabel);
            md.set(12290, null, null, null, strFormat, "angstroms", null, false, false, null, false, (int)(rad * 2000.0), colix, text, Float.NaN, null);
            this.addJmolObject(6, bs, md);
        }
        return true;
    }

    SB getViewScript(Lst<Object> view) {
        SB sb = new SB();
        double[] pymolView = this.getPymolView(view, true);
        sb.append(";set translucent " + (this.globalSetting(213) != 2.0) + ";set zshadePower 1;set traceAlpha " + (this.globalSetting(111) != 0.0));
        boolean rockets = this.getBooleanOrDefault(180);
        sb.append(";set cartoonRockets " + rockets);
        if (rockets) {
            sb.append(";set rocketBarrels " + rockets);
        }
        sb.append(";set cartoonLadders " + this.haveNucleicLadder);
        sb.append(";set ribbonBorder " + (this.globalSetting(118) != 0.0));
        sb.append(";set cartoonFancy " + (this.globalSetting(118) == 0.0));
        String s = "000000" + Integer.toHexString(this.bgRgb & 0xFFFFFF);
        s = "[x" + s.substring(s.length() - 6) + "]";
        sb.append(";background " + s);
        sb.append(";moveto 0 PyMOL " + Escape.eAD(pymolView));
        sb.append(";save orientation 'default';");
        return sb;
    }

    short getColix(int colorIndex, double translucency) {
        short colix = colorIndex == -7 ? (C.getBgContrast(this.bgRgb) == 8 ? (short)4 : 8) : (colorIndex == -6 ? (short)C.getBgContrast(this.bgRgb) : (short)C.getColixO(PyMOL.getRGB(colorIndex)));
        return C.getColixTranslucent3(colix, translucency > 0.0, (float)translucency);
    }

    void setAtomColor(int atomColor) {
        this.atomColorList.addLast(Integer.valueOf(this.getColix(atomColor, 0.0)));
    }

    void setFrameObject(int type, Object info) {
        if (info != null) {
            this.frameObj = this.getJmolObject(type, null, info);
            return;
        }
        if (this.frameObj == null) {
            return;
        }
        this.frameObj.finalizeObject(this, this.vwr.ms, null, false);
        this.frameObj = null;
    }

    private String fixName(String name) {
        char[] chars = name.toLowerCase().toCharArray();
        int i = chars.length;
        while (--i >= 0) {
            if (PT.isLetterOrDigit(chars[i])) continue;
            chars[i] = 95;
        }
        return String.valueOf(chars);
    }

    String getObjectID(String name) {
        return (String)this.objectInfo.get(name)[0];
    }

    private int getObjectType(String name) {
        Object[] o = this.objectInfo.get(name);
        return o == null ? 0 : (Integer)o[1];
    }

    BS setAtomMap(int[] atomMap, int ac0) {
        this.htAtomMap.put(this.objectStateName, atomMap);
        BS bsAtoms = this.htDefinedAtoms.get(this.objectJmolName);
        if (bsAtoms == null) {
            bsAtoms = BS.newN(ac0 + atomMap.length);
            Logger.info("PyMOL molecule " + this.objectName + " " + this.objectHidden);
            this.htDefinedAtoms.put(this.objectJmolName, bsAtoms);
            this.htObjectAtoms.put(this.objectName, bsAtoms);
            this.moleculeNames.addLast(this.objectName);
            this.modelName = this.objectName;
        }
        return bsAtoms;
    }

    private Text newTextLabel(String label, float[] labelOffset, int colorIndex) {
        Font font;
        Text t;
        String style;
        String face;
        int fontID = this.getIntOrDefault(328);
        switch (fontID) {
            default: {
                face = "SansSerif";
                break;
            }
            case 0: 
            case 1: {
                face = "Monospaced";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                face = "Serif";
            }
        }
        switch (fontID) {
            default: {
                style = "Plain";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 17: {
                style = "Italic";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                style = "Bold";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                style = "BoldItalic";
            }
        }
        double fontSize = this.getDoubleOrDefault(453);
        if (fontSize > 0.0) {
            fontSize *= 1.25;
        }
        if ((t = Text.newLabel(this.vwr, font = this.vwr.getFont3D(face, style, fontSize == 0.0 ? 12.0f : (float)fontSize), label, this.getColix(colorIndex, 0.0), (short)0, 0, 0.0f)) != null) {
            t.pymolOffset = labelOffset;
        }
        return t;
    }

    private void addVersionSettings() {
        if (this.pymolVersion < 100) {
            this.addVersionSetting(550, 2, 0);
            this.addVersionSetting(529, 2, 2);
            this.addVersionSetting(471, 4, new float[]{1.0f, 1.0f, 0.0f});
            if (this.pymolVersion < 99) {
                this.addVersionSetting(448, 2, 0);
                this.addVersionSetting(431, 2, 0);
                this.addVersionSetting(361, 2, 1);
            }
        }
    }

    private void addVersionSetting(int key, int type, Object val) {
        int settingCount = this.globalSettings.size();
        if (settingCount <= key) {
            int i = key + 1;
            while (--i >= settingCount) {
                this.globalSettings.addLast((Object)null);
            }
        }
        if (type == 4) {
            Lst<Double> list;
            double[] d = (double[])val;
            val = list = new Lst<Double>();
            for (int i = 0; i < 3; ++i) {
                list.addLast(d[i]);
            }
        }
        Lst<Serializable> setting = new Lst<Serializable>();
        setting.addLast(Integer.valueOf(key));
        setting.addLast(Integer.valueOf(type));
        setting.addLast(val);
        this.globalSettings.set(key, setting);
    }

    private void fixReps(BS[] reps) {
        this.bsCartoon.clearAll();
        int iAtom = this.bsAtoms.nextSetBit(0);
        while (iAtom >= 0) {
            int cartoonType;
            int atomUID = this.reader == null ? this.uniqueIDs[iAtom] : this.reader.getUniqueID(iAtom);
            double rad = 0.0;
            if (reps[1].get(iAtom)) {
                double scale = this.getUniqueDoubleDef(atomUID, 155);
                rad = (this.reader == null ? this.radii[iAtom] : this.reader.getVDW(iAtom)) * scale;
            } else {
                boolean isRepNB = reps[4].get(iAtom);
                double d = rad = isRepNB ? this.getStickBallRadius(atomUID) : 0.0;
                if (rad > 0.0 && this.bsHydrogen.get(iAtom) && !this.bsNonbonded.get(iAtom)) {
                    rad *= this.getUniqueDoubleDef(atomUID, 605);
                }
                if (rad == 0.0 && isRepNB && this.bsNonbonded.get(iAtom)) {
                    rad = this.getUniqueDoubleDef(atomUID, 65);
                }
            }
            if (rad != 0.0) {
                this.addSpacefill(iAtom, rad, true);
            }
            int n = cartoonType = this.reader == null ? this.cartoonTypes[iAtom] : this.reader.getCartoonType(iAtom);
            if (reps[5].get(iAtom)) {
                switch (cartoonType) {
                    case 1: 
                    case 4: {
                        reps[21].set(iAtom);
                    }
                    case -1: {
                        reps[5].clear(iAtom);
                        this.bsCartoon.clear(iAtom);
                        break;
                    }
                    case 7: {
                        reps[22].set(iAtom);
                        reps[5].clear(iAtom);
                        this.bsCartoon.clear(iAtom);
                        break;
                    }
                    default: {
                        this.bsCartoon.set(iAtom);
                    }
                }
            }
            iAtom = this.bsAtoms.nextSetBit(iAtom + 1);
        }
        reps[5].and(this.bsCartoon);
        this.cleanSingletons(reps[5]);
        this.cleanSingletons(reps[6]);
        this.cleanSingletons(reps[21]);
        this.cleanSingletons(reps[22]);
        this.bsCartoon.and(reps[5]);
    }

    void addSpacefill(int iAtom, double rad, boolean doCheck) {
        if (doCheck && this.bsSpacefillSphere.get(iAtom)) {
            return;
        }
        this.bsSpacefillSphere.set(iAtom);
        Double r = rad;
        BS bsr = this.htSpacefill.get(r);
        if (bsr == null) {
            bsr = new BS();
            this.htSpacefill.put(r, bsr);
        }
        bsr.set(iAtom);
    }

    private void cleanSingletons(BS bs) {
        if (bs.isEmpty()) {
            return;
        }
        bs.and(this.bsAtoms);
        BS bsr = new BS();
        int n = bs.length();
        int pass = 0;
        while (true) {
            int i = 0;
            int offset = 0;
            int iPrev = Integer.MIN_VALUE;
            int iSeqLast = Integer.MIN_VALUE;
            int iSeq = Integer.MIN_VALUE;
            while (i < n) {
                if (iPrev < 0 || (this.reader == null ? this.newChain[i] : this.reader.compareAtoms(iPrev, i))) {
                    ++offset;
                }
                int n2 = iSeq = this.reader == null ? this.sequenceNumbers[i] : this.reader.getSequenceNumber(i);
                if (iSeq != iSeqLast) {
                    iSeqLast = iSeq;
                    ++offset;
                }
                if (pass == 0) {
                    if (bs.get(i)) {
                        bsr.set(offset);
                    }
                } else if (!bsr.get(offset)) {
                    bs.clear(i);
                }
                iPrev = i++;
            }
            if (++pass == 2) break;
            BS bsnot = new BS();
            int i2 = bsr.nextSetBit(0);
            while (i2 >= 0) {
                if (!bsr.get(i2 - 1) && !bsr.get(i2 + 1)) {
                    bsnot.set(i2);
                }
                i2 = bsr.nextSetBit(i2 + 1);
            }
            bsr.andNot(bsnot);
        }
    }

    private void createShapeObject(int repType, BS bs) {
        if (bs.isEmpty()) {
            return;
        }
        JmolObject jo = null;
        switch (repType) {
            case 11: {
                bs.and(this.bsNonbonded);
                if (bs.isEmpty()) {
                    return;
                }
                this.setUniqueObjects(7, bs, 0, 0, 524, this.getDoubleOrDefault(524), 0, this.getDoubleOrDefault(65), 0.5);
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                this.setUniqueObjects(0, bs, 173, this.getIntOrDefault(173), 172, this.getDoubleOrDefault(172), 155, this.getIntOrDefault(155), 1.0);
                break;
            }
            case 19: {
                double ellipsoidTranslucency = this.getDoubleOrDefault(571);
                int ellipsoidColor = this.getIntOrDefault(570);
                double ellipsoidScale = this.getDoubleOrDefault(569);
                this.setUniqueObjects(20, bs, 570, ellipsoidColor, 571, ellipsoidTranslucency, 569, ellipsoidScale, 50.0);
                break;
            }
            case 9: {
                this.setUniqueObjects(16, bs, 210, this.getIntOrDefault(210), 0, 0.0, 155, this.getDoubleOrDefault(155), 1.0);
                break;
            }
            case 2: {
                double withinDistance = this.getDoubleOrDefault(344);
                int surfaceMode = this.getIntOrDefault(421);
                jo = this.addJmolObject(135180, bs, new Object[]{this.getBooleanOrDefault(156) ? "FULLYLIT" : "FRONTLIT", surfaceMode == 3 || surfaceMode == 4 ? " only" : "", this.bsCarve, withinDistance});
                jo.setSize(this.getDoubleOrDefault(4) * (double)(this.getBooleanOrDefault(338) ? -1 : 1));
                jo.translucency = this.getDoubleOrDefault(138);
                int surfaceColor = this.getIntOrDefault(144);
                if (surfaceColor >= 0) {
                    jo.argb = PyMOL.getRGB(surfaceColor);
                }
                jo.modelIndex = this.currentAtomSetIndex;
                jo.cacheID = this.surfaceInfoName;
                this.setUniqueObjects(24, bs, 144, surfaceColor, 138, jo.translucency, 0, 0.0, 0.0);
                break;
            }
            case 8: {
                jo = this.addJmolObjectNoInfo(135180, bs);
                jo.setSize(this.getDoubleOrDefault(4));
                jo.translucency = this.getDoubleOrDefault(138);
                int surfaceColor = this.getIntOrDefault(144);
                this.setUniqueObjects(24, bs, 144, surfaceColor, 138, jo.translucency, 0, 0.0, 0.0);
                break;
            }
            case 3: {
                bs.and(this.bsLabeled);
                if (bs.isEmpty()) {
                    return;
                }
                jo = this.addJmolObject(5, bs, this.labels);
                break;
            }
            case 7: 
            case 10: {
                jo = this.addJmolObjectNoInfo(659488, bs);
                jo.setSize(this.getDoubleOrDefault(44) / 15.0);
                int color = this.getIntOrDefault(526);
                if (color < 0) break;
                jo.argb = PyMOL.getRGB(color);
                break;
            }
            case 0: {
                Object[] info = null;
                if (!this.bsHydrogen.isEmpty()) {
                    BS bsH = BSUtil.copy(bs);
                    bsH.and(this.bsHydrogen);
                    info = new Object[]{bsH, this.getUniqueDoubleDef(repType, 605)};
                }
                jo = this.addJmolObject(1, bs, info);
                jo.setSize(this.getDoubleOrDefault(21) * 2.0);
                jo.translucency = this.getDoubleOrDefault(198);
                int col = this.getIntOrDefault(376);
                if (col < 0) break;
                jo.argb = PyMOL.getRGB(col);
                break;
            }
            case 5: {
                this.createCartoonObject("H", this.getBooleanOrDefault(180) ? 181 : 100);
                this.createCartoonObject("S", 96);
                this.createCartoonObject("L", 92);
                this.createCartoonObject(" ", 92);
                break;
            }
            case 22: {
                this.createPuttyObject(bs);
                break;
            }
            case 21: {
                this.createTraceObject(bs);
                break;
            }
            case 6: {
                this.createRibbonObject(bs);
                break;
            }
            default: {
                Logger.error("Unprocessed representation type " + repType);
            }
        }
    }

    private JmolObject setUniqueObjects(int shape, BS bs, int setColor, int color, int setTrans, double trans, int setSize, double size, double f) {
        int n = bs.cardinality();
        short[] colixes = new short[n];
        float[] atrans = setTrans == 0 ? null : new float[n];
        float[] sizes = new float[n];
        boolean checkAtomScale = shape == 0 && !this.bsHydrogen.isEmpty();
        int pt = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            int c;
            int id;
            int n2 = id = this.reader == null ? this.uniqueIDs[i] : this.reader.getUniqueID(i);
            if (setColor != 0 && (c = (int)this.getUniqueFloatDefVal(id, setColor, color)) > 0) {
                colixes[pt] = this.getColix(c, 0.0);
            }
            if (atrans != null) {
                atrans[pt] = (float)this.getUniqueFloatDefVal(id, setTrans, trans);
            }
            float r = (float)(this.getUniqueFloatDefVal(id, setSize, size) * f);
            sizes[pt] = checkAtomScale && this.bsHydrogen.get(i) && this.isDefaultSettingID(id, setSize) ? 0.0f : r;
            i = bs.nextSetBit(i + 1);
            ++pt;
        }
        return this.addJmolObject(shape, bs, new Object[]{colixes, atrans, sizes});
    }

    private void createSpacefillObjects() {
        for (Map.Entry<Double, BS> e : this.htSpacefill.entrySet()) {
            float r = e.getKey().floatValue();
            BS bs = e.getValue();
            this.addJmolObjectNoInfo((int)1153433601, (BS)bs).rd = new RadiusData(null, r, RadiusData.EnumType.ABSOLUTE, VDW.AUTO);
        }
        this.htSpacefill.clear();
    }

    private void createTraceObject(BS bs) {
        this.checkNucleicObject(bs, true);
        if (bs.isEmpty()) {
            return;
        }
        double r = this.doubleSetting(103);
        JmolObject jo = this.setUniqueObjects(10, bs, 236, this.getIntOrDefault(236), 0, 0.0, 0, 0.0, 0.0);
        jo.setSize(r * 2.0);
        jo.translucency = this.getDoubleOrDefault(279);
    }

    private void checkNucleicObject(BS bs, boolean isTrace) {
        BS bsNuc = BSUtil.copy(this.bsNucleic);
        bsNuc.and(bs);
        if (!bsNuc.isEmpty()) {
            if (isTrace && this.getBooleanOrDefault(448)) {
                this.haveNucleicLadder = true;
            }
            JmolObject jo = this.addJmolObjectNoInfo(11, bsNuc);
            jo.translucency = this.getDoubleOrDefault(279);
            jo.setSize(this.doubleSetting(103) * 2.0);
            bs.andNot(bsNuc);
        }
    }

    private void createPuttyObject(BS bs) {
        float[] info = new float[]{(float)this.doubleSetting(378), (float)this.doubleSetting(377), (float)this.doubleSetting(382), (float)this.doubleSetting(379), (float)this.doubleSetting(380), (float)this.doubleSetting(381), (float)this.doubleSetting(581)};
        this.addJmolObject((int)1112152078, (BS)bs, (Object)info).translucency = this.getDoubleOrDefault(279);
    }

    private void createRibbonObject(BS bs) {
        boolean isTrace = this.doubleSetting(19) > 1.0;
        double r = this.doubleSetting(20) * 2.0;
        double rayScale = this.doubleSetting(327);
        if (r == 0.0) {
            r = this.doubleSetting(106) * (isTrace ? 1.0 : (rayScale <= 1.0 ? 0.5 : rayScale)) * 0.1;
        }
        JmolObject jo = this.setUniqueObjects(isTrace ? 10 : 9, bs, 235, this.getIntOrDefault(235), 0, 0.0, 0, 0.0, 0.0);
        jo.setSize(r);
        jo.translucency = this.getDoubleOrDefault(666);
    }

    private void createCartoonObject(String key, int sizeID) {
        BS bs = BSUtil.copy(this.ssMapAtom.get(key));
        if (bs == null) {
            return;
        }
        bs.and(this.bsCartoon);
        if (bs.isEmpty()) {
            return;
        }
        if (key.equals(" ")) {
            this.checkNucleicObject(bs, false);
            if (bs.isEmpty()) {
                return;
            }
        }
        JmolObject jo = this.setUniqueObjects(11, bs, 236, this.getIntOrDefault(236), 0, 0.0, 0, 0.0, 0.0);
        jo.setSize(this.doubleSetting(sizeID) * 2.0);
        jo.translucency = this.getDoubleOrDefault(279);
    }

    private JmolObject addObject(JmolObject obj) {
        this.jmolObjects.addLast(obj);
        return obj;
    }

    private void setGroupVisible(PyMOLGroup g, boolean parentVis) {
        boolean vis;
        boolean bl = vis = parentVis && g.visible;
        if (vis) {
            return;
        }
        g.visible = false;
        this.occludedObjects.put(g.objectNameID, Boolean.TRUE);
        this.htHiddenObjects.put(g.name, Boolean.TRUE);
        switch (g.type) {
            case 1: {
                this.bsHidden.or(g.bsAtoms);
                break;
            }
            default: {
                g.occluded = true;
            }
        }
        for (PyMOLGroup gg : g.list.values()) {
            this.setGroupVisible(gg, vis);
        }
    }

    BS getSSMapAtom(String ssType) {
        BS bs = this.ssMapAtom.get(ssType);
        if (bs == null) {
            bs = new BS();
            this.ssMapAtom.put(ssType, bs);
        }
        return bs;
    }

    Map<String, Object> setAtomDefs() {
        this.setGroupVisibilities();
        Hashtable<String, Object> defs = new Hashtable<String, Object>();
        for (Map.Entry<String, BS> e : this.htDefinedAtoms.entrySet()) {
            BS bs = e.getValue();
            if (bs.isEmpty()) continue;
            defs.put(e.getKey(), bs);
        }
        this.addJmolObject(12290, null, defs);
        return defs;
    }

    boolean needSelections() {
        return this.haveScenes || !this.htCarveSets.isEmpty();
    }

    void setUniqueBonds(BS bsBonds, boolean isSticks) {
        if (isSticks) {
            this.bsStickBonds.or(bsBonds);
            this.bsStickBonds.andNot(this.bsLineBonds);
        } else {
            this.bsLineBonds.or(bsBonds);
            this.bsLineBonds.andNot(this.bsStickBonds);
        }
    }

    private void finalizeUniqueBonds() {
        if (this.uniqueList == null) {
            return;
        }
        int bondCount = this.vwr.ms.bondCount;
        Bond[] bonds = this.vwr.ms.bo;
        int i = this.bsUniqueBonds.nextSetBit(0);
        while (i >= 0 && i < bondCount) {
            Bond b = bonds[i];
            double rad = Double.NaN;
            int id = this.uniqueList.get(i);
            boolean isStickBond = this.bsStickBonds.get(i);
            if (this.bsLineBonds.get(i)) {
                rad = this.getUniqueDoubleDef(id, 44) / 30.0;
            } else if (this.bsStickBonds.get(i)) {
                rad = this.getRadiusForBond(id, b.atom1.i, b.atom2.i);
            }
            int c = (int)this.getUniqueFloatDefVal(id, 376, 2.147483647E9);
            if (c != Integer.MAX_VALUE) {
                c = PyMOL.getRGB(c);
            }
            double v = this.getUniqueDoubleDef(id, 64);
            double t = this.getUniqueDoubleDef(id, 198);
            int scalex50 = (int)(v == 1.0 ? this.getUniqueDoubleDef(id, 512) * 50.0 : 0.0) & 0x3F;
            this.setUniqueBondParameters(b, this.thisState - 1, rad, v, c, t, scalex50, isStickBond);
            i = this.bsUniqueBonds.nextSetBit(i + 1);
        }
    }

    void setUniqueBondParameters(Bond b, int modelIndex, double rad, double pymolValence, int argb, double trans, int scalex50, boolean isStickBond) {
        if (modelIndex >= 0 && b.atom1.mi != modelIndex) {
            return;
        }
        if (!Double.isNaN(rad)) {
            b.mad = (short)(rad * 2000.0);
            if (rad > 0.0 && isStickBond) {
                this.addStickBall(b.atom1.i);
                this.addStickBall(b.atom2.i);
            }
        }
        short colix = b.colix;
        if (argb != Integer.MAX_VALUE) {
            colix = C.getColix(argb);
        }
        if (!Double.isNaN(trans)) {
            b.colix = C.getColixTranslucent3(colix, trans != 0.0, (float)trans);
        } else if (b.colix != colix) {
            b.colix = C.copyColixTranslucency(b.colix, colix);
        }
        if (pymolValence == 1.0) {
            b.order |= scalex50 << 2 | 0x18000;
        } else if (pymolValence == 0.0) {
            b.order |= 0x10000;
        }
    }

    private void addStickBall(int iatom) {
        this.addSpacefill(iatom, this.getStickBallRadius(this.jmolToUniqueID[iatom]), false);
    }

    void addMesh(int tok, Lst<Object> obj, String objName, boolean isMep) {
        JmolObject jo = this.addJmolObject(tok, null, obj);
        this.setSceneObject(objName, -1);
        int meshColor = this.getIntOrDefault(146);
        if (meshColor < 0) {
            meshColor = PyMOLReader.intAt(PyMOLReader.listAt(obj, 0), 2);
        }
        if (!isMep) {
            jo.setSize(this.getDoubleOrDefault(90));
            jo.argb = PyMOL.getRGB(meshColor);
        }
        jo.translucency = this.getDoubleOrDefault(138);
        jo.cacheID = this.surfaceInfoName;
    }

    JmolObject addIsosurface(String objectName) {
        JmolObject jo = this.addJmolObject(135180, null, objectName);
        jo.translucency = this.getDoubleOrDefault(138);
        jo.cacheID = this.surfaceInfoName;
        return jo;
    }

    private boolean isStickBall(int id) {
        return this.getUniqueDoubleDef(id, 276) == 1.0;
    }

    public double getStickBallRadius(int id) {
        return this.isStickBall(id) ? this.getUniqueDoubleDef(id, 21) * this.getUniqueDoubleDef(id, 277) : 0.0;
    }

    public int encodeMultipleBond(int uid, boolean isSpecial) {
        int scalex50 = (int)(isSpecial ? this.getUniqueDoubleDef(uid, 512) * 50.0 : 0.0) & 0x3F;
        return scalex50 << 2 | 0x18000;
    }

    public float getRadiusForBond(int id, int a1, int a2) {
        double rad = this.getUniqueDoubleDef(id, 21);
        if (this.bsHydrogen.get(a1) || this.bsHydrogen.get(a2)) {
            rad *= this.getUniqueDoubleDef(id, 605);
        }
        return (float)rad;
    }

    public void setNumAtoms(int nAtomsJmol) {
        this.jmolToUniqueID = new int[nAtomsJmol];
    }
}

