/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.SB;

public class XMLParser {
    private XmlEvent thisEvent = new XmlEvent(0);
    private DataBuffer buffer;
    public static final int TAG_NONE = 0;
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int START_END_ELEMENT = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 6;
    public static final int EOF = 8;

    public XMLParser(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return;
        }
        this.buffer = new DataBuffer(bufferedReader);
    }

    public String getBufferData() {
        return this.buffer == null ? null : this.buffer.data.toString().substring(0, this.buffer.ptr);
    }

    public String thisValue() throws Exception {
        return this.buffer.nextEvent().toString().trim();
    }

    public String qualifiedValue() throws Exception {
        this.buffer.nextTag();
        String string = this.buffer.nextEvent().toString().trim();
        this.buffer.nextTag();
        return string;
    }

    public int peek() throws Exception {
        this.thisEvent = this.buffer.peek();
        return this.thisEvent.getEventType();
    }

    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    public void nextTag() throws Exception {
        do {
            this.thisEvent = this.buffer.nextTag();
        } while (this.thisEvent.eventType == 6);
    }

    public int nextEvent() throws Exception {
        this.thisEvent = this.buffer.nextEvent();
        return this.thisEvent.getEventType();
    }

    public void nextStartTag() throws Exception {
        this.thisEvent = this.buffer.nextTag();
        while (!this.thisEvent.isStartElement()) {
            this.thisEvent = this.buffer.nextTag();
        }
    }

    public String getTagName() {
        return this.thisEvent.getTagName();
    }

    public int getTagType() {
        return this.thisEvent.getTagType();
    }

    public String getEndTag() {
        return this.thisEvent.getTagName();
    }

    public String nextValue() throws Exception {
        this.buffer.nextTag();
        return this.buffer.nextEvent().toString().trim();
    }

    public String getAttributeList() {
        return this.thisEvent.toString().toLowerCase();
    }

    public String getAttrValueLC(String string) {
        return this.getAttrValue(string).toLowerCase();
    }

    public String getAttrValue(String string) {
        String string2 = this.thisEvent.getAttributeByName(string);
        return string2 == null ? "" : string2;
    }

    public String getCharacters() throws Exception {
        SB sB = new SB();
        this.thisEvent = this.buffer.peek();
        int n = this.thisEvent.getEventType();
        while (n != 4) {
            this.thisEvent = this.buffer.nextEvent();
        }
        while (n == 4) {
            this.thisEvent = this.buffer.nextEvent();
            n = this.thisEvent.getEventType();
            if (n != 4) continue;
            sB.append(this.thisEvent.toString());
        }
        return sB.toString();
    }

    public String getOuterXML() throws Exception {
        int n = this.buffer.pt0;
        String string = this.thisEvent.getTagName();
        this.thisEvent = this.buffer.peek();
        while (this.thisEvent.getEventType() != 2 || !this.thisEvent.getTagName().equals(string)) {
            this.thisEvent = this.buffer.newXmlEvent();
        }
        return this.buffer.data.substring2(n, this.buffer.ptEnd);
    }

    public String getInnerXML() throws Exception {
        int n;
        int n2 = n = this.buffer.data.length();
        int n3 = n;
        String string = this.thisEvent.getTagName();
        this.thisEvent = this.buffer.peek();
        while (this.thisEvent.getEventType() != 2 || !this.thisEvent.getTagName().equals(string)) {
            n3 = n2;
            n2 = this.buffer.data.length();
            this.thisEvent = this.buffer.newXmlEvent();
        }
        return this.buffer.data.substring2(n, n3);
    }

    public boolean requiresEndTag() {
        int n = this.thisEvent.getTagType();
        return n != 3 && n != 6;
    }

    private class DataBuffer
    extends DataString {
        int pt0;

        DataBuffer(BufferedReader bufferedReader) {
            this.reader = bufferedReader;
        }

        boolean hasNext() {
            if (this.ptr == this.ptEnd) {
                try {
                    this.readLine();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return this.ptr < this.ptEnd;
        }

        @Override
        public boolean readLine() throws Exception {
            String string = this.reader.readLine();
            if (string == null) {
                return false;
            }
            this.data.append(String.valueOf(string) + "\n");
            this.ptEnd = this.data.length();
            return true;
        }

        XmlEvent peek() throws Exception {
            if (this.ptEnd - this.ptr < 2) {
                try {
                    this.readLine();
                }
                catch (Exception exception) {
                    return new XmlEvent(8);
                }
            }
            int n = this.ptr;
            XmlEvent xmlEvent = new XmlEvent(this);
            this.ptr = n;
            return xmlEvent;
        }

        XmlEvent nextTag() throws Exception {
            this.flush();
            this.skipTo('<', false);
            XmlEvent xmlEvent = new XmlEvent(this);
            return xmlEvent;
        }

        XmlEvent nextEvent() throws Exception {
            this.flush();
            return this.newXmlEvent();
        }

        protected XmlEvent newXmlEvent() throws Exception {
            this.pt0 = this.ptr;
            return new XmlEvent(this);
        }
    }

    private class DataString {
        SB data;
        protected BufferedReader reader;
        int ptr;
        int ptEnd;

        DataString() {
            this.data = new SB();
        }

        DataString(SB sB) {
            this.data = sB;
            this.ptEnd = sB.length();
        }

        int getNCharactersRemaining() {
            return this.ptEnd - this.ptr;
        }

        protected void flush() {
            if (this.data.length() < 1000 || this.ptEnd - this.ptr > 100) {
                return;
            }
            this.data = new SB().append(this.data.substring(this.ptr));
            this.ptr = 0;
            this.ptEnd = this.data.length();
        }

        String substring(int n, int n2) {
            return this.data.toString().substring(n, n2);
        }

        int skipOver(char c, boolean bl) throws Exception {
            if (this.skipTo(c, bl) > 0 && this.ptr != this.ptEnd) {
                ++this.ptr;
            }
            return this.ptr;
        }

        int skipTo(char c, boolean bl) throws Exception {
            char c2;
            if (this.data == null) {
                return -1;
            }
            if (this.ptr == this.ptEnd) {
                if (this.reader == null) {
                    return -1;
                }
                this.readLine();
            }
            int n = this.ptEnd - 1;
            while (this.ptr < this.ptEnd && (c2 = this.data.charAt(this.ptr)) != c) {
                if (bl && c2 == '\\' && this.ptr < n) {
                    c2 = this.data.charAt(this.ptr + 1);
                    if (c2 == '\"' || c2 == '\\') {
                        ++this.ptr;
                    }
                } else if (c2 == '\"') {
                    ++this.ptr;
                    if (this.skipTo('\"', true) < 0) {
                        return -1;
                    }
                }
                if (++this.ptr != this.ptEnd) continue;
                if (this.reader == null) {
                    return -1;
                }
                this.readLine();
            }
            return this.ptr;
        }

        public boolean readLine() throws Exception {
            return false;
        }
    }

    class Tag {
        int tagType;
        String name;
        String text;
        private Hashtable<String, String> attributes;

        Tag() {
        }

        Tag(String string) {
            this.text = string;
            this.tagType = string.startsWith("<!--") ? 6 : (string.charAt(1) == '/' ? 2 : (string.charAt(string.length() - 2) == '/' ? 3 : 1));
        }

        String getName() {
            if (this.name != null) {
                return this.name;
            }
            int n = this.tagType == 2 ? 2 : 1;
            int n2 = this.text.length() - (this.tagType == 3 ? 2 : 1);
            while (n < n2 && Character.isWhitespace(this.text.charAt(n))) {
                ++n;
            }
            int n3 = n;
            while (n < n2 && !Character.isWhitespace(this.text.charAt(n))) {
                ++n;
            }
            this.name = this.text.substring(n3, n).toLowerCase().trim();
            return this.name;
        }

        String getAttributeByName(String string) {
            if (this.attributes == null) {
                this.getAttributes();
            }
            return this.attributes.get(string.toLowerCase());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void getAttributes() {
            this.attributes = new Hashtable();
            DataString dataString = new DataString(new SB().append(this.text));
            try {
                if (dataString.skipTo(' ', false) < 0) {
                    return;
                }
                while (true) {
                    int n = ++dataString.ptr;
                    if (dataString.ptr < 0) {
                        return;
                    }
                    if (dataString.skipTo('=', false) < 0) {
                        return;
                    }
                    String string = dataString.substring(n, dataString.ptr).trim().toLowerCase();
                    dataString.skipTo('\"', false);
                    n = ++dataString.ptr;
                    dataString.skipTo('\"', true);
                    String string2 = dataString.substring(n, dataString.ptr);
                    this.attributes.put(string, string2);
                    int n2 = string.indexOf(":");
                    if (n2 < 0) continue;
                    string = string.substring(n2).trim();
                    this.attributes.put(string, string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class XmlEvent {
        int eventType = 0;
        private int ptr = 0;
        private Tag tag;
        private String data;

        public String toString() {
            return this.data != null ? this.data : (this.tag != null ? this.tag.text : null);
        }

        XmlEvent(int n) {
            this.eventType = n;
        }

        XmlEvent(DataBuffer dataBuffer) throws Exception {
            this.ptr = dataBuffer.ptr;
            int n = dataBuffer.getNCharactersRemaining();
            int n2 = n == 0 ? 8 : (n == 1 || dataBuffer.data.charAt(dataBuffer.ptr) != '<' ? 4 : (this.eventType = dataBuffer.data.charAt(dataBuffer.ptr + 1) != '/' ? 1 : 2));
            if (this.eventType == 8) {
                return;
            }
            if (this.eventType == 4) {
                dataBuffer.skipTo('<', false);
                this.data = dataBuffer.data.toString().substring(this.ptr, dataBuffer.ptr);
            } else {
                dataBuffer.skipOver('>', false);
                String string = dataBuffer.data.toString().substring(this.ptr, dataBuffer.ptr);
                if (string.startsWith("<!--")) {
                    this.eventType = 6;
                }
                this.tag = new Tag(string);
            }
        }

        public int getEventType() {
            return this.eventType;
        }

        boolean isStartElement() {
            return (this.eventType & 1) != 0;
        }

        public String getTagName() {
            return this.tag == null ? null : this.tag.getName();
        }

        public int getTagType() {
            return this.tag == null ? 0 : this.tag.tagType;
        }

        public String getAttributeByName(String string) {
            return this.tag == null ? null : this.tag.getAttributeByName(string);
        }
    }
}

