/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise the computation of squared difference.


This filter is parameterized over the types of the two input images
and the type of the output image.

Numeric conversions (castings) are done by the C++ defaults.

The filter will walk over all the pixels in the two input images, and
for each one of them it will do the following:


cast the input 1 pixel value to double

cast the input 2 pixel value to double

compute the difference of the two pixel values

compute the square of the difference

cast the double value resulting from sqr() to the pixel type of the
output image

store the casted value into the output image.
 The filter expect all images to have the same dimension (e.g. all 2D,
or all 3D, or all ND)
See:
 itk::simple::SquaredDifference for the procedural interface

 itk::SquaredDifferenceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSquaredDifferenceImageFilter.h
*/
public class SquaredDifferenceImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SquaredDifferenceImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SquaredDifferenceImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SquaredDifferenceImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SquaredDifferenceImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SquaredDifferenceImageFilter::~SquaredDifferenceImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SquaredDifferenceImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SquaredDifferenceImageFilter::SquaredDifferenceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SquaredDifferenceImageFilter() {
    this(SimpleITKJNI.new_SquaredDifferenceImageFilter(), true);
  }

  /**
std::string itk::simple::SquaredDifferenceImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SquaredDifferenceImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SquaredDifferenceImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SquaredDifferenceImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SquaredDifferenceImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.SquaredDifferenceImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::SquaredDifferenceImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.SquaredDifferenceImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::SquaredDifferenceImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.SquaredDifferenceImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

}
