/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.Point3;
import org.jetbrains.skia.ShadowUtilsKt;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.Stats;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skia/ShadowUtils;", "", "<init>", "()V", "drawShadow", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "path", "Lorg/jetbrains/skia/Path;", "zPlaneParams", "Lorg/jetbrains/skia/Point3;", "lightPos", "lightRadius", "", "ambientColor", "", "spotColor", "transparentOccluder", "", "geometricOnly", "computeTonalAmbientColor", "computeTonalSpotColor", "skiko"})
public final class ShadowUtils {
    @NotNull
    public static final ShadowUtils INSTANCE = new ShadowUtils();

    private ShadowUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawShadow(@NotNull Canvas canvas, @NotNull Path path, @NotNull Point3 zPlaneParams, @NotNull Point3 lightPos, float lightRadius, int ambientColor, int spotColor, boolean transparentOccluder, boolean geometricOnly) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)zPlaneParams, (String)"zPlaneParams");
        Intrinsics.checkNotNullParameter((Object)lightPos, (String)"lightPos");
        Stats.INSTANCE.onNativeCall();
        int flags = 0;
        if (transparentOccluder) {
            flags |= 1;
        }
        if (geometricOnly) {
            flags |= 2;
        }
        try {
            ShadowUtilsKt.access$_nDrawShadow(NativeKt.getPtr(canvas), NativeKt.getPtr(path), zPlaneParams.getX(), zPlaneParams.getY(), zPlaneParams.getZ(), lightPos.getX(), lightPos.getY(), lightPos.getZ(), lightRadius, ambientColor, spotColor, flags);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(canvas);
            Native_jvmKt.reachabilityBarrier(path);
        }
    }

    public final int computeTonalAmbientColor(int ambientColor, int spotColor) {
        Stats.INSTANCE.onNativeCall();
        return ShadowUtilsKt.access$_nComputeTonalAmbientColor(ambientColor, spotColor);
    }

    public final int computeTonalSpotColor(int ambientColor, int spotColor) {
        Stats.INSTANCE.onNativeCall();
        return ShadowUtilsKt.access$_nComputeTonalSpotColor(ambientColor, spotColor);
    }

    static {
        Library.Companion.staticLoad();
    }
}

