/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.daemon.impl.analysis.PsiReferenceWithUnresolvedQuickFixes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public final class JavaFxEventHandlerReference
extends PsiReferenceBase<XmlAttributeValue>
implements PsiReferenceWithUnresolvedQuickFixes {
    final PsiMethod myEventHandler;
    final PsiClass myController;

    public JavaFxEventHandlerReference(XmlAttributeValue element, PsiMethod method, PsiClass controller) {
        super((PsiElement)element);
        this.myEventHandler = method;
        this.myController = controller;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myEventHandler;
    }

    public Object @NotNull [] getVariants() {
        if (this.myController == null) {
            if (EMPTY_ARRAY == null) {
                JavaFxEventHandlerReference.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiMethod> availableHandlers = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : this.myController.getAllMethods()) {
            if (!JavaFxEventHandlerReference.isHandlerMethodSignature(psiMethod, this.myController) || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)psiMethod)) continue;
            availableHandlers.add(psiMethod);
        }
        Object[] objectArray = availableHandlers.isEmpty() ? EMPTY_ARRAY : ArrayUtil.toObjectArray(availableHandlers);
        if (objectArray == null) {
            JavaFxEventHandlerReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public static boolean isHandlerMethodSignature(@NotNull PsiMethod psiMethod, @NotNull PsiClass controllerClass) {
        PsiClass containingClass;
        if (psiMethod == null) {
            JavaFxEventHandlerReference.$$$reportNull$$$0(2);
        }
        if (controllerClass == null) {
            JavaFxEventHandlerReference.$$$reportNull$$$0(3);
        }
        if ((containingClass = psiMethod.getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length == 1) {
                PsiType parameterType = parameters[0].getType();
                if (containingClass != null && !controllerClass.isEquivalentTo((PsiElement)containingClass)) {
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)controllerClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    parameterType = substitutor.substitute(parameterType);
                }
                if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"javafx.event.Event")) {
                    return true;
                }
            }
            return parameters.length == 0;
        }
        return false;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange range = super.getRangeInElement();
        return new TextRange(range.getStartOffset() + 1, range.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isHandlerMethodSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

