/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.uk.AgreementSet;
import java.util.List;
import one.util.streamex.StreamEx;

class GrammarRules {
    private static final NodePattern smthWithNumber = NodePattern.N.lemma("\u043a\u043b\u0430\u0441|\u0432\u0430\u0433\u043e\u043d|\u0430\u0432\u0442\u043e\u0431\u0443\u0441|\u0442\u0440\u0430\u043c\u0432\u0430\u0439|\u0442\u0440\u043e\u043b\u0435\u0439\u0431\u0443\u0441|\u0431\u0443\u0434\u0438\u043d\u043e\u043a|\u043a\u0430\u0431\u0456\u043d\u0435\u0442|\u043a\u0432\u0430\u0440\u0442\u0438\u0440\u0430|\u0437\u0443\u0431");
    private static final String NE_BETTER_MSG = "\u041c\u0430\u0454\u0442\u044c\u0441\u044f \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u043d\u0430\u0439\u0432\u0438\u0449\u0438\u0439 \u0441\u0442\u0443\u043f\u0456\u043d\u044c \u043f\u043e\u0440\u0456\u0432\u043d\u044f\u043d\u043d\u044f?";

    GrammarRules() {
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Grammar.GOVERNMENT", "\u0423\u043f\u0440\u0430\u0432\u043b\u0456\u043d\u043d\u044f", "\u041f\u043e\u043c\u0438\u043b\u043a\u0438 \u0432\u0438\u0431\u043e\u0440\u0443 \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0430\u0445 \u0442\u0430 \u0456\u043d\u0448\u0438\u0445 \u0447\u0430\u0441\u0442\u0438\u043d\u0430\u0445 \u043c\u043e\u0432\u0438.", "https://miyklas.com.ua/p/ukrainska-mova/11-klas/morfologichna-norma-379685/chislivnik-skladni-vipadki-uzgodzhennia-i-vidminiuvannia-chislivnika-379884/re-f2eda738-76a3-461f-8dbe-5e8569cb0358", () -> NodePattern.or(GrammarRules.nezvazhajuchiNe(), GrammarRules.zgidnoZ(), GrammarRules.vikU(), GrammarRules.bil(), CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("root|parataxis(:discourse)?|flat:abs|appos|advcl|xcomp|nsubj(:pass)?|i?obj|obl|nmod|compound")).andNot(AgreementSet.nonMain.trace("nonMain")).and((node, match) -> {
            AgreementSet set = AgreementSet.create(node);
            return set == null ? null : set.check(match);
        })), new Example("\u041f\u0440\u043e\u0431\u0430\u0447 <b>\u043c\u0435\u043d\u0435</b>", "\u041f\u0440\u043e\u0431\u0430\u0447 <b>\u043c\u0435\u043d\u0456</b>"), new Example("\u0423 \u0432\u0456\u043a\u043d\u043e \u0434\u0438\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0432\u0441\u043b\u0456\u0434 <b>\u0434\u043e\u0440\u043e\u0433\u0456\u0439 \u043b\u044e\u0434\u0438\u043d\u0438</b>", "\u0423 \u0432\u0456\u043a\u043d\u043e \u0434\u0438\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0432\u0441\u043b\u0456\u0434 <b>\u0434\u043e\u0440\u043e\u0433\u0456\u0439 \u043b\u044e\u0434\u0438\u043d\u0456</b>", "\u0423 \u0432\u0456\u043a\u043d\u043e \u0434\u0438\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0432\u0441\u043b\u0456\u0434 <b>\u0434\u043e\u0440\u043e\u0433\u0438\u043c \u043b\u044e\u0434\u044f\u043c</b>"), new Example("\u0417\u0430\u043f\u0443\u0441\u043a \u0432\u0456\u0434\u0431\u0443\u0432\u0441\u044f \u043d\u0430 \u043f\u0456\u0432\u0442\u043e\u0440\u0430 <b>\u043c\u0456\u0441\u044f\u0446\u0456</b> \u043f\u0456\u0437\u043d\u0456\u0448\u0435.", "\u0417\u0430\u043f\u0443\u0441\u043a \u0432\u0456\u0434\u0431\u0443\u0432\u0441\u044f \u043d\u0430 \u043f\u0456\u0432\u0442\u043e\u0440\u0430 <b>\u043c\u0456\u0441\u044f\u0446\u044f</b> \u043f\u0456\u0437\u043d\u0456\u0448\u0435."), new Example("\u041c\u043e\u0436\u043b\u0438\u0432\u0456 \u0442\u0430\u043a\u043e\u0436 <b>\u0433\u043e\u043b\u043e\u0432\u043d\u0430</b> \u0431\u0456\u043b\u044c \u0442\u0430 \u043b\u0438\u0445\u043e\u043c\u0430\u043d\u043a\u0430.", "\u041c\u043e\u0436\u043b\u0438\u0432\u0456 \u0442\u0430\u043a\u043e\u0436 <b>\u0433\u043e\u043b\u043e\u0432\u043d\u0438\u0439</b> \u0431\u0456\u043b\u044c \u0442\u0430 \u043b\u0438\u0445\u043e\u043c\u0430\u043d\u043a\u0430.")).honorCrazyParses(), new Rule.PatternRule("Grammar.WORD_REPETITION", "\u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u043d\u044f \u0441\u043b\u043e\u0432\u0430", "\u0414\u0432\u0430 \u043e\u0434\u043d\u0430\u043a\u043e\u0432\u0456 \u0441\u043b\u043e\u0432\u0430 \u043f\u043e\u0441\u043f\u0456\u043b\u044c \u0448\u0432\u0438\u0434\u0448\u0435 \u0437\u0430 \u0432\u0441\u0435 \u0454 \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u044e.", null, () -> CommonPatterns.repeatedWord((n1, n2) -> true).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).message("\u0412\u0438\u043f\u0430\u0434\u043a\u043e\u0432\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u043d\u044f \u00ab$_\u00bb?"), new Example("\u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0435 <b>\u0441\u043b\u043e\u0432\u043e \u0441\u043b\u043e\u0432\u043e</b> \u0454 \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u044e", "\u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0435 <b>\u0441\u043b\u043e\u0432\u043e</b> \u0454 \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u044e")), new Rule.PatternRule("Grammar.UNEXPECTED_VERB", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0435 \u043f\u043e\u0454\u0434\u043d\u0430\u043d\u043d\u044f \u0437 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430\u043c\u0438", "\u0414\u0456\u0454\u0441\u043b\u043e\u0432\u043e \u043f\u043e\u0433\u0430\u043d\u043e \u043f\u043e\u0454\u0434\u043d\u0443\u0454\u0442\u044c\u0441\u044f \u0437 \u0434\u0435\u044f\u043a\u0438\u043c\u0438 \u0434\u043e\u0442\u0438\u0447\u043d\u0438\u043c\u0438 \u0447\u0430\u0441\u0442\u0438\u043d\u0430\u043c\u0438 \u043c\u043e\u0432\u0438 \u0432 \u0440\u0435\u0447\u0435\u043d\u043d\u0456.", null, () -> GrammarRules.unexpectedVerb(), new Example("\u0429\u043e\u0431 <b>\u043f\u0440\u0438 \u043f\u0440\u0438\u0454\u0434\u043d\u0430\u0442\u0438\u0441\u044f</b> \u0434\u043e \u043f\u0440\u043e\u0454\u043a\u0442\u0443, \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043d\u0430\u0434\u0456\u0441\u043b\u0430\u0442\u0438 \u0440\u0435\u0437\u044e\u043c\u0435.", "\u0429\u043e\u0431 <b>\u043f\u0440\u0438\u0454\u0434\u043d\u0430\u0442\u0438\u0441\u044f</b> \u0434\u043e \u043f\u0440\u043e\u0454\u043a\u0442\u0443, \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043d\u0430\u0434\u0456\u0441\u043b\u0430\u0442\u0438 \u0440\u0435\u0437\u044e\u043c\u0435.")).honorCrazyParses(), new Rule.PatternRule("Grammar.INFINITIVE_EXPECTED", "\u041f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0430 \u0444\u043e\u0440\u043c\u0430 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430", "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e \u0432 \u043d\u0435\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0456\u0439 \u0444\u043e\u0440\u043c\u0456 (\u0456\u043d\u0444\u0456\u043d\u0456\u0442\u0438\u0432).", null, () -> GrammarRules.infinitiveExpected(), new Example("\u0422\u0443\u0442 \u043d\u0435 \u043f\u043e\u0432\u0438\u043d\u043d\u043e <b>\u0437\u0430\u043b\u0438\u0448\u0438\u043b\u0430\u0441\u044f</b> \u0436\u043e\u0434\u043d\u043e\u0457 \u043f\u043e\u043c\u0438\u043b\u043a\u0438.", "\u0422\u0443\u0442 \u043d\u0435 \u043f\u043e\u0432\u0438\u043d\u043d\u043e <b>\u0437\u0430\u043b\u0438\u0448\u0438\u0442\u0438\u0441\u044f</b> \u0436\u043e\u0434\u043d\u043e\u0457 \u043f\u043e\u043c\u0438\u043b\u043a\u0438.", "\u0422\u0443\u0442 \u043d\u0435 \u043f\u043e\u0432\u0438\u043d\u043d\u043e <b>\u0437\u0430\u043b\u0438\u0448\u0438\u0442\u0438\u0441\u044c</b> \u0436\u043e\u0434\u043d\u043e\u0457 \u043f\u043e\u043c\u0438\u043b\u043a\u0438.")), new Rule.PatternRule("Grammar.FRACTIONS", "\u0406\u043c\u0435\u043d\u043d\u0438\u043a \u043f\u0456\u0441\u043b\u044f \u0434\u0440\u043e\u0431\u0443", "\u0406\u043c\u0435\u043d\u043d\u0438\u043a \u043f\u0456\u0441\u043b\u044f \u0434\u0440\u043e\u0431\u0443 \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0432 \u0440\u043e\u0434\u043e\u0432\u043e\u043c\u0443 \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0443.", "https://slovnyk.ua/pravopys.php?prav_par=107", () -> NodePattern.or(GrammarRules.genitivePercentAfterFraction(), GrammarRules.fractionNumerator(), GrammarRules.fractionDenominator()), new Example("\u0414\u0432\u0456 <b>\u043f'\u044f\u0442\u0456</b> (41,3%) \u044f\u043a\u0449\u043e \u043c\u0430\u044e\u0442\u044c \u0437\u0430 \u0449\u043e \u043a\u0443\u043f\u0443\u0432\u0430\u0442\u0438 \u0457\u0436\u0443, \u0442\u043e \u043d\u0435 \u043c\u0430\u044e\u0442\u044c \u043a\u043e\u0448\u0442\u0456\u0432 \u043d\u0430 \u043e\u0434\u044f\u0433 \u0447\u0438 \u0432\u0437\u0443\u0442\u0442\u044f.", "\u0414\u0432\u0456 <b>\u043f'\u044f\u0442\u0438\u0445</b> (41,3%) \u044f\u043a\u0449\u043e \u043c\u0430\u044e\u0442\u044c \u0437\u0430 \u0449\u043e \u043a\u0443\u043f\u0443\u0432\u0430\u0442\u0438 \u0457\u0436\u0443, \u0442\u043e \u043d\u0435 \u043c\u0430\u044e\u0442\u044c \u043a\u043e\u0448\u0442\u0456\u0432 \u043d\u0430 \u043e\u0434\u044f\u0433 \u0447\u0438 \u0432\u0437\u0443\u0442\u0442\u044f.")), new Rule.PatternRule("Grammar.NOT_BETTER_SHOULD_BE_NOT_THE_BEST", "\u00ab\u041a\u0440\u0430\u0449\u0438\u0439\u00bb \u0447\u0438 \u00ab\u043d\u0430\u0439\u043a\u0440\u0430\u0449\u0438\u0439\u00bb \u0437 \u00ab\u043d\u0435\u00bb", "\u0423\u0436\u0438\u0432\u0430\u0442\u0438 \u0441\u043b\u043e\u0432\u043e \u00ab\u043a\u0440\u0430\u0449\u0438\u0439\u00bb \u0443 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u0456 \u00ab\u043d\u0430\u0439\u043a\u0440\u0430\u0449\u0438\u0439\u00bb \u2013 \u043f\u043e\u043c\u0438\u043b\u043a\u0430.", "https://pustunchik.ua/ua/online-school/linguistics/luchshiy-i-nailuchshiy", () -> GrammarRules.betterWithNot(), new Example("\u0414\u0430\u043b\u0435\u043a\u043e \u043d\u0435 <b>\u043a\u0440\u0430\u0449\u0438\u0439</b> \u0432\u0438\u0441\u0442\u0443\u043f \u043d\u0430 \u0404\u0432\u0440\u043e\u0431\u0430\u0447\u0435\u043d\u043d\u0456.", "\u0414\u0430\u043b\u0435\u043a\u043e \u043d\u0435 <b>\u043d\u0430\u0439\u043a\u0440\u0430\u0449\u0438\u0439</b> \u0432\u0438\u0441\u0442\u0443\u043f \u043d\u0430 \u0404\u0432\u0440\u043e\u0431\u0430\u0447\u0435\u043d\u043d\u0456.")));
    }

    private static NodePattern vikU() {
        return NodePattern.N.formCaseSensitive("\u0432\u0456\u043a\u0430").pos("noun.*rod.*").andNot(NodePattern.N.directlyAfter(NodePattern.N.pos(".*:p:.*"))).message("\u0420\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a - \u00ab\u0432\u0456\u043a\u0443\u00bb").correct(NodeCorrector.replace("\u0432\u0456\u043a\u0443"));
    }

    private static NodePattern bil() {
        return NodePattern.or(NodePattern.N.pos("adj:f:.*").withHead("amod", NodePattern.N.lemma("\u0431\u0456\u043b\u044c").pos("noun:inanim:m:.*")).correct(NodeCorrector.inflect("adj:f:v_zna:(.*)", "adj:m:v_zna:rinanim:$1")).correct(NodeCorrector.inflect("adj:f:(.*)", "adj:m:$1")), NodePattern.N.form("\u0431\u043e\u043b\u0456").noDependents("case").withDependent("amod", NodePattern.N.pos("adj:[fm]:.*").noPos("adj:p.*")).correct(NodeCorrector.replace("\u0431\u043e\u043b\u044e"))).message("\u0421\u043b\u043e\u0432\u043e \u00ab\u0431\u0456\u043b\u044c\u00bb \u0432\u0456\u0434\u043d\u043e\u0441\u0438\u0442\u044c\u0441\u044f \u0434\u043e \u0447\u043e\u043b\u043e\u0432\u0456\u0447\u043e\u0433\u043e \u0440\u043e\u0434\u0443");
    }

    private static NodePattern unexpectedVerb() {
        NodePattern verb = NodePattern.N.pos("verb.*").noPos(".*(noun|adv).*").andNot(CommonPatterns.capitalizedMiddle).includeIntoReport().andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE));
        return NodePattern.N.directlyBeforeHead().withHeadRelation("obl:npmod|cc|case|discourse|advmod").pos("prep.*").noPos(".*(noun|adv).*").directlyBefore(verb).andNot(NodePattern.N.form("\u043e").withHeadRelation("discourse")).noForm("\u043a\u0440\u0456\u043c").andNot(NodePattern.N.inFormSequence(0, "\u0437\u0430\u0434\u043b\u044f", "\u0433\u043e\u0434\u0438\u0442\u044c\u0441\u044f")).andNot(NodePattern.N.inFormSequence(0, "\u043d\u0430", "\u0432\u0438\u043d\u0456\u0441")).message("\u0417\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u043f\u0435\u0440\u0435\u0434 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e\u043c").andOptionally(NodePattern.N.form("\u043d\u0430").directlyAfter(NodePattern.N.pos("verb.*")).correct(NodeCorrector.replace("\u0442\u0430"))).includeIntoReport().correct(NodeCorrector.replace(""));
    }

    private static NodePattern zgidnoZ() {
        NodeCorrector.Relative toOru = NodeCorrector.inflect("(.*)(dav|kly|mis|naz|oru|rod|zna)(.*)", "$1oru$3");
        return NodePattern.or(NodePattern.N.directlyAfter(NodePattern.N.form("\u0437\u0433\u0456\u0434\u043d\u043e")).pos("(noun|adj).*").correct(toOru.join(NodeCorrector.insertBefore("\u0437 "))), NodePattern.N.pos("(noun|adj).*").noHeadRelation("compound").withNeighbor(-2, NodePattern.N.form("\u0437\u0433\u0456\u0434\u043d\u043e")).withNeighbor(-1, NodePattern.N.pos("prep.*").markAs("Prep")).andNot(NodePattern.N.pos(".*oru.*").directlyAfter(NodePattern.N.form("\u0456?\u0437|\u0437\u0456"))).correct(toOru.join(NodeCorrector.replace(NodePointer.marked("Prep"), "\u0437")))).message("\u041f\u0456\u0441\u043b\u044f \u00ab\u0437\u0433\u0456\u0434\u043d\u043e\u00bb \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u00ab\u0437\u00bb \u0442\u0430 \u0456\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a");
    }

    private static NodePattern infinitiveExpected() {
        NodePattern governorHead = NodePattern.N.lemma("\u0432\u0430\u0440\u0442\u043e|\u043f\u043e\u0432\u0438\u043d\u043d\u043e|\u043f\u043e\u0432\u0438\u043d\u043d\u0438\u0439|\u043c\u0443\u0441\u0438\u0442\u0438|\u043c\u0430\u0442\u0438|\u043c\u043e\u0433\u0442\u0438|\u0431\u0430\u0436\u0430\u0442\u0438|\u0431\u043b\u0430\u0433\u0430\u0442\u0438").noDependents("cop|ccomp|xcomp|csubj", NodePattern.N.pos("verb:.*inf")).andNot(NodePattern.N.lemma("\u043c\u0430\u0442\u0438").andOr(NodePattern.N.noPos("verb.*"), NodePattern.N.withDependent("obj"))).markAs("Gov");
        return NodePattern.N.pos("verb:.*(past|pres|futr|impr).*").noPos(".*inf.*").noDependents("cop|mark").andOr(NodePattern.N.withHead("csubj", NodePattern.N.form("\u0442\u0440\u0435\u0431\u0430").markAs("Gov")), NodePattern.N.withHead("ccomp|xcomp|csubj|obl", governorHead), NodePattern.N.withDependent("nsubj|advmod", governorHead.noForm("\u043c\u0430\u043b[\u0430\u043e]?|\u043c\u0430\u0442\u0438")), NodePattern.N.withHead("cop", NodePattern.or(NodePattern.N.withHead("xcomp", governorHead), governorHead.noDependents("xcomp", NodePattern.N.pos("verb.*")).noForm("\u043c\u0430\u043b\u043e")).noDependents("cop|ccomp|xcomp|csubj", NodePattern.N.pos("verb:.*inf.*")))).after("Gov").message("\u041f\u0456\u0441\u043b\u044f \u00ab$Gov\u00bb \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u043d\u0435\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0443 \u0444\u043e\u0440\u043c\u0443 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430").correct(NodeCorrector.inflect("verb:.*", "verb:.*inf"));
    }

    private static NodePattern nezvazhajuchiNe() {
        return NodePattern.N.inFormSequence(1, "\u0437\u0432\u0430\u0436\u0430\u044e\u0447\u0438|\u043d\u0435\u0437\u0432\u0430\u0436\u0430\u044e\u0447\u0438", "\u043d\u0435").andNot(NodePattern.N.directlyBefore(NodePattern.N.directlyBefore(NodePattern.N.form("\u043d\u0430")))).message("\u0417\u0430\u043c\u0456\u043d\u0438\u0442\u0438 \u043d\u0430 \"\u043d\u0430\"?").correct(NodeCorrector.replace("\u043d\u0430"));
    }

    private static NodePattern genitivePercentAfterFraction() {
        return NodePattern.N.form("\u0432\u0456\u0434\u0441\u043e\u0442\u043a\u0438").withNeighbor(-1, NodePattern.N.pos("(.*:)?numr(:.*)?")).withNeighbor(-2, NodePattern.N.pos("numr(:.*)?")).correct(NodeCorrector.inflect("(.*)p:v_naz(.*)", "$1[mfn]?:v_rod$2")).message("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0435 \u0437\u0430\u043a\u0456\u043d\u0447\u0435\u043d\u043d\u044f \u0441\u043b\u043e\u0432\u0430 \u043f\u0456\u0441\u043b\u044f \u0434\u0440\u043e\u0431\u0443");
    }

    private static NodePattern fractionNumerator() {
        return NodePattern.or(NodePattern.N.form("\u0434\u0432\u0430").correct(NodeCorrector.replace("\u0434\u0432\u0456")).message("\u0417\u0430\u043c\u0456\u043d\u0438\u0442\u0438 \u043d\u0430 \u00ab\u0434\u0432\u0456\u00bb?"), NodePattern.N.form("\u043f\u0456\u0432\u0442\u043e\u0440\u0430").correct(NodeCorrector.replace("\u043f\u0456\u0432\u0442\u043e\u0440\u0438")).message("\u0417\u0430\u043c\u0456\u043d\u0438\u0442\u0438 \u043d\u0430 \u00ab\u043f\u0456\u0432\u0442\u043e\u0440\u0438\u00bb?")).directlyBefore(NodePattern.N.pos(".*adj:p:v_rod:numr.*").andNot(NodePattern.N.directlyBefore(smthWithNumber)));
    }

    private static NodePattern fractionDenominator() {
        return NodePattern.N.pos(".*naz:numr.*").noLemma("\u043e\u0434\u0438\u043d\u0438\u0446\u044f|\u0434\u0435\u0441\u044f\u0442\u043e\u043a|\u0442\u0438\u0441\u044f\u0447\u0430|\u043c\u0456\u043b\u044c\u0439\u043e\u043d|\u043c\u0456\u043b\u044c\u044f\u0440\u0434|\u043f\u0435\u0440\u0448\u0438\u0439").directlyAfter(NodePattern.N.form("(\u0434\u0432\u0456|\u0442\u0440\u0438|\u0447\u043e\u0442\u0438\u0440\u0438)")).correct(NodeCorrector.inflect("(.*)p:v_naz(.*)", "$1p:v_rod$2")).message("\u0417\u0430\u043c\u0456\u043d\u0438\u0442\u0438 \u043d\u0430 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a?");
    }

    private static NodePattern betterWithNot() {
        return NodePattern.N.lemma("\u043a\u0440\u0430\u0449\u0438\u0439").pos("adj:.*").withNeighbor(-1, NodePattern.N.lemma("\u043d\u0435")).withNeighbor(-2, NodePattern.N.andOr(NodePattern.N.lemma("\u0447\u0438|\u0434\u0430\u043b\u0435\u043a\u043e|\u0431\u0443\u0442\u0438|\u0437\u0430\u0440\u0430\u0437"), NodePattern.N.withHeadRelation("punct"))).andNot(NodePattern.custom((node, match) -> {
            if (((StreamEx)node.forward().limit(3L)).anyMatch(n -> n.hasLemma("\u043d\u0456\u0436|\u0437\u0430"))) {
                return match;
            }
            return null;
        })).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.lemma("\u0456")).withNeighbor(2, NodePattern.N.lemma("\u043d\u0435")).withNeighbor(3, NodePattern.N.lemma("\u0433\u0456\u0440\u0448\u0438\u0439"))).message(NE_BETTER_MSG).correct(NodeCorrector.regexReplace("\u043a\u0440\u0430\u0449(.*)", "\u043d\u0430\u0439\u043a\u0440\u0430\u0449$1"));
    }
}

