/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import org.gradle.internal.buildoption.Option;

public abstract class InternalOption<T>
implements Option {
    private static final String INTERNAL_PROPERTY_PREFIX = "org.gradle.internal.";
    private final String propertyName;

    public InternalOption(String propertyName) {
        if (!InternalOption.isInternalOption(propertyName)) {
            throw new IllegalArgumentException("Internal property name must start with 'org.gradle.internal.', got '" + propertyName + "'");
        }
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public abstract T getDefaultValue();

    public abstract T convert(String var1);

    public String toString() {
        return "InternalOption('" + this.getPropertyName() + "', default=" + this.getDefaultValue() + ")";
    }

    private static boolean isInternalOption(String name) {
        return name.startsWith(INTERNAL_PROPERTY_PREFIX) || name.startsWith("org.gradle.unsafe.") || name.startsWith("org.gradle.configuration-cache.internal.");
    }
}

