---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: PHP Remote File Inclusion
---

## Description

The server is vulnerable to PHP Remote File Inclusion (RFI), which enables attackers to load
remote files and have them executed as PHP scripts on the server side. This vulnerability occurs
when untrusted user input is directly used in script inclusion without proper validation. Attackers
can leverage this vulnerability to include and execute arbitrary remote files, potentially
compromising the system's integrity and confidentiality.

## Remediation

Avoid using user-controlled data directly in `include` and `require` statements and instead consider
an allow-list approach for dynamically including scripts.

If possible, also consider setting `allow_url_include=Off` in the server's PHP configuration to
ensure URLs cannot be used in `include` and `require` statements.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 98.1 | false | 98 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/98.html)
- [File inclusion Vulnerability - Wikipedia](https://en.wikipedia.org/wiki/File_inclusion_vulnerability)
