# frozen_string_literal: true

class FinalizeBackfillArchivedAndTraversalIdsToVulnerabilityStatistics < Gitlab::Database::Migration[2.2]
  milestone '18.0'

  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION_NAME = "BackfillArchivedAndTraversalIdsToVulnerabilityStatistics"

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: MIGRATION_NAME,
      table_name: :vulnerability_statistics,
      column_name: :id,
      job_arguments: []
    )
  end

  def down
    # no-op
  end
end
