/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.bkmk;

import com.google.gson.JsonElement;
import ghidra.program.model.listing.Bookmark;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.bkmk.ExtBookmark;
import sarif.managers.BookmarksSarifMgr;

public class SarifBookmarkWriter
extends AbstractExtWriter {
    private List<Bookmark> bookmarks = new ArrayList<Bookmark>();

    public SarifBookmarkWriter(List<Bookmark> target, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.bookmarks = target;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genBookmarks(monitor);
        this.root.add("bookmarks", (JsonElement)this.objects);
    }

    private void genBookmarks(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.bookmarks.size());
        for (Bookmark b : this.bookmarks) {
            ExtBookmark isf = new ExtBookmark(b);
            SarifObject sarif = new SarifObject(BookmarksSarifMgr.SUBKEY, BookmarksSarifMgr.KEY, this.getTree(isf), b.getAddress(), b.getAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

