/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidatedListener;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class DataTypeIndexer {
    private List<DataTypeManager> dataTypeManagers = new ArrayList<DataTypeManager>();
    private List<DataType> dataTypeList = Collections.emptyList();
    private DataTypeIndexUpdateListener listener = new DataTypeIndexUpdateListener();
    private volatile boolean isStale = true;
    private List<CategoryPath> categoryPathList = Collections.emptyList();

    public synchronized void addDataTypeManager(DataTypeManager dataTypeManager) {
        if (!this.dataTypeManagers.contains(dataTypeManager)) {
            dataTypeManager.addDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
            dataTypeManager.addInvalidatedListener((InvalidatedListener)this.listener);
            this.dataTypeManagers.add(dataTypeManager);
            this.markStale();
        }
    }

    public synchronized void removeDataTypeManager(DataTypeManager dataTypeManager) {
        if (this.dataTypeManagers.contains(dataTypeManager)) {
            dataTypeManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
            dataTypeManager.removeInvalidatedListener((InvalidatedListener)this.listener);
            this.dataTypeManagers.remove(dataTypeManager);
            this.markStale();
        }
    }

    public synchronized List<DataType> getSortedDataTypeList() {
        List<DataType> newList = this.updateDataTypeList();
        if (this.isStale) {
            return newList;
        }
        this.dataTypeList = newList;
        return Collections.unmodifiableList(newList);
    }

    public List<CategoryPath> getSortedCategoryPathList() {
        this.updateDataTypeList();
        return this.categoryPathList;
    }

    private List<DataType> updateDataTypeList() {
        if (!this.isStale) {
            return this.dataTypeList;
        }
        this.isStale = false;
        IndexerTask task = new IndexerTask();
        if (SwingUtilities.isEventDispatchThread()) {
            TaskLauncher.launch((Task)task);
        } else {
            task.run(TaskMonitor.DUMMY);
        }
        List<DataType> newDataTypeList = task.getList();
        this.categoryPathList = task.getCategoryPathList();
        return newDataTypeList;
    }

    private void markStale() {
        this.isStale = true;
        this.dataTypeList = Collections.emptyList();
        this.categoryPathList = Collections.emptyList();
    }

    private class DataTypeIndexUpdateListener
    implements DataTypeManagerChangeListener,
    InvalidatedListener {
        private DataTypeIndexUpdateListener() {
        }

        public void dataTypeManagerInvalidated(DataTypeManager dataTypeManager) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            DataTypeIndexer.this.markStale();
        }

        public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
        }

        public void sourceArchiveAdded(DataTypeManager dtm, SourceArchive dataTypeSource) {
            DataTypeIndexer.this.markStale();
        }

        public void sourceArchiveChanged(DataTypeManager dtm, SourceArchive dataTypeSource) {
            DataTypeIndexer.this.markStale();
        }

        public void programArchitectureChanged(DataTypeManager dataTypeManager) {
            DataTypeIndexer.this.markStale();
        }

        public void restored(DataTypeManager dataTypeManager) {
            DataTypeIndexer.this.markStale();
        }
    }

    private class IndexerTask
    extends Task {
        private List<DataType> dataTypes;
        private List<CategoryPath> categories;
        private Set<CategoryPath> categorySet;

        IndexerTask() {
            super("Data Type Indexer Task", false, true, true);
            this.dataTypes = new ArrayList<DataType>();
            this.categories = new ArrayList<CategoryPath>();
            this.categorySet = new HashSet<CategoryPath>();
        }

        public void run(TaskMonitor monitor) {
            monitor.initialize((long)DataTypeIndexer.this.dataTypeManagers.size());
            monitor.setMessage("Preparing to index data types...");
            for (DataTypeManager dtm : DataTypeIndexer.this.dataTypeManagers) {
                monitor.setMessage("Searching " + dtm.getName());
                dtm.getAllDataTypes(this.dataTypes);
                Category root = dtm.getRootCategory();
                this.populateCategories(root);
                monitor.incrementProgress(1L);
            }
            Collections.sort(this.dataTypes, new CaseInsensitiveDataTypeComparator(DataTypeIndexer.this));
            this.categories.addAll(this.categorySet);
            Collections.sort(this.categories, new CaseInsensitiveCategoryComparator(DataTypeIndexer.this));
        }

        private void populateCategories(Category parent) {
            Category[] children;
            this.categorySet.add(parent.getCategoryPath());
            for (Category category : children = parent.getCategories()) {
                CategoryPath path = category.getCategoryPath();
                this.categorySet.add(path);
                this.populateCategories(category);
            }
        }

        List<DataType> getList() {
            return this.dataTypes;
        }

        List<CategoryPath> getCategoryPathList() {
            return this.categories;
        }
    }

    private class CaseInsensitiveCategoryComparator
    implements Comparator<CategoryPath> {
        private CaseInsensitiveCategoryComparator(DataTypeIndexer dataTypeIndexer) {
        }

        @Override
        public int compare(CategoryPath cp1, CategoryPath cp2) {
            String name2;
            String name1 = cp1.getName();
            int result = name1.compareToIgnoreCase(name2 = cp2.getName());
            if (result != 0) {
                return result;
            }
            result = name1.compareTo(name2);
            if (result != 0) {
                return -result;
            }
            String p1 = cp1.getPath();
            String p2 = cp2.getPath();
            return p1.compareToIgnoreCase(p2);
        }
    }

    private class CaseInsensitiveDataTypeComparator
    implements Comparator<DataType> {
        private CaseInsensitiveDataTypeComparator(DataTypeIndexer dataTypeIndexer) {
        }

        @Override
        public int compare(DataType dt1, DataType dt2) {
            String dtmName2;
            String name2;
            String name1 = dt1.getName();
            int result = name1.compareToIgnoreCase(name2 = dt2.getName());
            if (result != 0) {
                return result;
            }
            result = name1.compareTo(name2);
            if (result != 0) {
                return -result;
            }
            String dtmName1 = dt1.getDataTypeManager().getName();
            result = dtmName1.compareToIgnoreCase(dtmName2 = dt2.getDataTypeManager().getName());
            if (result != 0) {
                return result;
            }
            CategoryPath cp1 = dt1.getCategoryPath();
            CategoryPath cp2 = dt2.getCategoryPath();
            String p1 = cp1.getPath();
            String p2 = cp2.getPath();
            return p1.compareToIgnoreCase(p2);
        }
    }
}

