/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.dyldcache.DyldCacheEntry;
import ghidra.file.formats.ios.dyldcache.DyldCacheExtractor;
import ghidra.file.formats.ios.dyldcache.DyldCacheFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import util.CollectionUtils;

@FileSystemInfo(type="dyldcachev1", description="iOS DYLD Cache Version 1", factory=DyldCacheFileSystemFactory.class)
public class DyldCacheFileSystem
extends AbstractFileSystem<DyldCacheEntry> {
    public static final String DYLD_CACHE_FSTYPE = "dyldcachev1";
    private ByteProvider provider;
    private DyldCacheUtils.SplitDyldCache splitDyldCache;
    private boolean parsedLocalSymbols = false;
    private Map<DyldCacheMappingInfo, Map<Long, DyldFixup>> slideFixupMap;
    private RangeMap<Long, DyldCacheEntry> rangeMap = TreeRangeMap.create();

    public DyldCacheFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        super(fsFSRL, FileSystemService.getInstance());
        this.provider = provider;
    }

    public void mount(TaskMonitor monitor) throws IOException, MachException, CancelledException {
        this.splitDyldCache = new DyldCacheUtils.SplitDyldCache(this.provider, false, new MessageLog(), monitor);
        TreeRangeSet allDylibRanges = TreeRangeSet.create();
        List imageRecords = this.splitDyldCache.getImageRecords();
        monitor.initialize((long)imageRecords.size(), "Find DYLD DYLIBs...");
        for (DyldCacheUtils.DyldCacheImageRecord imageRecord : imageRecords) {
            monitor.increment();
            DyldCacheImage image = imageRecord.image();
            MachHeader machHeader = this.splitDyldCache.getMacho(imageRecord);
            TreeRangeSet rangeSet = TreeRangeSet.create();
            for (SegmentCommand segment : machHeader.parseSegments()) {
                Range range = Range.openClosed((Comparable)Long.valueOf(segment.getVMaddress()), (Comparable)Long.valueOf(segment.getVMaddress() + segment.getVMsize()));
                rangeSet.add(range);
            }
            DyldCacheEntry entry = new DyldCacheEntry(image.getPath(), imageRecord.splitCacheIndex(), (RangeSet<Long>)rangeSet, null, null, -1);
            rangeSet.asRanges().forEach(r -> this.rangeMap.put(r, (Object)entry));
            allDylibRanges.addAll((RangeSet)rangeSet);
            this.fsIndex.storeFile(image.getPath(), (long)this.fsIndex.getFileCount(), false, -1L, (Object)entry);
        }
        monitor.initialize((long)this.splitDyldCache.size(), "Find DYLD mapping ranges...");
        for (int i = 0; i < this.splitDyldCache.size(); ++i) {
            monitor.increment();
            DyldCacheHeader header = this.splitDyldCache.getDyldCacheHeader(i);
            String name = this.splitDyldCache.getName(i);
            List mappingInfos = header.getMappingInfos();
            List mappingAndSlideInfos = header.getCacheMappingAndSlideInfos();
            for (int j = 0; j < mappingInfos.size(); ++j) {
                DyldCacheMappingInfo mappingInfo = (DyldCacheMappingInfo)mappingInfos.get(j);
                DyldCacheMappingAndSlideInfo mappingAndSlideInfo = !mappingAndSlideInfos.isEmpty() ? (DyldCacheMappingAndSlideInfo)mappingAndSlideInfos.get(j) : null;
                Range mappingRange = Range.openClosed((Comparable)Long.valueOf(mappingInfo.getAddress()), (Comparable)Long.valueOf(mappingInfo.getAddress() + mappingInfo.getSize()));
                TreeRangeSet reducedRangeSet = TreeRangeSet.create();
                reducedRangeSet.add(mappingRange);
                reducedRangeSet.removeAll((RangeSet)allDylibRanges);
                for (Range range : reducedRangeSet.asRanges()) {
                    String path = this.getComponentPath(name, mappingInfo, mappingAndSlideInfo, j, (Range<Long>)range);
                    DyldCacheEntry entry = new DyldCacheEntry(path, i, (RangeSet<Long>)TreeRangeSet.create((Iterable)CollectionUtils.asIterable((Object)range)), mappingInfo, mappingAndSlideInfo, j);
                    this.rangeMap.put(range, (Object)entry);
                    this.fsIndex.storeFile(path, (long)this.fsIndex.getFileCount(), false, -1L, (Object)entry);
                }
            }
        }
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws CancelledException, IOException {
        DyldCacheEntry entry = (DyldCacheEntry)this.fsIndex.getMetadata(file);
        if (entry == null) {
            return null;
        }
        if (this.slideFixupMap == null) {
            this.slideFixupMap = DyldCacheExtractor.getSlideFixups(this.splitDyldCache, monitor);
        }
        if (!this.parsedLocalSymbols) {
            for (int i = 0; i < this.splitDyldCache.size(); ++i) {
                this.splitDyldCache.getDyldCacheHeader(i).parseLocalSymbolsInfo(true, new MessageLog(), monitor);
            }
            this.parsedLocalSymbols = true;
        }
        try {
            if (entry.mappingInfo() != null) {
                return DyldCacheExtractor.extractMapping(entry, this.getComponentName(entry.mappingAndSlideInfo()), this.splitDyldCache, this.slideFixupMap, file.getFSRL(), monitor);
            }
            return DyldCacheExtractor.extractDylib(entry, this.splitDyldCache, this.slideFixupMap, file.getFSRL(), monitor);
        }
        catch (MachException e) {
            throw new IOException("Invalid Mach-O header detected at: " + String.valueOf(entry));
        }
    }

    public String findAddress(long addr) throws IOException {
        DyldCacheEntry entry = (DyldCacheEntry)this.rangeMap.get((Comparable)Long.valueOf(addr));
        return entry != null ? entry.path() : null;
    }

    public List<GFile> getFiles(long flags) {
        ArrayList<GFile> files = new ArrayList<GFile>();
        for (DyldCacheEntry entry : this.rangeMap.asMapOfRanges().values()) {
            DyldCacheMappingAndSlideInfo mappingAndSlideInfo = entry.mappingAndSlideInfo();
            if (mappingAndSlideInfo == null || (flags & mappingAndSlideInfo.getFlags()) == 0L) continue;
            Optional.ofNullable(this.lookup(entry.path())).ifPresent(files::add);
        }
        return files;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        DyldCacheEntry entry = (DyldCacheEntry)this.fsIndex.getMetadata(file);
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.path());
            result.add(FileAttributeType.PATH_ATTR, (Object)entry.path());
            result.add("Cache Index", (Object)entry.splitCacheIndex());
            result.add("Address Range", (Object)entry.rangeSet().toString());
        }
        return result;
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        if (this.splitDyldCache != null) {
            this.splitDyldCache.close();
            this.splitDyldCache = null;
        }
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.slideFixupMap = null;
        this.parsedLocalSymbols = false;
        this.rangeMap.clear();
    }

    private String getComponentName(DyldCacheMappingAndSlideInfo mappingAndSlideInfo) {
        String name = "DYLD";
        if (mappingAndSlideInfo == null) {
            return name;
        }
        if (mappingAndSlideInfo.isDirtyData()) {
            name = "DATA_DIRTY";
        } else if (mappingAndSlideInfo.isConstData()) {
            name = mappingAndSlideInfo.isAuthData() ? "AUTH_CONST" : "DATA_CONST";
        } else if (mappingAndSlideInfo.isTextStubs()) {
            name = "TEXT_STUBS";
        } else if (mappingAndSlideInfo.isConfigData()) {
            name = "DATA_CONFIG";
        } else if (mappingAndSlideInfo.isAuthData()) {
            name = "AUTH";
        } else if (mappingAndSlideInfo.isReadOnlyData()) {
            name = "DATA_RO";
        } else if (mappingAndSlideInfo.isConstTproData()) {
            name = "DATA_CONST_TPRO";
        }
        return name;
    }

    private String getComponentPath(String dyldCacheName, DyldCacheMappingInfo mappingInfo, DyldCacheMappingAndSlideInfo mappingAndSlideInfo, int mappingIndex, Range<Long> range) {
        return "/DYLD/%s/%s.%d.0x%x-0x%x".formatted(dyldCacheName, this.getComponentName(mappingAndSlideInfo), mappingIndex, range.lowerEndpoint(), range.upperEndpoint());
    }
}

